/*
 * Decompiled with CFR 0.152.
 */
package net.sweetohm.ant.xml;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import net.sweetohm.ant.util.FileTask;
import net.sweetohm.ant.util.IO;
import org.apache.tools.ant.BuildException;

public class SplitTask
extends FileTask {
    String pattern = "split";
    String pi = "<?" + this.pattern;
    boolean verbose = false;
    Vector files = new Vector();

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.pi = "<?" + pattern;
    }

    public void execute() {
        Vector files = this.getFiles(true);
        if (files.size() == 0) {
            throw new BuildException("At least one of the file or dir attributes, or a fileset element, must be set.");
        }
        this.log("Splitting " + files.size() + " files.");
        try {
            int i = 0;
            while (i < files.size()) {
                File file = (File)files.elementAt(i);
                if (file.isDirectory()) {
                    String[] list = file.list();
                    int j = 0;
                    while (j < list.length) {
                        File file2 = new File(file, list[j]);
                        if (!file2.isDirectory()) {
                            this.processFile(file2);
                        }
                        ++j;
                    }
                } else {
                    this.processFile(file);
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new BuildException("IO error: " + e.getMessage());
        }
    }

    void processFile(File file) throws IOException {
        String string = IO.loadFile(file);
        if (string.indexOf(this.pi) >= 0) {
            this.cutFile(string, file);
        }
    }

    void cutFile(String string, File file) throws IOException {
        int index = 0;
        while ((index = string.indexOf(this.pi, index)) >= 0) {
            int start = string.indexOf("\"", index) + 1;
            int end = string.indexOf("\"", start);
            String name = string.substring(start, end);
            name = file.getParent() + File.separator + name;
            start = string.indexOf(">", end) + 1;
            end = string.indexOf(this.pi, end);
            index = string.indexOf(">", end) + 1;
            IO.writeFile(string.substring(start, end), new File(name));
        }
    }
}

