/*
 * Decompiled with CFR 0.152.
 */
package net.sweetohm.ant.xml;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import net.sweetohm.ant.util.FileTask;
import net.sweetohm.ant.util.IO;
import org.apache.tools.ant.BuildException;

public class MergeTask
extends FileTask {
    File tofile;
    String encoding;
    String guessedEncoding;
    String doctype;
    static final String defaultToFile = "index.xml";
    boolean nestingElement = true;
    String nestingElementName = "index";

    public void setTofile(String tofile) {
        this.tofile = this.getProject().resolveFile(tofile);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public void setNestingElement(boolean nestingElement) {
        this.nestingElement = nestingElement;
    }

    public void setNestingElementName(String nestingElementName) {
        this.nestingElementName = nestingElementName;
    }

    public void execute() {
        if (this.tofile != null && !this.tofile.getParentFile().exists()) {
            throw new BuildException("Directory " + this.tofile.getParent() + " not found.");
        }
        if (this.tofile == null) {
            this.tofile = this.getProject().resolveFile(defaultToFile);
        }
        Vector files = this.getFiles(true);
        this.log("Merging " + files.size() + " files into " + this.tofile + ".");
        StringBuffer body = new StringBuffer();
        if (this.doctype != null) {
            body.append("<!DOCTYPE " + this.doctype + ">\n\n");
            body.append("<" + this.doctype.substring(0, this.doctype.indexOf(" ")) + ">\n");
        } else if (this.nestingElement) {
            body.append("<" + this.nestingElementName + ">\n");
        }
        try {
            int i = 0;
            while (i < files.size()) {
                File file = (File)files.elementAt(i);
                if (file.isDirectory()) {
                    String[] list = file.list();
                    int j = 0;
                    while (j < list.length) {
                        File file2 = new File(file, list[j]);
                        if (!file2.isDirectory()) {
                            body.append(this.processFile(file2));
                        }
                        ++j;
                    }
                } else {
                    body.append(this.processFile(file));
                }
                ++i;
            }
            if (this.doctype != null) {
                body.append("\n</" + this.doctype.substring(0, this.doctype.indexOf(" ")) + ">");
            } else if (this.nestingElement) {
                body.append("\n</" + this.nestingElementName + ">");
            }
            if (this.encoding == null) {
                this.encoding = this.guessedEncoding;
            }
            StringBuffer document = new StringBuffer("<?xml version=\"1.0\" encoding=\"").append(this.encoding).append("\"?>\n\n").append(body);
            IO.writeFile(document.toString(), this.tofile, this.encoding);
        }
        catch (IOException e) {
            throw new BuildException("IO error: " + e.getMessage());
        }
    }

    String processFile(File file) throws IOException {
        if (this.encoding == null && this.guessedEncoding == null) {
            this.guessedEncoding = IO.getXMLFileEncoding(file);
        }
        String content = IO.loadXMLFile(file);
        return this.extract(content);
    }

    String extract(String content) {
        int start = 0;
        boolean ok = false;
        do {
            if (content.indexOf("<!--", start = content.indexOf("<", start)) == 0) {
                start = content.indexOf("-->", start) + 3;
                continue;
            }
            if (content.charAt(start + 1) == '?' || content.charAt(start + 1) == '!') {
                start = content.indexOf(">", start) + 1;
                continue;
            }
            ok = true;
        } while (!ok);
        return content.substring(start, content.length());
    }
}

