/*
 * Decompiled with CFR 0.152.
 */
package net.sweetohm.ant.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.StringTokenizer;

public class IO {
    static final String DEFAULT_ENCODING = "ascii";
    static final String XML_HEADER_START = "<?xml";
    static final String XML_HEADER_END = "?>";
    static final String BLANKS = " \t\n";
    static final String VERSION_ATT = "version";
    static final String VERSION_VAL = "1.0";
    static final String ENCODING_ATT = "encoding";

    public static String loadFile(File file) throws IOException {
        FileReader in = new FileReader(file);
        StringWriter out = new StringWriter();
        char[] buffer = new char[4096];
        int len = -1;
        while ((len = in.read(buffer, 0, buffer.length)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.flush();
        out.close();
        return out.toString();
    }

    public static String loadFile(File file, String encoding) throws IOException {
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        StringWriter out = new StringWriter();
        char[] buffer = new char[4096];
        int len = -1;
        while ((len = in.read(buffer, 0, buffer.length)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.flush();
        out.close();
        return out.toString();
    }

    public static String loadXMLFile(File file) throws IOException {
        String encoding = IO.getXMLFileEncoding(file);
        return IO.loadFile(file, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getXMLFileEncoding(File file) throws IOException {
        String encoding = DEFAULT_ENCODING;
        InputStreamReader in = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            StringBuffer buffer = new StringBuffer();
            int character = -1;
            while ((character = ((Reader)in).read()) > -1 && character != 10) {
                buffer.append((char)character);
            }
            String header = buffer.toString();
            encoding = IO.parseXMLHeader(header);
            Object var7_6 = null;
            if (in == null) return encoding;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (in == null) throw throwable;
            ((Reader)in).close();
            throw throwable;
        }
        ((Reader)in).close();
        return encoding;
    }

    static String parseXMLHeader(String header) throws IOException {
        String encoding = null;
        if (!(header = header.trim()).startsWith(XML_HEADER_START) || !header.endsWith(XML_HEADER_END)) {
            throw new IOException("Not an XML file");
        }
        StringTokenizer st = new StringTokenizer(header, BLANKS);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(XML_HEADER_START)) continue;
            if (token.endsWith(XML_HEADER_END)) {
                token = token.substring(0, token.lastIndexOf(XML_HEADER_END));
            }
            int pos = token.indexOf("=");
            String attribute = token.substring(0, pos);
            String quote = token.substring(pos + 1, pos + 2);
            String value = token.substring(token.indexOf(quote) + 1, token.lastIndexOf(quote));
            if (attribute.equals(VERSION_ATT) && !value.equals(VERSION_VAL)) {
                throw new IOException("Bad XML version, should be 1.0");
            }
            if (!attribute.equals(ENCODING_ATT)) continue;
            encoding = value;
        }
        return encoding == null ? DEFAULT_ENCODING : encoding;
    }

    public static void writeFile(String string, File file) throws IOException {
        FileWriter out = new FileWriter(file);
        out.write(string);
        out.flush();
        out.close();
    }

    public static void writeFile(String string, File file, String encoding) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        out.write(string);
        out.flush();
        out.close();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(IO.loadXMLFile(new File(args[0])));
    }
}

