/*
 * Decompiled with CFR 0.152.
 */
package net.sweetohm.ant.util;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public abstract class FileTask
extends Task {
    String file;
    String dir;
    Vector filesets = new Vector();

    public void setFile(String file) {
        this.file = file;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void addFileset(FileSet fileset) {
        this.filesets.addElement(fileset);
    }

    public Vector getFiles(boolean strict) throws BuildException {
        int i;
        StringTokenizer st;
        if (strict && this.file == null && this.dir == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source - a file, dir or a fileset.");
        }
        Vector<File> files = new Vector<File>();
        if (this.file != null) {
            st = new StringTokenizer(this.file, ",");
            int nbFiles = st.countTokens();
            i = 0;
            while (i < nbFiles) {
                File file = this.getProject().resolveFile(st.nextToken());
                if (!file.exists()) {
                    throw new BuildException("File " + file + " not found.");
                }
                files.addElement(file);
                ++i;
            }
        }
        if (this.dir != null) {
            st = new StringTokenizer(this.dir, ",");
            int nbDirs = st.countTokens();
            i = 0;
            while (i < nbDirs) {
                File dir = this.getProject().resolveFile(st.nextToken());
                if (!dir.exists()) {
                    throw new BuildException("Directory " + dir + " not found.");
                }
                if (dir.exists()) {
                    String[] list = dir.list();
                    int j = 0;
                    while (j < list.length) {
                        if (!new File(dir, list[j]).isDirectory()) {
                            files.addElement(new File(dir, list[j]));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        int i2 = 0;
        while (i2 < this.filesets.size()) {
            FileSet fileset = (FileSet)this.filesets.elementAt(i2);
            DirectoryScanner ds = fileset.getDirectoryScanner(this.project);
            ds.scan();
            String[] list = ds.getIncludedFiles();
            int j = 0;
            while (j < list.length) {
                files.addElement(new File(ds.getBasedir(), list[j]));
                ++j;
            }
            ++i2;
        }
        return files;
    }
}

