/*
 * Decompiled with CFR 0.152.
 */
package net.sweetohm.ant.server.command;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;

public class Target {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void execute(List args, Project project, Writer out) throws IOException {
        BuildListener logger = Target.removeLogger(project);
        try {
            out.write("Building Project: " + project.getName() + "\n\n");
            long start = System.currentTimeMillis();
            Vector targets = new Vector();
            int i = 0;
            while (i < args.size()) {
                targets.addElement(args.get(i));
                ++i;
            }
            if (targets.size() > 0) {
                project.executeTargets(targets);
            } else {
                project.executeTarget(project.getDefaultTarget());
            }
            long end = System.currentTimeMillis();
            out.write("BUILD SUCCESSFUL\n\nTotal time: " + (double)(end - start) / 1000.0 + " s\n");
            Object var11_8 = null;
            if (logger == null) return;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            if (logger == null) throw throwable;
            project.addBuildListener(logger);
            throw throwable;
        }
        project.addBuildListener(logger);
    }

    static BuildListener removeLogger(Project project) {
        Vector listeners = project.getBuildListeners();
        int i = 0;
        while (i < listeners.size()) {
            BuildListener listener = (BuildListener)listeners.elementAt(i);
            if (listener instanceof DefaultLogger) {
                project.removeBuildListener(listener);
                return listener;
            }
            ++i;
        }
        return null;
    }
}

