/*
 * Decompiled with CFR 0.152.
 */
package net.sweetohm.ant.server.command;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;

public class Help {
    public static void execute(List args, Project project, Writer out) throws IOException {
        Help.printDescription(project, out);
        Help.printTargets(project, out);
    }

    private static void printDescription(Project project, Writer out) throws IOException {
        if (project.getDescription() != null) {
            out.write(project.getDescription());
        }
    }

    private static void printTargets(Project project, Writer out) throws IOException {
        int maxLength = 0;
        Enumeration ptargets = project.getTargets().elements();
        Vector<String> topNames = new Vector<String>();
        Vector<String> topDescriptions = new Vector<String>();
        Vector<String> subNames = new Vector<String>();
        while (ptargets.hasMoreElements()) {
            int pos;
            Target currentTarget = (Target)ptargets.nextElement();
            String targetName = currentTarget.getName();
            String targetDescription = currentTarget.getDescription();
            if (targetDescription == null) {
                pos = Help.findTargetPosition(subNames, targetName);
                subNames.insertElementAt(targetName, pos);
                continue;
            }
            pos = Help.findTargetPosition(topNames, targetName);
            topNames.insertElementAt(targetName, pos);
            topDescriptions.insertElementAt(targetDescription, pos);
            if (targetName.length() <= maxLength) continue;
            maxLength = targetName.length();
        }
        String defaultTarget = project.getDefaultTarget();
        if (defaultTarget != null && !"".equals(defaultTarget)) {
            Vector<String> defaultName = new Vector<String>();
            Vector defaultDesc = null;
            defaultName.addElement(defaultTarget);
            int indexOfDefDesc = topNames.indexOf(defaultTarget);
            if (indexOfDefDesc >= 0) {
                defaultDesc = new Vector();
                defaultDesc.addElement(topDescriptions.elementAt(indexOfDefDesc));
            }
            Help.printTargets(defaultName, defaultDesc, "Default target:", maxLength, out);
        }
        Help.printTargets(topNames, topDescriptions, "Main targets:", maxLength, out);
        Help.printTargets(subNames, null, "Subtargets:", 0, out);
    }

    private static int findTargetPosition(Vector names, String name) {
        int res = names.size();
        int i = 0;
        while (i < names.size() && res == names.size()) {
            if (name.compareTo((String)names.elementAt(i)) < 0) {
                res = i;
            }
            ++i;
        }
        return res;
    }

    private static void printTargets(Vector names, Vector descriptions, String heading, int maxlen, Writer out) throws IOException {
        String lSep = System.getProperty("line.separator");
        String spaces = "    ";
        while (spaces.length() < maxlen) {
            spaces = spaces + spaces;
        }
        StringBuffer msg = new StringBuffer();
        msg.append(heading + lSep + lSep);
        int i = 0;
        while (i < names.size()) {
            msg.append(" ");
            msg.append(names.elementAt(i));
            if (descriptions != null) {
                msg.append(spaces.substring(0, maxlen - ((String)names.elementAt(i)).length() + 2));
                msg.append(descriptions.elementAt(i));
            }
            msg.append(lSep);
            ++i;
        }
        out.write(msg.toString());
    }
}

