/*
 * Decompiled with CFR 0.152.
 */
package net.sweetohm.ant.html;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import net.sweetohm.ant.util.FileTask;
import org.apache.tools.ant.BuildException;
import sun.net.www.protocol.file.FileURLConnection;
import sun.net.www.protocol.ftp.FtpURLConnection;

public class LinkTask
extends FileTask {
    boolean external;
    boolean interrupt;
    boolean interrupted;
    String log;
    Writer logWriter;
    boolean debug;
    ParserDelegator delegator;
    Parser parser;
    File parsedFile;
    Hashtable okCache = new Hashtable();
    Hashtable koCache = new Hashtable();
    static final int OK = 200;
    static final String INDENT = "  ";
    boolean ignoreCharSet = true;

    public LinkTask() {
        this.delegator = new ParserDelegator();
        this.parser = new Parser();
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public void setInterrupt(boolean interrupt) {
        this.interrupt = interrupt;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setIgnoreCharSet(boolean ignoreCharSet) {
        this.ignoreCharSet = ignoreCharSet;
    }

    public void execute() {
        this.interrupted = false;
        if (this.log != null) {
            try {
                this.logWriter = new FileWriter(this.getProject().resolveFile(this.log));
            }
            catch (IOException e) {
                throw new BuildException("Unable to open the log file");
            }
        }
        Vector files = this.getFiles(true);
        int i = 0;
        while (i < files.size()) {
            this.parsedFile = (File)files.elementAt(i);
            this.log("Checking: " + this.parsedFile + "...");
            try {
                FileReader reader = new FileReader(this.parsedFile);
                this.delegator.parse(reader, this.parser, this.ignoreCharSet);
            }
            catch (Exception e) {
                if (this.debug) {
                    e.printStackTrace();
                }
                throw new BuildException("Error parsing file " + this.parsedFile);
            }
            if (this.interrupted) {
                throw new BuildException("Broken Link");
            }
            ++i;
        }
        if (this.log != null) {
            try {
                this.logWriter.close();
            }
            catch (IOException e) {
                throw new BuildException("Unable to close the log file");
            }
        }
    }

    void startTag(HTML.Tag tag, MutableAttributeSet attrSet) {
        if (tag == HTML.Tag.A && attrSet.getAttribute(HTML.Attribute.HREF) != null) {
            this.testURL((String)attrSet.getAttribute(HTML.Attribute.HREF));
        } else if (tag == HTML.Tag.IMG && attrSet.getAttribute(HTML.Attribute.SRC) != null) {
            this.testURL((String)attrSet.getAttribute(HTML.Attribute.SRC));
        } else if (tag == HTML.Tag.AREA && attrSet.getAttribute(HTML.Attribute.HREF) != null) {
            this.testURL((String)attrSet.getAttribute(HTML.Attribute.HREF));
        } else if (tag == HTML.Tag.BODY && attrSet.getAttribute(HTML.Attribute.BACKGROUND) != null) {
            this.testURL((String)attrSet.getAttribute(HTML.Attribute.BACKGROUND));
        }
    }

    void testURL(String location) {
        block13: {
            if (this.debug) {
                this.log(INDENT + location);
            }
            try {
                URL fileURL = this.parsedFile.toURL();
                URL url = new URL(fileURL, location);
                URLConnection connection = url.openConnection();
                if (connection instanceof FileURLConnection) {
                    FileURLConnection fileConnection = (FileURLConnection)connection;
                    fileConnection.connect();
                    fileConnection.close();
                    break block13;
                }
                if (connection instanceof HttpURLConnection) {
                    if (!this.external) break block13;
                    if (this.koCache.get(location) != null) {
                        throw new IOException();
                    }
                    if (this.okCache.get(location) == null) {
                        HttpURLConnection httpConnection = (HttpURLConnection)connection;
                        httpConnection.connect();
                        int code = httpConnection.getResponseCode();
                        httpConnection.disconnect();
                        if (code != 200) {
                            throw new IOException();
                        }
                        this.okCache.put(location, new Object());
                    }
                    break block13;
                }
                if (connection instanceof FtpURLConnection) {
                    if (!this.external) break block13;
                    if (this.koCache.get(location) != null) {
                        throw new IOException();
                    }
                    if (this.okCache.get(location) == null) {
                        FtpURLConnection ftpConnection = (FtpURLConnection)connection;
                        ftpConnection.connect();
                        ftpConnection.close();
                        this.okCache.put(location, new Object());
                    }
                    break block13;
                }
                if (this.debug) {
                    this.log("    Unknown protocol " + connection.getClass().getName());
                }
            }
            catch (Exception e) {
                if (this.debug) {
                    e.printStackTrace();
                }
                this.log("  Broken link " + location);
                if (!this.interrupt) break block13;
                this.interrupted = true;
            }
        }
    }

    public void log(String message) {
        super.log(message);
        if (this.logWriter != null) {
            try {
                this.logWriter.write(message + '\n');
                this.logWriter.flush();
            }
            catch (IOException e) {
                throw new BuildException("Unable to log");
            }
        }
    }

    class Parser
    extends HTMLEditorKit.ParserCallback {
        Parser() {
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
            LinkTask.this.startTag(tag, attrSet);
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
            LinkTask.this.startTag(tag, attrSet);
        }
    }
}

