/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.workers.internal.AbstractSerializedActionExecutionSpec;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.SerializedParametersActionExecutionSpec;
import org.gradle.workers.internal.SimpleActionExecutionSpec;
import org.gradle.workers.internal.WorkSerializationException;

public class TransportableActionExecutionSpec
extends AbstractSerializedActionExecutionSpec {
    private final String displayName;
    private final String implementationClassName;
    private final byte[] serializedParameters;
    private final ClassLoaderStructure classLoaderStructure;

    public TransportableActionExecutionSpec(String displayName, Class<?> implementationClass, Object[] params, ClassLoaderStructure classLoaderStructure) {
        this.displayName = displayName;
        this.implementationClassName = implementationClass.getName();
        this.serializedParameters = this.serialize(params);
        this.classLoaderStructure = classLoaderStructure;
    }

    public TransportableActionExecutionSpec(String displayName, String implementationClassName, byte[] serializedParameters, ClassLoaderStructure classLoaderStructure) {
        this.displayName = displayName;
        this.implementationClassName = implementationClassName;
        this.serializedParameters = serializedParameters;
        this.classLoaderStructure = classLoaderStructure;
    }

    public static TransportableActionExecutionSpec from(ActionExecutionSpec spec) {
        if (spec instanceof SerializedParametersActionExecutionSpec) {
            SerializedParametersActionExecutionSpec serializedSpec = (SerializedParametersActionExecutionSpec)spec;
            return new TransportableActionExecutionSpec(serializedSpec.getDisplayName(), serializedSpec.getImplementationClass().getName(), serializedSpec.getSerializedParameters(), serializedSpec.getClassLoaderStructure());
        }
        if (spec instanceof TransportableActionExecutionSpec) {
            return (TransportableActionExecutionSpec)spec;
        }
        throw new IllegalArgumentException("Can't create a TransportableActionExecutionSpec from spec with type: " + spec.getClass().getSimpleName());
    }

    @Override
    public ClassLoaderStructure getClassLoaderStructure() {
        return this.classLoaderStructure;
    }

    @Override
    public Class<?> getImplementationClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Object[] getParams() {
        throw new UnsupportedOperationException();
    }

    public String getImplementationClassName() {
        return this.implementationClassName;
    }

    public byte[] getSerializedParameters() {
        return this.serializedParameters;
    }

    @Override
    public ActionExecutionSpec deserialize(ClassLoader classLoader) {
        try {
            Class<?> implementationClass = classLoader.loadClass(this.implementationClassName);
            Object[] params = (Object[])this.deserialize(this.serializedParameters, classLoader);
            return new SimpleActionExecutionSpec(implementationClass, this.displayName, params);
        }
        catch (Exception e) {
            throw new WorkSerializationException("Could not deserialize unit of work", e);
        }
    }
}

