/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.child;

import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.gradle.process.internal.worker.child.WorkerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionExecutionWorker
implements Action<WorkerContext>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionExecutionWorker.class);
    private final Action<? super WorkerProcessContext> action;
    private final Object workerId;
    private final String displayName;

    public ActionExecutionWorker(Action<? super WorkerProcessContext> action, Object workerId, String displayName) {
        this.action = action;
        this.workerId = workerId;
        this.displayName = displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final WorkerContext workerContext) {
        final ObjectConnection clientConnection = workerContext.getServerConnection();
        final ServiceRegistry serviceRegistry = workerContext.getServiceRegistry();
        LOGGER.debug("Starting {}.", (Object)this.displayName);
        WorkerProcessContext context = new WorkerProcessContext(){

            @Override
            public ObjectConnection getServerConnection() {
                return clientConnection;
            }

            @Override
            public ClassLoader getApplicationClassLoader() {
                return workerContext.getApplicationClassLoader();
            }

            @Override
            public Object getWorkerId() {
                return ActionExecutionWorker.this.workerId;
            }

            @Override
            public String getDisplayName() {
                return ActionExecutionWorker.this.displayName;
            }

            @Override
            public ServiceRegistry getServiceRegistry() {
                return serviceRegistry;
            }
        };
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.action.getClass().getClassLoader());
        clientConnection.addUnrecoverableErrorHandler((Action)new Action<Throwable>(){

            public void execute(Throwable throwable) {
                if (ActionExecutionWorker.this.action instanceof Stoppable) {
                    ((Stoppable)ActionExecutionWorker.this.action).stop();
                }
            }
        });
        try {
            this.action.execute((Object)context);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        LOGGER.debug("Completed {}.", (Object)this.displayName);
    }
}

