/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/* This file is automatically generated using bindtool */

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/qtgui/utils.h>
#include <qwt_legend.h>
#include <qwt_painter.h>
#include <qwt_plot.h>
#include <qwt_plot_canvas.h>
#include <qwt_plot_curve.h>
#include <qwt_plot_magnifier.h>
#include <qwt_plot_marker.h>
#include <qwt_plot_panner.h>
#include <qwt_plot_zoomer.h>
#include <qwt_scale_engine.h>
#include <qwt_scale_widget.h>
#include <qwt_symbol.h>

#include <gnuradio/qtgui/waterfall_sink_f.h>
// pydoc.h is automatically generated in the build directory
#include <waterfall_sink_f_pydoc.h>

void bind_waterfall_sink_f(py::module& m)
{

    using waterfall_sink_f = ::gr::qtgui::waterfall_sink_f;


    py::class_<waterfall_sink_f,
               gr::sync_block,
               gr::block,
               gr::basic_block,
               std::shared_ptr<waterfall_sink_f>>(
        m, "waterfall_sink_f", D(waterfall_sink_f))

        .def(py::init(&waterfall_sink_f::make),
             py::arg("size"),
             py::arg("wintype"),
             py::arg("fc"),
             py::arg("bw"),
             py::arg("name"),
             py::arg("nconnections") = 1,
             py::arg("parent") = nullptr,
             D(waterfall_sink_f, make))


        .def("exec_", &waterfall_sink_f::exec_, D(waterfall_sink_f, exec_))


        .def(
            "qwidget",
            [](waterfall_sink_f& self) {
                return reinterpret_cast<uintptr_t>(self.qwidget());
            },
            D(waterfall_sink_f, qwidget))


        .def(
            "pyqwidget",
            [](waterfall_sink_f& self) {
                return reinterpret_cast<uintptr_t>(self.qwidget());
            },
            D(waterfall_sink_f, qwidget))


        .def("clear_data", &waterfall_sink_f::clear_data, D(waterfall_sink_f, clear_data))


        .def("set_fft_size",
             &waterfall_sink_f::set_fft_size,
             py::arg("fftsize"),
             D(waterfall_sink_f, set_fft_size))


        .def("fft_size", &waterfall_sink_f::fft_size, D(waterfall_sink_f, fft_size))


        .def("set_time_per_fft",
             &waterfall_sink_f::set_time_per_fft,
             py::arg("t"),
             D(waterfall_sink_f, set_time_per_fft))


        .def("set_fft_average",
             &waterfall_sink_f::set_fft_average,
             py::arg("fftavg"),
             D(waterfall_sink_f, set_fft_average))


        .def("fft_average",
             &waterfall_sink_f::fft_average,
             D(waterfall_sink_f, fft_average))


        .def("set_fft_window",
             &waterfall_sink_f::set_fft_window,
             py::arg("win"),
             D(waterfall_sink_f, set_fft_window))


        .def("fft_window", &waterfall_sink_f::fft_window, D(waterfall_sink_f, fft_window))


        .def("set_frequency_range",
             &waterfall_sink_f::set_frequency_range,
             py::arg("centerfreq"),
             py::arg("bandwidth"),
             D(waterfall_sink_f, set_frequency_range))


        .def("set_intensity_range",
             &waterfall_sink_f::set_intensity_range,
             py::arg("min"),
             py::arg("max"),
             D(waterfall_sink_f, set_intensity_range))


        .def("set_update_time",
             &waterfall_sink_f::set_update_time,
             py::arg("t"),
             D(waterfall_sink_f, set_update_time))


        .def("set_title",
             &waterfall_sink_f::set_title,
             py::arg("title"),
             D(waterfall_sink_f, set_title))


        .def("set_time_title",
             &waterfall_sink_f::set_time_title,
             py::arg("title"),
             D(waterfall_sink_f, set_time_title))


        .def("set_line_label",
             &waterfall_sink_f::set_line_label,
             py::arg("which"),
             py::arg("line"),
             D(waterfall_sink_f, set_line_label))


        .def("set_line_alpha",
             &waterfall_sink_f::set_line_alpha,
             py::arg("which"),
             py::arg("alpha"),
             D(waterfall_sink_f, set_line_alpha))


        .def("set_color_map",
             &waterfall_sink_f::set_color_map,
             py::arg("which"),
             py::arg("color"),
             D(waterfall_sink_f, set_color_map))


        .def("set_plot_pos_half",
             &waterfall_sink_f::set_plot_pos_half,
             py::arg("half"),
             D(waterfall_sink_f, set_plot_pos_half))


        .def("title", &waterfall_sink_f::title, D(waterfall_sink_f, title))


        .def("line_label",
             &waterfall_sink_f::line_label,
             py::arg("which"),
             D(waterfall_sink_f, line_label))


        .def("line_alpha",
             &waterfall_sink_f::line_alpha,
             py::arg("which"),
             D(waterfall_sink_f, line_alpha))


        .def("color_map",
             &waterfall_sink_f::color_map,
             py::arg("which"),
             D(waterfall_sink_f, color_map))


        .def("set_size",
             &waterfall_sink_f::set_size,
             py::arg("width"),
             py::arg("height"),
             D(waterfall_sink_f, set_size))


        .def("auto_scale", &waterfall_sink_f::auto_scale, D(waterfall_sink_f, auto_scale))


        .def("min_intensity",
             &waterfall_sink_f::min_intensity,
             py::arg("which"),
             D(waterfall_sink_f, min_intensity))


        .def("max_intensity",
             &waterfall_sink_f::max_intensity,
             py::arg("which"),
             D(waterfall_sink_f, max_intensity))


        .def("enable_menu",
             &waterfall_sink_f::enable_menu,
             py::arg("en") = true,
             D(waterfall_sink_f, enable_menu))


        .def("enable_grid",
             &waterfall_sink_f::enable_grid,
             py::arg("en") = true,
             D(waterfall_sink_f, enable_grid))


        .def("disable_legend",
             &waterfall_sink_f::disable_legend,
             D(waterfall_sink_f, disable_legend))


        .def("enable_axis_labels",
             &waterfall_sink_f::enable_axis_labels,
             py::arg("en") = true,
             D(waterfall_sink_f, enable_axis_labels))

        ;
}
