/* -*- c++ -*- */
/*
 * Copyright 2007-2010,2013 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

#ifndef INCLUDED_GR_UDP_SINK_IMPL_H
#define INCLUDED_GR_UDP_SINK_IMPL_H

#include <gnuradio/blocks/udp_sink.h>
#include <boost/asio.hpp>
#include <memory>

namespace gr {
namespace blocks {

class udp_sink_impl : public udp_sink
{
private:
    const size_t d_itemsize;

    const int d_payload_size;  // maximum transmission unit (packet length)
    const bool d_eof;          // send zero-length packet on disconnect
    bool d_connected;          // are we connected?
    gr::thread::mutex d_mutex; // protects d_socket and d_connected

    std::unique_ptr<boost::asio::ip::udp::socket> d_socket; // handle to socket
    boost::asio::ip::udp::endpoint d_endpoint;
    boost::asio::io_service d_io_service;

public:
    udp_sink_impl(
        size_t itemsize, const std::string& host, int port, int payload_size, bool eof);
    ~udp_sink_impl() override;

    int payload_size() override { return d_payload_size; }

    void connect(const std::string& host, int port) override;
    void disconnect() override;

    int work(int noutput_items,
             gr_vector_const_void_star& input_items,
             gr_vector_void_star& output_items) override;
};

} /* namespace blocks */
} /* namespace gr */

#endif /* INCLUDED_GR_UDP_SINK_IMPL_H */
