# Shared by interpreter, T2 compiler and T3 compiler.
add_library (
    COMMON_OBJECTS OBJECT
    src/common.h
    src/missing.cc
    src/missing.h
    src/osbeos.h
    src/osdos.h
    src/osfrobtads.h
    src/osos2.h
    src/osunixt.h
    src/oswin.h
    tads2/osifc.c
    tads2/osnoui.c
    tads2/osstzprs.c
    tads2/osrestad.c
)

set (
    TADS2_HEADERS
    tads2/appctx.h
    tads2/argize.h
    tads2/bif.h
    tads2/cmap.h
    tads2/cmd.h
    tads2/dat.h
    tads2/dbg.h
    tads2/emt.h
    tads2/err.h
    tads2/fio.h
    tads2/h_le_c11.h
    tads2/h_ppc.h
    tads2/ler.h
    tads2/lib.h
    tads2/linf.h
    tads2/lin.h
    tads2/lst.h
    tads2/mch.h
    tads2/mcl.h
    tads2/mcm.h
    tads2/mcs.h
    tads2/obj.h
    tads2/oem.h
    tads2/opc.h
    tads2/osbigmem.h
    tads2/osgen.h
    tads2/os.h
    tads2/osifc.h
    tads2/osifctyp.h
    tads2/osstzprs.h
    tads2/ply.h
    tads2/prp.h
    tads2/prs.h
    tads2/regex.h
    tads2/res.h
    tads2/run.h
    tads2/std.h
    tads2/sup.h
    tads2/tio.h
    tads2/tok.h
    tads2/trd.h
    tads2/voc.h
    tads2/tcd.h
    tads2/tcg.h
)

# Shared by interpreter and T2 compiler.
add_library (
    TADS2_RC_OBJECTS OBJECT
    tads2/askf_tx.c
    tads2/bif.c
    tads2/bifgdum.c
    tads2/cmap.c
    tads2/cmd.c
    tads2/dat.c
    tads2/errmsg.c
    tads2/fio.c
    tads2/fioxor.c
    tads2/getstr.c
    tads2/indlg_tx.c
    tads2/ler.c
    tads2/lst.c
    tads2/mch.c
    tads2/mcm.c
    tads2/mcs.c
    tads2/obj.c
    tads2/oserr.c
    tads2/out.c
    tads2/output.c
    tads2/regex.c
    tads2/run.c
    tads2/suprun.c
    tads2/voc.c
)

set (
    TADS3_HEADERS
    tads3/charmap.h
    tads3/core.h
    tads3/md5.h
    tads3/osifcnet.h
    tads3/rcmain.h
    tads3/resload.h
    tads3/sha2.h
    tads3/t3_os.h
    tads3/t3std.h
    tads3/tccmdutl.h
    tads3/tcerr.h
    tads3/tcerrnum.h
    tads3/tcgen.h
    tads3/tcglob.h
    tads3/tchost.h
    tads3/tchostsi.h
    tads3/tclibprs.h
    tads3/tcmain.h
    tads3/tcmake.h
    tads3/tcpnbase.h
    tads3/tcpndrv.h
    tads3/tcpnint.h
    tads3/tcprs.h
    tads3/tcprstyp.h
    tads3/tcsrc.h
    tads3/tct3base.h
    tads3/tct3drv.h
    tads3/tct3.h
    tads3/tct3int.h
    tads3/tct3ty.h
    tads3/tct3unas.h
    tads3/tctarg.h
    tads3/tctargty.h
    tads3/tctok.h
    tads3/tcunas.h
    tads3/tcvsn.h
    tads3/test/t3test.h
    tads3/unix/osnetunix.h
    tads3/utf8.h
    tads3/vmanonfn.h
    tads3/vmbif.h
    tads3/vmbifnet.h
    tads3/vmbifreg.h
    tads3/vmbift3.h
    tads3/vmbiftad.h
    tads3/vmbiftio.h
    tads3/vmbignum.h
    tads3/vmbytarr.h
    tads3/vmcoll.h
    tads3/vmconsol.h
    tads3/vmcrc.h
    tads3/vmcset.h
    tads3/vmdatasrc.h
    tads3/vmdbg.h
    tads3/vmdict.h
    tads3/vmdynfunc.h
    tads3/vmerr.h
    tads3/vmerrnum.h
    tads3/vmfile.h
    tads3/vmfilobj.h
    tads3/vmfilnam.h
    tads3/vmfindrep.h
    tads3/vmdate.h
    tads3/vmtz.h
    tads3/vmtzobj.h
    tads3/vmfref.h
    tads3/vmfunc.h
    tads3/vmglob.h
    tads3/vmglobv.h
    tads3/vmgram.h
    tads3/vmhash.h
    tads3/vmhost.h
    tads3/vmhostsi.h
    tads3/vmhosttx.h
    tads3/vmhttpreq.h
    tads3/vmhttpsrv.h
    tads3/vmimage.h
    tads3/vmimgrb.h
    tads3/vmimport.h
    tads3/vminit.h
    tads3/vmintcls.h
    tads3/vmisaac.h
    tads3/vmiter.h
    tads3/vmlog.h
    tads3/vmlookup.h
    tads3/vmlst.h
    tads3/vmmaincn.h
    tads3/vmmain.h
    tads3/vmmccore.h
    tads3/vmmcnet.h
    tads3/vmmcreg.h
    tads3/vmmersenne.h
    tads3/vmmeta.h
    tads3/vmnetfil.h
    tads3/vmnet.h
    tads3/vmobj.h
    tads3/vmop.h
    tads3/vmpack.h
    tads3/vmparam.h
    tads3/vmpat.h
    tads3/vmpool.h
    tads3/vmpoolsl.h
    tads3/vmpredef.h
    tads3/vmpreini.h
    tads3/vmprof.h
    tads3/vmprofty.h
    tads3/vmrefcnt.h
    tads3/vmregex.h
    tads3/vmres.h
    tads3/vmrun.h
    tads3/vmrunsym.h
    tads3/vmsave.h
    tads3/vmsort.h
    tads3/vmsrcf.h
    tads3/vmstack.h
    tads3/vmstrbuf.h
    tads3/vmstrcmp.h
    tads3/vmstr.h
    tads3/vmstrref.h
    tads3/vmstrres.h
    tads3/vmtmpfil.h
    tads3/vmtobj.h
    tads3/vmtype.h
    tads3/vmundo.h
    tads3/vmuni.h
    tads3/vmvec.h
    tads3/vmvsn.h
    tads3/vmwrtimg.h
)

# Shared by interpreter and T3 compiler (non-debugger versions).
add_library (
    TADS3_RC_OBJECTS_ND OBJECT
    tads3/vmbt3_nd.cpp
    tads3/vmimg_nd.cpp
    tads3/vmini_nd.cpp
)

# Shared by interpreter and T3 compiler.
add_library (
    TADS3_RC_OBJECTS OBJECT
    tads2/ostzposix.c
    tads3/askf_tx3.cpp
    tads3/charmap.cpp
    tads3/derived/vmuni_cs.cpp
    tads3/indlg_tx3.cpp
    tads3/md5.cpp
    tads3/resldexe.cpp
    tads3/resload.cpp
    tads3/sha2.cpp
    tads3/std.cpp
    tads3/tccmdutl.cpp
    tads3/tcerr.cpp
    tads3/tcerrmsg.cpp
    tads3/tcgen.cpp
    tads3/tcglob.cpp
    tads3/tchostsi.cpp
    tads3/tclibprs.cpp
    tads3/tcmain.cpp
    tads3/tcprs.cpp
    tads3/tcprsstm.cpp
    tads3/tcsrc.cpp
    tads3/tct3.cpp
    tads3/tct3stm.cpp
    tads3/tct3unas.cpp
    tads3/tctok.cpp
    tads3/utf8.cpp
    tads3/vmanonfn.cpp
    tads3/vmbif.cpp
    tads3/vmbift3.cpp
    tads3/vmbiftad.cpp
    tads3/vmbiftio.cpp
    tads3/vmbignum.cpp
    tads3/vmbignumlib.cpp
    tads3/vmbytarr.cpp
    tads3/vmcfgmem.cpp
    #tads3/vmcfgfl.cpp
    tads3/vmcoll.cpp
    tads3/vmconhmp.cpp
    tads3/vmconmor.cpp
    tads3/vmconsol.cpp
    tads3/vmcrc.cpp
    tads3/vmcset.cpp
    tads3/vmdict.cpp
    tads3/vmdynfunc.cpp
    tads3/vmerr.cpp
    tads3/vmerrmsg.cpp
    tads3/vmfile.cpp
    tads3/vmfilobj.cpp
    tads3/vmfilnam.cpp
    tads3/vmdate.cpp
    tads3/vmtzobj.cpp
    tads3/vmtz.cpp
    tads3/vmop.cpp
    tads3/vmfref.cpp
    tads3/vmfunc.cpp
    tads3/vmglob.cpp
    tads3/vmgram.cpp
    tads3/vmhash.cpp
    tads3/vmhostsi.cpp
    tads3/vmhosttx.cpp
    tads3/vmimage.cpp
    tads3/vminit.cpp
    tads3/vminitim.cpp
    #tads3/vminitfl.cpp
    tads3/vmintcls.cpp
    tads3/vmisaac.cpp
    tads3/vmiter.cpp
    tads3/vmlog.cpp
    tads3/vmlookup.cpp
    tads3/vmlst.cpp
    tads3/vmmcreg.cpp
    tads3/vmmeta.cpp
    tads3/vmnetfillcl.cpp
    tads3/vmobj.cpp
    tads3/vmpack.cpp
    tads3/vmpat.cpp
    tads3/vmpool.cpp
    tads3/vmpoolim.cpp
    #tads3/vmpoolfl.cpp
    tads3/vmrefcnt.cpp
    tads3/vmregex.cpp
    tads3/vmrunsym.cpp
    tads3/vmsave.cpp
    tads3/vmsort.cpp
    tads3/vmsortv.cpp
    tads3/vmsrcf.cpp
    tads3/vmstack.cpp
    tads3/vmstrbuf.cpp
    tads3/vmstrcmp.cpp
    tads3/vmstr.cpp
    tads3/vmtmpfil.cpp
    tads3/vmtobj.cpp
    tads3/vmtype.cpp
    tads3/vmtypedh.cpp
    tads3/vmundo.cpp
    tads3/vmvec.cpp
)

if (ENABLE_INTERPRETER OR ENABLE_T3_COMPILER)
    install (
        FILES tads3/charmap/cmaplib.t3r
        DESTINATION ${T3_RES_DIR}/charmap/
    )
endif()

install (
    FILES
    doc/AUTHORS
    doc/BUGS
    doc/COPYING
    doc/NEWS
    doc/README
    doc/THANKS
    DESTINATION share/doc/frobtads-${FROB_VERSION}
)
