/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.Constants;
import java.util.Hashtable;
import java.util.Vector;

public class Tables
implements Constants {
    static Hashtable mnemocodes = new Hashtable(301, 0.5f);
    static String[] opcExtNamesTab = new String[128];
    static String[] opcPrivExtNamesTab = new String[128];
    static Vector keywordNames;
    static Hashtable keywords;
    private static Vector tagNames;
    private static Hashtable Tags;
    private static Vector typeNames;
    private static Hashtable Types;
    private static Vector mapTypeNames;
    private static Hashtable MapTypes;

    static {
        int k = 0;
        while (k < 196) {
            mnemocodes.put(opcNamesTab[k], new Integer(k));
            ++k;
        }
        k = 197;
        while (k < opcNamesTab.length) {
            mnemocodes.put(opcNamesTab[k], new Integer(k));
            ++k;
        }
        mnemocodes.put("invokenonvirtual", new Integer(183));
        mnemocodes.put("iload_w", new Integer(50197));
        mnemocodes.put("lload_w", new Integer(50198));
        mnemocodes.put("fload_w", new Integer(50199));
        mnemocodes.put("dload_w", new Integer(50200));
        mnemocodes.put("aload_w", new Integer(50201));
        mnemocodes.put("istore_w", new Integer(50230));
        mnemocodes.put("lstore_w", new Integer(50231));
        mnemocodes.put("fstore_w", new Integer(50232));
        mnemocodes.put("dstore_w", new Integer(50233));
        mnemocodes.put("astore_w", new Integer(50234));
        mnemocodes.put("ret_w", new Integer(50345));
        mnemocodes.put("iinc_w", new Integer(50308));
        mnemocodes.put("nonpriv", new Integer(254));
        mnemocodes.put("priv", new Integer(255));
        Tables.defineExt(0, "load_ubyte");
        Tables.defineExt(1, "load_byte");
        Tables.defineExt(2, "load_char");
        Tables.defineExt(3, "load_short");
        Tables.defineExt(4, "load_word");
        Tables.defineExt(10, "load_char_oe");
        Tables.defineExt(11, "load_short_oe");
        Tables.defineExt(12, "load_word_oe");
        Tables.defineExt(16, "ncload_ubyte");
        Tables.defineExt(17, "ncload_byte");
        Tables.defineExt(18, "ncload_char");
        Tables.defineExt(19, "ncload_short");
        Tables.defineExt(20, "ncload_word");
        Tables.defineExt(26, "ncload_char_oe");
        Tables.defineExt(27, "ncload_short_oe");
        Tables.defineExt(28, "ncload_word_oe");
        Tables.defineExt(30, "cache_flush");
        Tables.defineExt(32, "store_byte");
        Tables.defineExt(34, "store_short");
        Tables.defineExt(36, "store_word");
        Tables.defineExt(42, "store_short_oe");
        Tables.defineExt(44, "store_word_oe");
        Tables.defineExt(48, "ncstore_byte");
        Tables.defineExt(50, "ncstore_short");
        Tables.defineExt(52, "ncstore_word");
        Tables.defineExt(58, "ncstore_short_oe");
        Tables.defineExt(60, "ncstore_word_oe");
        Tables.defineExt(62, "zero_line");
        Tables.defineNonPriv(5, "ret_from_sub");
        Tables.defineNonPriv(63, "enter_sync_method");
        Tables.definePriv(5, "ret_from_trap");
        Tables.definePriv(6, "read_dcache_tag");
        Tables.definePriv(7, "read_dcache_data");
        Tables.definePriv(14, "read_icache_tag");
        Tables.definePriv(15, "read_icache_data");
        Tables.definePriv(22, "powerdown");
        Tables.definePriv(23, "read_scache_data");
        Tables.definePriv(31, "cache_index_flush");
        Tables.definePriv(38, "write_dcache_tag");
        Tables.definePriv(39, "write_dcache_data");
        Tables.definePriv(46, "write_icache_tag");
        Tables.definePriv(47, "write_icache_data");
        Tables.definePriv(54, "reset");
        Tables.definePriv(55, "write_scache_data");
        k = 0;
        while (k < 32) {
            Tables.definePriv(k + 64, "read_reg_" + k);
            ++k;
        }
        k = 0;
        while (k < 32) {
            Tables.definePriv(k + 96, "write_reg_" + k);
            ++k;
        }
        keywordNames = new Vector(40);
        Tables.defineKeywordName("ident", 60);
        Tables.defineKeywordName("STRINGVAL", 69);
        Tables.defineKeywordName("intVal", 65);
        Tables.defineKeywordName("longVal", 66);
        Tables.defineKeywordName("floatVal", 67);
        Tables.defineKeywordName("doubleVal", 68);
        Tables.defineKeywordName("SEMICOLON", 135);
        Tables.defineKeywordName("COLON", 136);
        Tables.defineKeywordName("LBRACE", 138);
        Tables.defineKeywordName("RBRACE", 139);
        keywords = new Hashtable(40);
        Tables.defineKeyword("private", 120);
        Tables.defineKeyword("public", 121);
        Tables.defineKeyword("protected", 122);
        Tables.defineKeyword("static", 124);
        Tables.defineKeyword("transient", 125);
        Tables.defineKeyword("synchronized", 126);
        Tables.defineKeyword("super", 83);
        Tables.defineKeyword("native", 127);
        Tables.defineKeyword("abstract", 130);
        Tables.defineKeyword("volatile", 129);
        Tables.defineKeyword("final", 128);
        Tables.defineKeyword("interface", 114);
        Tables.defineKeyword("synthetic", 164);
        Tables.defineKeyword("strict", 165);
        Tables.defineKeyword("package", 115);
        Tables.defineKeyword("class", 111);
        Tables.defineKeyword("extends", 112);
        Tables.defineKeyword("implements", 113);
        Tables.defineKeyword("const", 123);
        Tables.defineKeyword("throws", 144);
        Tables.defineKeyword("interface", 114);
        Tables.defineKeyword("Method", 152);
        Tables.defineKeyword("Field", 153);
        Tables.defineKeyword("stack", 154);
        Tables.defineKeyword("locals", 155);
        Tables.defineKeyword("default", 97);
        Tables.defineKeyword("InnerClass", 162);
        Tables.defineKeyword("of", 163);
        Tables.defineKeyword("bits", 159);
        Tables.defineKeyword("Infinity", 160);
        Tables.defineKeyword("Inf", 160);
        Tables.defineKeyword("NaN", 161);
        tagNames = new Vector(10);
        Tags = new Hashtable(10);
        Tables.defineTag("Asciz", 1);
        Tables.defineTag("int", 3);
        Tables.defineTag("float", 4);
        Tables.defineTag("long", 5);
        Tables.defineTag("double", 6);
        Tables.defineTag("class", 7);
        Tables.defineTag("String", 8);
        Tables.defineTag("Field", 9);
        Tables.defineTag("Method", 10);
        Tables.defineTag("InterfaceMethod", 11);
        Tables.defineTag("NameAndType", 12);
        typeNames = new Vector(10);
        Types = new Hashtable(10);
        Tables.defineType("int", 10);
        Tables.defineType("long", 11);
        Tables.defineType("float", 6);
        Tables.defineType("double", 7);
        Tables.defineType("class", 2);
        Tables.defineType("boolean", 4);
        Tables.defineType("char", 5);
        Tables.defineType("byte", 8);
        Tables.defineType("short", 9);
        mapTypeNames = new Vector(10);
        MapTypes = new Hashtable(10);
        Tables.defineMapType("bogus", 0);
        Tables.defineMapType("int", 1);
        Tables.defineMapType("float", 2);
        Tables.defineMapType("double", 3);
        Tables.defineMapType("long", 4);
        Tables.defineMapType("null", 5);
        Tables.defineMapType("this", 6);
        Tables.defineMapType("CP", 7);
        Tables.defineMapType("uninitialized", 8);
    }

    static void defineNonPriv(int opc, String mnem) {
        Tables.opcExtNamesTab[opc] = mnem;
        mnemocodes.put(Tables.opcExtNamesTab[opc], new Integer(65024 + opc));
    }

    static void definePriv(int opc, String mnem) {
        Tables.opcPrivExtNamesTab[opc] = "priv_" + mnem;
        mnemocodes.put(Tables.opcPrivExtNamesTab[opc], new Integer(65280 + opc));
    }

    static void defineExt(int opc, String mnem) {
        Tables.defineNonPriv(opc, mnem);
        Tables.definePriv(opc, mnem);
    }

    public static int opcLength(int opc) throws ArrayIndexOutOfBoundsException {
        switch (opc >> 8) {
            case 0: {
                return opcLengthsTab[opc];
            }
            case 196: {
                switch (opc & 0xFF) {
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 169: {
                        return 4;
                    }
                    case 132: {
                        return 6;
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            case 254: 
            case 255: {
                return 2;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String opcName(int opc) {
        try {
            switch (opc >> 8) {
                case 0: {
                    return opcNamesTab[opc];
                }
                case 196: {
                    String mnem = String.valueOf(opcNamesTab[opc & 0xFF]) + "_w";
                    if (mnemocodes.get(mnem) == null) {
                        return null;
                    }
                    return mnem;
                }
                case 254: {
                    return opcExtNamesTab[opc & 0xFF];
                }
                case 255: {
                    return opcPrivExtNamesTab[opc & 0xFF];
                }
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            switch (opc) {
                case 254: {
                    return "nonpriv";
                }
                case 255: {
                    return "priv";
                }
            }
            return null;
        }
    }

    public static int opcode(String mnem) {
        Integer Val = (Integer)mnemocodes.get(mnem);
        if (Val == null) {
            return -1;
        }
        return Val;
    }

    private static void defineKeywordName(String id, int token) {
        if (token >= keywordNames.size()) {
            keywordNames.setSize(token + 1);
        }
        keywordNames.setElementAt(id, token);
    }

    public static String keywordName(int token) {
        if (token == -1) {
            return "EOF";
        }
        if (token >= keywordNames.size()) {
            return null;
        }
        return (String)keywordNames.elementAt(token);
    }

    public static int keyword(String idValue) {
        Integer Val = (Integer)keywords.get(idValue);
        if (Val == null) {
            return 60;
        }
        return Val;
    }

    private static void defineKeyword(String id, int token) {
        keywords.put(id, new Integer(token));
        Tables.defineKeywordName(id, token);
    }

    private static void defineTag(String id, int val) {
        Tags.put(id, new Integer(val));
        if (val >= tagNames.size()) {
            tagNames.setSize(val + 1);
        }
        tagNames.setElementAt(id, val);
    }

    public static String tagName(int tag) {
        if (tag >= tagNames.size()) {
            return null;
        }
        return (String)tagNames.elementAt(tag);
    }

    public static int tagValue(String idValue) {
        Integer Val = (Integer)Tags.get(idValue);
        if (Val == null) {
            return 0;
        }
        return Val;
    }

    private static void defineType(String id, int val) {
        Types.put(id, new Integer(val));
        if (val >= typeNames.size()) {
            typeNames.setSize(val + 1);
        }
        typeNames.setElementAt(id, val);
    }

    public static int typeValue(String idValue) {
        Integer Val = (Integer)Types.get(idValue);
        if (Val == null) {
            return -1;
        }
        return Val;
    }

    public static String typeName(int type) {
        if (type >= typeNames.size()) {
            return null;
        }
        return (String)typeNames.elementAt(type);
    }

    private static void defineMapType(String id, int val) {
        MapTypes.put(id, new Integer(val));
        if (val >= mapTypeNames.size()) {
            mapTypeNames.setSize(val + 1);
        }
        mapTypeNames.setElementAt(id, val);
    }

    public static int mapTypeValue(String idValue) {
        Integer Val = (Integer)MapTypes.get(idValue);
        if (Val == null) {
            return -1;
        }
        return Val;
    }

    public static String mapTypeName(int type) {
        if (type >= mapTypeNames.size()) {
            return null;
        }
        return (String)mapTypeNames.elementAt(type);
    }
}

