/*
 * Copyright (C) 2011 Marcelina Kościelnicka <mwk@0x04.net>
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#include "h264_cabac.h"
#include <stdlib.h>
#include <stdio.h>

/* modes: I, 0, 1, 2 */

static const struct h264_cabac_ctx_init ctx_init_tab[H264_CABAC_CTXIDX_NUM][4] = {
	/* 0-2 mb_type SI prefix */
	{	{   20,  -15 },	{    0,    0 },	{    0,    0 },	{    0,    0 },	},	/*    0 */
	{	{    2,   54 },	{    0,    0 },	{    0,    0 },	{    0,    0 },	},	/*    1 */
	{	{    3,   74 },	{    0,    0 },	{    0,    0 },	{    0,    0 },	},	/*    2 */
	/* 3-10 mb_type I, SI suffix */
	{	{   20,  -15 },	{    0,    0 },	{    0,    0 },	{    0,    0 },	},	/*    3 */
	{	{    2,   54 },	{    0,    0 },	{    0,    0 },	{    0,    0 },	},	/*    4 */
	{	{    3,   74 },	{    0,    0 },	{    0,    0 },	{    0,    0 },	},	/*    5 */
	{	{  -28,  127 },	{    0,    0 },	{    0,    0 },	{    0,    0 },	},	/*    6 */
	{	{  -23,  104 },	{    0,    0 },	{    0,    0 },	{    0,    0 },	},	/*    7 */
	{	{   -6,   53 },	{    0,    0 },	{    0,    0 },	{    0,    0 },	},	/*    8 */
	{	{   -1,   54 },	{    0,    0 },	{    0,    0 },	{    0,    0 },	},	/*    9 */
	{	{    7,   51 },	{    0,    0 },	{    0,    0 },	{    0,    0 },	},	/*   10 */

	/* 11-13 mb_skip_flag P */
	{	{    0,    0 },	{   23,   33 },	{   22,   25 },	{   29,   16 },	},	/*   11 */
	{	{    0,    0 },	{   23,    2 },	{   34,    0 },	{   25,    0 },	},	/*   12 */
	{	{    0,    0 },	{   21,    0 },	{   16,    0 },	{   14,    0 },	},	/*   13 */
	/* 14-16 mb_type P prefix */
	{	{    0,    0 },	{    1,    9 },	{   -2,    9 },	{  -10,   51 },	},	/*   14 */
	{	{    0,    0 },	{    0,   49 },	{    4,   41 },	{   -3,   62 },	},	/*   15 */
	{	{    0,    0 },	{  -37,  118 },	{  -29,  118 },	{  -27,   99 },	},	/*   16 */
	/* 17-20 mb_type P suffix */
	{	{    0,    0 },	{    5,   57 },	{    2,   65 },	{   26,   16 },	},	/*   17 */
	{	{    0,    0 },	{  -13,   78 },	{   -6,   71 },	{   -4,   85 },	},	/*   18 */
	{	{    0,    0 },	{  -11,   65 },	{  -13,   79 },	{  -24,  102 },	},	/*   19 */
	{	{    0,    0 },	{    1,   62 },	{    5,   52 },	{    5,   57 },	},	/*   20 */
	/* 21-23 sub_mb_type P */
	{	{    0,    0 },	{   12,   49 },	{    9,   50 },	{    6,   57 },	},	/*   21 */
	{	{    0,    0 },	{   -4,   73 },	{   -3,   70 },	{  -17,   73 },	},	/*   22 */
	{	{    0,    0 },	{   17,   50 },	{   10,   54 },	{   14,   57 },	},	/*   23 */

	/* 24-26 mb_skip_flag B */
	{	{    0,    0 },	{   18,   64 },	{   26,   34 },	{   20,   40 },	},	/*   24 */
	{	{    0,    0 },	{    9,   43 },	{   19,   22 },	{   20,   10 },	},	/*   25 */
	{	{    0,    0 },	{   29,    0 },	{   40,    0 },	{   29,    0 },	},	/*   26 */
	/* 27-31 mb_type B prefix */
	{	{    0,    0 },	{   26,   67 },	{   57,    2 },	{   54,    0 },	},	/*   27 */
	{	{    0,    0 },	{   16,   90 },	{   41,   36 },	{   37,   42 },	},	/*   28 */
	{	{    0,    0 },	{    9,  104 },	{   26,   69 },	{   12,   97 },	},	/*   29 */
	{	{    0,    0 },	{  -46,  127 },	{  -45,  127 },	{  -32,  127 },	},	/*   30 */
	{	{    0,    0 },	{  -20,  104 },	{  -15,  101 },	{  -22,  117 },	},	/*   31 */
	/* 32-35 mb_type B suffix */
	{	{    0,    0 },	{    1,   67 },	{   -4,   76 },	{   -2,   74 },	},	/*   32 */
	{	{    0,    0 },	{  -13,   78 },	{   -6,   71 },	{   -4,   85 },	},	/*   33 */
	{	{    0,    0 },	{  -11,   65 },	{  -13,   79 },	{  -24,  102 },	},	/*   34 */
	{	{    0,    0 },	{    1,   62 },	{    5,   52 },	{    5,   57 },	},	/*   35 */
	/* 36-39 sub_mb_type B */
	{	{    0,    0 },	{   -6,   86 },	{    6,   69 },	{   -6,   93 },	},	/*   36 */
	{	{    0,    0 },	{  -17,   95 },	{  -13,   90 },	{  -14,   88 },	},	/*   37 */
	{	{    0,    0 },	{   -6,   61 },	{    0,   52 },	{   -6,   44 },	},	/*   38 */
	{	{    0,    0 },	{    9,   45 },	{    8,   43 },	{    4,   55 },	},	/*   39 */

	/* 40-46 mvd X component */
	{	{    0,    0 },	{   -3,   69 },	{   -2,   69 },	{  -11,   89 },	},	/*   40 */
	{	{    0,    0 },	{   -6,   81 },	{   -5,   82 },	{  -15,  103 },	},	/*   41 */
	{	{    0,    0 },	{  -11,   96 },	{  -10,   96 },	{  -21,  116 },	},	/*   42 */
	{	{    0,    0 },	{    6,   55 },	{    2,   59 },	{   19,   57 },	},	/*   43 */
	{	{    0,    0 },	{    7,   67 },	{    2,   75 },	{   20,   58 },	},	/*   44 */
	{	{    0,    0 },	{   -5,   86 },	{   -3,   87 },	{    4,   84 },	},	/*   45 */
	{	{    0,    0 },	{    2,   88 },	{   -3,  100 },	{    6,   96 },	},	/*   46 */
	/* 47-53 mvd Y component */
	{	{    0,    0 },	{    0,   58 },	{    1,   56 },	{    1,   63 },	},	/*   47 */
	{	{    0,    0 },	{   -3,   76 },	{   -3,   74 },	{   -5,   85 },	},	/*   48 */
	{	{    0,    0 },	{  -10,   94 },	{   -6,   85 },	{  -13,  106 },	},	/*   49 */
	{	{    0,    0 },	{    5,   54 },	{    0,   59 },	{    5,   63 },	},	/*   50 */
	{	{    0,    0 },	{    4,   69 },	{   -3,   81 },	{    6,   75 },	},	/*   51 */
	{	{    0,    0 },	{   -3,   81 },	{   -7,   86 },	{   -3,   90 },	},	/*   52 */
	{	{    0,    0 },	{    0,   88 },	{   -5,   95 },	{   -1,  101 },	},	/*   53 */

	/* 54-59 ref_idx_l* */
	{	{    0,    0 },	{   -7,   67 },	{   -1,   66 },	{    3,   55 },	},	/*   54 */
	{	{    0,    0 },	{   -5,   74 },	{   -1,   77 },	{   -4,   79 },	},	/*   55 */
	{	{    0,    0 },	{   -4,   74 },	{    1,   70 },	{   -2,   75 },	},	/*   56 */
	{	{    0,    0 },	{   -5,   80 },	{   -2,   86 },	{  -12,   97 },	},	/*   57 */
	{	{    0,    0 },	{   -7,   72 },	{   -5,   72 },	{   -7,   50 },	},	/*   58 */
	{	{    0,    0 },	{    1,   58 },	{    0,   61 },	{    1,   60 },	},	/*   59 */

	/* 60-63 mb_qp_delta */
	{	{    0,   41 },	{    0,   41 },	{    0,   41 },	{    0,   41 },	},	/*   60 */
	{	{    0,   63 },	{    0,   63 },	{    0,   63 },	{    0,   63 },	},	/*   61 */
	{	{    0,   63 },	{    0,   63 },	{    0,   63 },	{    0,   63 },	},	/*   62 */
	{	{    0,   63 },	{    0,   63 },	{    0,   63 },	{    0,   63 },	},	/*   63 */
	/* 64-67 intra_chroma_pred_mode */
	{	{   -9,   83 },	{   -9,   83 },	{   -9,   83 },	{   -9,   83 },	},	/*   64 */
	{	{    4,   86 },	{    4,   86 },	{    4,   86 },	{    4,   86 },	},	/*   65 */
	{	{    0,   97 },	{    0,   97 },	{    0,   97 },	{    0,   97 },	},	/*   66 */
	{	{   -7,   72 },	{   -7,   72 },	{   -7,   72 },	{   -7,   72 },	},	/*   67 */
	/* 68 prev_intra_pred_mode_flag */
	{	{   13,   41 },	{   13,   41 },	{   13,   41 },	{   13,   41 },	},	/*   68 */
	/* 69 rem_intra_pred_mode */
	{	{    3,   62 },	{    3,   62 },	{    3,   62 },	{    3,   62 },	},	/*   69 */

	/* 70-72 mb_field_decoding_flag */
	{	{    0,   11 },	{    0,   45 },	{   13,   15 },	{    7,   34 },	},	/*   70 */
	{	{    1,   55 },	{   -4,   78 },	{    7,   51 },	{   -9,   88 },	},	/*   71 */
	{	{    0,   69 },	{   -3,   96 },	{    2,   80 },	{  -20,  127 },	},	/*   72 */
	/* 73-76 coded_block_pattern luma */
	{	{  -17,  127 },	{  -27,  126 },	{  -39,  127 },	{  -36,  127 },	},	/*   73 */
	{	{  -13,  102 },	{  -28,   98 },	{  -18,   91 },	{  -17,   91 },	},	/*   74 */
	{	{    0,   82 },	{  -25,  101 },	{  -17,   96 },	{  -14,   95 },	},	/*   75 */
	{	{   -7,   74 },	{  -23,   67 },	{  -26,   81 },	{  -25,   84 },	},	/*   76 */
	/* 77-84 coded_block_pattern chroma */
	{	{  -21,  107 },	{  -28,   82 },	{  -35,   98 },	{  -25,   86 },	},	/*   77 */
	{	{  -27,  127 },	{  -20,   94 },	{  -24,  102 },	{  -12,   89 },	},	/*   78 */
	{	{  -31,  127 },	{  -16,   83 },	{  -23,   97 },	{  -17,   91 },	},	/*   79 */
	{	{  -24,  127 },	{  -22,  110 },	{  -27,  119 },	{  -31,  127 },	},	/*   80 */
	{	{  -18,   95 },	{  -21,   91 },	{  -24,   99 },	{  -14,   76 },	},	/*   81 */
	{	{  -27,  127 },	{  -18,  102 },	{  -21,  110 },	{  -18,  103 },	},	/*   82 */
	{	{  -21,  114 },	{  -13,   93 },	{  -18,  102 },	{  -13,   90 },	},	/*   83 */
	{	{  -30,  127 },	{  -29,  127 },	{  -36,  127 },	{  -37,  127 },	},	/*   84 */

	/* 85-88 coded_block_flag with ctxBlockCat 0 */
	{	{  -17,  123 },	{   -7,   92 },	{    0,   80 },	{   11,   80 },	},	/*   85 */
	{	{  -12,  115 },	{   -5,   89 },	{   -5,   89 },	{    5,   76 },	},	/*   86 */
	{	{  -16,  122 },	{   -7,   96 },	{   -7,   94 },	{    2,   84 },	},	/*   87 */
	{	{  -11,  115 },	{  -13,  108 },	{   -4,   92 },	{    5,   78 },	},	/*   88 */
	/* 89-92 coded_block_flag with ctxBlockCat 1 */
	{	{  -12,   63 },	{   -3,   46 },	{    0,   39 },	{   -6,   55 },	},	/*   89 */
	{	{   -2,   68 },	{   -1,   65 },	{    0,   65 },	{    4,   61 },	},	/*   90 */
	{	{  -15,   84 },	{   -1,   57 },	{  -15,   84 },	{  -14,   83 },	},	/*   91 */
	{	{  -13,  104 },	{   -9,   93 },	{  -35,  127 },	{  -37,  127 },	},	/*   92 */
	/* 93-96 coded_block_flag with ctxBlockCat 2 */
	{	{   -3,   70 },	{   -3,   74 },	{   -2,   73 },	{   -5,   79 },	},	/*   93 */
	{	{   -8,   93 },	{   -9,   92 },	{  -12,  104 },	{  -11,  104 },	},	/*   94 */
	{	{  -10,   90 },	{   -8,   87 },	{   -9,   91 },	{  -11,   91 },	},	/*   95 */
	{	{  -30,  127 },	{  -23,  126 },	{  -31,  127 },	{  -30,  127 },	},	/*   96 */
	/* 97-100 coded_block_flag with ctxBlockCat 3 */
	{	{   -1,   74 },	{    5,   54 },	{    3,   55 },	{    0,   65 },	},	/*   97 */
	{	{   -6,   97 },	{    6,   60 },	{    7,   56 },	{   -2,   79 },	},	/*   98 */
	{	{   -7,   91 },	{    6,   59 },	{    7,   55 },	{    0,   72 },	},	/*   99 */
	{	{  -20,  127 },	{    6,   69 },	{    8,   61 },	{   -4,   92 },	},	/*  100 */
	/* 101-104 coded_block_flag with ctxBlockCat 4 */
	{	{   -4,   56 },	{   -1,   48 },	{   -3,   53 },	{   -6,   56 },	},	/*  101 */
	{	{   -5,   82 },	{    0,   68 },	{    0,   68 },	{    3,   68 },	},	/*  102 */
	{	{   -7,   76 },	{   -4,   69 },	{   -7,   74 },	{   -8,   71 },	},	/*  103 */
	{	{  -22,  125 },	{   -8,   88 },	{   -9,   88 },	{  -13,   98 },	},	/*  104 */

	/* 105-119 significant_coeff_flag with ctxBlockCat 0 for frame mode */
	{	{   -7,   93 },	{   -2,   85 },	{  -13,  103 },	{   -4,   86 },	},	/*  105 */
	{	{  -11,   87 },	{   -6,   78 },	{  -13,   91 },	{  -12,   88 },	},	/*  106 */
	{	{   -3,   77 },	{   -1,   75 },	{   -9,   89 },	{   -5,   82 },	},	/*  107 */
	{	{   -5,   71 },	{   -7,   77 },	{  -14,   92 },	{   -3,   72 },	},	/*  108 */
	{	{   -4,   63 },	{    2,   54 },	{   -8,   76 },	{   -4,   67 },	},	/*  109 */
	{	{   -4,   68 },	{    5,   50 },	{  -12,   87 },	{   -8,   72 },	},	/*  110 */
	{	{  -12,   84 },	{   -3,   68 },	{  -23,  110 },	{  -16,   89 },	},	/*  111 */
	{	{   -7,   62 },	{    1,   50 },	{  -24,  105 },	{   -9,   69 },	},	/*  112 */
	{	{   -7,   65 },	{    6,   42 },	{  -10,   78 },	{   -1,   59 },	},	/*  113 */
	{	{    8,   61 },	{   -4,   81 },	{  -20,  112 },	{    5,   66 },	},	/*  114 */
	{	{    5,   56 },	{    1,   63 },	{  -17,   99 },	{    4,   57 },	},	/*  115 */
	{	{   -2,   66 },	{   -4,   70 },	{  -78,  127 },	{   -4,   71 },	},	/*  116 */
	{	{    1,   64 },	{    0,   67 },	{  -70,  127 },	{   -2,   71 },	},	/*  117 */
	{	{    0,   61 },	{    2,   57 },	{  -50,  127 },	{    2,   58 },	},	/*  118 */
	{	{   -2,   78 },	{   -2,   76 },	{  -46,  127 },	{   -1,   74 },	},	/*  119 */
	/* 120-133 significant_coeff_flag with ctxBlockCat 1 for frame mode */
	{	{    1,   50 },	{   11,   35 },	{   -4,   66 },	{   -4,   44 },	},	/*  120 */
	{	{    7,   52 },	{    4,   64 },	{   -5,   78 },	{   -1,   69 },	},	/*  121 */
	{	{   10,   35 },	{    1,   61 },	{   -4,   71 },	{    0,   62 },	},	/*  122 */
	{	{    0,   44 },	{   11,   35 },	{   -8,   72 },	{   -7,   51 },	},	/*  123 */
	{	{   11,   38 },	{   18,   25 },	{    2,   59 },	{   -4,   47 },	},	/*  124 */
	{	{    1,   45 },	{   12,   24 },	{   -1,   55 },	{   -6,   42 },	},	/*  125 */
	{	{    0,   46 },	{   13,   29 },	{   -7,   70 },	{   -3,   41 },	},	/*  126 */
	{	{    5,   44 },	{   13,   36 },	{   -6,   75 },	{   -6,   53 },	},	/*  127 */
	{	{   31,   17 },	{  -10,   93 },	{   -8,   89 },	{    8,   76 },	},	/*  128 */
	{	{    1,   51 },	{   -7,   73 },	{  -34,  119 },	{   -9,   78 },	},	/*  129 */
	{	{    7,   50 },	{   -2,   73 },	{   -3,   75 },	{  -11,   83 },	},	/*  130 */
	{	{   28,   19 },	{   13,   46 },	{   32,   20 },	{    9,   52 },	},	/*  131 */
	{	{   16,   33 },	{    9,   49 },	{   30,   22 },	{    0,   67 },	},	/*  132 */
	{	{   14,   62 },	{   -7,  100 },	{  -44,  127 },	{   -5,   90 },	},	/*  133 */
	/* 134-148 significant_coeff_flag with ctxBlockCat 2 for frame mode */
	{	{  -13,  108 },	{    9,   53 },	{    0,   54 },	{    1,   67 },	},	/*  134 */
	{	{  -15,  100 },	{    2,   53 },	{   -5,   61 },	{  -15,   72 },	},	/*  135 */
	{	{  -13,  101 },	{    5,   53 },	{    0,   58 },	{   -5,   75 },	},	/*  136 */
	{	{  -13,   91 },	{   -2,   61 },	{   -1,   60 },	{   -8,   80 },	},	/*  137 */
	{	{  -12,   94 },	{    0,   56 },	{   -3,   61 },	{  -21,   83 },	},	/*  138 */
	{	{  -10,   88 },	{    0,   56 },	{   -8,   67 },	{  -21,   64 },	},	/*  139 */
	{	{  -16,   84 },	{  -13,   63 },	{  -25,   84 },	{  -13,   31 },	},	/*  140 */
	{	{  -10,   86 },	{   -5,   60 },	{  -14,   74 },	{  -25,   64 },	},	/*  141 */
	{	{   -7,   83 },	{   -1,   62 },	{   -5,   65 },	{  -29,   94 },	},	/*  142 */
	{	{  -13,   87 },	{    4,   57 },	{    5,   52 },	{    9,   75 },	},	/*  143 */
	{	{  -19,   94 },	{   -6,   69 },	{    2,   57 },	{   17,   63 },	},	/*  144 */
	{	{    1,   70 },	{    4,   57 },	{    0,   61 },	{   -8,   74 },	},	/*  145 */
	{	{    0,   72 },	{   14,   39 },	{   -9,   69 },	{   -5,   35 },	},	/*  146 */
	{	{   -5,   74 },	{    4,   51 },	{  -11,   70 },	{   -2,   27 },	},	/*  147 */
	{	{   18,   59 },	{   13,   68 },	{   18,   55 },	{   13,   91 },	},	/*  148 */
	/* 149-151 significant_coeff_flag with ctxBlockCat 3 for frame mode */
	{	{   -8,  102 },	{    3,   64 },	{   -4,   71 },	{    3,   65 },	},	/*  149 */
	{	{  -15,  100 },	{    1,   61 },	{    0,   58 },	{   -7,   69 },	},	/*  150 */
	{	{    0,   95 },	{    9,   63 },	{    7,   61 },	{    8,   77 },	},	/*  151 */
	/* 152-165 significant_coeff_flag with ctxBlockCat 4 for frame mode */
	{	{   -4,   75 },	{    7,   50 },	{    9,   41 },	{  -10,   66 },	},	/*  152 */
	{	{    2,   72 },	{   16,   39 },	{   18,   25 },	{    3,   62 },	},	/*  153 */
	{	{  -11,   75 },	{    5,   44 },	{    9,   32 },	{   -3,   68 },	},	/*  154 */
	{	{   -3,   71 },	{    4,   52 },	{    5,   43 },	{  -20,   81 },	},	/*  155 */
	{	{   15,   46 },	{   11,   48 },	{    9,   47 },	{    0,   30 },	},	/*  156 */
	{	{  -13,   69 },	{   -5,   60 },	{    0,   44 },	{    1,    7 },	},	/*  157 */
	{	{    0,   62 },	{   -1,   59 },	{    0,   51 },	{   -3,   23 },	},	/*  158 */
	{	{    0,   65 },	{    0,   59 },	{    2,   46 },	{  -21,   74 },	},	/*  159 */
	{	{   21,   37 },	{   22,   33 },	{   19,   38 },	{   16,   66 },	},	/*  160 */
	{	{  -15,   72 },	{    5,   44 },	{   -4,   66 },	{  -23,  124 },	},	/*  161 */
	{	{    9,   57 },	{   14,   43 },	{   15,   38 },	{   17,   37 },	},	/*  162 */
	{	{   16,   54 },	{   -1,   78 },	{   12,   42 },	{   44,  -18 },	},	/*  163 */
	{	{    0,   62 },	{    0,   60 },	{    9,   34 },	{   50,  -34 },	},	/*  164 */
	{	{   12,   72 },	{    9,   69 },	{    0,   89 },	{  -22,  127 },	},	/*  165 */

	/* 166-180 last_significant_coeff_flag with ctxBlockCat 0 for frame mode */
	{	{   24,    0 },	{   11,   28 },	{    4,   45 },	{    4,   39 },	},	/*  166 */
	{	{   15,    9 },	{    2,   40 },	{   10,   28 },	{    0,   42 },	},	/*  167 */
	{	{    8,   25 },	{    3,   44 },	{   10,   31 },	{    7,   34 },	},	/*  168 */
	{	{   13,   18 },	{    0,   49 },	{   33,  -11 },	{   11,   29 },	},	/*  169 */
	{	{   15,    9 },	{    0,   46 },	{   52,  -43 },	{    8,   31 },	},	/*  170 */
	{	{   13,   19 },	{    2,   44 },	{   18,   15 },	{    6,   37 },	},	/*  171 */
	{	{   10,   37 },	{    2,   51 },	{   28,    0 },	{    7,   42 },	},	/*  172 */
	{	{   12,   18 },	{    0,   47 },	{   35,  -22 },	{    3,   40 },	},	/*  173 */
	{	{    6,   29 },	{    4,   39 },	{   38,  -25 },	{    8,   33 },	},	/*  174 */
	{	{   20,   33 },	{    2,   62 },	{   34,    0 },	{   13,   43 },	},	/*  175 */
	{	{   15,   30 },	{    6,   46 },	{   39,  -18 },	{   13,   36 },	},	/*  176 */
	{	{    4,   45 },	{    0,   54 },	{   32,  -12 },	{    4,   47 },	},	/*  177 */
	{	{    1,   58 },	{    3,   54 },	{  102,  -94 },	{    3,   55 },	},	/*  178 */
	{	{    0,   62 },	{    2,   58 },	{    0,    0 },	{    2,   58 },	},	/*  179 */
	{	{    7,   61 },	{    4,   63 },	{   56,  -15 },	{    6,   60 },	},	/*  180 */
	/* 181-194 last_significant_coeff_flag with ctxBlockCat 1 for frame mode */
	{	{   12,   38 },	{    6,   51 },	{   33,   -4 },	{    8,   44 },	},	/*  181 */
	{	{   11,   45 },	{    6,   57 },	{   29,   10 },	{   11,   44 },	},	/*  182 */
	{	{   15,   39 },	{    7,   53 },	{   37,   -5 },	{   14,   42 },	},	/*  183 */
	{	{   11,   42 },	{    6,   52 },	{   51,  -29 },	{    7,   48 },	},	/*  184 */
	{	{   13,   44 },	{    6,   55 },	{   39,   -9 },	{    4,   56 },	},	/*  185 */
	{	{   16,   45 },	{   11,   45 },	{   52,  -34 },	{    4,   52 },	},	/*  186 */
	{	{   12,   41 },	{   14,   36 },	{   69,  -58 },	{   13,   37 },	},	/*  187 */
	{	{   10,   49 },	{    8,   53 },	{   67,  -63 },	{    9,   49 },	},	/*  188 */
	{	{   30,   34 },	{   -1,   82 },	{   44,   -5 },	{   19,   58 },	},	/*  189 */
	{	{   18,   42 },	{    7,   55 },	{   32,    7 },	{   10,   48 },	},	/*  190 */
	{	{   10,   55 },	{   -3,   78 },	{   55,  -29 },	{   12,   45 },	},	/*  191 */
	{	{   17,   51 },	{   15,   46 },	{   32,    1 },	{    0,   69 },	},	/*  192 */
	{	{   17,   46 },	{   22,   31 },	{    0,    0 },	{   20,   33 },	},	/*  193 */
	{	{    0,   89 },	{   -1,   84 },	{   27,   36 },	{    8,   63 },	},	/*  194 */
	/* 195-209 last_significant_coeff_flag with ctxBlockCat 2 for frame mode */
	{	{   26,  -19 },	{   25,    7 },	{   33,  -25 },	{   35,  -18 },	},	/*  195 */
	{	{   22,  -17 },	{   30,   -7 },	{   34,  -30 },	{   33,  -25 },	},	/*  196 */
	{	{   26,  -17 },	{   28,    3 },	{   36,  -28 },	{   28,   -3 },	},	/*  197 */
	{	{   30,  -25 },	{   28,    4 },	{   38,  -28 },	{   24,   10 },	},	/*  198 */
	{	{   28,  -20 },	{   32,    0 },	{   38,  -27 },	{   27,    0 },	},	/*  199 */
	{	{   33,  -23 },	{   34,   -1 },	{   34,  -18 },	{   34,  -14 },	},	/*  200 */
	{	{   37,  -27 },	{   30,    6 },	{   35,  -16 },	{   52,  -44 },	},	/*  201 */
	{	{   33,  -23 },	{   30,    6 },	{   34,  -14 },	{   39,  -24 },	},	/*  202 */
	{	{   40,  -28 },	{   32,    9 },	{   32,   -8 },	{   19,   17 },	},	/*  203 */
	{	{   38,  -17 },	{   31,   19 },	{   37,   -6 },	{   31,   25 },	},	/*  204 */
	{	{   33,  -11 },	{   26,   27 },	{   35,    0 },	{   36,   29 },	},	/*  205 */
	{	{   40,  -15 },	{   26,   30 },	{   30,   10 },	{   24,   33 },	},	/*  206 */
	{	{   41,   -6 },	{   37,   20 },	{   28,   18 },	{   34,   15 },	},	/*  207 */
	{	{   38,    1 },	{   28,   34 },	{   26,   25 },	{   30,   20 },	},	/*  208 */
	{	{   41,   17 },	{   17,   70 },	{   29,   41 },	{   22,   73 },	},	/*  209 */
	/* 210-212 last_significant_coeff_flag with ctxBlockCat 3 for frame mode */
	{	{   30,   -6 },	{    1,   67 },	{    0,   75 },	{   20,   34 },	},	/*  210 */
	{	{   27,    3 },	{    5,   59 },	{    2,   72 },	{   19,   31 },	},	/*  211 */
	{	{   26,   22 },	{    9,   67 },	{    8,   77 },	{   27,   44 },	},	/*  212 */
	/* 213-226 last_significant_coeff_flag with ctxBlockCat 4 for frame mode */
	{	{   37,  -16 },	{   16,   30 },	{   14,   35 },	{   19,   16 },	},	/*  213 */
	{	{   35,   -4 },	{   18,   32 },	{   18,   31 },	{   15,   36 },	},	/*  214 */
	{	{   38,   -8 },	{   18,   35 },	{   17,   35 },	{   15,   36 },	},	/*  215 */
	{	{   38,   -3 },	{   22,   29 },	{   21,   30 },	{   21,   28 },	},	/*  216 */
	{	{   37,    3 },	{   24,   31 },	{   17,   45 },	{   25,   21 },	},	/*  217 */
	{	{   38,    5 },	{   23,   38 },	{   20,   42 },	{   30,   20 },	},	/*  218 */
	{	{   42,    0 },	{   18,   43 },	{   18,   45 },	{   31,   12 },	},	/*  219 */
	{	{   35,   16 },	{   20,   41 },	{   27,   26 },	{   27,   16 },	},	/*  220 */
	{	{   39,   22 },	{   11,   63 },	{   16,   54 },	{   24,   42 },	},	/*  221 */
	{	{   14,   48 },	{    9,   59 },	{    7,   66 },	{    0,   93 },	},	/*  222 */
	{	{   27,   37 },	{    9,   64 },	{   16,   56 },	{   14,   56 },	},	/*  223 */
	{	{   21,   60 },	{   -1,   94 },	{   11,   73 },	{   15,   57 },	},	/*  224 */
	{	{   12,   68 },	{   -2,   89 },	{   10,   67 },	{   26,   38 },	},	/*  225 */
	{	{    2,   97 },	{   -9,  108 },	{  -10,  116 },	{  -24,  127 },	},	/*  226 */

	/* 227-236 coeff_abs_level_minus1 with ctxBlockCat 0 */
	{	{   -3,   71 },	{   -6,   76 },	{  -23,  112 },	{  -24,  115 },	},	/*  227 */
	{	{   -6,   42 },	{   -2,   44 },	{  -15,   71 },	{  -22,   82 },	},	/*  228 */
	{	{   -5,   50 },	{    0,   45 },	{   -7,   61 },	{   -9,   62 },	},	/*  229 */
	{	{   -3,   54 },	{    0,   52 },	{    0,   53 },	{    0,   53 },	},	/*  230 */
	{	{   -2,   62 },	{   -3,   64 },	{   -5,   66 },	{    0,   59 },	},	/*  231 */
	{	{    0,   58 },	{   -2,   59 },	{  -11,   77 },	{  -14,   85 },	},	/*  232 */
	{	{    1,   63 },	{   -4,   70 },	{   -9,   80 },	{  -13,   89 },	},	/*  233 */
	{	{   -2,   72 },	{   -4,   75 },	{   -9,   84 },	{  -13,   94 },	},	/*  234 */
	{	{   -1,   74 },	{   -8,   82 },	{  -10,   87 },	{  -11,   92 },	},	/*  235 */
	{	{   -9,   91 },	{  -17,  102 },	{  -34,  127 },	{  -29,  127 },	},	/*  236 */
	/* 237-246 coeff_abs_level_minus1 with ctxBlockCat 1 */
	{	{   -5,   67 },	{   -9,   77 },	{  -21,  101 },	{  -21,  100 },	},	/*  237 */
	{	{   -5,   27 },	{    3,   24 },	{   -3,   39 },	{  -14,   57 },	},	/*  238 */
	{	{   -3,   39 },	{    0,   42 },	{   -5,   53 },	{  -12,   67 },	},	/*  239 */
	{	{   -2,   44 },	{    0,   48 },	{   -7,   61 },	{  -11,   71 },	},	/*  240 */
	{	{    0,   46 },	{    0,   55 },	{  -11,   75 },	{  -10,   77 },	},	/*  241 */
	{	{  -16,   64 },	{   -6,   59 },	{  -15,   77 },	{  -21,   85 },	},	/*  242 */
	{	{   -8,   68 },	{   -7,   71 },	{  -17,   91 },	{  -16,   88 },	},	/*  243 */
	{	{  -10,   78 },	{  -12,   83 },	{  -25,  107 },	{  -23,  104 },	},	/*  244 */
	{	{   -6,   77 },	{  -11,   87 },	{  -25,  111 },	{  -15,   98 },	},	/*  245 */
	{	{  -10,   86 },	{  -30,  119 },	{  -28,  122 },	{  -37,  127 },	},	/*  246 */
	/* 247-256 coeff_abs_level_minus1 with ctxBlockCat 2 */
	{	{  -12,   92 },	{    1,   58 },	{  -11,   76 },	{  -10,   82 },	},	/*  247 */
	{	{  -15,   55 },	{   -3,   29 },	{  -10,   44 },	{   -8,   48 },	},	/*  248 */
	{	{  -10,   60 },	{   -1,   36 },	{  -10,   52 },	{   -8,   61 },	},	/*  249 */
	{	{   -6,   62 },	{    1,   38 },	{  -10,   57 },	{   -8,   66 },	},	/*  250 */
	{	{   -4,   65 },	{    2,   43 },	{   -9,   58 },	{   -7,   70 },	},	/*  251 */
	{	{  -12,   73 },	{   -6,   55 },	{  -16,   72 },	{  -14,   75 },	},	/*  252 */
	{	{   -8,   76 },	{    0,   58 },	{   -7,   69 },	{  -10,   79 },	},	/*  253 */
	{	{   -7,   80 },	{    0,   64 },	{   -4,   69 },	{   -9,   83 },	},	/*  254 */
	{	{   -9,   88 },	{   -3,   74 },	{   -5,   74 },	{  -12,   92 },	},	/*  255 */
	{	{  -17,  110 },	{  -10,   90 },	{   -9,   86 },	{  -18,  108 },	},	/*  256 */
	/* 257-266 coeff_abs_level_minus1 with ctxBlockCat 3 */
	{	{  -11,   97 },	{    0,   70 },	{    2,   66 },	{   -4,   79 },	},	/*  257 */
	{	{  -20,   84 },	{   -4,   29 },	{   -9,   34 },	{  -22,   69 },	},	/*  258 */
	{	{  -11,   79 },	{    5,   31 },	{    1,   32 },	{  -16,   75 },	},	/*  259 */
	{	{   -6,   73 },	{    7,   42 },	{   11,   31 },	{   -2,   58 },	},	/*  260 */
	{	{   -4,   74 },	{    1,   59 },	{    5,   52 },	{    1,   58 },	},	/*  261 */
	{	{  -13,   86 },	{   -2,   58 },	{   -2,   55 },	{  -13,   78 },	},	/*  262 */
	{	{  -13,   96 },	{   -3,   72 },	{   -2,   67 },	{   -9,   83 },	},	/*  263 */
	{	{  -11,   97 },	{   -3,   81 },	{    0,   73 },	{   -4,   81 },	},	/*  264 */
	{	{  -19,  117 },	{  -11,   97 },	{   -8,   89 },	{  -13,   99 },	},	/*  265 */
	/* 266-275 coeff_abs_level_minus1 with ctxBlockCat 4 */
	{	{   -8,   78 },	{    0,   58 },	{    3,   52 },	{  -13,   81 },	},	/*  266 */
	{	{   -5,   33 },	{    8,    5 },	{    7,    4 },	{   -6,   38 },	},	/*  267 */
	{	{   -4,   48 },	{   10,   14 },	{   10,    8 },	{  -13,   62 },	},	/*  268 */
	{	{   -2,   53 },	{   14,   18 },	{   17,    8 },	{   -6,   58 },	},	/*  269 */
	{	{   -3,   62 },	{   13,   27 },	{   16,   19 },	{   -2,   59 },	},	/*  270 */
	{	{  -13,   71 },	{    2,   40 },	{    3,   37 },	{  -16,   73 },	},	/*  271 */
	{	{  -10,   79 },	{    0,   58 },	{   -1,   61 },	{  -10,   76 },	},	/*  272 */
	{	{  -12,   86 },	{   -3,   70 },	{   -5,   73 },	{  -13,   86 },	},	/*  273 */
	{	{  -13,   90 },	{   -6,   79 },	{   -1,   70 },	{   -9,   83 },	},	/*  274 */
	{	{  -14,   97 },	{   -8,   85 },	{   -4,   78 },	{  -10,   87 },	},	/*  275 */

	/* 276 end_of_slice flag and mb_type I_PCM bin - special case */
	{	{    0,    0 },	{    0,    0 },	{    0,    0 },	{    0,    0 },	},	/*  276 */

	/* 277-291 significant_coeff_flag with ctxBlockCat 0 for field mode */
	{	{   -6,   93 },	{  -13,  106 },	{  -21,  126 },	{  -22,  127 },	},	/*  277 */
	{	{   -6,   84 },	{  -16,  106 },	{  -23,  124 },	{  -25,  127 },	},	/*  278 */
	{	{   -8,   79 },	{  -10,   87 },	{  -20,  110 },	{  -25,  120 },	},	/*  279 */
	{	{    0,   66 },	{  -21,  114 },	{  -26,  126 },	{  -27,  127 },	},	/*  280 */
	{	{   -1,   71 },	{  -18,  110 },	{  -25,  124 },	{  -19,  114 },	},	/*  281 */
	{	{    0,   62 },	{  -14,   98 },	{  -17,  105 },	{  -23,  117 },	},	/*  282 */
	{	{   -2,   60 },	{  -22,  110 },	{  -27,  121 },	{  -25,  118 },	},	/*  283 */
	{	{   -2,   59 },	{  -21,  106 },	{  -27,  117 },	{  -26,  117 },	},	/*  284 */
	{	{   -5,   75 },	{  -18,  103 },	{  -17,  102 },	{  -24,  113 },	},	/*  285 */
	{	{   -3,   62 },	{  -21,  107 },	{  -26,  117 },	{  -28,  118 },	},	/*  286 */
	{	{   -4,   58 },	{  -23,  108 },	{  -27,  116 },	{  -31,  120 },	},	/*  287 */
	{	{   -9,   66 },	{  -26,  112 },	{  -33,  122 },	{  -37,  124 },	},	/*  288 */
	{	{   -1,   79 },	{  -10,   96 },	{  -10,   95 },	{  -10,   94 },	},	/*  289 */
	{	{    0,   71 },	{  -12,   95 },	{  -14,  100 },	{  -15,  102 },	},	/*  290 */
	{	{    3,   68 },	{   -5,   91 },	{   -8,   95 },	{  -10,   99 },	},	/*  291 */
	/* 292-305 significant_coeff_flag with ctxBlockCat 1 for field mode */
	{	{   10,   44 },	{   -9,   93 },	{  -17,  111 },	{  -13,  106 },	},	/*  292 */
	{	{   -7,   62 },	{  -22,   94 },	{  -28,  114 },	{  -50,  127 },	},	/*  293 */
	{	{   15,   36 },	{   -5,   86 },	{   -6,   89 },	{   -5,   92 },	},	/*  294 */
	{	{   14,   40 },	{    9,   67 },	{   -2,   80 },	{   17,   57 },	},	/*  295 */
	{	{   16,   27 },	{   -4,   80 },	{   -4,   82 },	{   -5,   86 },	},	/*  296 */
	{	{   12,   29 },	{  -10,   85 },	{   -9,   85 },	{  -13,   94 },	},	/*  297 */
	{	{    1,   44 },	{   -1,   70 },	{   -8,   81 },	{  -12,   91 },	},	/*  298 */
	{	{   20,   36 },	{    7,   60 },	{   -1,   72 },	{   -2,   77 },	},	/*  299 */
	{	{   18,   32 },	{    9,   58 },	{    5,   64 },	{    0,   71 },	},	/*  300 */
	{	{    5,   42 },	{    5,   61 },	{    1,   67 },	{   -1,   73 },	},	/*  301 */
	{	{    1,   48 },	{   12,   50 },	{    9,   56 },	{    4,   64 },	},	/*  302 */
	{	{   10,   62 },	{   15,   50 },	{    0,   69 },	{   -7,   81 },	},	/*  303 */
	{	{   17,   46 },	{   18,   49 },	{    1,   69 },	{    5,   64 },	},	/*  304 */
	{	{    9,   64 },	{   17,   54 },	{    7,   69 },	{   15,   57 },	},	/*  305 */
	/* 306-320 significant_coeff_flag with ctxBlockCat 2 for field mode */
	{	{  -12,  104 },	{   10,   41 },	{   -7,   69 },	{    1,   67 },	},	/*  306 */
	{	{  -11,   97 },	{    7,   46 },	{   -6,   67 },	{    0,   68 },	},	/*  307 */
	{	{  -16,   96 },	{   -1,   51 },	{  -16,   77 },	{  -10,   67 },	},	/*  308 */
	{	{   -7,   88 },	{    7,   49 },	{   -2,   64 },	{    1,   68 },	},	/*  309 */
	{	{   -8,   85 },	{    8,   52 },	{    2,   61 },	{    0,   77 },	},	/*  310 */
	{	{   -7,   85 },	{    9,   41 },	{   -6,   67 },	{    2,   64 },	},	/*  311 */
	{	{   -9,   85 },	{    6,   47 },	{   -3,   64 },	{    0,   68 },	},	/*  312 */
	{	{  -13,   88 },	{    2,   55 },	{    2,   57 },	{   -5,   78 },	},	/*  313 */
	{	{    4,   66 },	{   13,   41 },	{   -3,   65 },	{    7,   55 },	},	/*  314 */
	{	{   -3,   77 },	{   10,   44 },	{   -3,   66 },	{    5,   59 },	},	/*  315 */
	{	{   -3,   76 },	{    6,   50 },	{    0,   62 },	{    2,   65 },	},	/*  316 */
	{	{   -6,   76 },	{    5,   53 },	{    9,   51 },	{   14,   54 },	},	/*  317 */
	{	{   10,   58 },	{   13,   49 },	{   -1,   66 },	{   15,   44 },	},	/*  318 */
	{	{   -1,   76 },	{    4,   63 },	{   -2,   71 },	{    5,   60 },	},	/*  319 */
	{	{   -1,   83 },	{    6,   64 },	{   -2,   75 },	{    2,   70 },	},	/*  320 */
	/* 321-323 significant_coeff_flag with ctxBlockCat 3 for field mode */
	{	{   -7,   99 },	{   -2,   69 },	{   -1,   70 },	{   -2,   76 },	},	/*  321 */
	{	{  -14,   95 },	{   -2,   59 },	{   -9,   72 },	{  -18,   86 },	},	/*  322 */
	{	{    2,   95 },	{    6,   70 },	{   14,   60 },	{   12,   70 },	},	/*  323 */
	/* 324-337 significant_coeff_flag with ctxBlockCat 4 for field mode */
	{	{    0,   76 },	{   10,   44 },	{   16,   37 },	{    5,   64 },	},	/*  324 */
	{	{   -5,   74 },	{    9,   31 },	{    0,   47 },	{  -12,   70 },	},	/*  325 */
	{	{    0,   70 },	{   12,   43 },	{   18,   35 },	{   11,   55 },	},	/*  326 */
	{	{  -11,   75 },	{    3,   53 },	{   11,   37 },	{    5,   56 },	},	/*  327 */
	{	{    1,   68 },	{   14,   34 },	{   12,   41 },	{    0,   69 },	},	/*  328 */
	{	{    0,   65 },	{   10,   38 },	{   10,   41 },	{    2,   65 },	},	/*  329 */
	{	{  -14,   73 },	{   -3,   52 },	{    2,   48 },	{   -6,   74 },	},	/*  330 */
	{	{    3,   62 },	{   13,   40 },	{   12,   41 },	{    5,   54 },	},	/*  331 */
	{	{    4,   62 },	{   17,   32 },	{   13,   41 },	{    7,   54 },	},	/*  332 */
	{	{   -1,   68 },	{    7,   44 },	{    0,   59 },	{   -6,   76 },	},	/*  333 */
	{	{  -13,   75 },	{    7,   38 },	{    3,   50 },	{  -11,   82 },	},	/*  334 */
	{	{   11,   55 },	{   13,   50 },	{   19,   40 },	{   -2,   77 },	},	/*  335 */
	{	{    5,   64 },	{   10,   57 },	{    3,   66 },	{   -2,   77 },	},	/*  336 */
	{	{   12,   70 },	{   26,   43 },	{   18,   50 },	{   25,   42 },	},	/*  337 */

	/* 338-352 last_significant_coeff_flag with ctxBlockCat 0 for field mode */
	{	{   15,    6 },	{   14,   11 },	{   19,   -6 },	{   17,  -13 },	},	/*  338 */
	{	{    6,   19 },	{   11,   14 },	{   18,   -6 },	{   16,   -9 },	},	/*  339 */
	{	{    7,   16 },	{    9,   11 },	{   14,    0 },	{   17,  -12 },	},	/*  340 */
	{	{   12,   14 },	{   18,   11 },	{   26,  -12 },	{   27,  -21 },	},	/*  341 */
	{	{   18,   13 },	{   21,    9 },	{   31,  -16 },	{   37,  -30 },	},	/*  342 */
	{	{   13,   11 },	{   23,   -2 },	{   33,  -25 },	{   41,  -40 },	},	/*  343 */
	{	{   13,   15 },	{   32,  -15 },	{   33,  -22 },	{   42,  -41 },	},	/*  344 */
	{	{   15,   16 },	{   32,  -15 },	{   37,  -28 },	{   48,  -47 },	},	/*  345 */
	{	{   12,   23 },	{   34,  -21 },	{   39,  -30 },	{   39,  -32 },	},	/*  346 */
	{	{   13,   23 },	{   39,  -23 },	{   42,  -30 },	{   46,  -40 },	},	/*  347 */
	{	{   15,   20 },	{   42,  -33 },	{   47,  -42 },	{   52,  -51 },	},	/*  348 */
	{	{   14,   26 },	{   41,  -31 },	{   45,  -36 },	{   46,  -41 },	},	/*  349 */
	{	{   14,   44 },	{   46,  -28 },	{   49,  -34 },	{   52,  -39 },	},	/*  350 */
	{	{   17,   40 },	{   38,  -12 },	{   41,  -17 },	{   43,  -19 },	},	/*  351 */
	{	{   17,   47 },	{   21,   29 },	{   32,    9 },	{   32,   11 },	},	/*  352 */
	/* 353-366 last_significant_coeff_flag with ctxBlockCat 1 for field mode */
	{	{   24,   17 },	{   45,  -24 },	{   69,  -71 },	{   61,  -55 },	},	/*  353 */
	{	{   21,   21 },	{   53,  -45 },	{   63,  -63 },	{   56,  -46 },	},	/*  354 */
	{	{   25,   22 },	{   48,  -26 },	{   66,  -64 },	{   62,  -50 },	},	/*  355 */
	{	{   31,   27 },	{   65,  -43 },	{   77,  -74 },	{   81,  -67 },	},	/*  356 */
	{	{   22,   29 },	{   43,  -19 },	{   54,  -39 },	{   45,  -20 },	},	/*  357 */
	{	{   19,   35 },	{   39,  -10 },	{   52,  -35 },	{   35,   -2 },	},	/*  358 */
	{	{   14,   50 },	{   30,    9 },	{   41,  -10 },	{   28,   15 },	},	/*  359 */
	{	{   10,   57 },	{   18,   26 },	{   36,    0 },	{   34,    1 },	},	/*  360 */
	{	{    7,   63 },	{   20,   27 },	{   40,   -1 },	{   39,    1 },	},	/*  361 */
	{	{   -2,   77 },	{    0,   57 },	{   30,   14 },	{   30,   17 },	},	/*  362 */
	{	{   -4,   82 },	{  -14,   82 },	{   28,   26 },	{   20,   38 },	},	/*  363 */
	{	{   -3,   94 },	{   -5,   75 },	{   23,   37 },	{   18,   45 },	},	/*  364 */
	{	{    9,   69 },	{  -19,   97 },	{   12,   55 },	{   15,   54 },	},	/*  365 */
	{	{  -12,  109 },	{  -35,  125 },	{   11,   65 },	{    0,   79 },	},	/*  366 */
	/* 367-381 last_significant_coeff_flag with ctxBlockCat 2 for field mode */
	{	{   36,  -35 },	{   27,    0 },	{   37,  -33 },	{   36,  -16 },	},	/*  367 */
	{	{   36,  -34 },	{   28,    0 },	{   39,  -36 },	{   37,  -14 },	},	/*  368 */
	{	{   32,  -26 },	{   31,   -4 },	{   40,  -37 },	{   37,  -17 },	},	/*  369 */
	{	{   37,  -30 },	{   27,    6 },	{   38,  -30 },	{   32,    1 },	},	/*  370 */
	{	{   44,  -32 },	{   34,    8 },	{   46,  -33 },	{   34,   15 },	},	/*  371 */
	{	{   34,  -18 },	{   30,   10 },	{   42,  -30 },	{   29,   15 },	},	/*  372 */
	{	{   34,  -15 },	{   24,   22 },	{   40,  -24 },	{   24,   25 },	},	/*  373 */
	{	{   40,  -15 },	{   33,   19 },	{   49,  -29 },	{   34,   22 },	},	/*  374 */
	{	{   33,   -7 },	{   22,   32 },	{   38,  -12 },	{   31,   16 },	},	/*  375 */
	{	{   35,   -5 },	{   26,   31 },	{   40,  -10 },	{   35,   18 },	},	/*  376 */
	{	{   33,    0 },	{   21,   41 },	{   38,   -3 },	{   31,   28 },	},	/*  377 */
	{	{   38,    2 },	{   26,   44 },	{   46,   -5 },	{   33,   41 },	},	/*  378 */
	{	{   33,   13 },	{   23,   47 },	{   31,   20 },	{   36,   28 },	},	/*  379 */
	{	{   23,   35 },	{   16,   65 },	{   29,   30 },	{   27,   47 },	},	/*  380 */
	{	{   13,   58 },	{   14,   71 },	{   25,   44 },	{   21,   62 },	},	/*  381 */
	/* 382-384 last_significant_coeff_flag with ctxBlockCat 3 for field mode */
	{	{   29,   -3 },	{    8,   60 },	{   12,   48 },	{   18,   31 },	},	/*  382 */
	{	{   26,    0 },	{    6,   63 },	{   11,   49 },	{   19,   26 },	},	/*  383 */
	{	{   22,   30 },	{   17,   65 },	{   26,   45 },	{   36,   24 },	},	/*  384 */
	/* 385-398 last_significant_coeff_flag with ctxBlockCat 4 for field mode */
	{	{   31,   -7 },	{   21,   24 },	{   22,   22 },	{   24,   23 },	},	/*  385 */
	{	{   35,  -15 },	{   23,   20 },	{   23,   22 },	{   27,   16 },	},	/*  386 */
	{	{   34,   -3 },	{   26,   23 },	{   27,   21 },	{   24,   30 },	},	/*  387 */
	{	{   34,    3 },	{   27,   32 },	{   33,   20 },	{   31,   29 },	},	/*  388 */
	{	{   36,   -1 },	{   28,   23 },	{   26,   28 },	{   22,   41 },	},	/*  389 */
	{	{   34,    5 },	{   28,   24 },	{   30,   24 },	{   22,   42 },	},	/*  390 */
	{	{   32,   11 },	{   23,   40 },	{   27,   34 },	{   16,   60 },	},	/*  391 */
	{	{   35,    5 },	{   24,   32 },	{   18,   42 },	{   15,   52 },	},	/*  392 */
	{	{   34,   12 },	{   28,   29 },	{   25,   39 },	{   14,   60 },	},	/*  393 */
	{	{   39,   11 },	{   23,   42 },	{   18,   50 },	{    3,   78 },	},	/*  394 */
	{	{   30,   29 },	{   19,   57 },	{   12,   70 },	{  -16,  123 },	},	/*  395 */
	{	{   34,   26 },	{   22,   53 },	{   21,   54 },	{   21,   53 },	},	/*  396 */
	{	{   29,   39 },	{   22,   61 },	{   14,   71 },	{   22,   56 },	},	/*  397 */
	{	{   19,   66 },	{   11,   86 },	{   11,   83 },	{   25,   61 },	},	/*  398 */

	/* 399-401 transform_size_8x8_flag */
	{	{   31,   21 },	{   12,   40 },	{   25,   32 },	{   21,   33 },	},	/*  399 */
	{	{   31,   31 },	{   11,   51 },	{   21,   49 },	{   19,   50 },	},	/*  400 */
	{	{   25,   50 },	{   14,   59 },	{   21,   54 },	{   17,   61 },	},	/*  401 */

	/* 402-416 significant_coeff_flag with ctxBlockCat 5 for frame mode */
	{	{  -17,  120 },	{   -4,   79 },	{   -5,   85 },	{   -3,   78 },	},	/*  402 */
	{	{  -20,  112 },	{   -7,   71 },	{   -6,   81 },	{   -8,   74 },	},	/*  403 */
	{	{  -18,  114 },	{   -5,   69 },	{  -10,   77 },	{   -9,   72 },	},	/*  404 */
	{	{  -11,   85 },	{   -9,   70 },	{   -7,   81 },	{  -10,   72 },	},	/*  405 */
	{	{  -15,   92 },	{   -8,   66 },	{  -17,   80 },	{  -18,   75 },	},	/*  406 */
	{	{  -14,   89 },	{  -10,   68 },	{  -18,   73 },	{  -12,   71 },	},	/*  407 */
	{	{  -26,   71 },	{  -19,   73 },	{   -4,   74 },	{  -11,   63 },	},	/*  408 */
	{	{  -15,   81 },	{  -12,   69 },	{  -10,   83 },	{   -5,   70 },	},	/*  409 */
	{	{  -14,   80 },	{  -16,   70 },	{   -9,   71 },	{  -17,   75 },	},	/*  410 */
	{	{    0,   68 },	{  -15,   67 },	{   -9,   67 },	{  -14,   72 },	},	/*  411 */
	{	{  -14,   70 },	{  -20,   62 },	{   -1,   61 },	{  -16,   67 },	},	/*  412 */
	{	{  -24,   56 },	{  -19,   70 },	{   -8,   66 },	{   -8,   53 },	},	/*  413 */
	{	{  -23,   68 },	{  -16,   66 },	{  -14,   66 },	{  -14,   59 },	},	/*  414 */
	{	{  -24,   50 },	{  -22,   65 },	{    0,   59 },	{   -9,   52 },	},	/*  415 */
	{	{  -11,   74 },	{  -20,   63 },	{    2,   59 },	{  -11,   68 },	},	/*  416 */
	/* 417-425 last_significant_coeff_flag with ctxBlockCat 5 for frame mode */
	{	{   23,  -13 },	{    9,   -2 },	{   17,  -10 },	{    9,   -2 },	},	/*  417 */
	{	{   26,  -13 },	{   26,   -9 },	{   32,  -13 },	{   30,  -10 },	},	/*  418 */
	{	{   40,  -15 },	{   33,   -9 },	{   42,   -9 },	{   31,   -4 },	},	/*  419 */
	{	{   49,  -14 },	{   39,   -7 },	{   49,   -5 },	{   33,   -1 },	},	/*  420 */
	{	{   44,    3 },	{   41,   -2 },	{   53,    0 },	{   33,    7 },	},	/*  421 */
	{	{   45,    6 },	{   45,    3 },	{   64,    3 },	{   31,   12 },	},	/*  422 */
	{	{   44,   34 },	{   49,    9 },	{   68,   10 },	{   37,   23 },	},	/*  423 */
	{	{   33,   54 },	{   45,   27 },	{   66,   27 },	{   31,   38 },	},	/*  424 */
	{	{   19,   82 },	{   36,   59 },	{   47,   57 },	{   20,   64 },	},	/*  425 */
	/* 436-435 coeff_abs_level_minus1 with ctxBlockCat 5 */
	{	{   -3,   75 },	{   -6,   66 },	{   -5,   71 },	{   -9,   71 },	},	/*  426 */
	{	{   -1,   23 },	{   -7,   35 },	{    0,   24 },	{   -7,   37 },	},	/*  427 */
	{	{    1,   34 },	{   -7,   42 },	{   -1,   36 },	{   -8,   44 },	},	/*  428 */
	{	{    1,   43 },	{   -8,   45 },	{   -2,   42 },	{  -11,   49 },	},	/*  429 */
	{	{    0,   54 },	{   -5,   48 },	{   -2,   52 },	{  -10,   56 },	},	/*  430 */
	{	{   -2,   55 },	{  -12,   56 },	{   -9,   57 },	{  -12,   59 },	},	/*  431 */
	{	{    0,   61 },	{   -6,   60 },	{   -6,   63 },	{   -8,   63 },	},	/*  432 */
	{	{    1,   64 },	{   -5,   62 },	{   -4,   65 },	{   -9,   67 },	},	/*  433 */
	{	{    0,   68 },	{   -8,   66 },	{   -4,   67 },	{   -6,   68 },	},	/*  434 */
	{	{   -9,   92 },	{   -8,   76 },	{   -7,   82 },	{  -10,   79 },	},	/*  435 */
	/* 436-450 significant_coeff_flag with ctxBlockCat 5 for field mode */
	{	{  -14,  106 },	{   -5,   85 },	{   -3,   81 },	{   -3,   78 },	},	/*  436 */
	{	{  -13,   97 },	{   -6,   81 },	{   -3,   76 },	{   -8,   74 },	},	/*  437 */
	{	{  -15,   90 },	{  -10,   77 },	{   -7,   72 },	{   -9,   72 },	},	/*  438 */
	{	{  -12,   90 },	{   -7,   81 },	{   -6,   78 },	{  -10,   72 },	},	/*  439 */
	{	{  -18,   88 },	{  -17,   80 },	{  -12,   72 },	{  -18,   75 },	},	/*  440 */
	{	{  -10,   73 },	{  -18,   73 },	{  -14,   68 },	{  -12,   71 },	},	/*  441 */
	{	{   -9,   79 },	{   -4,   74 },	{   -3,   70 },	{  -11,   63 },	},	/*  442 */
	{	{  -14,   86 },	{  -10,   83 },	{   -6,   76 },	{   -5,   70 },	},	/*  443 */
	{	{  -10,   73 },	{   -9,   71 },	{   -5,   66 },	{  -17,   75 },	},	/*  444 */
	{	{  -10,   70 },	{   -9,   67 },	{   -5,   62 },	{  -14,   72 },	},	/*  445 */
	{	{  -10,   69 },	{   -1,   61 },	{    0,   57 },	{  -16,   67 },	},	/*  446 */
	{	{   -5,   66 },	{   -8,   66 },	{   -4,   61 },	{   -8,   53 },	},	/*  447 */
	{	{   -9,   64 },	{  -14,   66 },	{   -9,   60 },	{  -14,   59 },	},	/*  448 */
	{	{   -5,   58 },	{    0,   59 },	{    1,   54 },	{   -9,   52 },	},	/*  449 */
	{	{    2,   59 },	{    2,   59 },	{    2,   58 },	{  -11,   68 },	},	/*  450 */
	/* 451-459 last_significant_coeff_flag with ctxBlockCat 5 for field mode */
	{	{   21,  -10 },	{   21,  -13 },	{   17,  -10 },	{    9,   -2 },	},	/*  451 */
	{	{   24,  -11 },	{   33,  -14 },	{   32,  -13 },	{   30,  -10 },	},	/*  452 */
	{	{   28,   -8 },	{   39,   -7 },	{   42,   -9 },	{   31,   -4 },	},	/*  453 */
	{	{   28,   -1 },	{   46,   -2 },	{   49,   -5 },	{   33,   -1 },	},	/*  454 */
	{	{   29,    3 },	{   51,    2 },	{   53,    0 },	{   33,    7 },	},	/*  455 */
	{	{   29,    9 },	{   60,    6 },	{   64,    3 },	{   31,   12 },	},	/*  456 */
	{	{   35,   20 },	{   61,   17 },	{   68,   10 },	{   37,   23 },	},	/*  457 */
	{	{   29,   36 },	{   55,   34 },	{   66,   27 },	{   31,   38 },	},	/*  458 */
	{	{   14,   67 },	{   42,   62 },	{   47,   57 },	{   20,   64 },	},	/*  459 */

	/* 460-463 coded_block_flag with ctxBlockCat 6 */
	{	{  -17,  123 },	{   -7,   92 },	{    0,   80 },	{   11,   80 },	},	/*  460 */
	{	{  -12,  115 },	{   -5,   89 },	{   -5,   89 },	{    5,   76 },	},	/*  461 */
	{	{  -16,  122 },	{   -7,   96 },	{   -7,   94 },	{    2,   84 },	},	/*  462 */
	{	{  -11,  115 },	{  -13,  108 },	{   -4,   92 },	{    5,   78 },	},	/*  463 */
	/* 464-467 coded_block_flag with ctxBlockCat 7 */
	{	{  -12,   63 },	{   -3,   46 },	{    0,   39 },	{   -6,   55 },	},	/*  464 */
	{	{   -2,   68 },	{   -1,   65 },	{    0,   65 },	{    4,   61 },	},	/*  465 */
	{	{  -15,   84 },	{   -1,   57 },	{  -15,   84 },	{  -14,   83 },	},	/*  466 */
	{	{  -13,  104 },	{   -9,   93 },	{  -35,  127 },	{  -37,  127 },	},	/*  467 */
	/* 468-471 coded_block_flag with ctxBlockCat 8 */
	{	{   -3,   70 },	{   -3,   74 },	{   -2,   73 },	{   -5,   79 },	},	/*  468 */
	{	{   -8,   93 },	{   -9,   92 },	{  -12,  104 },	{  -11,  104 },	},	/*  469 */
	{	{  -10,   90 },	{   -8,   87 },	{   -9,   91 },	{  -11,   91 },	},	/*  470 */
	{	{  -30,  127 },	{  -23,  126 },	{  -31,  127 },	{  -30,  127 },	},	/*  471 */
	/* 472-475 coded_block_flag with ctxBlockCat 10 */
	{	{  -17,  123 },	{   -7,   92 },	{    0,   80 },	{   11,   80 },	},	/*  472 */
	{	{  -12,  115 },	{   -5,   89 },	{   -5,   89 },	{    5,   76 },	},	/*  473 */
	{	{  -16,  122 },	{   -7,   96 },	{   -7,   94 },	{    2,   84 },	},	/*  474 */
	{	{  -11,  115 },	{  -13,  108 },	{   -4,   92 },	{    5,   78 },	},	/*  475 */
	/* 476-479 coded_block_flag with ctxBlockCat 11 */
	{	{  -12,   63 },	{   -3,   46 },	{    0,   39 },	{   -6,   55 },	},	/*  476 */
	{	{   -2,   68 },	{   -1,   65 },	{    0,   65 },	{    4,   61 },	},	/*  477 */
	{	{  -15,   84 },	{   -1,   57 },	{  -15,   84 },	{  -14,   83 },	},	/*  478 */
	{	{  -13,  104 },	{   -9,   93 },	{  -35,  127 },	{  -37,  127 },	},	/*  479 */
	/* 480-483 coded_block_flag with ctxBlockCat 12 */
	{	{   -3,   70 },	{   -3,   74 },	{   -2,   73 },	{   -5,   79 },	},	/*  480 */
	{	{   -8,   93 },	{   -9,   92 },	{  -12,  104 },	{  -11,  104 },	},	/*  481 */
	{	{  -10,   90 },	{   -8,   87 },	{   -9,   91 },	{  -11,   91 },	},	/*  482 */
	{	{  -30,  127 },	{  -23,  126 },	{  -31,  127 },	{  -30,  127 },	},	/*  483 */

	/* 484-498 significant_coeff_flag with ctxBlockCat 6 for frame mode */
	{	{   -7,   93 },	{   -2,   85 },	{  -13,  103 },	{   -4,   86 },	},	/*  484 */
	{	{  -11,   87 },	{   -6,   78 },	{  -13,   91 },	{  -12,   88 },	},	/*  485 */
	{	{   -3,   77 },	{   -1,   75 },	{   -9,   89 },	{   -5,   82 },	},	/*  486 */
	{	{   -5,   71 },	{   -7,   77 },	{  -14,   92 },	{   -3,   72 },	},	/*  487 */
	{	{   -4,   63 },	{    2,   54 },	{   -8,   76 },	{   -4,   67 },	},	/*  488 */
	{	{   -4,   68 },	{    5,   50 },	{  -12,   87 },	{   -8,   72 },	},	/*  489 */
	{	{  -12,   84 },	{   -3,   68 },	{  -23,  110 },	{  -16,   89 },	},	/*  490 */
	{	{   -7,   62 },	{    1,   50 },	{  -24,  105 },	{   -9,   69 },	},	/*  491 */
	{	{   -7,   65 },	{    6,   42 },	{  -10,   78 },	{   -1,   59 },	},	/*  492 */
	{	{    8,   61 },	{   -4,   81 },	{  -20,  112 },	{    5,   66 },	},	/*  493 */
	{	{    5,   56 },	{    1,   63 },	{  -17,   99 },	{    4,   57 },	},	/*  494 */
	{	{   -2,   66 },	{   -4,   70 },	{  -78,  127 },	{   -4,   71 },	},	/*  495 */
	{	{    1,   64 },	{    0,   67 },	{  -70,  127 },	{   -2,   71 },	},	/*  496 */
	{	{    0,   61 },	{    2,   57 },	{  -50,  127 },	{    2,   58 },	},	/*  497 */
	{	{   -2,   78 },	{   -2,   76 },	{  -46,  127 },	{   -1,   74 },	},	/*  498 */
	/* 499-512 significant_coeff_flag with ctxBlockCat 7 for frame mode */
	{	{    1,   50 },	{   11,   35 },	{   -4,   66 },	{   -4,   44 },	},	/*  499 */
	{	{    7,   52 },	{    4,   64 },	{   -5,   78 },	{   -1,   69 },	},	/*  500 */
	{	{   10,   35 },	{    1,   61 },	{   -4,   71 },	{    0,   62 },	},	/*  501 */
	{	{    0,   44 },	{   11,   35 },	{   -8,   72 },	{   -7,   51 },	},	/*  502 */
	{	{   11,   38 },	{   18,   25 },	{    2,   59 },	{   -4,   47 },	},	/*  503 */
	{	{    1,   45 },	{   12,   24 },	{   -1,   55 },	{   -6,   42 },	},	/*  504 */
	{	{    0,   46 },	{   13,   29 },	{   -7,   70 },	{   -3,   41 },	},	/*  505 */
	{	{    5,   44 },	{   13,   36 },	{   -6,   75 },	{   -6,   53 },	},	/*  506 */
	{	{   31,   17 },	{  -10,   93 },	{   -8,   89 },	{    8,   76 },	},	/*  507 */
	{	{    1,   51 },	{   -7,   73 },	{  -34,  119 },	{   -9,   78 },	},	/*  508 */
	{	{    7,   50 },	{   -2,   73 },	{   -3,   75 },	{  -11,   83 },	},	/*  509 */
	{	{   28,   19 },	{   13,   46 },	{   32,   20 },	{    9,   52 },	},	/*  510 */
	{	{   16,   33 },	{    9,   49 },	{   30,   22 },	{    0,   67 },	},	/*  511 */
	{	{   14,   62 },	{   -7,  100 },	{  -44,  127 },	{   -5,   90 },	},	/*  512 */
	/* 513-527 significant_coeff_flag with ctxBlockCat 8 for frame mode */
	{	{  -13,  108 },	{    9,   53 },	{    0,   54 },	{    1,   67 },	},	/*  513 */
	{	{  -15,  100 },	{    2,   53 },	{   -5,   61 },	{  -15,   72 },	},	/*  514 */
	{	{  -13,  101 },	{    5,   53 },	{    0,   58 },	{   -5,   75 },	},	/*  515 */
	{	{  -13,   91 },	{   -2,   61 },	{   -1,   60 },	{   -8,   80 },	},	/*  516 */
	{	{  -12,   94 },	{    0,   56 },	{   -3,   61 },	{  -21,   83 },	},	/*  517 */
	{	{  -10,   88 },	{    0,   56 },	{   -8,   67 },	{  -21,   64 },	},	/*  518 */
	{	{  -16,   84 },	{  -13,   63 },	{  -25,   84 },	{  -13,   31 },	},	/*  519 */
	{	{  -10,   86 },	{   -5,   60 },	{  -14,   74 },	{  -25,   64 },	},	/*  520 */
	{	{   -7,   83 },	{   -1,   62 },	{   -5,   65 },	{  -29,   94 },	},	/*  521 */
	{	{  -13,   87 },	{    4,   57 },	{    5,   52 },	{    9,   75 },	},	/*  522 */
	{	{  -19,   94 },	{   -6,   69 },	{    2,   57 },	{   17,   63 },	},	/*  523 */
	{	{    1,   70 },	{    4,   57 },	{    0,   61 },	{   -8,   74 },	},	/*  524 */
	{	{    0,   72 },	{   14,   39 },	{   -9,   69 },	{   -5,   35 },	},	/*  525 */
	{	{   -5,   74 },	{    4,   51 },	{  -11,   70 },	{   -2,   27 },	},	/*  526 */
	{	{   18,   59 },	{   13,   68 },	{   18,   55 },	{   13,   91 },	},	/*  527 */
	/* 528-542 significant_coeff_flag with ctxBlockCat 10 for frame mode */
	{	{   -7,   93 },	{   -2,   85 },	{  -13,  103 },	{   -4,   86 },	},	/*  528 */
	{	{  -11,   87 },	{   -6,   78 },	{  -13,   91 },	{  -12,   88 },	},	/*  529 */
	{	{   -3,   77 },	{   -1,   75 },	{   -9,   89 },	{   -5,   82 },	},	/*  530 */
	{	{   -5,   71 },	{   -7,   77 },	{  -14,   92 },	{   -3,   72 },	},	/*  531 */
	{	{   -4,   63 },	{    2,   54 },	{   -8,   76 },	{   -4,   67 },	},	/*  532 */
	{	{   -4,   68 },	{    5,   50 },	{  -12,   87 },	{   -8,   72 },	},	/*  533 */
	{	{  -12,   84 },	{   -3,   68 },	{  -23,  110 },	{  -16,   89 },	},	/*  534 */
	{	{   -7,   62 },	{    1,   50 },	{  -24,  105 },	{   -9,   69 },	},	/*  535 */
	{	{   -7,   65 },	{    6,   42 },	{  -10,   78 },	{   -1,   59 },	},	/*  536 */
	{	{    8,   61 },	{   -4,   81 },	{  -20,  112 },	{    5,   66 },	},	/*  537 */
	{	{    5,   56 },	{    1,   63 },	{  -17,   99 },	{    4,   57 },	},	/*  538 */
	{	{   -2,   66 },	{   -4,   70 },	{  -78,  127 },	{   -4,   71 },	},	/*  539 */
	{	{    1,   64 },	{    0,   67 },	{  -70,  127 },	{   -2,   71 },	},	/*  540 */
	{	{    0,   61 },	{    2,   57 },	{  -50,  127 },	{    2,   58 },	},	/*  541 */
	{	{   -2,   78 },	{   -2,   76 },	{  -46,  127 },	{   -1,   74 },	},	/*  542 */
	/* 543-556 significant_coeff_flag with ctxBlockCat 11 for frame mode */
	{	{    1,   50 },	{   11,   35 },	{   -4,   66 },	{   -4,   44 },	},	/*  543 */
	{	{    7,   52 },	{    4,   64 },	{   -5,   78 },	{   -1,   69 },	},	/*  544 */
	{	{   10,   35 },	{    1,   61 },	{   -4,   71 },	{    0,   62 },	},	/*  545 */
	{	{    0,   44 },	{   11,   35 },	{   -8,   72 },	{   -7,   51 },	},	/*  546 */
	{	{   11,   38 },	{   18,   25 },	{    2,   59 },	{   -4,   47 },	},	/*  547 */
	{	{    1,   45 },	{   12,   24 },	{   -1,   55 },	{   -6,   42 },	},	/*  548 */
	{	{    0,   46 },	{   13,   29 },	{   -7,   70 },	{   -3,   41 },	},	/*  549 */
	{	{    5,   44 },	{   13,   36 },	{   -6,   75 },	{   -6,   53 },	},	/*  550 */
	{	{   31,   17 },	{  -10,   93 },	{   -8,   89 },	{    8,   76 },	},	/*  551 */
	{	{    1,   51 },	{   -7,   73 },	{  -34,  119 },	{   -9,   78 },	},	/*  552 */
	{	{    7,   50 },	{   -2,   73 },	{   -3,   75 },	{  -11,   83 },	},	/*  553 */
	{	{   28,   19 },	{   13,   46 },	{   32,   20 },	{    9,   52 },	},	/*  554 */
	{	{   16,   33 },	{    9,   49 },	{   30,   22 },	{    0,   67 },	},	/*  555 */
	{	{   14,   62 },	{   -7,  100 },	{  -44,  127 },	{   -5,   90 },	},	/*  556 */
	/* 557-571 significant_coeff_flag with ctxBlockCat 12 for frame mode */
	{	{  -13,  108 },	{    9,   53 },	{    0,   54 },	{    1,   67 },	},	/*  557 */
	{	{  -15,  100 },	{    2,   53 },	{   -5,   61 },	{  -15,   72 },	},	/*  558 */
	{	{  -13,  101 },	{    5,   53 },	{    0,   58 },	{   -5,   75 },	},	/*  559 */
	{	{  -13,   91 },	{   -2,   61 },	{   -1,   60 },	{   -8,   80 },	},	/*  560 */
	{	{  -12,   94 },	{    0,   56 },	{   -3,   61 },	{  -21,   83 },	},	/*  561 */
	{	{  -10,   88 },	{    0,   56 },	{   -8,   67 },	{  -21,   64 },	},	/*  562 */
	{	{  -16,   84 },	{  -13,   63 },	{  -25,   84 },	{  -13,   31 },	},	/*  563 */
	{	{  -10,   86 },	{   -5,   60 },	{  -14,   74 },	{  -25,   64 },	},	/*  564 */
	{	{   -7,   83 },	{   -1,   62 },	{   -5,   65 },	{  -29,   94 },	},	/*  565 */
	{	{  -13,   87 },	{    4,   57 },	{    5,   52 },	{    9,   75 },	},	/*  566 */
	{	{  -19,   94 },	{   -6,   69 },	{    2,   57 },	{   17,   63 },	},	/*  567 */
	{	{    1,   70 },	{    4,   57 },	{    0,   61 },	{   -8,   74 },	},	/*  568 */
	{	{    0,   72 },	{   14,   39 },	{   -9,   69 },	{   -5,   35 },	},	/*  569 */
	{	{   -5,   74 },	{    4,   51 },	{  -11,   70 },	{   -2,   27 },	},	/*  570 */
	{	{   18,   59 },	{   13,   68 },	{   18,   55 },	{   13,   91 },	},	/*  571 */

	/* 572-586 last_significant_coeff_flag with ctxBlockCat 6 for frame mode */
	{	{   24,    0 },	{   11,   28 },	{    4,   45 },	{    4,   39 },	},	/*  572 */
	{	{   15,    9 },	{    2,   40 },	{   10,   28 },	{    0,   42 },	},	/*  573 */
	{	{    8,   25 },	{    3,   44 },	{   10,   31 },	{    7,   34 },	},	/*  574 */
	{	{   13,   18 },	{    0,   49 },	{   33,  -11 },	{   11,   29 },	},	/*  575 */
	{	{   15,    9 },	{    0,   46 },	{   52,  -43 },	{    8,   31 },	},	/*  576 */
	{	{   13,   19 },	{    2,   44 },	{   18,   15 },	{    6,   37 },	},	/*  577 */
	{	{   10,   37 },	{    2,   51 },	{   28,    0 },	{    7,   42 },	},	/*  578 */
	{	{   12,   18 },	{    0,   47 },	{   35,  -22 },	{    3,   40 },	},	/*  579 */
	{	{    6,   29 },	{    4,   39 },	{   38,  -25 },	{    8,   33 },	},	/*  580 */
	{	{   20,   33 },	{    2,   62 },	{   34,    0 },	{   13,   43 },	},	/*  581 */
	{	{   15,   30 },	{    6,   46 },	{   39,  -18 },	{   13,   36 },	},	/*  582 */
	{	{    4,   45 },	{    0,   54 },	{   32,  -12 },	{    4,   47 },	},	/*  583 */
	{	{    1,   58 },	{    3,   54 },	{  102,  -94 },	{    3,   55 },	},	/*  584 */
	{	{    0,   62 },	{    2,   58 },	{    0,    0 },	{    2,   58 },	},	/*  585 */
	{	{    7,   61 },	{    4,   63 },	{   56,  -15 },	{    6,   60 },	},	/*  586 */
	/* 587-600 last_significant_coeff_flag with ctxBlockCat 7 for frame mode */
	{	{   12,   38 },	{    6,   51 },	{   33,   -4 },	{    8,   44 },	},	/*  587 */
	{	{   11,   45 },	{    6,   57 },	{   29,   10 },	{   11,   44 },	},	/*  588 */
	{	{   15,   39 },	{    7,   53 },	{   37,   -5 },	{   14,   42 },	},	/*  589 */
	{	{   11,   42 },	{    6,   52 },	{   51,  -29 },	{    7,   48 },	},	/*  590 */
	{	{   13,   44 },	{    6,   55 },	{   39,   -9 },	{    4,   56 },	},	/*  591 */
	{	{   16,   45 },	{   11,   45 },	{   52,  -34 },	{    4,   52 },	},	/*  592 */
	{	{   12,   41 },	{   14,   36 },	{   69,  -58 },	{   13,   37 },	},	/*  593 */
	{	{   10,   49 },	{    8,   53 },	{   67,  -63 },	{    9,   49 },	},	/*  594 */
	{	{   30,   34 },	{   -1,   82 },	{   44,   -5 },	{   19,   58 },	},	/*  595 */
	{	{   18,   42 },	{    7,   55 },	{   32,    7 },	{   10,   48 },	},	/*  596 */
	{	{   10,   55 },	{   -3,   78 },	{   55,  -29 },	{   12,   45 },	},	/*  597 */
	{	{   17,   51 },	{   15,   46 },	{   32,    1 },	{    0,   69 },	},	/*  598 */
	{	{   17,   46 },	{   22,   31 },	{    0,    0 },	{   20,   33 },	},	/*  599 */
	{	{    0,   89 },	{   -1,   84 },	{   27,   36 },	{    8,   63 },	},	/*  600 */
	/* 601-615 last_significant_coeff_flag with ctxBlockCat 8 for frame mode */
	{	{   26,  -19 },	{   25,    7 },	{   33,  -25 },	{   35,  -18 },	},	/*  601 */
	{	{   22,  -17 },	{   30,   -7 },	{   34,  -30 },	{   33,  -25 },	},	/*  602 */
	{	{   26,  -17 },	{   28,    3 },	{   36,  -28 },	{   28,   -3 },	},	/*  603 */
	{	{   30,  -25 },	{   28,    4 },	{   38,  -28 },	{   24,   10 },	},	/*  604 */
	{	{   28,  -20 },	{   32,    0 },	{   38,  -27 },	{   27,    0 },	},	/*  605 */
	{	{   33,  -23 },	{   34,   -1 },	{   34,  -18 },	{   34,  -14 },	},	/*  606 */
	{	{   37,  -27 },	{   30,    6 },	{   35,  -16 },	{   52,  -44 },	},	/*  607 */
	{	{   33,  -23 },	{   30,    6 },	{   34,  -14 },	{   39,  -24 },	},	/*  608 */
	{	{   40,  -28 },	{   32,    9 },	{   32,   -8 },	{   19,   17 },	},	/*  609 */
	{	{   38,  -17 },	{   31,   19 },	{   37,   -6 },	{   31,   25 },	},	/*  610 */
	{	{   33,  -11 },	{   26,   27 },	{   35,    0 },	{   36,   29 },	},	/*  611 */
	{	{   40,  -15 },	{   26,   30 },	{   30,   10 },	{   24,   33 },	},	/*  612 */
	{	{   41,   -6 },	{   37,   20 },	{   28,   18 },	{   34,   15 },	},	/*  613 */
	{	{   38,    1 },	{   28,   34 },	{   26,   25 },	{   30,   20 },	},	/*  614 */
	{	{   41,   17 },	{   17,   70 },	{   29,   41 },	{   22,   73 },	},	/*  615 */

	/* 616-630 last_significant_coeff_flag with ctxBlockCat 10 for frame mode */
	{	{   24,    0 },	{   11,   28 },	{    4,   45 },	{    4,   39 },	},	/*  616 */
	{	{   15,    9 },	{    2,   40 },	{   10,   28 },	{    0,   42 },	},	/*  617 */
	{	{    8,   25 },	{    3,   44 },	{   10,   31 },	{    7,   34 },	},	/*  618 */
	{	{   13,   18 },	{    0,   49 },	{   33,  -11 },	{   11,   29 },	},	/*  619 */
	{	{   15,    9 },	{    0,   46 },	{   52,  -43 },	{    8,   31 },	},	/*  620 */
	{	{   13,   19 },	{    2,   44 },	{   18,   15 },	{    6,   37 },	},	/*  621 */
	{	{   10,   37 },	{    2,   51 },	{   28,    0 },	{    7,   42 },	},	/*  622 */
	{	{   12,   18 },	{    0,   47 },	{   35,  -22 },	{    3,   40 },	},	/*  623 */
	{	{    6,   29 },	{    4,   39 },	{   38,  -25 },	{    8,   33 },	},	/*  624 */
	{	{   20,   33 },	{    2,   62 },	{   34,    0 },	{   13,   43 },	},	/*  625 */
	{	{   15,   30 },	{    6,   46 },	{   39,  -18 },	{   13,   36 },	},	/*  626 */
	{	{    4,   45 },	{    0,   54 },	{   32,  -12 },	{    4,   47 },	},	/*  627 */
	{	{    1,   58 },	{    3,   54 },	{  102,  -94 },	{    3,   55 },	},	/*  628 */
	{	{    0,   62 },	{    2,   58 },	{    0,    0 },	{    2,   58 },	},	/*  629 */
	{	{    7,   61 },	{    4,   63 },	{   56,  -15 },	{    6,   60 },	},	/*  630 */
	/* 631-644 last_significant_coeff_flag with ctxBlockCat 11 for frame mode */
	{	{   12,   38 },	{    6,   51 },	{   33,   -4 },	{    8,   44 },	},	/*  631 */
	{	{   11,   45 },	{    6,   57 },	{   29,   10 },	{   11,   44 },	},	/*  632 */
	{	{   15,   39 },	{    7,   53 },	{   37,   -5 },	{   14,   42 },	},	/*  633 */
	{	{   11,   42 },	{    6,   52 },	{   51,  -29 },	{    7,   48 },	},	/*  634 */
	{	{   13,   44 },	{    6,   55 },	{   39,   -9 },	{    4,   56 },	},	/*  635 */
	{	{   16,   45 },	{   11,   45 },	{   52,  -34 },	{    4,   52 },	},	/*  636 */
	{	{   12,   41 },	{   14,   36 },	{   69,  -58 },	{   13,   37 },	},	/*  637 */
	{	{   10,   49 },	{    8,   53 },	{   67,  -63 },	{    9,   49 },	},	/*  638 */
	{	{   30,   34 },	{   -1,   82 },	{   44,   -5 },	{   19,   58 },	},	/*  639 */
	{	{   18,   42 },	{    7,   55 },	{   32,    7 },	{   10,   48 },	},	/*  640 */
	{	{   10,   55 },	{   -3,   78 },	{   55,  -29 },	{   12,   45 },	},	/*  641 */
	{	{   17,   51 },	{   15,   46 },	{   32,    1 },	{    0,   69 },	},	/*  642 */
	{	{   17,   46 },	{   22,   31 },	{    0,    0 },	{   20,   33 },	},	/*  643 */
	{	{    0,   89 },	{   -1,   84 },	{   27,   36 },	{    8,   63 },	},	/*  644 */
	/* 645-659 last_significant_coeff_flag with ctxBlockCat 12 for frame mode */
	{	{   26,  -19 },	{   25,    7 },	{   33,  -25 },	{   35,  -18 },	},	/*  645 */
	{	{   22,  -17 },	{   30,   -7 },	{   34,  -30 },	{   33,  -25 },	},	/*  646 */
	{	{   26,  -17 },	{   28,    3 },	{   36,  -28 },	{   28,   -3 },	},	/*  647 */
	{	{   30,  -25 },	{   28,    4 },	{   38,  -28 },	{   24,   10 },	},	/*  648 */
	{	{   28,  -20 },	{   32,    0 },	{   38,  -27 },	{   27,    0 },	},	/*  649 */
	{	{   33,  -23 },	{   34,   -1 },	{   34,  -18 },	{   34,  -14 },	},	/*  650 */
	{	{   37,  -27 },	{   30,    6 },	{   35,  -16 },	{   52,  -44 },	},	/*  651 */
	{	{   33,  -23 },	{   30,    6 },	{   34,  -14 },	{   39,  -24 },	},	/*  652 */
	{	{   40,  -28 },	{   32,    9 },	{   32,   -8 },	{   19,   17 },	},	/*  653 */
	{	{   38,  -17 },	{   31,   19 },	{   37,   -6 },	{   31,   25 },	},	/*  654 */
	{	{   33,  -11 },	{   26,   27 },	{   35,    0 },	{   36,   29 },	},	/*  655 */
	{	{   40,  -15 },	{   26,   30 },	{   30,   10 },	{   24,   33 },	},	/*  656 */
	{	{   41,   -6 },	{   37,   20 },	{   28,   18 },	{   34,   15 },	},	/*  657 */
	{	{   38,    1 },	{   28,   34 },	{   26,   25 },	{   30,   20 },	},	/*  658 */
	{	{   41,   17 },	{   17,   70 },	{   29,   41 },	{   22,   73 },	},	/*  659 */

	/* 660-674 significant_coeff_flag with ctxBlockCat 9 for frame mode */
	{	{  -17,  120 },	{   -4,   79 },	{   -5,   85 },	{   -3,   78 },	},	/*  660 */
	{	{  -20,  112 },	{   -7,   71 },	{   -6,   81 },	{   -8,   74 },	},	/*  661 */
	{	{  -18,  114 },	{   -5,   69 },	{  -10,   77 },	{   -9,   72 },	},	/*  662 */
	{	{  -11,   85 },	{   -9,   70 },	{   -7,   81 },	{  -10,   72 },	},	/*  663 */
	{	{  -15,   92 },	{   -8,   66 },	{  -17,   80 },	{  -18,   75 },	},	/*  664 */
	{	{  -14,   89 },	{  -10,   68 },	{  -18,   73 },	{  -12,   71 },	},	/*  665 */
	{	{  -26,   71 },	{  -19,   73 },	{   -4,   74 },	{  -11,   63 },	},	/*  666 */
	{	{  -15,   81 },	{  -12,   69 },	{  -10,   83 },	{   -5,   70 },	},	/*  667 */
	{	{  -14,   80 },	{  -16,   70 },	{   -9,   71 },	{  -17,   75 },	},	/*  668 */
	{	{    0,   68 },	{  -15,   67 },	{   -9,   67 },	{  -14,   72 },	},	/*  669 */
	{	{  -14,   70 },	{  -20,   62 },	{   -1,   61 },	{  -16,   67 },	},	/*  670 */
	{	{  -24,   56 },	{  -19,   70 },	{   -8,   66 },	{   -8,   53 },	},	/*  671 */
	{	{  -23,   68 },	{  -16,   66 },	{  -14,   66 },	{  -14,   59 },	},	/*  672 */
	{	{  -24,   50 },	{  -22,   65 },	{    0,   59 },	{   -9,   52 },	},	/*  673 */
	{	{  -11,   74 },	{  -20,   63 },	{    2,   59 },	{  -11,   68 },	},	/*  674 */
	/* 675-689 significant_coeff_flag with ctxBlockCat 9 for field mode */
	{	{  -14,  106 },	{   -5,   85 },	{   -3,   81 },	{   -3,   78 },	},	/*  675 */
	{	{  -13,   97 },	{   -6,   81 },	{   -3,   76 },	{   -8,   74 },	},	/*  676 */
	{	{  -15,   90 },	{  -10,   77 },	{   -7,   72 },	{   -9,   72 },	},	/*  677 */
	{	{  -12,   90 },	{   -7,   81 },	{   -6,   78 },	{  -10,   72 },	},	/*  678 */
	{	{  -18,   88 },	{  -17,   80 },	{  -12,   72 },	{  -18,   75 },	},	/*  679 */
	{	{  -10,   73 },	{  -18,   73 },	{  -14,   68 },	{  -12,   71 },	},	/*  680 */
	{	{   -9,   79 },	{   -4,   74 },	{   -3,   70 },	{  -11,   63 },	},	/*  681 */
	{	{  -14,   86 },	{  -10,   83 },	{   -6,   76 },	{   -5,   70 },	},	/*  682 */
	{	{  -10,   73 },	{   -9,   71 },	{   -5,   66 },	{  -17,   75 },	},	/*  683 */
	{	{  -10,   70 },	{   -9,   67 },	{   -5,   62 },	{  -14,   72 },	},	/*  684 */
	{	{  -10,   69 },	{   -1,   61 },	{    0,   57 },	{  -16,   67 },	},	/*  685 */
	{	{   -5,   66 },	{   -8,   66 },	{   -4,   61 },	{   -8,   53 },	},	/*  686 */
	{	{   -9,   64 },	{  -14,   66 },	{   -9,   60 },	{  -14,   59 },	},	/*  687 */
	{	{   -5,   58 },	{    0,   59 },	{    1,   54 },	{   -9,   52 },	},	/*  688 */
	{	{    2,   59 },	{    2,   59 },	{    2,   58 },	{  -11,   68 },	},	/*  689 */
	/* 690-698 last_significant_coeff_flag with ctxBlockCat 9 for frame mode */
	{	{   23,  -13 },	{    9,   -2 },	{   17,  -10 },	{    9,   -2 },	},	/*  690 */
	{	{   26,  -13 },	{   26,   -9 },	{   32,  -13 },	{   30,  -10 },	},	/*  691 */
	{	{   40,  -15 },	{   33,   -9 },	{   42,   -9 },	{   31,   -4 },	},	/*  692 */
	{	{   49,  -14 },	{   39,   -7 },	{   49,   -5 },	{   33,   -1 },	},	/*  693 */
	{	{   44,    3 },	{   41,   -2 },	{   53,    0 },	{   33,    7 },	},	/*  694 */
	{	{   45,    6 },	{   45,    3 },	{   64,    3 },	{   31,   12 },	},	/*  695 */
	{	{   44,   34 },	{   49,    9 },	{   68,   10 },	{   37,   23 },	},	/*  696 */
	{	{   33,   54 },	{   45,   27 },	{   66,   27 },	{   31,   38 },	},	/*  697 */
	{	{   19,   82 },	{   36,   59 },	{   47,   57 },	{   20,   64 },	},	/*  698 */
	/* 699-707 last_significant_coeff_flag with ctxBlockCat 9 for field mode */
	{	{   21,  -10 },	{   21,  -13 },	{   17,  -10 },	{    9,   -2 },	},	/*  699 */
	{	{   24,  -11 },	{   33,  -14 },	{   32,  -13 },	{   30,  -10 },	},	/*  700 */
	{	{   28,   -8 },	{   39,   -7 },	{   42,   -9 },	{   31,   -4 },	},	/*  701 */
	{	{   28,   -1 },	{   46,   -2 },	{   49,   -5 },	{   33,   -1 },	},	/*  702 */
	{	{   29,    3 },	{   51,    2 },	{   53,    0 },	{   33,    7 },	},	/*  703 */
	{	{   29,    9 },	{   60,    6 },	{   64,    3 },	{   31,   12 },	},	/*  704 */
	{	{   35,   20 },	{   61,   17 },	{   68,   10 },	{   37,   23 },	},	/*  705 */
	{	{   29,   36 },	{   55,   34 },	{   66,   27 },	{   31,   38 },	},	/*  706 */
	{	{   14,   67 },	{   42,   62 },	{   47,   57 },	{   20,   64 },	},	/*  707 */
	/* 708-717 coeff_abs_level_minus1 with ctxBlockCat 9 */
	{	{   -3,   75 },	{   -6,   66 },	{   -5,   71 },	{   -9,   71 },	},	/*  708 */
	{	{   -1,   23 },	{   -7,   35 },	{    0,   24 },	{   -7,   37 },	},	/*  709 */
	{	{    1,   34 },	{   -7,   42 },	{   -1,   36 },	{   -8,   44 },	},	/*  710 */
	{	{    1,   43 },	{   -8,   45 },	{   -2,   42 },	{  -11,   49 },	},	/*  711 */
	{	{    0,   54 },	{   -5,   48 },	{   -2,   52 },	{  -10,   56 },	},	/*  712 */
	{	{   -2,   55 },	{  -12,   56 },	{   -9,   57 },	{  -12,   59 },	},	/*  713 */
	{	{    0,   61 },	{   -6,   60 },	{   -6,   63 },	{   -8,   63 },	},	/*  714 */
	{	{    1,   64 },	{   -5,   62 },	{   -4,   65 },	{   -9,   67 },	},	/*  715 */
	{	{    0,   68 },	{   -8,   66 },	{   -4,   67 },	{   -6,   68 },	},	/*  716 */
	{	{   -9,   92 },	{   -8,   76 },	{   -7,   82 },	{  -10,   79 },	},	/*  717 */

	/* 718-732 significant_coeff_flag with ctxBlockCat 13 for frame mode */
	{	{  -17,  120 },	{   -4,   79 },	{   -5,   85 },	{   -3,   78 },	},	/*  718 */
	{	{  -20,  112 },	{   -7,   71 },	{   -6,   81 },	{   -8,   74 },	},	/*  719 */
	{	{  -18,  114 },	{   -5,   69 },	{  -10,   77 },	{   -9,   72 },	},	/*  720 */
	{	{  -11,   85 },	{   -9,   70 },	{   -7,   81 },	{  -10,   72 },	},	/*  721 */
	{	{  -15,   92 },	{   -8,   66 },	{  -17,   80 },	{  -18,   75 },	},	/*  722 */
	{	{  -14,   89 },	{  -10,   68 },	{  -18,   73 },	{  -12,   71 },	},	/*  723 */
	{	{  -26,   71 },	{  -19,   73 },	{   -4,   74 },	{  -11,   63 },	},	/*  724 */
	{	{  -15,   81 },	{  -12,   69 },	{  -10,   83 },	{   -5,   70 },	},	/*  725 */
	{	{  -14,   80 },	{  -16,   70 },	{   -9,   71 },	{  -17,   75 },	},	/*  726 */
	{	{    0,   68 },	{  -15,   67 },	{   -9,   67 },	{  -14,   72 },	},	/*  727 */
	{	{  -14,   70 },	{  -20,   62 },	{   -1,   61 },	{  -16,   67 },	},	/*  728 */
	{	{  -24,   56 },	{  -19,   70 },	{   -8,   66 },	{   -8,   53 },	},	/*  729 */
	{	{  -23,   68 },	{  -16,   66 },	{  -14,   66 },	{  -14,   59 },	},	/*  730 */
	{	{  -24,   50 },	{  -22,   65 },	{    0,   59 },	{   -9,   52 },	},	/*  731 */
	{	{  -11,   74 },	{  -20,   63 },	{    2,   59 },	{  -11,   68 },	},	/*  732 */
	/* 733-747 significant_coeff_flag with ctxBlockCat 13 for field mode */
	{	{  -14,  106 },	{   -5,   85 },	{   -3,   81 },	{   -3,   78 },	},	/*  733 */
	{	{  -13,   97 },	{   -6,   81 },	{   -3,   76 },	{   -8,   74 },	},	/*  734 */
	{	{  -15,   90 },	{  -10,   77 },	{   -7,   72 },	{   -9,   72 },	},	/*  735 */
	{	{  -12,   90 },	{   -7,   81 },	{   -6,   78 },	{  -10,   72 },	},	/*  736 */
	{	{  -18,   88 },	{  -17,   80 },	{  -12,   72 },	{  -18,   75 },	},	/*  737 */
	{	{  -10,   73 },	{  -18,   73 },	{  -14,   68 },	{  -12,   71 },	},	/*  738 */
	{	{   -9,   79 },	{   -4,   74 },	{   -3,   70 },	{  -11,   63 },	},	/*  739 */
	{	{  -14,   86 },	{  -10,   83 },	{   -6,   76 },	{   -5,   70 },	},	/*  740 */
	{	{  -10,   73 },	{   -9,   71 },	{   -5,   66 },	{  -17,   75 },	},	/*  741 */
	{	{  -10,   70 },	{   -9,   67 },	{   -5,   62 },	{  -14,   72 },	},	/*  742 */
	{	{  -10,   69 },	{   -1,   61 },	{    0,   57 },	{  -16,   67 },	},	/*  743 */
	{	{   -5,   66 },	{   -8,   66 },	{   -4,   61 },	{   -8,   53 },	},	/*  744 */
	{	{   -9,   64 },	{  -14,   66 },	{   -9,   60 },	{  -14,   59 },	},	/*  745 */
	{	{   -5,   58 },	{    0,   59 },	{    1,   54 },	{   -9,   52 },	},	/*  746 */
	{	{    2,   59 },	{    2,   59 },	{    2,   58 },	{  -11,   68 },	},	/*  747 */
	/* 748-756 last_significant_coeff_flag with ctxBlockCat 13 for frame mode */
	{	{   23,  -13 },	{    9,   -2 },	{   17,  -10 },	{    9,   -2 },	},	/*  748 */
	{	{   26,  -13 },	{   26,   -9 },	{   32,  -13 },	{   30,  -10 },	},	/*  749 */
	{	{   40,  -15 },	{   33,   -9 },	{   42,   -9 },	{   31,   -4 },	},	/*  750 */
	{	{   49,  -14 },	{   39,   -7 },	{   49,   -5 },	{   33,   -1 },	},	/*  751 */
	{	{   44,    3 },	{   41,   -2 },	{   53,    0 },	{   33,    7 },	},	/*  752 */
	{	{   45,    6 },	{   45,    3 },	{   64,    3 },	{   31,   12 },	},	/*  753 */
	{	{   44,   34 },	{   49,    9 },	{   68,   10 },	{   37,   23 },	},	/*  754 */
	{	{   33,   54 },	{   45,   27 },	{   66,   27 },	{   31,   38 },	},	/*  755 */
	{	{   19,   82 },	{   36,   59 },	{   47,   57 },	{   20,   64 },	},	/*  756 */
	/* 757-765 last_significant_coeff_flag with ctxBlockCat 13 for field mode */
	{	{   21,  -10 },	{   21,  -13 },	{   17,  -10 },	{    9,   -2 },	},	/*  757 */
	{	{   24,  -11 },	{   33,  -14 },	{   32,  -13 },	{   30,  -10 },	},	/*  758 */
	{	{   28,   -8 },	{   39,   -7 },	{   42,   -9 },	{   31,   -4 },	},	/*  759 */
	{	{   28,   -1 },	{   46,   -2 },	{   49,   -5 },	{   33,   -1 },	},	/*  760 */
	{	{   29,    3 },	{   51,    2 },	{   53,    0 },	{   33,    7 },	},	/*  761 */
	{	{   29,    9 },	{   60,    6 },	{   64,    3 },	{   31,   12 },	},	/*  762 */
	{	{   35,   20 },	{   61,   17 },	{   68,   10 },	{   37,   23 },	},	/*  763 */
	{	{   29,   36 },	{   55,   34 },	{   66,   27 },	{   31,   38 },	},	/*  764 */
	{	{   14,   67 },	{   42,   62 },	{   47,   57 },	{   20,   64 },	},	/*  765 */
	/* 766-775 coeff_abs_level_minus1 with ctxBlockCat 13 */
	{	{   -3,   75 },	{   -6,   66 },	{   -5,   71 },	{   -9,   71 },	},	/*  766 */
	{	{   -1,   23 },	{   -7,   35 },	{    0,   24 },	{   -7,   37 },	},	/*  767 */
	{	{    1,   34 },	{   -7,   42 },	{   -1,   36 },	{   -8,   44 },	},	/*  768 */
	{	{    1,   43 },	{   -8,   45 },	{   -2,   42 },	{  -11,   49 },	},	/*  769 */
	{	{    0,   54 },	{   -5,   48 },	{   -2,   52 },	{  -10,   56 },	},	/*  770 */
	{	{   -2,   55 },	{  -12,   56 },	{   -9,   57 },	{  -12,   59 },	},	/*  771 */
	{	{    0,   61 },	{   -6,   60 },	{   -6,   63 },	{   -8,   63 },	},	/*  772 */
	{	{    1,   64 },	{   -5,   62 },	{   -4,   65 },	{   -9,   67 },	},	/*  773 */
	{	{    0,   68 },	{   -8,   66 },	{   -4,   67 },	{   -6,   68 },	},	/*  774 */
	{	{   -9,   92 },	{   -8,   76 },	{   -7,   82 },	{  -10,   79 },	},	/*  775 */

	/* 776-790 significant_coeff_flag with ctxBlockCat 6 for field mode */
	{	{   -6,   93 },	{  -13,  106 },	{  -21,  126 },	{  -22,  127 },	},	/*  776 */
	{	{   -6,   84 },	{  -16,  106 },	{  -23,  124 },	{  -25,  127 },	},	/*  777 */
	{	{   -8,   79 },	{  -10,   87 },	{  -20,  110 },	{  -25,  120 },	},	/*  778 */
	{	{    0,   66 },	{  -21,  114 },	{  -26,  126 },	{  -27,  127 },	},	/*  779 */
	{	{   -1,   71 },	{  -18,  110 },	{  -25,  124 },	{  -19,  114 },	},	/*  780 */
	{	{    0,   62 },	{  -14,   98 },	{  -17,  105 },	{  -23,  117 },	},	/*  781 */
	{	{   -2,   60 },	{  -22,  110 },	{  -27,  121 },	{  -25,  118 },	},	/*  782 */
	{	{   -2,   59 },	{  -21,  106 },	{  -27,  117 },	{  -26,  117 },	},	/*  783 */
	{	{   -5,   75 },	{  -18,  103 },	{  -17,  102 },	{  -24,  113 },	},	/*  784 */
	{	{   -3,   62 },	{  -21,  107 },	{  -26,  117 },	{  -28,  118 },	},	/*  785 */
	{	{   -4,   58 },	{  -23,  108 },	{  -27,  116 },	{  -31,  120 },	},	/*  786 */
	{	{   -9,   66 },	{  -26,  112 },	{  -33,  122 },	{  -37,  124 },	},	/*  787 */
	{	{   -1,   79 },	{  -10,   96 },	{  -10,   95 },	{  -10,   94 },	},	/*  788 */
	{	{    0,   71 },	{  -12,   95 },	{  -14,  100 },	{  -15,  102 },	},	/*  789 */
	{	{    3,   68 },	{   -5,   91 },	{   -8,   95 },	{  -10,   99 },	},	/*  790 */
	/* 791-804 significant_coeff_flag with ctxBlockCat 7 for field mode */
	{	{   10,   44 },	{   -9,   93 },	{  -17,  111 },	{  -13,  106 },	},	/*  791 */
	{	{   -7,   62 },	{  -22,   94 },	{  -28,  114 },	{  -50,  127 },	},	/*  792 */
	{	{   15,   36 },	{   -5,   86 },	{   -6,   89 },	{   -5,   92 },	},	/*  793 */
	{	{   14,   40 },	{    9,   67 },	{   -2,   80 },	{   17,   57 },	},	/*  794 */
	{	{   16,   27 },	{   -4,   80 },	{   -4,   82 },	{   -5,   86 },	},	/*  795 */
	{	{   12,   29 },	{  -10,   85 },	{   -9,   85 },	{  -13,   94 },	},	/*  796 */
	{	{    1,   44 },	{   -1,   70 },	{   -8,   81 },	{  -12,   91 },	},	/*  797 */
	{	{   20,   36 },	{    7,   60 },	{   -1,   72 },	{   -2,   77 },	},	/*  798 */
	{	{   18,   32 },	{    9,   58 },	{    5,   64 },	{    0,   71 },	},	/*  799 */
	{	{    5,   42 },	{    5,   61 },	{    1,   67 },	{   -1,   73 },	},	/*  800 */
	{	{    1,   48 },	{   12,   50 },	{    9,   56 },	{    4,   64 },	},	/*  801 */
	{	{   10,   62 },	{   15,   50 },	{    0,   69 },	{   -7,   81 },	},	/*  802 */
	{	{   17,   46 },	{   18,   49 },	{    1,   69 },	{    5,   64 },	},	/*  803 */
	{	{    9,   64 },	{   17,   54 },	{    7,   69 },	{   15,   57 },	},	/*  804 */
	/* 805-819 significant_coeff_flag with ctxBlockCat 8 for field mode */
	{	{  -12,  104 },	{   10,   41 },	{   -7,   69 },	{    1,   67 },	},	/*  805 */
	{	{  -11,   97 },	{    7,   46 },	{   -6,   67 },	{    0,   68 },	},	/*  806 */
	{	{  -16,   96 },	{   -1,   51 },	{  -16,   77 },	{  -10,   67 },	},	/*  807 */
	{	{   -7,   88 },	{    7,   49 },	{   -2,   64 },	{    1,   68 },	},	/*  808 */
	{	{   -8,   85 },	{    8,   52 },	{    2,   61 },	{    0,   77 },	},	/*  809 */
	{	{   -7,   85 },	{    9,   41 },	{   -6,   67 },	{    2,   64 },	},	/*  810 */
	{	{   -9,   85 },	{    6,   47 },	{   -3,   64 },	{    0,   68 },	},	/*  811 */
	{	{  -13,   88 },	{    2,   55 },	{    2,   57 },	{   -5,   78 },	},	/*  812 */
	{	{    4,   66 },	{   13,   41 },	{   -3,   65 },	{    7,   55 },	},	/*  813 */
	{	{   -3,   77 },	{   10,   44 },	{   -3,   66 },	{    5,   59 },	},	/*  814 */
	{	{   -3,   76 },	{    6,   50 },	{    0,   62 },	{    2,   65 },	},	/*  815 */
	{	{   -6,   76 },	{    5,   53 },	{    9,   51 },	{   14,   54 },	},	/*  816 */
	{	{   10,   58 },	{   13,   49 },	{   -1,   66 },	{   15,   44 },	},	/*  817 */
	{	{   -1,   76 },	{    4,   63 },	{   -2,   71 },	{    5,   60 },	},	/*  818 */
	{	{   -1,   83 },	{    6,   64 },	{   -2,   75 },	{    2,   70 },	},	/*  819 */
	/* 820-834 significant_coeff_flag with ctxBlockCat 10 for field mode */
	{	{   -6,   93 },	{  -13,  106 },	{  -21,  126 },	{  -22,  127 },	},	/*  820 */
	{	{   -6,   84 },	{  -16,  106 },	{  -23,  124 },	{  -25,  127 },	},	/*  821 */
	{	{   -8,   79 },	{  -10,   87 },	{  -20,  110 },	{  -25,  120 },	},	/*  822 */
	{	{    0,   66 },	{  -21,  114 },	{  -26,  126 },	{  -27,  127 },	},	/*  823 */
	{	{   -1,   71 },	{  -18,  110 },	{  -25,  124 },	{  -19,  114 },	},	/*  824 */
	{	{    0,   62 },	{  -14,   98 },	{  -17,  105 },	{  -23,  117 },	},	/*  825 */
	{	{   -2,   60 },	{  -22,  110 },	{  -27,  121 },	{  -25,  118 },	},	/*  826 */
	{	{   -2,   59 },	{  -21,  106 },	{  -27,  117 },	{  -26,  117 },	},	/*  827 */
	{	{   -5,   75 },	{  -18,  103 },	{  -17,  102 },	{  -24,  113 },	},	/*  828 */
	{	{   -3,   62 },	{  -21,  107 },	{  -26,  117 },	{  -28,  118 },	},	/*  829 */
	{	{   -4,   58 },	{  -23,  108 },	{  -27,  116 },	{  -31,  120 },	},	/*  830 */
	{	{   -9,   66 },	{  -26,  112 },	{  -33,  122 },	{  -37,  124 },	},	/*  831 */
	{	{   -1,   79 },	{  -10,   96 },	{  -10,   95 },	{  -10,   94 },	},	/*  832 */
	{	{    0,   71 },	{  -12,   95 },	{  -14,  100 },	{  -15,  102 },	},	/*  833 */
	{	{    3,   68 },	{   -5,   91 },	{   -8,   95 },	{  -10,   99 },	},	/*  834 */
	/* 835-838 significant_coeff_flag with ctxBlockCat 11 for field mode */
	{	{   10,   44 },	{   -9,   93 },	{  -17,  111 },	{  -13,  106 },	},	/*  835 */
	{	{   -7,   62 },	{  -22,   94 },	{  -28,  114 },	{  -50,  127 },	},	/*  836 */
	{	{   15,   36 },	{   -5,   86 },	{   -6,   89 },	{   -5,   92 },	},	/*  837 */
	{	{   14,   40 },	{    9,   67 },	{   -2,   80 },	{   17,   57 },	},	/*  838 */
	{	{   16,   27 },	{   -4,   80 },	{   -4,   82 },	{   -5,   86 },	},	/*  839 */
	{	{   12,   29 },	{  -10,   85 },	{   -9,   85 },	{  -13,   94 },	},	/*  840 */
	{	{    1,   44 },	{   -1,   70 },	{   -8,   81 },	{  -12,   91 },	},	/*  841 */
	{	{   20,   36 },	{    7,   60 },	{   -1,   72 },	{   -2,   77 },	},	/*  842 */
	{	{   18,   32 },	{    9,   58 },	{    5,   64 },	{    0,   71 },	},	/*  843 */
	{	{    5,   42 },	{    5,   61 },	{    1,   67 },	{   -1,   73 },	},	/*  844 */
	{	{    1,   48 },	{   12,   50 },	{    9,   56 },	{    4,   64 },	},	/*  845 */
	{	{   10,   62 },	{   15,   50 },	{    0,   69 },	{   -7,   81 },	},	/*  846 */
	{	{   17,   46 },	{   18,   49 },	{    1,   69 },	{    5,   64 },	},	/*  847 */
	{	{    9,   64 },	{   17,   54 },	{    7,   69 },	{   15,   57 },	},	/*  848 */
	/* 849-863 significant_coeff_flag with ctxBlockCat 12 for field mode */
	{	{  -12,  104 },	{   10,   41 },	{   -7,   69 },	{    1,   67 },	},	/*  849 */
	{	{  -11,   97 },	{    7,   46 },	{   -6,   67 },	{    0,   68 },	},	/*  850 */
	{	{  -16,   96 },	{   -1,   51 },	{  -16,   77 },	{  -10,   67 },	},	/*  851 */
	{	{   -7,   88 },	{    7,   49 },	{   -2,   64 },	{    1,   68 },	},	/*  852 */
	{	{   -8,   85 },	{    8,   52 },	{    2,   61 },	{    0,   77 },	},	/*  853 */
	{	{   -7,   85 },	{    9,   41 },	{   -6,   67 },	{    2,   64 },	},	/*  854 */
	{	{   -9,   85 },	{    6,   47 },	{   -3,   64 },	{    0,   68 },	},	/*  855 */
	{	{  -13,   88 },	{    2,   55 },	{    2,   57 },	{   -5,   78 },	},	/*  856 */
	{	{    4,   66 },	{   13,   41 },	{   -3,   65 },	{    7,   55 },	},	/*  857 */
	{	{   -3,   77 },	{   10,   44 },	{   -3,   66 },	{    5,   59 },	},	/*  858 */
	{	{   -3,   76 },	{    6,   50 },	{    0,   62 },	{    2,   65 },	},	/*  859 */
	{	{   -6,   76 },	{    5,   53 },	{    9,   51 },	{   14,   54 },	},	/*  860 */
	{	{   10,   58 },	{   13,   49 },	{   -1,   66 },	{   15,   44 },	},	/*  861 */
	{	{   -1,   76 },	{    4,   63 },	{   -2,   71 },	{    5,   60 },	},	/*  862 */
	{	{   -1,   83 },	{    6,   64 },	{   -2,   75 },	{    2,   70 },	},	/*  863 */

	/* 864-878 last_significant_coeff_flag with ctxBlockCat 6 for field mode */
	{	{   15,    6 },	{   14,   11 },	{   19,   -6 },	{   17,  -13 },	},	/*  864 */
	{	{    6,   19 },	{   11,   14 },	{   18,   -6 },	{   16,   -9 },	},	/*  865 */
	{	{    7,   16 },	{    9,   11 },	{   14,    0 },	{   17,  -12 },	},	/*  866 */
	{	{   12,   14 },	{   18,   11 },	{   26,  -12 },	{   27,  -21 },	},	/*  867 */
	{	{   18,   13 },	{   21,    9 },	{   31,  -16 },	{   37,  -30 },	},	/*  868 */
	{	{   13,   11 },	{   23,   -2 },	{   33,  -25 },	{   41,  -40 },	},	/*  869 */
	{	{   13,   15 },	{   32,  -15 },	{   33,  -22 },	{   42,  -41 },	},	/*  870 */
	{	{   15,   16 },	{   32,  -15 },	{   37,  -28 },	{   48,  -47 },	},	/*  871 */
	{	{   12,   23 },	{   34,  -21 },	{   39,  -30 },	{   39,  -32 },	},	/*  872 */
	{	{   13,   23 },	{   39,  -23 },	{   42,  -30 },	{   46,  -40 },	},	/*  873 */
	{	{   15,   20 },	{   42,  -33 },	{   47,  -42 },	{   52,  -51 },	},	/*  874 */
	{	{   14,   26 },	{   41,  -31 },	{   45,  -36 },	{   46,  -41 },	},	/*  875 */
	{	{   14,   44 },	{   46,  -28 },	{   49,  -34 },	{   52,  -39 },	},	/*  876 */
	{	{   17,   40 },	{   38,  -12 },	{   41,  -17 },	{   43,  -19 },	},	/*  877 */
	{	{   17,   47 },	{   21,   29 },	{   32,    9 },	{   32,   11 },	},	/*  878 */
	/* 879-892 last_significant_coeff_flag with ctxBlockCat 7 for field mode */
	{	{   24,   17 },	{   45,  -24 },	{   69,  -71 },	{   61,  -55 },	},	/*  879 */
	{	{   21,   21 },	{   53,  -45 },	{   63,  -63 },	{   56,  -46 },	},	/*  880 */
	{	{   25,   22 },	{   48,  -26 },	{   66,  -64 },	{   62,  -50 },	},	/*  881 */
	{	{   31,   27 },	{   65,  -43 },	{   77,  -74 },	{   81,  -67 },	},	/*  882 */
	{	{   22,   29 },	{   43,  -19 },	{   54,  -39 },	{   45,  -20 },	},	/*  883 */
	{	{   19,   35 },	{   39,  -10 },	{   52,  -35 },	{   35,   -2 },	},	/*  884 */
	{	{   14,   50 },	{   30,    9 },	{   41,  -10 },	{   28,   15 },	},	/*  885 */
	{	{   10,   57 },	{   18,   26 },	{   36,    0 },	{   34,    1 },	},	/*  886 */
	{	{    7,   63 },	{   20,   27 },	{   40,   -1 },	{   39,    1 },	},	/*  887 */
	{	{   -2,   77 },	{    0,   57 },	{   30,   14 },	{   30,   17 },	},	/*  888 */
	{	{   -4,   82 },	{  -14,   82 },	{   28,   26 },	{   20,   38 },	},	/*  889 */
	{	{   -3,   94 },	{   -5,   75 },	{   23,   37 },	{   18,   45 },	},	/*  890 */
	{	{    9,   69 },	{  -19,   97 },	{   12,   55 },	{   15,   54 },	},	/*  891 */
	{	{  -12,  109 },	{  -35,  125 },	{   11,   65 },	{    0,   79 },	},	/*  892 */
	/* 893-907 last_significant_coeff_flag with ctxBlockCat 8 for field mode */
	{	{   36,  -35 },	{   27,    0 },	{   37,  -33 },	{   36,  -16 },	},	/*  893 */
	{	{   36,  -34 },	{   28,    0 },	{   39,  -36 },	{   37,  -14 },	},	/*  894 */
	{	{   32,  -26 },	{   31,   -4 },	{   40,  -37 },	{   37,  -17 },	},	/*  895 */
	{	{   37,  -30 },	{   27,    6 },	{   38,  -30 },	{   32,    1 },	},	/*  896 */
	{	{   44,  -32 },	{   34,    8 },	{   46,  -33 },	{   34,   15 },	},	/*  897 */
	{	{   34,  -18 },	{   30,   10 },	{   42,  -30 },	{   29,   15 },	},	/*  898 */
	{	{   34,  -15 },	{   24,   22 },	{   40,  -24 },	{   24,   25 },	},	/*  899 */
	{	{   40,  -15 },	{   33,   19 },	{   49,  -29 },	{   34,   22 },	},	/*  900 */
	{	{   33,   -7 },	{   22,   32 },	{   38,  -12 },	{   31,   16 },	},	/*  901 */
	{	{   35,   -5 },	{   26,   31 },	{   40,  -10 },	{   35,   18 },	},	/*  902 */
	{	{   33,    0 },	{   21,   41 },	{   38,   -3 },	{   31,   28 },	},	/*  903 */
	{	{   38,    2 },	{   26,   44 },	{   46,   -5 },	{   33,   41 },	},	/*  904 */
	{	{   33,   13 },	{   23,   47 },	{   31,   20 },	{   36,   28 },	},	/*  905 */
	{	{   23,   35 },	{   16,   65 },	{   29,   30 },	{   27,   47 },	},	/*  906 */
	{	{   13,   58 },	{   14,   71 },	{   25,   44 },	{   21,   62 },	},	/*  907 */
	/* 908-922 last_significant_coeff_flag with ctxBlockCat 10 for field mode */
	{	{   15,    6 },	{   14,   11 },	{   19,   -6 },	{   17,  -13 },	},	/*  908 */
	{	{    6,   19 },	{   11,   14 },	{   18,   -6 },	{   16,   -9 },	},	/*  909 */
	{	{    7,   16 },	{    9,   11 },	{   14,    0 },	{   17,  -12 },	},	/*  910 */
	{	{   12,   14 },	{   18,   11 },	{   26,  -12 },	{   27,  -21 },	},	/*  911 */
	{	{   18,   13 },	{   21,    9 },	{   31,  -16 },	{   37,  -30 },	},	/*  912 */
	{	{   13,   11 },	{   23,   -2 },	{   33,  -25 },	{   41,  -40 },	},	/*  913 */
	{	{   13,   15 },	{   32,  -15 },	{   33,  -22 },	{   42,  -41 },	},	/*  914 */
	{	{   15,   16 },	{   32,  -15 },	{   37,  -28 },	{   48,  -47 },	},	/*  915 */
	{	{   12,   23 },	{   34,  -21 },	{   39,  -30 },	{   39,  -32 },	},	/*  916 */
	{	{   13,   23 },	{   39,  -23 },	{   42,  -30 },	{   46,  -40 },	},	/*  917 */
	{	{   15,   20 },	{   42,  -33 },	{   47,  -42 },	{   52,  -51 },	},	/*  918 */
	{	{   14,   26 },	{   41,  -31 },	{   45,  -36 },	{   46,  -41 },	},	/*  919 */
	{	{   14,   44 },	{   46,  -28 },	{   49,  -34 },	{   52,  -39 },	},	/*  920 */
	{	{   17,   40 },	{   38,  -12 },	{   41,  -17 },	{   43,  -19 },	},	/*  921 */
	{	{   17,   47 },	{   21,   29 },	{   32,    9 },	{   32,   11 },	},	/*  922 */
	/* 923-936 last_significant_coeff_flag with ctxBlockCat 11 for field mode */
	{	{   24,   17 },	{   45,  -24 },	{   69,  -71 },	{   61,  -55 },	},	/*  923 */
	{	{   21,   21 },	{   53,  -45 },	{   63,  -63 },	{   56,  -46 },	},	/*  924 */
	{	{   25,   22 },	{   48,  -26 },	{   66,  -64 },	{   62,  -50 },	},	/*  925 */
	{	{   31,   27 },	{   65,  -43 },	{   77,  -74 },	{   81,  -67 },	},	/*  926 */
	{	{   22,   29 },	{   43,  -19 },	{   54,  -39 },	{   45,  -20 },	},	/*  927 */
	{	{   19,   35 },	{   39,  -10 },	{   52,  -35 },	{   35,   -2 },	},	/*  928 */
	{	{   14,   50 },	{   30,    9 },	{   41,  -10 },	{   28,   15 },	},	/*  929 */
	{	{   10,   57 },	{   18,   26 },	{   36,    0 },	{   34,    1 },	},	/*  930 */
	{	{    7,   63 },	{   20,   27 },	{   40,   -1 },	{   39,    1 },	},	/*  931 */
	{	{   -2,   77 },	{    0,   57 },	{   30,   14 },	{   30,   17 },	},	/*  932 */
	{	{   -4,   82 },	{  -14,   82 },	{   28,   26 },	{   20,   38 },	},	/*  933 */
	{	{   -3,   94 },	{   -5,   75 },	{   23,   37 },	{   18,   45 },	},	/*  934 */
	{	{    9,   69 },	{  -19,   97 },	{   12,   55 },	{   15,   54 },	},	/*  935 */
	{	{  -12,  109 },	{  -35,  125 },	{   11,   65 },	{    0,   79 },	},	/*  936 */
	/* 937-951 last_significant_coeff_flag with ctxBlockCat 12 for field mode */
	{	{   36,  -35 },	{   27,    0 },	{   37,  -33 },	{   36,  -16 },	},	/*  937 */
	{	{   36,  -34 },	{   28,    0 },	{   39,  -36 },	{   37,  -14 },	},	/*  938 */
	{	{   32,  -26 },	{   31,   -4 },	{   40,  -37 },	{   37,  -17 },	},	/*  939 */
	{	{   37,  -30 },	{   27,    6 },	{   38,  -30 },	{   32,    1 },	},	/*  940 */
	{	{   44,  -32 },	{   34,    8 },	{   46,  -33 },	{   34,   15 },	},	/*  941 */
	{	{   34,  -18 },	{   30,   10 },	{   42,  -30 },	{   29,   15 },	},	/*  942 */
	{	{   34,  -15 },	{   24,   22 },	{   40,  -24 },	{   24,   25 },	},	/*  943 */
	{	{   40,  -15 },	{   33,   19 },	{   49,  -29 },	{   34,   22 },	},	/*  944 */
	{	{   33,   -7 },	{   22,   32 },	{   38,  -12 },	{   31,   16 },	},	/*  945 */
	{	{   35,   -5 },	{   26,   31 },	{   40,  -10 },	{   35,   18 },	},	/*  946 */
	{	{   33,    0 },	{   21,   41 },	{   38,   -3 },	{   31,   28 },	},	/*  947 */
	{	{   38,    2 },	{   26,   44 },	{   46,   -5 },	{   33,   41 },	},	/*  948 */
	{	{   33,   13 },	{   23,   47 },	{   31,   20 },	{   36,   28 },	},	/*  949 */
	{	{   23,   35 },	{   16,   65 },	{   29,   30 },	{   27,   47 },	},	/*  950 */
	{	{   13,   58 },	{   14,   71 },	{   25,   44 },	{   21,   62 },	},	/*  951 */

	/* 952-961 coeff_abs_level_minus1 with ctxBlockCat 6 */
	{	{   -3,   71 },	{   -6,   76 },	{  -23,  112 },	{  -24,  115 },	},	/*  952 */
	{	{   -6,   42 },	{   -2,   44 },	{  -15,   71 },	{  -22,   82 },	},	/*  953 */
	{	{   -5,   50 },	{    0,   45 },	{   -7,   61 },	{   -9,   62 },	},	/*  954 */
	{	{   -3,   54 },	{    0,   52 },	{    0,   53 },	{    0,   53 },	},	/*  955 */
	{	{   -2,   62 },	{   -3,   64 },	{   -5,   66 },	{    0,   59 },	},	/*  956 */
	{	{    0,   58 },	{   -2,   59 },	{  -11,   77 },	{  -14,   85 },	},	/*  957 */
	{	{    1,   63 },	{   -4,   70 },	{   -9,   80 },	{  -13,   89 },	},	/*  958 */
	{	{   -2,   72 },	{   -4,   75 },	{   -9,   84 },	{  -13,   94 },	},	/*  959 */
	{	{   -1,   74 },	{   -8,   82 },	{  -10,   87 },	{  -11,   92 },	},	/*  960 */
	{	{   -9,   91 },	{  -17,  102 },	{  -34,  127 },	{  -29,  127 },	},	/*  961 */
	/* 962-971 coeff_abs_level_minus1 with ctxBlockCat 7 */
	{	{   -5,   67 },	{   -9,   77 },	{  -21,  101 },	{  -21,  100 },	},	/*  962 */
	{	{   -5,   27 },	{    3,   24 },	{   -3,   39 },	{  -14,   57 },	},	/*  963 */
	{	{   -3,   39 },	{    0,   42 },	{   -5,   53 },	{  -12,   67 },	},	/*  964 */
	{	{   -2,   44 },	{    0,   48 },	{   -7,   61 },	{  -11,   71 },	},	/*  965 */
	{	{    0,   46 },	{    0,   55 },	{  -11,   75 },	{  -10,   77 },	},	/*  966 */
	{	{  -16,   64 },	{   -6,   59 },	{  -15,   77 },	{  -21,   85 },	},	/*  967 */
	{	{   -8,   68 },	{   -7,   71 },	{  -17,   91 },	{  -16,   88 },	},	/*  968 */
	{	{  -10,   78 },	{  -12,   83 },	{  -25,  107 },	{  -23,  104 },	},	/*  969 */
	{	{   -6,   77 },	{  -11,   87 },	{  -25,  111 },	{  -15,   98 },	},	/*  970 */
	{	{  -10,   86 },	{  -30,  119 },	{  -28,  122 },	{  -37,  127 },	},	/*  971 */
	/* 972-981 coeff_abs_level_minus1 with ctxBlockCat 8 */
	{	{  -12,   92 },	{    1,   58 },	{  -11,   76 },	{  -10,   82 },	},	/*  972 */
	{	{  -15,   55 },	{   -3,   29 },	{  -10,   44 },	{   -8,   48 },	},	/*  973 */
	{	{  -10,   60 },	{   -1,   36 },	{  -10,   52 },	{   -8,   61 },	},	/*  974 */
	{	{   -6,   62 },	{    1,   38 },	{  -10,   57 },	{   -8,   66 },	},	/*  975 */
	{	{   -4,   65 },	{    2,   43 },	{   -9,   58 },	{   -7,   70 },	},	/*  976 */
	{	{  -12,   73 },	{   -6,   55 },	{  -16,   72 },	{  -14,   75 },	},	/*  977 */
	{	{   -8,   76 },	{    0,   58 },	{   -7,   69 },	{  -10,   79 },	},	/*  978 */
	{	{   -7,   80 },	{    0,   64 },	{   -4,   69 },	{   -9,   83 },	},	/*  979 */
	{	{   -9,   88 },	{   -3,   74 },	{   -5,   74 },	{  -12,   92 },	},	/*  980 */
	{	{  -17,  110 },	{  -10,   90 },	{   -9,   86 },	{  -18,  108 },	},	/*  981 */
	/* 982-991 coeff_abs_level_minus1 with ctxBlockCat 10 */
	{	{   -3,   71 },	{   -6,   76 },	{  -23,  112 },	{  -24,  115 },	},	/*  982 */
	{	{   -6,   42 },	{   -2,   44 },	{  -15,   71 },	{  -22,   82 },	},	/*  983 */
	{	{   -5,   50 },	{    0,   45 },	{   -7,   61 },	{   -9,   62 },	},	/*  984 */
	{	{   -3,   54 },	{    0,   52 },	{    0,   53 },	{    0,   53 },	},	/*  985 */
	{	{   -2,   62 },	{   -3,   64 },	{   -5,   66 },	{    0,   59 },	},	/*  986 */
	{	{    0,   58 },	{   -2,   59 },	{  -11,   77 },	{  -14,   85 },	},	/*  987 */
	{	{    1,   63 },	{   -4,   70 },	{   -9,   80 },	{  -13,   89 },	},	/*  988 */
	{	{   -2,   72 },	{   -4,   75 },	{   -9,   84 },	{  -13,   94 },	},	/*  989 */
	{	{   -1,   74 },	{   -8,   82 },	{  -10,   87 },	{  -11,   92 },	},	/*  990 */
	{	{   -9,   91 },	{  -17,  102 },	{  -34,  127 },	{  -29,  127 },	},	/*  991 */
	/* 992-1001 coeff_abs_level_minus1 with ctxBlockCat 11 */
	{	{   -5,   67 },	{   -9,   77 },	{  -21,  101 },	{  -21,  100 },	},	/*  992 */
	{	{   -5,   27 },	{    3,   24 },	{   -3,   39 },	{  -14,   57 },	},	/*  993 */
	{	{   -3,   39 },	{    0,   42 },	{   -5,   53 },	{  -12,   67 },	},	/*  994 */
	{	{   -2,   44 },	{    0,   48 },	{   -7,   61 },	{  -11,   71 },	},	/*  995 */
	{	{    0,   46 },	{    0,   55 },	{  -11,   75 },	{  -10,   77 },	},	/*  996 */
	{	{  -16,   64 },	{   -6,   59 },	{  -15,   77 },	{  -21,   85 },	},	/*  997 */
	{	{   -8,   68 },	{   -7,   71 },	{  -17,   91 },	{  -16,   88 },	},	/*  998 */
	{	{  -10,   78 },	{  -12,   83 },	{  -25,  107 },	{  -23,  104 },	},	/*  999 */
	{	{   -6,   77 },	{  -11,   87 },	{  -25,  111 },	{  -15,   98 },	},	/* 1000 */
	{	{  -10,   86 },	{  -30,  119 },	{  -28,  122 },	{  -37,  127 },	},	/* 1001 */
	/* 1002-1011 coeff_abs_level_minus1 with ctxBlockCat 12 */
	{	{  -12,   92 },	{    1,   58 },	{  -11,   76 },	{  -10,   82 },	},	/* 1002 */
	{	{  -15,   55 },	{   -3,   29 },	{  -10,   44 },	{   -8,   48 },	},	/* 1003 */
	{	{  -10,   60 },	{   -1,   36 },	{  -10,   52 },	{   -8,   61 },	},	/* 1004 */
	{	{   -6,   62 },	{    1,   38 },	{  -10,   57 },	{   -8,   66 },	},	/* 1005 */
	{	{   -4,   65 },	{    2,   43 },	{   -9,   58 },	{   -7,   70 },	},	/* 1006 */
	{	{  -12,   73 },	{   -6,   55 },	{  -16,   72 },	{  -14,   75 },	},	/* 1007 */
	{	{   -8,   76 },	{    0,   58 },	{   -7,   69 },	{  -10,   79 },	},	/* 1008 */
	{	{   -7,   80 },	{    0,   64 },	{   -4,   69 },	{   -9,   83 },	},	/* 1009 */
	{	{   -9,   88 },	{   -3,   74 },	{   -5,   74 },	{  -12,   92 },	},	/* 1010 */
	{	{  -17,  110 },	{  -10,   90 },	{   -9,   86 },	{  -18,  108 },	},	/* 1011 */

	/* 1012-1015 coded_block_flag with ctxBlockCat 5 */
	{	{   -3,   70 },	{   -3,   74 },	{   -2,   73 },	{   -5,   79 },	},	/* 1012 */
	{	{   -8,   93 },	{   -9,   92 },	{  -12,  104 },	{  -11,  104 },	},	/* 1013 */
	{	{  -10,   90 },	{   -8,   87 },	{   -9,   91 },	{  -11,   91 },	},	/* 1014 */
	{	{  -30,  127 },	{  -23,  126 },	{  -31,  127 },	{  -30,  127 },	},	/* 1015 */
	/* 1016-1019 coded_block_flag with ctxBlockCat 9 */
	{	{   -3,   70 },	{   -3,   74 },	{   -2,   73 },	{   -5,   79 },	},	/* 1016 */
	{	{   -8,   93 },	{   -9,   92 },	{  -12,  104 },	{  -11,  104 },	},	/* 1017 */
	{	{  -10,   90 },	{   -8,   87 },	{   -9,   91 },	{  -11,   91 },	},	/* 1018 */
	{	{  -30,  127 },	{  -23,  126 },	{  -31,  127 },	{  -30,  127 },	},	/* 1019 */
	/* 1020-1023 coded_block_flag with ctxBlockCat 12 */
	{	{   -3,   70 },	{   -3,   74 },	{   -2,   73 },	{   -5,   79 },	},	/* 1020 */
	{	{   -8,   93 },	{   -9,   92 },	{  -12,  104 },	{  -11,  104 },	},	/* 1021 */
	{	{  -10,   90 },	{   -8,   87 },	{   -9,   91 },	{  -11,   91 },	},	/* 1022 */
	{	{  -30,  127 },	{  -23,  126 },	{  -31,  127 },	{  -30,  127 },	},	/* 1023 */

	/* 1024-1026 base_mode_flag */
	{	{  -14,  138 },	{    0,   75 },	{    0,   75 },	{    0,   75 },	},	/* 1024 */
	{	{  -22,  140 },	{    2,   65 },	{    2,   65 },	{    2,   65 },	},	/* 1025 */
	{	{  -11,   99 },	{    2,   59 },	{    2,   59 },	{    2,   59 },	},	/* 1026 */
	/* 1027 motion_prediction_flag_l0 */
	{	{    0,    0 },	{   -6,   67 },	{   -6,   67 },	{   -6,   67 },	},	/* 1027 */
	/* 1028 motion_prediction_flag_l1 */
	{	{    0,    0 },	{   -6,   67 },	{   -6,   67 },	{   -6,   67 },	},	/* 1028 */
	/* 1029-1030 residual_prediction_flag */
	{	{    0,    0 },	{  -23,  104 },	{  -23,  104 },	{  -23,  104 },	},	/* 1029 */
	{	{    0,    0 },	{  -35,  106 },	{  -35,  106 },	{  -35,  106 },	},	/* 1030 */
};

static const uint8_t rangeTabLPS[64][4] = {
	{ 128, 176, 208, 240 },
	{ 128, 167, 197, 227 },
	{ 128, 158, 187, 216 },
	{ 123, 150, 178, 205 },
	{ 116, 142, 169, 195 },
	{ 111, 135, 160, 185 },
	{ 105, 128, 152, 175 },
	{ 100, 122, 144, 166 },
	{ 95, 116, 137, 158 },
	{ 90, 110, 130, 150 },
	{ 85, 104, 123, 142 },
	{ 81, 99, 117, 135 },
	{ 77, 94, 111, 128 },
	{ 73, 89, 105, 122 },
	{ 69, 85, 100, 116 },
	{ 66, 80, 95, 110 },
	{ 62, 76, 90, 104 },
	{ 59, 72, 86, 99 },
	{ 56, 69, 81, 94 },
	{ 53, 65, 77, 89 },
	{ 51, 62, 73, 85 },
	{ 48, 59, 69, 80 },
	{ 46, 56, 66, 76 },
	{ 43, 53, 63, 72 },
	{ 41, 50, 59, 69 },
	{ 39, 48, 56, 65 },
	{ 37, 45, 54, 62 },
	{ 35, 43, 51, 59 },
	{ 33, 41, 48, 56 },
	{ 32, 39, 46, 53 },
	{ 30, 37, 43, 50 },
	{ 29, 35, 41, 48 },
	{ 27, 33, 39, 45 },
	{ 26, 31, 37, 43 },
	{ 24, 30, 35, 41 },
	{ 23, 28, 33, 39 },
	{ 22, 27, 32, 37 },
	{ 21, 26, 30, 35 },
	{ 20, 24, 29, 33 },
	{ 19, 23, 27, 31 },
	{ 18, 22, 26, 30 },
	{ 17, 21, 25, 28 },
	{ 16, 20, 23, 27 },
	{ 15, 19, 22, 25 },
	{ 14, 18, 21, 24 },
	{ 14, 17, 20, 23 },
	{ 13, 16, 19, 22 },
	{ 12, 15, 18, 21 },
	{ 12, 14, 17, 20 },
	{ 11, 14, 16, 19 },
	{ 11, 13, 15, 18 },
	{ 10, 12, 15, 17 },
	{ 10, 12, 14, 16 },
	{ 9, 11, 13, 15 },
	{ 9, 11, 12, 14 },
	{ 8, 10, 12, 14 },
	{ 8, 9, 11, 13 },
	{ 7, 9, 11, 12 },
	{ 7, 9, 10, 12 },
	{ 7, 8, 10, 11 },
	{ 6, 8, 9, 11 },
	{ 6, 7, 9, 10 },
	{ 6, 7, 8, 9 },
	{ 2, 2, 2, 2 },
};

static const uint8_t transIdxLPS[64] = {
	0, 0, 1, 2, 2, 4, 4, 5, 6, 7, 8, 9, 9, 11, 11, 12,
	13, 13, 15, 15, 16, 16, 18, 18, 19, 19, 21, 21, 22, 22, 23, 24,
	24, 25, 26, 26, 27, 27, 28, 29, 29, 30, 30, 30, 31, 32, 32, 33,
	33, 33, 34, 34, 35, 35, 35, 36, 36, 36, 37, 37, 37, 38, 38, 63,
};

static const uint8_t transIdxMPS[64] = {
	1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
	33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 62, 63,
};

static inline int clip3(int a, int b, int c) {
	if (c < a)
		return a;
	if (c > b)
		return b;
	return c;
}

static void init_ctx(struct h264_cabac_context *cabac, int ctxIdx, const struct h264_cabac_ctx_init *init) {
	int preCtxState = clip3(1, 126, ((init->m * clip3(0, 51, cabac->slice->sliceqpy)) >> 4) + init->n);
	if (preCtxState <= 63) {
		cabac->pStateIdx[ctxIdx] = 63 - preCtxState;
		cabac->valMPS[ctxIdx] = 0;
	} else {
		cabac->pStateIdx[ctxIdx] = preCtxState - 64;
		cabac->valMPS[ctxIdx] = 1;
	}
}

struct h264_cabac_context *h264_cabac_new(struct h264_slice *slice) {
	struct h264_cabac_context *cabac = calloc (sizeof *cabac, 1);
	cabac->slice = slice;
	int i;
	int mode;
	if (slice->slice_type == H264_SLICE_TYPE_I || slice->slice_type == H264_SLICE_TYPE_SI)
		mode = 0;
	else
		mode = slice->cabac_init_idc + 1;
	for (i = 0; i < H264_CABAC_CTXIDX_NUM; i++)
		init_ctx(cabac, i, &ctx_init_tab[i][mode]);
	return cabac;
}

int h264_cabac_init_arith (struct bitstream *str, struct h264_cabac_context *cabac) {
	if (!cabac)
		return 0;
	if (str->bitpos != 7) {
		fprintf (stderr, "Trying to init CABAC when not byte aligned\n");
		return 1;
	}
	if (str->dir == VS_ENCODE) {
		cabac->codIRange = 510;
		cabac->codIOffset = 0;
		cabac->firstBitFlag = 1;
		cabac->bitsOutstanding = 0;
	} else {
		cabac->codIRange = 510;
		if (vs_u(str, &cabac->codIOffset, 9))
			return 1;
		if (cabac->codIOffset >= 510) {
			fprintf (stderr, "Initial codIOffset >= 510\n");
			return 1;
		}
	}
	return 0;
}

static int put_bit(struct bitstream *str, struct h264_cabac_context *cabac, uint32_t bit) {
	uint32_t nbit = !bit;
	if (cabac->firstBitFlag) {
		cabac->firstBitFlag = 0;
		if (bit != 0) {
			fprintf (stderr, "CABAC initial skipped bit not 0\n");
			return 1;
		}
	} else {
		if (vs_u(str, &bit, 1))
			return 1;
	}
	while (cabac->bitsOutstanding) {
		cabac->bitsOutstanding--;
		if (vs_u(str, &nbit, 1))
			return 1;
	}
	return 0;
}

int h264_cabac_renorm(struct bitstream *str, struct h264_cabac_context *cabac) {
	while (cabac->codIRange < 256) {
		cabac->codIRange <<= 1;
		cabac->codIOffset <<= 1;
		if (str->dir == VS_ENCODE) {
			if (cabac->codIOffset < 512) {
				if (put_bit(str, cabac, 0))
					return 1;
			} else if (cabac->codIOffset >= 1024) {
				if (put_bit(str, cabac, 1))
					return 1;
				cabac->codIOffset -= 1024;
			} else {
				cabac->bitsOutstanding++;
				cabac->codIOffset -= 512;
			}
		} else {
			uint32_t tmp;
			if (vs_u(str, &tmp, 1))
				return 1;
			cabac->codIOffset |= tmp;
		}
	}
	return 0;
}

int h264_cabac_decision(struct bitstream *str, struct h264_cabac_context *cabac, int ctxIdx, uint32_t *binVal) {
	if (ctxIdx == -1)
		return h264_cabac_bypass(str, cabac, binVal);
	if (ctxIdx == H264_CABAC_CTXIDX_TERMINATE)
		return h264_cabac_terminate(str, cabac, binVal);
	int qCodIRangeIdx = cabac->codIRange >> 6 & 3;
	int codIRangeLPS = rangeTabLPS[cabac->pStateIdx[ctxIdx]][qCodIRangeIdx];
	cabac->codIRange -= codIRangeLPS;
	if (str->dir == VS_ENCODE) {
		if (*binVal != cabac->valMPS[ctxIdx]) {
			cabac->codIOffset += cabac->codIRange;
			cabac->codIRange = codIRangeLPS;
		}
	} else {
		if (cabac->codIOffset >= cabac->codIRange) {
			*binVal = !cabac->valMPS[ctxIdx];
			cabac->codIOffset -= cabac->codIRange;
			cabac->codIRange = codIRangeLPS;
		} else {
			*binVal = cabac->valMPS[ctxIdx];
		}
	}
	if (*binVal == cabac->valMPS[ctxIdx]) {
		cabac->pStateIdx[ctxIdx] = transIdxMPS[cabac->pStateIdx[ctxIdx]];
	} else {
		if (cabac->pStateIdx[ctxIdx] == 0)
			cabac->valMPS[ctxIdx] = !cabac->valMPS[ctxIdx];
		cabac->pStateIdx[ctxIdx] = transIdxLPS[cabac->pStateIdx[ctxIdx]];
	}
	if (h264_cabac_renorm(str, cabac))
		return 1;
	cabac->BinCount++;
	return 0;
}

int h264_cabac_bypass(struct bitstream *str, struct h264_cabac_context *cabac, uint32_t *binVal) {
	cabac->codIOffset <<= 1;
	if (str->dir == VS_ENCODE) {
		if (*binVal)
			cabac->codIOffset += cabac->codIRange;
		if (cabac->codIOffset < 512) {
			if (put_bit(str, cabac, 0))
				return 1;
		} else if (cabac->codIOffset >= 1024) {
			if (put_bit(str, cabac, 1))
				return 1;
			cabac->codIOffset -= 1024;
		} else {
			cabac->bitsOutstanding++;
			cabac->codIOffset -= 512;
		}
	} else {
		uint32_t tmp;
		if (vs_u(str, &tmp, 1))
			return 1;
		cabac->codIOffset |= tmp;
		if (cabac->codIOffset >= cabac->codIRange) {
			*binVal = 1;
			cabac->codIOffset -= cabac->codIRange;
		} else {
			*binVal = 0;
		}
	}
	cabac->BinCount++;
	return 0;
}

int h264_cabac_terminate(struct bitstream *str, struct h264_cabac_context *cabac, uint32_t *binVal) {
	cabac->codIRange -= 2;
	if (str->dir == VS_ENCODE) {
		if (*binVal) {
			cabac->codIOffset += cabac->codIRange;
			/* end of the road */
			cabac->codIRange = 2;
			if (h264_cabac_renorm(str, cabac))
				return 1;
			if (put_bit(str, cabac, cabac->codIOffset >> 9 & 1))
				return 1;
			if (put_bit(str, cabac, cabac->codIOffset >> 8 & 1))
				return 1;
			if (put_bit(str, cabac, 1)) /* the last bit, doubling as RBSP terminator if terminating due to end of slice */
				return 1;
		} else {
			if (h264_cabac_renorm(str, cabac))
				return 1;
		}
	} else {
		if (cabac->codIOffset >= cabac->codIRange) {
			*binVal = 1;
		} else {
			*binVal = 0;
			if (h264_cabac_renorm(str, cabac))
				return 1;
		}
	}
	cabac->BinCount++;
	return 0;
}

static int in_tab(const struct h264_cabac_se_val *tab, uint32_t val) {
	int i;
	for (i = 0; tab[i].blen; i++) {
		if (tab[i].subtab) {
			if (in_tab(tab[i].subtab, val))
				return 1;
		} else {
			if (val == tab[i].val)
				return 1;
		}
	}
	return 0;
}

int h264_cabac_se(struct bitstream *str, struct h264_cabac_context *cabac, const struct h264_cabac_se_val *tab, int *ctxIdx, uint32_t *val) {
	if (str->dir == VS_ENCODE) {
		int i, j;
		for (i = 0; tab[i].blen; i++) {
			if (tab[i].subtab ? in_tab(tab[i].subtab, *val) : *val == tab[i].val) {
				uint32_t bit;
				for (j = 0; j < tab[i].blen; j++) {
					bit = tab[i].bits[j].val;
					if (h264_cabac_decision(str, cabac, ctxIdx[tab[i].bits[j].bidx], &bit))
						return 1;
				}
				if (tab[i].subtab)
					return h264_cabac_se(str, cabac, tab[i].subtab, ctxIdx, val);
				else
					return 0;
			}
		}
		fprintf(stderr, "No binarization for a value\n");
		return 1;
	} else {
		int i, j;
		uint32_t bit[8];
		int bidx[8];
		for (i = 0; i < 8; i++)
			bidx[i] = -1;
		for (i = 0; tab[i].blen; i++) {
			for (j = 0; j < tab[i].blen; j++) {
				if (bidx[j] == -1) {
					bidx[j] = tab[i].bits[j].bidx;
					if (h264_cabac_decision(str, cabac, ctxIdx[bidx[j]], &bit[j]))
						return 1;
				}
				if (bidx[j] != tab[i].bits[j].bidx) {
					fprintf(stderr, "Inconsistent CABAC se table!\n");
					return 1;
				}
				if (bit[j] != tab[i].bits[j].val)
					break;
			}
			if (j == tab[i].blen) {
				if (tab[i].subtab) {
					return h264_cabac_se(str, cabac, tab[i].subtab, ctxIdx, val);
				} else {
					*val = tab[i].val;
					return 0;
				}
			}
		}
		fprintf(stderr, "No value for a binarization\n");
		return 1;
	}
}

int h264_cabac_tu(struct bitstream *str, struct h264_cabac_context *cabac, int *ctxIdx, int numidx, uint32_t cMax, uint32_t *val) {
	if (str->dir == VS_ENCODE) {
		int i;
		if (*val > cMax) {
			fprintf(stderr, "TU value over limit\n");
			return 1;
		}
		for (i = 0; i <= *val && i < cMax; i++) {
			uint32_t tmp = i < *val;
			if (h264_cabac_decision(str, cabac, ctxIdx[i >= numidx ? numidx - 1 : i], &tmp)) return 1;
		}
		return 0;
	} else {
		int i;
		uint32_t tmp = 1;
		for (i = 0; i < cMax; i++) {
			if (h264_cabac_decision(str, cabac, ctxIdx[i >= numidx ? numidx - 1 : i], &tmp)) return 1;
			if (!tmp)
				break;
		}
		*val = i;
		return 0;		
	}
}

int h264_cabac_ueg(struct bitstream *str, struct h264_cabac_context *cabac, int *ctxIdx, int numidx, int k, int sign, uint32_t uCoff, int32_t *val) {
	uint32_t tuval = abs(*val);
	if (tuval > uCoff)
		tuval = uCoff;
	if (h264_cabac_tu(str, cabac, ctxIdx, numidx, uCoff, &tuval)) return 1;
	uint32_t rval = tuval;
	if (tuval >= uCoff) {
		if (str->dir == VS_ENCODE) {
			rval = abs(*val);
			uint32_t sufS = rval - uCoff;
			uint32_t tmp = 1;
			while (sufS >= (1 << k)) {
				if (h264_cabac_bypass(str, cabac, &tmp)) return 1;
				sufS -= 1 << k;
				k++;
			}
			tmp = 0;
			if (h264_cabac_bypass(str, cabac, &tmp)) return 1;
			while (k--) {
				tmp = sufS >> k & 1;
				if (h264_cabac_bypass(str, cabac, &tmp)) return 1;
			}
		} else {
			uint32_t tmp;
			while (1) {
				if (h264_cabac_bypass(str, cabac, &tmp)) return 1;
				if (!tmp)
					break;
				rval += 1 << k;
				k++;
			}
			while (k--) {
				if (h264_cabac_bypass(str, cabac, &tmp)) return 1;
				rval += tmp << k;
			}
		}
	}
	if (rval && sign) {
		uint32_t s = *val < 0;
		if (h264_cabac_bypass(str, cabac, &s)) return 1;
		if (str->dir == VS_DECODE) {
			if (s)
				*val = -rval;
			else
				*val = rval;
		}
	} else {
		if (str->dir == VS_DECODE)
			*val = rval;
	}
	return 0;
}

void h264_cabac_destroy(struct h264_cabac_context *cabac) {
	free(cabac);
}
