/*
 * Copyright (C) 2016 Marcelina Kościelnicka <mwk@0x04.net>
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#include "nvhw/pgraph.h"

void pgraph_celsius_pre_icmd(struct pgraph_state *state) {
	uint32_t cb = state->shadow_config_b;
	if (!extr(cb, 9, 1)) {
		state->celsius_pipe_xvtx[0][6] = state->bundle_point_size << 12;
		state->celsius_pipe_xvtx[1][6] = state->bundle_point_size << 12;
		state->celsius_pipe_xvtx[2][6] = state->bundle_point_size << 12;
	}
}

void pgraph_celsius_icmd(struct pgraph_state *state, int cmd, uint32_t val, bool last) {
	int vs = extr(state->celsius_pipe_vtx_state, 28, 3);
	int pt = state->celsius_pipe_begin_end;
	uint32_t cb = state->shadow_config_b;
	if (!extr(cb, 7, 1)) {
		if (!extr(cb, 0, 1)) {
			if (pt == 3 && vs != 0 && vs != 4) {
				state->celsius_pipe_xvtx[1][10] = state->celsius_pipe_xvtx[0][10];
				state->celsius_pipe_xvtx[2][10] = state->celsius_pipe_xvtx[0][10];
				insrt(state->celsius_pipe_xvtx[1][11], 8, 24, extr(state->celsius_pipe_xvtx[0][11], 8, 24));
				insrt(state->celsius_pipe_xvtx[2][11], 8, 24, extr(state->celsius_pipe_xvtx[0][11], 8, 24));
			}
		} else {
			if (pt == 3 && vs != 0 && vs != 4) {
				int ctr = state->celsius_pipe_ovtx_pos;
				state->celsius_pipe_xvtx[0][10] = state->celsius_pipe_xvtx[2][10];
				state->celsius_pipe_xvtx[1][10] = state->celsius_pipe_xvtx[2][10];
				insrt(state->celsius_pipe_xvtx[0][11], 8, 24, extr(state->celsius_pipe_xvtx[2][11], 8, 24));
				insrt(state->celsius_pipe_xvtx[1][11], 8, 24, extr(state->celsius_pipe_xvtx[2][11], 8, 24));
				state->celsius_pipe_xvtx[2][10] = state->celsius_pipe_ovtx[ctr][10];
				insrt(state->celsius_pipe_xvtx[2][11], 8, 24, extr(state->celsius_pipe_ovtx[ctr][11], 8, 24));
			}
			if (pt == 0xa && vs != 0 && vs != 4 && vs != 7) {
				int ctr = state->celsius_pipe_ovtx_pos;
				state->celsius_pipe_xvtx[1][10] = state->celsius_pipe_xvtx[2][10];
				insrt(state->celsius_pipe_xvtx[1][11], 8, 24, extr(state->celsius_pipe_xvtx[2][11], 8, 24));
				state->celsius_pipe_xvtx[2][10] = state->celsius_pipe_ovtx[ctr][10];
				insrt(state->celsius_pipe_xvtx[2][11], 8, 24, extr(state->celsius_pipe_ovtx[ctr][11], 8, 24));
			}
		}
	}
	uint32_t cls = pgraph_class(state);
	uint32_t cc = state->celsius_config_c;
	if (cls == 0x55 || cls == 0x95) {
		if (cmd == 0x11 || cmd == 0x13) {
			bool color = cmd == 0x13;
			if (extr(cc, 20 + color, 1) && !extr(cc, 18 + color, 1)) {
				for (int i = 0; i < 4; i++)
					if (extr(val, i * 8, 4) == 0xc)
						val ^= 1 << (i * 8 + 5);
			}
		}
		if (cmd == 7)
			insrt(val, 30, 1, extr(cc, 16, 4) != 0xf);
		if (cmd == 0x1b) {
			if (extr(cc, 23, 1) || (extr(cc, 19, 1) && extr(cc, 21, 1)))
				insrt(val, 5, 1, 1);
			if (extr(cc, 22, 1) || (extr(cc, 18, 1) && extr(cc, 20, 1)))
				insrt(val, 13, 1, 1);
		}
	}
	pgraph_celsius_raw_icmd(state, cmd, val, last);
}

void pgraph_celsius_raw_icmd(struct pgraph_state *state, int cmd, uint32_t val, bool last) {
	state->celsius_pipe_junk[0] = cmd << 2;
	state->celsius_pipe_junk[1] = val;
	insrt(state->celsius_pipe_vtx_state, 28, 3, 0);
	if (state->chipset.chipset == 0x10) {
		int prev = state->celsius_pipe_prev_ovtx_pos;
		state->celsius_pipe_xvtx[0][0] = state->celsius_pipe_ovtx[prev][0];
		state->celsius_pipe_xvtx[0][1] = state->celsius_pipe_ovtx[prev][1];
		state->celsius_pipe_xvtx[0][3] = state->celsius_pipe_ovtx[prev][3];
		insrt(state->celsius_pipe_xvtx[0][11], 0, 1, extr(state->celsius_pipe_ovtx[prev][2], 31, 1));
		if (extr(state->shadow_config_b, 9, 1)) {
			state->celsius_pipe_xvtx[0][6] = state->celsius_pipe_ovtx[prev][2] & 0x001ff000;
		}
	}
	int ctr = state->celsius_pipe_ovtx_pos;
	state->celsius_pipe_ovtx[ctr][2] = val;
	insrt(state->celsius_pipe_ovtx[ctr][9], 0, 6, cmd);
	insrt(state->celsius_pipe_ovtx[ctr][11], 0, 1, extr(val, 31, 1));
	state->celsius_pipe_xvtx[0][4] = cmd << 2;
	state->celsius_pipe_xvtx[0][5] = val;
	state->celsius_pipe_xvtx[0][7] = state->celsius_pipe_ovtx[ctr][3];
	state->celsius_pipe_xvtx[0][12] = val;
	state->celsius_pipe_xvtx[0][13] = cmd;
	uint32_t fract = extr(state->celsius_pipe_ovtx[ctr][9], 11, 12);
	if (extr(state->celsius_pipe_ovtx[ctr][9], 23, 8))
		fract |= 0x1000;
	if (extr(state->celsius_pipe_ovtx[ctr][9], 31, 1))
		fract = -fract;
	insrt(state->celsius_pipe_xvtx[0][13], 10, 14, fract);
	insrt(state->celsius_pipe_xvtx[0][13], 24, 8, extr(state->celsius_pipe_ovtx[ctr][9], 23, 8));
	state->celsius_pipe_xvtx[0][14] = state->celsius_pipe_ovtx[ctr][10];
	if (extr(state->shadow_config_b, 6, 1) && last)
		state->celsius_pipe_xvtx[0][15] = state->celsius_pipe_ovtx[ctr][11] & ~1;
	state->celsius_pipe_prev_ovtx_pos = state->celsius_pipe_ovtx_pos;
	state->celsius_pipe_ovtx_pos++;
	state->celsius_pipe_ovtx_pos &= 0xf;
	if (cmd == 0x1f) {
		if (!extr(state->shadow_config_b, 7, 1) && extr(state->shadow_config_b, 0, 1) && (extr(val, 7, 1) || !extr(val, 0, 1))) {
			state->celsius_pipe_xvtx[1][10] = state->celsius_pipe_xvtx[0][10];
			insrt(state->celsius_pipe_xvtx[1][11], 8, 24, extr(state->celsius_pipe_xvtx[0][11], 8, 24));
			state->celsius_pipe_xvtx[2][10] = state->celsius_pipe_xvtx[0][10];
			insrt(state->celsius_pipe_xvtx[2][11], 8, 24, extr(state->celsius_pipe_xvtx[0][11], 8, 24));
		}
		state->shadow_config_b = val;
	}
}

uint32_t pgraph_celsius_fixup_vtxbuf_format(struct pgraph_state *state, int idx, uint32_t val) {
	uint32_t res = 0;
	insrt(res, 10, 6, extr(val, 10, 6));
	int comp = extr(val, 4, 3);
	int fmt = extr(val, 0, 3);
	bool w = extr(val, 24, 1);
	switch (idx) {
		case 0:
			if (comp > 4)
				comp &= 3;
			if (comp == 0)
				comp = 4;
			break;
		case 1:
		case 2:
			if (comp < 2)
				comp = 0;
			else if (comp < 4)
				comp = 3;
			else
				comp = 4;
			break;
		case 3:
		case 4:
			if (comp > 4)
				comp &= 3;
			break;
		case 5:
			if ((comp & 3) == 3)
				comp = 3;
			else
				comp = 0;
			break;
		case 6:
		case 7:
			if (comp & 1)
				comp = 1;
			else
				comp = 0;
			break;
	}
	if (idx == 1 || idx == 2) {
		if (fmt == 2 || fmt == 3 || fmt == 7)
			fmt = 6;
		if (fmt == 1)
			fmt = 0;
		if (fmt == 5)
			fmt = 4;
	} else {
		if (fmt & 2)
			fmt = 6;
		else
			fmt = 5;
	}
	insrt(res, 0, 3, fmt);
	insrt(res, 4, 3, comp);
	insrt(res, 24, 1, w);
	return res;
}
