/*
 * Copyright (C) 2013 Marcelina Kościelnicka <mwk@0x04.net>
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef NVRM_IOCTL_H
#define NVRM_IOCTL_H

#include <sys/ioctl.h>
#include <inttypes.h>

#define NVRM_IOCTL_MAGIC 'F'

struct nvrm_ioctl_create_ctx {
	uint32_t handle;
	uint32_t unk04;
	uint32_t unk08;
};
#define NVRM_IOCTL_CREATE_CTX _IOWR(NVRM_IOCTL_MAGIC, 0x22, struct nvrm_ioctl_create_ctx)

struct nvrm_ioctl_create_dev_obj {
	uint32_t cid;
	uint32_t handle;
	uint32_t unk08;
	uint32_t unk0c;
	uint32_t ptr;
	uint32_t unk14;
	uint32_t unk18;
	uint32_t unk1c;
};
#define NVRM_IOCTL_CREATE_DEV_OBJ _IOWR(NVRM_IOCTL_MAGIC, 0x23, struct nvrm_ioctl_create_dev_obj)

/* used on dev fd */
struct nvrm_ioctl_create_vspace {
	uint32_t cid;
	uint32_t parent;
	uint32_t handle;
	uint32_t cls;
	uint32_t flags;
	uint32_t _pad1;
	uint64_t foffset;
	uint64_t limit;
	uint32_t status;
	uint32_t _pad2;
};
#define NVRM_IOCTL_CREATE_VSPACE _IOWR(NVRM_IOCTL_MAGIC, 0x27, struct nvrm_ioctl_create_vspace)

struct nvrm_ioctl_create_vspace56 {
	uint32_t cid;
	uint32_t parent;
	uint32_t handle;
	uint32_t cls;
	uint32_t flags;
	uint32_t _pad1;
	uint64_t map_id;
	uint64_t limit;
	uint32_t status;
	uint32_t _pad2;
	uint32_t target_fd;
	uint32_t _pad3;
};
#define NVRM_IOCTL_CREATE_VSPACE56 _IOWR(NVRM_IOCTL_MAGIC, 0x27, struct nvrm_ioctl_create_vspace56)

struct nvrm_ioctl_create_simple {
	uint32_t cid;
	uint32_t parent;
	uint32_t handle;
	uint32_t cls;
	uint32_t status;
};
#define NVRM_IOCTL_CREATE_SIMPLE _IOWR(NVRM_IOCTL_MAGIC, 0x28, struct nvrm_ioctl_create_simple)

struct nvrm_ioctl_destroy {
	uint32_t cid;
	uint32_t parent;
	uint32_t handle;
	uint32_t status;
};
#define NVRM_IOCTL_DESTROY _IOWR(NVRM_IOCTL_MAGIC, 0x29, struct nvrm_ioctl_destroy)

struct nvrm_ioctl_call {
	uint32_t cid;
	uint32_t handle;
	uint32_t mthd;
	uint32_t _pad;
	uint64_t ptr;
	uint32_t size;
	uint32_t status;
};
#define NVRM_IOCTL_CALL _IOWR(NVRM_IOCTL_MAGIC, 0x2a, struct nvrm_ioctl_call)

struct nvrm_ioctl_create {
	uint32_t cid;
	uint32_t parent;
	uint32_t handle;
	uint32_t cls;
	uint64_t ptr;
	uint32_t status;
	uint32_t _pad;
};
#define NVRM_IOCTL_CREATE _IOWR(NVRM_IOCTL_MAGIC, 0x2b, struct nvrm_ioctl_create)

struct nvrm_ioctl_create_drv_obj {
	uint32_t cid;
	uint32_t parent;
	uint32_t handle;
	uint32_t cls;
	uint32_t status;
};
#define NVRM_IOCTL_CREATE_DRV_OBJ _IOWR(NVRM_IOCTL_MAGIC, 0x2d, struct nvrm_ioctl_create_drv_obj)

/* used on dev fd */
struct nvrm_ioctl_get_param {
	uint32_t cid;
	uint32_t handle; /* device */
	uint32_t key;
	uint32_t value; /* out */
	uint32_t status;
};
#define NVRM_IOCTL_GET_PARAM _IOWR(NVRM_IOCTL_MAGIC, 0x32, struct nvrm_ioctl_get_param)

struct nvrm_ioctl_create_unk34 {
	uint32_t cid;
	uint32_t parent;
	uint32_t handle;
	uint32_t cid2;
	uint32_t handle2;
	uint32_t unk14;
	uint32_t status;
};
#define NVRM_IOCTL_CREATE_UNK34 _IOWR(NVRM_IOCTL_MAGIC, 0x34, struct nvrm_ioctl_create_unk34)

/* used on dev fd */
struct nvrm_ioctl_query {
	uint32_t cid;
	uint32_t handle;
	uint32_t query;
	uint32_t size;
	uint64_t ptr;
	uint32_t status;
	uint32_t _pad;
};
#define NVRM_IOCTL_QUERY _IOWR(NVRM_IOCTL_MAGIC, 0x37, struct nvrm_ioctl_query)

struct nvrm_ioctl_unk38 {
	uint32_t cid;
	uint32_t handle;
	uint32_t unk08;
	uint32_t size;
	uint64_t ptr;
	uint32_t status;
	uint32_t _pad;
};
#define NVRM_IOCTL_UNK38 _IOWR(NVRM_IOCTL_MAGIC, 0x38, struct nvrm_ioctl_unk38)

struct nvrm_ioctl_sched_fifo {
	uint32_t cid;
	uint32_t dev;
	uint32_t handle; // NVRM_FIFO_* handle / something else
	uint32_t cnt;    // 0 when handle is a fifo, >0 otherwise
	uint64_t ptr1;
	uint64_t ptr2;
	uint64_t ptr3;
	uint32_t unk28;
	uint32_t unk2c;
	uint32_t status;
	uint32_t _pad;
};
#define NVRM_IOCTL_SCHED_FIFO _IOWR(NVRM_IOCTL_MAGIC, 0x41, struct nvrm_ioctl_sched_fifo)

struct nvrm_ioctl_disp_unk48 {
	uint32_t cid;
	uint32_t handle;
	uint32_t unk08;
	uint32_t _pad;
};
#define NVRM_IOCTL_DISP_UNK48 _IOWR(NVRM_IOCTL_MAGIC, 0x48, struct nvrm_ioctl_disp_unk48)

struct nvrm_ioctl_memory {
	uint32_t cid;
	uint32_t parent;
	uint32_t cls;
	uint32_t unk0c;
	uint32_t status;
	uint32_t unk14;
	uint64_t vram_total;
	uint64_t vram_free;
	uint32_t vspace;
	uint32_t handle;
	uint32_t unk30;
	uint32_t flags1;
#define NVRM_IOCTL_MEMORY_FLAGS1_USER_HANDLE	0x00004000 /* otherwise 0xcaf..... allocated */
	uint64_t unk38;
	uint32_t flags2;
	uint32_t unk44;
	uint64_t unk48;
	uint32_t flags3;
	uint32_t unk54;
	uint64_t unk58;
	uint64_t size;
	uint64_t align;
	uint64_t base;
	uint64_t limit;
	uint64_t unk80;
	uint64_t unk88;
	uint64_t unk90;
	uint64_t unk98;
};
struct nvrm_ioctl_memory2 {
	uint32_t cid;
	uint32_t parent;
	uint32_t cls;
	uint32_t unk0c;
	uint32_t status;
	uint32_t unk14;
	uint64_t vram_total;
	uint64_t vram_free;
	uint32_t vspace;
	uint32_t handle;
	uint32_t unk30[32];
};
struct nvrm_ioctl_memory3 {
	uint32_t cid;
	uint32_t parent;
	uint32_t cls;
	uint32_t unk0c;
	uint32_t status;
	uint32_t unk14;
	uint64_t vram_total;
	uint64_t vram_free;
	uint32_t vspace;
	uint32_t handle;
	uint32_t unk30[36];
};
#define NVRM_IOCTL_MEMORY _IOWR(NVRM_IOCTL_MAGIC, 0x4a, struct nvrm_ioctl_memory)
#define NVRM_IOCTL_MEMORY2 _IOWR(NVRM_IOCTL_MAGIC, 0x4a, struct nvrm_ioctl_memory2)
#define NVRM_IOCTL_MEMORY3 _IOWR(NVRM_IOCTL_MAGIC, 0x4a, struct nvrm_ioctl_memory3)

struct nvrm_ioctl_config {
	uint32_t cid;
	uint32_t handle;
	uint64_t unk08;
	uint64_t unk10;
	uint64_t slen;
	uint64_t sptr;
	uint64_t unk28;
	uint64_t unk30;
	uint64_t unk38; /* out */
	uint32_t status;
	uint32_t _pad;
};
#define NVRM_IOCTL_CONFIG _IOWR(NVRM_IOCTL_MAGIC, 0x4d, struct nvrm_ioctl_config)

struct nvrm_ioctl_unk4d_old {
	uint32_t unk00;
	uint32_t unk04;
	uint32_t unk08;
	uint32_t unk0c;
	uint32_t unk10;
	uint32_t unk14;
	uint32_t ptr;
	uint32_t unk1c;
	uint32_t unk20;
	uint32_t unk24;
	uint32_t unk28;
	uint32_t unk2c;
	uint32_t unk30;
	uint32_t unk34;
	uint32_t unk38;
	uint32_t unk3c;
};
#define NVRM_IOCTL_UNK4D_OLD _IOWR(NVRM_IOCTL_MAGIC, 0x4d, struct nvrm_ioctl_unk4d_old)

struct nvrm_ioctl_host_map {
	uint32_t cid;
	uint32_t subdev;
	uint32_t handle;
	uint32_t _pad;
	uint64_t base;
	uint64_t limit;
	uint64_t foffset;
	uint32_t status;
	uint32_t unk;
};
#define NVRM_IOCTL_HOST_MAP _IOWR(NVRM_IOCTL_MAGIC, 0x4e, struct nvrm_ioctl_host_map)

struct nvrm_ioctl_host_map56 {
	uint32_t cid;
	uint32_t subdev;
	uint32_t handle;
	uint32_t _pad;
	uint64_t foffset;
	uint64_t length;
	uint64_t map_id;
	uint32_t status;
	uint32_t _pad2;
	uint32_t target_fd;
	uint32_t _pad3;
};
#define NVRM_IOCTL_HOST_MAP56 _IOWR(NVRM_IOCTL_MAGIC, 0x4e, struct nvrm_ioctl_host_map56)

struct nvrm_ioctl_host_unmap {
	uint32_t cid;
	uint32_t subdev;
	uint32_t handle;
	uint32_t _pad;
	uint64_t foffset;
	uint32_t status;
	uint32_t _pad2;
};
#define NVRM_IOCTL_HOST_UNMAP _IOWR(NVRM_IOCTL_MAGIC, 0x4f, struct nvrm_ioctl_host_unmap)

struct nvrm_ioctl_unk52 {
	uint64_t ptr;
	uint32_t unk08;/*cnt?*/
	uint32_t status;
};
#define NVRM_IOCTL_UNK52 _IOWR(NVRM_IOCTL_MAGIC, 0x52, struct nvrm_ioctl_unk52)

struct nvrm_ioctl_create_dma {
	uint32_t cid;
	uint32_t handle;
	uint32_t cls;
	uint32_t flags;
	uint32_t _pad1;
	uint32_t parent;
	uint64_t base;
	uint64_t limit;
	uint32_t status;
	uint32_t _pad2;
};
#define NVRM_IOCTL_CREATE_DMA _IOWR(NVRM_IOCTL_MAGIC, 0x54, struct nvrm_ioctl_create_dma)

struct nvrm_ioctl_create_dma56 {
	uint32_t cid;
	uint32_t _pad1;
	uint32_t handle;
	uint32_t cls;
	uint32_t flags;
	uint32_t _pad2;
	uint32_t parent;
	uint32_t _pad3;
	uint64_t base;
	uint64_t limit;
	uint32_t status;
	uint32_t unk34;
};
#define NVRM_IOCTL_CREATE_DMA56 _IOWR(NVRM_IOCTL_MAGIC, 0x54, struct nvrm_ioctl_create_dma56)

struct nvrm_ioctl_vspace_map {
	uint32_t cid;
	uint32_t dev;
	uint32_t vspace;
	uint32_t handle;
	uint64_t base;
	uint64_t size;
	uint32_t flags;
	uint32_t _pad1;
	uint64_t addr;
	uint32_t status;
	uint32_t _pad2;
};
#define NVRM_IOCTL_VSPACE_MAP _IOWR(NVRM_IOCTL_MAGIC, 0x57, struct nvrm_ioctl_vspace_map)

struct nvrm_ioctl_vspace_unmap {
	uint32_t cid;
	uint32_t dev;
	uint32_t vspace;
	uint32_t handle;
	uint64_t unk10;
	uint64_t addr;
	uint32_t status;
	uint32_t _pad;
};
#define NVRM_IOCTL_VSPACE_UNMAP _IOWR(NVRM_IOCTL_MAGIC, 0x58, struct nvrm_ioctl_vspace_unmap)

struct nvrm_ioctl_bind {
	uint32_t cid;
	uint32_t target;
	uint32_t handle;
	uint32_t status;
};
#define NVRM_IOCTL_BIND _IOWR(NVRM_IOCTL_MAGIC, 0x59, struct nvrm_ioctl_bind)

struct nvrm_ioctl_unk5e {
	uint32_t cid;
	uint32_t subdev;
	uint32_t handle;
	uint32_t _pad1;
	uint64_t foffset;
	uint64_t ptr; /* to just-mmapped thing */
	uint32_t status;
	uint32_t _pad2;
};
#define NVRM_IOCTL_UNK5E _IOWR(NVRM_IOCTL_MAGIC, 0x5e, struct nvrm_ioctl_unk5e)

#define NVRM_IOCTL_ESC_BASE 200

struct nvrm_ioctl_card_info {
	struct {
		uint32_t flags;
		uint32_t domain;
		uint8_t bus;
		uint8_t slot;
		uint16_t vendor_id;
		uint16_t device_id;
		uint16_t _pad;
		uint32_t gpu_id;
		uint16_t interrupt;
		uint16_t _pad2;
		uint64_t reg_address;
		uint64_t reg_size;
		uint64_t fb_address;
		uint64_t fb_size;
	} card[32];
};
struct nvrm_ioctl_card_info2 {
	struct {
		uint32_t flags;
		uint32_t domain;
		uint8_t bus;
		uint8_t slot;
		uint8_t function;
		uint8_t _pad0;
		uint16_t vendor_id;
		uint16_t device_id;
		uint32_t _pad1;
		uint32_t gpu_id;
		uint32_t interrupt;
		uint32_t _pad2;
		uint64_t reg_address;
		uint64_t reg_size;
		uint64_t fb_address;
		uint64_t fb_size;
		uint32_t index;
		uint32_t _pad3;
	} card[32];
};
struct nvrm_ioctl_card_info3 {
	struct {
		uint32_t flags;
		uint32_t domain;
		uint8_t bus;
		uint8_t slot;
		uint8_t function;
		uint8_t _pad0;
		uint16_t vendor_id;
		uint16_t device_id;
		uint32_t _pad1;
		uint32_t gpu_id;
		uint32_t interrupt;
		uint32_t _pad2;
		uint64_t reg_address;
		uint64_t reg_size;
		uint64_t fb_address;
		uint64_t fb_size;
		uint32_t index;
		uint32_t _pad3;
		uint32_t _pad4;
		uint32_t _pad5;
	} card[32];
};
#define NVRM_IOCTL_CARD_INFO _IOWR(NVRM_IOCTL_MAGIC, NVRM_IOCTL_ESC_BASE+0, struct nvrm_ioctl_card_info)
#define NVRM_IOCTL_CARD_INFO2 _IOWR(NVRM_IOCTL_MAGIC, NVRM_IOCTL_ESC_BASE+0, struct nvrm_ioctl_card_info2)
#define NVRM_IOCTL_CARD_INFO3 _IOWR(NVRM_IOCTL_MAGIC, NVRM_IOCTL_ESC_BASE+0, struct nvrm_ioctl_card_info3)

struct nvrm_ioctl_env_info {
	uint32_t pat_supported;
};
#define NVRM_IOCTL_ENV_INFO _IOWR(NVRM_IOCTL_MAGIC, NVRM_IOCTL_ESC_BASE+2, struct nvrm_ioctl_env_info)

struct nvrm_ioctl_create_os_event {
	uint32_t cid;
	uint32_t handle;
	uint32_t ehandle;
	uint32_t fd;
	uint32_t status;
};
#define NVRM_IOCTL_CREATE_OS_EVENT _IOWR(NVRM_IOCTL_MAGIC, NVRM_IOCTL_ESC_BASE+6, struct nvrm_ioctl_create_os_event)

struct nvrm_ioctl_destroy_os_event {
	uint32_t cid;
	uint32_t handle;
	uint32_t fd;
	uint32_t status;
};
#define NVRM_IOCTL_DESTROY_OS_EVENT _IOWR(NVRM_IOCTL_MAGIC, NVRM_IOCTL_ESC_BASE+7, struct nvrm_ioctl_destroy_os_event)

struct nvrm_ioctl_status_code {
	uint32_t domain;
	uint8_t bus;
	uint8_t slot;
	uint16_t _pad0;
	uint32_t status;
};
#define NVRM_IOCTL_STATUS_CODE _IOWR(NVRM_IOCTL_MAGIC, NVRM_IOCTL_ESC_BASE+9, struct nvrm_ioctl_status_code)

struct nvrm_ioctl_check_version_str {
	uint32_t cmd;
	uint32_t reply;
	char vernum[0x40];
};
#define NVRM_IOCTL_CHECK_VERSION_STR _IOWR(NVRM_IOCTL_MAGIC, NVRM_IOCTL_ESC_BASE+10, struct nvrm_ioctl_check_version_str)

struct nvrm_ioctl_xfer_cmd {
	uint32_t cmd;
	uint32_t size;
	uint64_t ptr;
};
#define NVRM_IOCTL_XFER_CMD _IOWR(NVRM_IOCTL_MAGIC, NVRM_IOCTL_ESC_BASE+11, struct nvrm_ioctl_xfer_cmd)

struct nvrm_ioctl_query_device_intr {
	uint32_t intr_status;
	uint32_t status;
};
#define NVRM_IOCTL_QUERY_DEVICE_INTR _IOWR(NVRM_IOCTL_MAGIC, NVRM_IOCTL_ESC_BASE+13, struct nvrm_ioctl_query_device_intr)

struct nvrm_ioctl_sys_params {
	uint64_t memblock_size;
};
#define NVRM_IOCTL_SYS_PARAMS _IOWR(NVRM_IOCTL_MAGIC, NVRM_IOCTL_ESC_BASE+14, struct nvrm_ioctl_sys_params)

struct nvrm_ioctl_numa_info {
	int32_t nid;
	int32_t status;
	uint64_t memblock_size;
	uint64_t numa_mem_addr;
	uint64_t numa_mem_size;
};
#define NVRM_IOCTL_NUMA_INFO _IOWR(NVRM_IOCTL_MAGIC, NVRM_IOCTL_ESC_BASE+15, struct nvrm_ioctl_numa_info)

struct nvrm_ioctl_numa_info2 {
	int32_t nid;
	int32_t status;
#define NVRM_IOCTL_NUMA_STATUS_DISABLED             0
#define NVRM_IOCTL_NUMA_STATUS_OFFLINE              1
#define NVRM_IOCTL_NUMA_STATUS_ONLINE_IN_PROGRESS   2
#define NVRM_IOCTL_NUMA_STATUS_ONLINE               3
#define NVRM_IOCTL_NUMA_STATUS_ONLINE_FAILED        4
#define NVRM_IOCTL_NUMA_STATUS_OFFLINE_IN_PROGRESS  5
#define NVRM_IOCTL_NUMA_STATUS_OFFLINE_FAILED       6
	uint64_t memblock_size;
	uint64_t numa_mem_addr;
	uint64_t numa_mem_size;
	struct {
#define NVRM_IOCTL_NUMA_INFO_MAX_BLACKLIST_ADDRESSES 64
		uint64_t address[NVRM_IOCTL_NUMA_INFO_MAX_BLACKLIST_ADDRESSES];
		uint32_t num_entries;
	} blacklist_addresses;
};
#define NVRM_IOCTL_NUMA_INFO2 _IOWR(NVRM_IOCTL_MAGIC, NVRM_IOCTL_ESC_BASE+15, struct nvrm_ioctl_numa_info2)

struct nvrm_ioctl_set_numa_status {
	int32_t status;
};
#define NVRM_IOCTL_SET_NUMA_STATUS _IOWR(NVRM_IOCTL_MAGIC, NVRM_IOCTL_ESC_BASE+16, struct nvrm_ioctl_set_numa_status)

#define NVRM_STATUS_SUCCESS		0
#define NVRM_STATUS_ALREADY_EXISTS_SUB	5	/* like 6, but for subdevice-relative stuff */
#define NVRM_STATUS_ALREADY_EXISTS	6	/* tried to create object for eg. device that already has one */
#define NVRM_STATUS_INVALID_PARAM	8	/* NULL param to create, ... */
#define NVRM_STATUS_INVALID_DEVICE	11	/* NVRM_CLASS_DEVICE devid out of range */
#define NVRM_STATUS_INVALID_MTHD	12	/* invalid mthd to call */
#define NVRM_STATUS_OBJECT_ERROR	26	/* object model violation - wrong parent class, tried to create object with existing handle, nonexistent object, etc. */
#define NVRM_STATUS_NO_HW		29	/* not supported on this card */
#define NVRM_STATUS_MTHD_SIZE_MISMATCH	32	/* invalid param size for a mthd */
#define NVRM_STATUS_ADDRESS_FAULT	34	/* basically -EFAULT */
#define NVRM_STATUS_MTHD_CLASS_MISMATCH	41	/* invalid mthd for given class */
#define NVRM_STATUS_MTHD_SIZE_MISMATCH2 58      /* another(!) error code for invalid param size for a mthd */

#endif
