#include "defines.h"
/*     Bed a Binary EDitor for Linux and for Rxvt running under Linux.       */
/*     Copyright (C) 1998  Jaap Korthals Altes <binaryeditor+bed@eml.cc>      */
/*                                                                           */
/*     Bed is free software; you can redistribute it and/or modify           */
/*     it under the terms of the GNU General Public License as published by  */
/*     the Free Software Foundation; either version 2 of the License, or     */
/*     (at your option) any later version.                                   */
/*                                                                           */
/*     Bed is distributed in the hope that it will be useful,                */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*     GNU General Public License for more details.                          */
/*                                                                           */
/*     You should have received a copy of the GNU General Public License     */
/*     along with bed; if not, write to the Free Software                    */
/*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                           */
/* Sun Dec  6 18:34:27 1998                                                  */

#ifdef __CYGWIN__
#include <windows.h>
#endif
#include <features.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <stdio.h>
#include <ctype.h>
#include <alloca.h>
#undef isprint
#define isprint(x) ((x)>31&&(x)<127)
#include <unistd.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <unistd.h>
       #include <pwd.h>
             #include <grp.h>
              #include <sys/types.h>
#include "dialog.h"
#include "screen.h"
#include "system.h"
#include "readconfig.h"
#include "onlykey.h"
#include "keyinput.h"
#include "myalloc.h"
#define trefresh(x)




extern WINDOW *rightwin(int l,int c,int by,int bx) ;
#include "minmax.h"
extern char spatiebuf[];
template <typename Init,typename Base>
class showlist :public Base{
private:
using typename Base::Pos;
using Base::next;
using Base::prev;
using Base::startpos;
using Base::endpos;
using Base::startscreen;
using Base::endscreen;
using Base::data;
Pos *possel;
const char *prompt;
	int h,l,beg,x,y,sel,endscreenpos;
	void rewrite();
	void showsel() ;
void unshowsel(void) ;
	void start();
	void end();
	void up();
	void down();
	void pageup();
	void pagedown();
	Pos *selectindex(int key) ;

inline void printline(const int down,const char *str) {
		mvwaddnstr(takescr,down+y,x,str,l);
		};
public:

	showlist(const char *prompt,Init init,int xpos=1,int ypos=1,int begin=0,int height=15,int len=60) : Base(init),
		prompt(prompt),
		h(height-1),
		l(len-2),
		beg((begin>h)?(begin-h)/2:0),
		x(xpos),
		y(ypos),
		sel(begin-beg)

 {
		int begy=(thelines-height)/2;
		int begx=(thecols-len)/2;
		rightwin(height,len,maxnum(begy,0),maxnum(begx,0));
/*
		if(!takescr)
			return INT_MAX;
*/
		werase(takescr);
		 };
	~showlist() {}

	Pos  *selectloop(void) ;
	};




template <typename I,typename B>
void showlist<I,B>::unshowsel(void) {
	SELCOLOR;
	trefresh(takescr);
	printline(sel,spatiebuf); 
	printline(sel,data(possel)); 
	trefresh(takescr);
	};




template <typename I,typename B>
void showlist<I,B>::showsel(void) {
	SELSELCOLOR;
	trefresh(takescr);
	printline(sel,spatiebuf); 
	printline(sel,data(possel)); 
	trefresh(takescr);
	};
template <typename I,typename B>
void showlist<I,B>::rewrite(void) {	
	Pos *tmp=startscreen;
	SELCOLOR;
	trefresh(stdscr);
	mvwvline(takescr,y,x-1,0, h); /*Without these lines on ncurses error sometimes meshed up the screen. Showmarks after list search at the end of the file*/
	mvwvline(takescr,y,x+l,0, h);
	for(int i=0;i<h;i++) {
		printline(i,spatiebuf); 
		}
int i=0;
	for(;;i++,tmp=next(tmp)) {
		if(i==sel) {
			possel=tmp;
			SELSELCOLOR;
			trefresh(takescr);
			printline(i,spatiebuf); 
			printline(i,data(tmp)); 
			SELCOLOR;
			trefresh(stdscr);
			}
		else
			printline(i,data(tmp)); 
		if(tmp==endpos||i>=(h-1))
			break;
		}
	endscreen=tmp;
	endscreenpos=i;
	if(sel<0||sel>endscreenpos)			 {
		possel=endscreen;
		sel=endscreenpos;
		showsel();
		}
	}
template <typename I,typename B>
void showlist<I,B>::pagedown(void) {	
		startscreen=endscreen;
		rewrite();
		};
template <typename I,typename B>
void showlist<I,B>::pageup(void) {	
		Pos *tmp=startscreen;
		int endscr=h-1;	
		for(int i=0;i<endscr&&tmp!=startpos;i++)
			tmp=prev(tmp);
		startscreen=tmp;
		rewrite();
		}
template <typename I,typename B>
void showlist<I,B>::down(void) {
	if(possel==endpos) {
		beep();
		showsel();	
		return;
		}
	if(possel!=endscreen)   {
		possel=next(possel);
		sel++;
		showsel();	
		return ;
		}
	else {
		startscreen=next(startscreen);
		rewrite();
		}
	};
template <typename I,typename B>
void showlist<I,B>::up(void) {
	if(possel==startpos) {
		beep(); 
		showsel();
		return;
		}
	if(possel!=startscreen) {
		possel=prev(possel);
		sel--;
		showsel();
		return;
		}
	startscreen=prev(possel);
	rewrite();
	}
template <typename I,typename B>
void showlist<I,B>::end(void) {
	if(possel==endpos) { beep();showsel();return; }
	possel=endpos;
	if(endpos==endscreen) { 
		sel=endscreenpos;
		showsel();
		return; 
		}
	Pos *tmp=endscreen=endpos;
	for(int i=h-2;i>=0;i--) {
		tmp=prev(tmp);
		printline(i,spatiebuf); 
		printline(i,data(tmp)); 
		}
	startscreen=tmp;
	sel=h-1;
	showsel();
	}
template <typename I,typename B>
void showlist<I,B>::start(void) {
	sel=0;
	if(startpos==startscreen) {
		possel=startpos;
		showsel();
		return;
		};
	startscreen=startpos;
	rewrite();
	}
#include "getlabel.h"
#include "main.h"
#include "keylabels.h"
template <typename I,typename B>
typename showlist<I,B>::Pos *showlist<I,B>::selectindex(int key) {
	unshowsel() ;
	switch(key) {
		case RETURN:  return possel;
		case DOWN: down();break;
		case UP: up();break;
		case END: end();break;
		case BEG: start();break;
		case PGDN: pagedown();break;
		case PGUP: pageup();break;
		default: showsel();
		};
	return nullptr;
	}



#include <stdint.h>
extern keyinput inputkeys;

extern void helpwin(void);
template <typename I,typename B>
typename showlist<I,B>::Pos *showlist<I,B>::selectloop(void) {
	if(!takescr)
		return  nullptr;

	trefresh(takescr);
	TITLECOLOR ;
	 mvwaddnstr( takescr,y-1,x-1,spatiebuf,l+2);
	 mvwaddnstr( takescr,y-1,x,prompt,l+1);
	rewrite();	
	while(1){
		wrefresh(takescr);
		int key=ggetch(takescr);
		if(!isprint(key)) {
			while((key=inputkeys.keyseq(key))==-1)
					key=ggetch(takescr);
			switch(key) {
				case -2: beep();continue;
				case HELP:
					helpwin();
					continue;
				case 	QUIT: return nullptr;
				case NOP:continue;
			  };
			}
		switch(key) {
			case	REFRESH: return reinterpret_cast<Pos *>(UINTPTR_MAX);
			default: if(Pos *nameindex=selectindex(key)) {
				return nameindex;
				}
			};
		}
	};
#include "marks.h"
#include "screenpart.h"
struct marklister {
	ScreenPart *part;	
	keylookup *look;
	char *numstr;
	int maxnumstr;
	};
class showmark  {
ScreenPart *part;
char *numstr;
const int bymax;

protected:
using Pos = keylookup::mark;
char *data(Pos *m) {
static constexpr int maxbuf=256;
static char buf[maxbuf];
	int slen=part->bin2search((unsigned char *)m->des, buf, bymax)  ;
	for(int s=minnum(slen,bymax);s<bymax+3;s++)
			buf[s]=' ';
	snprintf(buf+bymax+3,maxbuf-bymax-3,numstr  ,m->pos); 
	return buf;
	};
Pos *next(Pos *m) {
	return m->next;
	};
Pos *prev(Pos *m) {
	return m->prev;
	};
Pos *startpos,*endpos,*startscreen,*endscreen;
	showmark(marklister gegs): part(gegs.part), numstr(gegs.numstr),bymax(MAXMARKALL-3-gegs.maxnumstr),
	startpos(gegs.look->begin.next), endpos(gegs.look->head),startscreen(gegs.look->iter->next) {};
};



#include "editor.h"

#define marx (*marksptr)
#if 0
int Editor::showmarks(void) {
	auto total=marx.gettotal();
	if(total<=0)  {
		output("0 marks, nothing to show");
		return -1;
		}
extern unsigned long long startuptime;

if(backgroundsearch&& (startuptime/total)>30)
	return showmarkswhole();

return showmarksincr();
}
int Editor::showmarksincr(void) {
	auto total=marx.gettotal();
	if(total<=0)  {
		output("0 marks, nothing to show");
		return -1;
		}
		
	const int bufsize=30;
	char buf[bufsize];

if(backgroundsearch)
	output("Background search waits before adding marks during marks viewing");
#ifdef USETHREADS
	sem_wait(&sema);
#endif

	ScreenPart *activepart=parts[mode]->getsubpart();
	showlist<marklister,showmark> shower(total>1?(snprintf(buf,bufsize,"%d marks made",total),buf):"1 mark made",{activepart,marksptr,numstr,maxnumstr});
		
	struct keylookup::mark *mark;
	while((mark=shower.selectloop()) == reinterpret_cast<struct keylookup::mark *>(UINTPTR_MAX)) {
		menuresized();
		wrefresh(editscreen);
		}
	if(mark) {
		mkstandout( mark->pos, mark->len);
		marx.select(mark);
		marx.prev();
		}
#ifdef USETHREADS
sem_post(&sema);
#endif
	editup();
	return 0;
	}
#endif
//total>1?(snprintf(buf,bufsize,"%d marks made",total),buf):"1 mark made"

//int Editor::showmarksincr(void) {

template <> struct keylookup::mark *Editor::markselect<2>(const char *prompt) {
		
if(backgroundsearch)
	output("Background search waits before adding marks during marks viewing");
#ifdef USETHREADS
	sem_wait(&sema);
#endif

	ScreenPart *activepart=parts[mode]->getsubpart();
	showlist<marklister,showmark> shower(prompt,{activepart,marksptr,numstr,maxnumstr});
		
	struct keylookup::mark *mark=nullptr;
	while((mark=shower.selectloop()) == reinterpret_cast<struct keylookup::mark *>(UINTPTR_MAX)) {
		menuresized();
		wrefresh(editscreen);
		}
#ifdef USETHREADS
sem_post(&sema);
#endif
	editup();
	return mark;
	}
//template  struct keylookup::mark *Editor::markselect<1>(const char *prompt) ;
//
template <> struct keylookup::mark * Editor::markselect<0>(const char *prompt) {
#ifdef USETHREADS
	sem_wait(&sema);
#endif
	unsigned int total= marx.gettotal();
#ifdef USETHREADS
sem_post(&sema);
#endif
	if(total<=0)  {
		output("0 marks, nothing to show");
		return  nullptr;
		}

extern unsigned long long showmarkswhole; 
if(backgroundsearch&& (total<showmarkswhole))

	return markselect<1>(prompt);
else
	return markselect<2>(prompt) ;
}

/*
int Editor::showmarkswhole(void) {
	static int size=STARTSHOW;
	static char **names=myallocarpr(char **,char*,STARTSHOW);
	struct keylookup::mark *mark,*first;
	int i,take=0,ant,tot,ret=-1;
	ScreenPart *activepart=parts[mode]->getsubpart();
#ifdef USETHREADS
	sem_wait(&sema);
#endif
	first=marx.next();
	marx.tobegin();
      int aloc=maxnum(((MAXMARKDAT/activepart->bytes)+1)*(activepart->maxres+activepart->apart+1),MAXFILES)+1+sizeof(mark);
	for(i=0;(mark=marx.next());i++) {
		if(first==mark)
			take=i;
		if(i>=size) {
			const int oldsize __attribute__ ((unused)) =size;
			size*=2;
			names=myrealloc(char **,names,char*,size,oldsize);
			}
		names[i]=myallocar(char,aloc);
		int slen=activepart->fromascii((unsigned char*)names[i], (unsigned char *)mark->des,MAXMARKDAT);
		if(slen<MAXMARKDAT)
			for(int s=slen;s<MAXMARKDAT;s++)
				names[i][s]=' ';
		for(int s=MAXMARKDAT;s<(MAXMARKDAT+3);s++)
			names[i][s]=' ';
		snprintf(names[i]+MAXMARKDAT+3,MAXFILES,numstr  ,mark->pos); 
		memcpy(names[i]+MAXFILES+1,((char *)&mark),sizeof(mark));
		}
#ifdef USETHREADS
sem_post(&sema);
#endif
	tot=i;
	int bufsize=30;
	char buf[bufsize];
	snprintf(buf,bufsize,"%d marks made",marx.gettotal());
	while((ant=selectitemindex(buf,names,i,take))!=INT_MAX) {
			if(ant==(INT_MAX-1)) {
				menuresized();
				wrefresh(editscreen);
				}
			else {
				memcpy((char *)&first	,names[ant]+MAXFILES+1,sizeof(first));
				ret=mkstandout( first->pos, first->len);
				goto end;
				break; 
				 }
		}
end:
	marx.select(first);
	marx.prev();
	for(i=0;i<tot;i++)
		myrefree(names[i]);

	editup();
	return ret;
	}

*/
