/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * FormApplet.java
 *
 * Created on 28.02.2009, 12:35:11
 */

package avr8_burn_o_mat;

import java.util.Collections;
import java.util.Vector;

/**
 *
 * @author torsten
 */
public class JPanelApplet extends javax.swing.JPanel implements FusesObserver {

    JPanelFuses m_panelFuses;

    private Vector <AVR> m_avrList;

    private AVR          m_avr;

    
    /** Creates new form FormApplet */
    public JPanelApplet(String appletPath) {
        initComponents();

        m_panelFuses = new JPanelFuses(null);
        add(m_panelFuses, java.awt.BorderLayout.CENTER);

        try {
            readAVRConfig(appletPath + "/AVR8_Burn_O_Mat_Config.xml");
        } catch (Exception e) {
            jLabelStatus.setText("Error while loading program: " + e.getMessage());
        }

        m_panelFuses.getFusesObservable().addObserver(this);
    }

    public void readAVRConfig(String uri) {

        try {

            // for netbeans debuggin
            if (uri.endsWith("/build/AVR8_Burn_O_Mat_Config.xml"))
                uri = uri.substring(0, uri.lastIndexOf("/build/AVR8_Burn_O_Mat_Config.xml")) + "/AVR8_Burn_O_Mat_Config.xml";

            XmlReaderAvrConfig cfg = new XmlReaderAvrConfig();
            cfg.readXmlFile(uri);

            m_avrList = cfg.getAVRList();

        } catch (Exception e) {
            jLabelStatus.setText("Error while reading config: " + e.getMessage());
        }

        UpdateComboBoxAvr();
    }

    private void UpdateComboBoxAvr() {

        Vector <String> items = new Vector <String>();

        for (AVR avr : m_avrList) {
            items.add(avr.getCaption());
        }

        Collections.sort(items);

        jComboBoxAvr.removeAllItems();

        for (String item : items) {
            jComboBoxAvr.addItem(item);
        }

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jComboBoxAvr = new javax.swing.JComboBox();
        jLabel6 = new javax.swing.JLabel();
        jLabelStatus = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jTextFieldFuses = new javax.swing.JTextField();
        jTextFieldCommandLine = new javax.swing.JTextField();

        setLayout(new java.awt.BorderLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPanel1.setPreferredSize(new java.awt.Dimension(626, 70));

        jLabel1.setFont(new java.awt.Font("DejaVu Sans", 3, 18)); // NOI18N
        jLabel1.setText("AVR Burn-O-Mat Fuse Configurator Applet");

        jComboBoxAvr.setMaximumRowCount(10);
        jComboBoxAvr.setMinimumSize(new java.awt.Dimension(150, 24));
        jComboBoxAvr.setPreferredSize(new java.awt.Dimension(150, 24));
        jComboBoxAvr.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jComboBoxAvrItemStateChanged(evt);
            }
        });

        jLabel6.setText("AVR type");

        jLabelStatus.setForeground(new java.awt.Color(255, 0, 0));
        jLabelStatus.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jLabelStatus.setMaximumSize(new java.awt.Dimension(1000, 24));
        jLabelStatus.setMinimumSize(new java.awt.Dimension(100, 24));
        jLabelStatus.setPreferredSize(new java.awt.Dimension(432, 24));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel6)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jComboBoxAvr, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabelStatus, javax.swing.GroupLayout.DEFAULT_SIZE, 428, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel6)
                        .addComponent(jComboBoxAvr, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jLabelStatus, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        add(jPanel1, java.awt.BorderLayout.NORTH);

        jPanel2.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPanel2.setPreferredSize(new java.awt.Dimension(626, 70));

        jLabel2.setText("avrdude command line parameters");

        jLabel3.setText("fuses");

        jTextFieldFuses.setEditable(false);

        jTextFieldCommandLine.setEditable(false);

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTextFieldFuses, javax.swing.GroupLayout.PREFERRED_SIZE, 243, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel3))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTextFieldCommandLine, javax.swing.GroupLayout.DEFAULT_SIZE, 405, Short.MAX_VALUE)
                    .addComponent(jLabel2))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldFuses, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextFieldCommandLine, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        add(jPanel2, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    private void jComboBoxAvrItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jComboBoxAvrItemStateChanged

        String s = (String)jComboBoxAvr.getSelectedItem();

        for (AVR avr : m_avrList) {
            if (avr.getCaption().equals(s)) {
                m_panelFuses.setAVR(avr);
                fusesChanged();
                break;
            }
        }
        
    }//GEN-LAST:event_jComboBoxAvrItemStateChanged

    public void fusesChanged() {

        AVR avr = m_panelFuses.getAVR();

        if (avr == null)
            return;

        String s1 = "";
        String s2 = "";
        
        for (String fuseByte : avr.getUsedFuseBytes()) {
            int data = avr.getFuseByteData(fuseByte);
            s1 += String.format("%s=%02X ", fuseByte, data);
            s2 += String.format("-U %s:w:0x%02X:m ", fuseByte, data);

        }

        jTextFieldFuses.setText(s1);
        jTextFieldCommandLine.setText(s2);
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBoxAvr;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabelStatus;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JTextField jTextFieldCommandLine;
    private javax.swing.JTextField jTextFieldFuses;
    // End of variables declaration//GEN-END:variables

}
