/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.Fuse;
import avr8_burn_o_mat.FusesEditor;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableModelFuses
extends AbstractTableModel {
    private String[] m_columnNames = new String[]{"Name", "programmed", "Description"};
    private Vector<Fuse> m_fuses;
    private Fuse.FuseMode m_fuseMode = Fuse.FuseMode.NORMAL;
    private FusesEditor m_fusesEditor;
    public final int COL_NAME = 0;
    public final int COL_STATE = 1;
    public final int COL_DESC = 2;
    public final int COL_COUNT = 3;

    public TableModelFuses(FusesEditor fusesEditor) {
        this.m_fusesEditor = fusesEditor;
    }

    public void setFuseList(Vector<Fuse> fuses) {
        this.m_fuses = fuses;
        this.fireTableStructureChanged();
    }

    public void fuseListUpdate() {
        this.fireTableStructureChanged();
    }

    public void resetToDefault() {
        if (this.m_fuses == null) {
            return;
        }
        for (Fuse fuse : this.m_fuses) {
            fuse.setFuseState(fuse.getDefaultFuseState());
        }
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 2: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
        }
        assert (false);
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return this.m_columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.m_columnNames[columnIndex];
    }

    @Override
    public int getRowCount() {
        if (this.m_fuses != null) {
            return this.m_fuses.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.m_fuses == null) {
            return new Object();
        }
        switch (columnIndex) {
            case 0: {
                return this.m_fuses.elementAt(rowIndex).getName();
            }
            case 1: {
                return this.m_fuses.elementAt(rowIndex).isProgrammed();
            }
            case 2: {
                return this.m_fuses.elementAt(rowIndex).getDescription();
            }
        }
        assert (false);
        return new Object();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.m_fuses == null) {
            return;
        }
        if (columnIndex == 1) {
            Boolean b = (Boolean)aValue;
            if (b.booleanValue()) {
                this.m_fuses.elementAt(rowIndex).setFuseState(Fuse.FuseState.PROGRAMMED);
            } else {
                this.m_fuses.elementAt(rowIndex).setFuseState(Fuse.FuseState.UNPROGRAMMED);
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
            this.m_fusesEditor.getFusesObservable().fusesChanged(this);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.m_fuses == null) {
            return false;
        }
        if (columnIndex == 1) {
            if (this.m_fuseMode == Fuse.FuseMode.EXPERT) {
                return true;
            }
            return this.m_fuses.elementAt(rowIndex).getFuseMode() == Fuse.FuseMode.NORMAL;
        }
        return false;
    }

    public void setFuseMode(Fuse.FuseMode fuseMode) {
        this.m_fuseMode = fuseMode;
        this.fireTableStructureChanged();
    }

    public boolean isRowEditable(int row) {
        return this.isCellEditable(row, 1);
    }
}

