/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.AVR;
import avr8_burn_o_mat.FusesEditor;
import avr8_burn_o_mat.FusesObserver;
import avr8_burn_o_mat.JPanelFusesHexEditorItem;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;

public class JPanelFusesHexEditor
extends JPanel
implements FusesObserver {
    private AVR m_avr;
    private FusesEditor m_fusesEditor;
    private Vector<JPanelFusesHexEditorItem> m_fuseItems = new Vector();
    private JButton jButtonApply;

    public JPanelFusesHexEditor(FusesEditor fusesEditor) {
        this.initComponents();
        this.m_fusesEditor = fusesEditor;
        this.m_fusesEditor.getFusesObservable().addObserver(this);
    }

    public void fusesChanged() {
        if (this.m_avr == null) {
            return;
        }
        Vector<String> fuseBytes = this.m_avr.getUsedFuseBytes();
        for (int idx = 0; idx < fuseBytes.size(); ++idx) {
            int data = this.m_avr.getFuseByteData(fuseBytes.elementAt(idx));
            this.m_fuseItems.elementAt(idx).setVal(data);
        }
    }

    public void setAVR(AVR avr) {
        this.m_avr = avr;
        for (JPanelFusesHexEditorItem it : this.m_fuseItems) {
            this.remove(it);
        }
        this.m_fuseItems.clear();
        int y = 20;
        Vector<String> fuseBytes = this.m_avr.getUsedFuseBytes();
        for (String fuseByte : fuseBytes) {
            JPanelFusesHexEditorItem item = new JPanelFusesHexEditorItem(fuseByte);
            this.m_fuseItems.add(item);
            this.add(item);
            item.setLocation(10, y);
            item.setSize(item.getPreferredSize());
            y += item.getHeight();
            item.setVisible(true);
        }
        this.jButtonApply.setLocation(10, y + 20);
        this.fusesChanged();
    }

    private void initComponents() {
        this.jButtonApply = new JButton();
        this.setLayout(null);
        this.jButtonApply.setText("apply");
        this.jButtonApply.setPreferredSize(new Dimension(100, 29));
        this.jButtonApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelFusesHexEditor.this.jButtonApplyActionPerformed(evt);
            }
        });
        this.add(this.jButtonApply);
        this.jButtonApply.setBounds(10, 10, 100, 29);
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        if (this.m_avr == null) {
            return;
        }
        for (JPanelFusesHexEditorItem item : this.m_fuseItems) {
            this.m_avr.setFuseByteData(item.getFuseByteName(), item.getVal());
        }
        this.m_fusesEditor.getFusesObservable().fusesChanged(this);
    }
}

