/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.AVR;
import avr8_burn_o_mat.AvrdudeControl;
import avr8_burn_o_mat.CommonObservable;

class ActionThread
implements Runnable {
    Observable m_observable = new Observable();
    private String m_errorMsg = "";
    private Action m_action = Action.IDLE;
    private AvrdudeControl m_avrdudeCtrl;
    private AVR m_avr;
    private String m_filename;
    private AvrdudeControl.FileFormat m_fileFormat;

    public ActionThread(AvrdudeControl avrdudeCtrl) {
        this.m_avrdudeCtrl = avrdudeCtrl;
    }

    public void writeFuses(AVR avr) {
        assert (this.m_action == Action.IDLE);
        this.m_action = Action.WRITE_FUSES;
        this.m_avr = avr;
        this.m_filename = null;
        this.m_fileFormat = null;
        Thread t = new Thread(this);
        t.start();
    }

    public void readFuses(AVR avr) {
        assert (this.m_action == Action.IDLE);
        this.m_action = Action.READ_FUSES;
        this.m_avr = avr;
        this.m_filename = null;
        this.m_fileFormat = null;
        Thread t = new Thread(this);
        t.start();
    }

    public void verifyFuses(AVR avr) {
        assert (this.m_action == Action.IDLE);
        this.m_action = Action.VERIFY_FUSES;
        this.m_avr = avr;
        this.m_filename = null;
        this.m_fileFormat = null;
        Thread t = new Thread(this);
        t.start();
    }

    public void writeFlash(AVR avr, String filename, AvrdudeControl.FileFormat format) {
        assert (this.m_action == Action.IDLE);
        this.m_action = Action.WRITE_FLASH;
        this.m_avr = avr;
        this.m_filename = filename;
        this.m_fileFormat = format;
        Thread t = new Thread(this);
        t.start();
    }

    public void readFlash(AVR avr, String filename, AvrdudeControl.FileFormat format) {
        assert (this.m_action == Action.IDLE);
        this.m_action = Action.READ_FLASH;
        this.m_avr = avr;
        this.m_filename = filename;
        this.m_fileFormat = format;
        Thread t = new Thread(this);
        t.start();
    }

    public void verifyFlash(AVR avr, String filename, AvrdudeControl.FileFormat format) {
        assert (this.m_action == Action.IDLE);
        this.m_action = Action.VERIFY_FLASH;
        this.m_avr = avr;
        this.m_filename = filename;
        this.m_fileFormat = format;
        Thread t = new Thread(this);
        t.start();
    }

    public void writeEEPROM(AVR avr, String filename, AvrdudeControl.FileFormat format) {
        assert (this.m_action == Action.IDLE);
        this.m_action = Action.WRITE_EEPROM;
        this.m_avr = avr;
        this.m_filename = filename;
        this.m_fileFormat = format;
        Thread t = new Thread(this);
        t.start();
    }

    public void readEEPROM(AVR avr, String filename, AvrdudeControl.FileFormat format) {
        assert (this.m_action == Action.IDLE);
        this.m_action = Action.READ_EEPROM;
        this.m_avr = avr;
        this.m_filename = filename;
        this.m_fileFormat = format;
        Thread t = new Thread(this);
        t.start();
    }

    public void verifyEEPROM(AVR avr, String filename, AvrdudeControl.FileFormat format) {
        assert (this.m_action == Action.IDLE);
        this.m_action = Action.VERIFY_EEPROM;
        this.m_avr = avr;
        this.m_filename = filename;
        this.m_fileFormat = format;
        Thread t = new Thread(this);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.m_observable.actionThreadStateChanged(this, this.m_action);
            AvrdudeControl avrdudeControl = this.m_avrdudeCtrl;
            synchronized (avrdudeControl) {
                switch (this.m_action) {
                    case WRITE_FLASH: {
                        this.m_avrdudeCtrl.writeFlash(this.m_avr, this.m_filename, this.m_fileFormat);
                        this.m_action = Action.WRITE_FLASH_DONE;
                        break;
                    }
                    case READ_FLASH: {
                        this.m_avrdudeCtrl.readFlash(this.m_avr, this.m_filename, this.m_fileFormat);
                        this.m_action = Action.READ_FLASH_DONE;
                        break;
                    }
                    case VERIFY_FLASH: {
                        this.m_avrdudeCtrl.verifyFlash(this.m_avr, this.m_filename, this.m_fileFormat);
                        this.m_action = Action.VERIFY_FLASH_DONE;
                        break;
                    }
                    case WRITE_FUSES: {
                        this.m_avrdudeCtrl.writeFuses(this.m_avr);
                        this.m_action = Action.WRITE_FUSES_DONE;
                        break;
                    }
                    case READ_FUSES: {
                        this.m_avrdudeCtrl.readFuses(this.m_avr);
                        this.m_action = Action.READ_FUSES_DONE;
                        break;
                    }
                    case VERIFY_FUSES: {
                        this.m_avrdudeCtrl.verifyFuses(this.m_avr);
                        this.m_action = Action.VERIFY_FUSES_DONE;
                        break;
                    }
                    case WRITE_EEPROM: {
                        this.m_avrdudeCtrl.writeEEPROM(this.m_avr, this.m_filename, this.m_fileFormat);
                        this.m_action = Action.WRITE_EEPROM_DONE;
                        break;
                    }
                    case READ_EEPROM: {
                        this.m_avrdudeCtrl.readEEPROM(this.m_avr, this.m_filename, this.m_fileFormat);
                        this.m_action = Action.READ_EEPROM_DONE;
                        break;
                    }
                    case VERIFY_EEPROM: {
                        this.m_avrdudeCtrl.verifyEEPROM(this.m_avr, this.m_filename, this.m_fileFormat);
                        this.m_action = Action.VERIFY_EEPROM_DONE;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            this.m_observable.actionThreadStateChanged(this, this.m_action);
        }
        catch (Exception e) {
            switch (this.m_action) {
                case WRITE_FLASH: {
                    this.m_action = Action.WRITE_FLASH_ERROR;
                    break;
                }
                case READ_FLASH: {
                    this.m_action = Action.READ_FLASH_ERROR;
                    break;
                }
                case VERIFY_FLASH: {
                    this.m_action = Action.VERIFY_FLASH_ERROR;
                    break;
                }
                case WRITE_FUSES: {
                    this.m_action = Action.WRITE_FUSES_ERROR;
                    break;
                }
                case READ_FUSES: {
                    this.m_action = Action.READ_FUSES_ERROR;
                    break;
                }
                case VERIFY_FUSES: {
                    this.m_action = Action.VERIFY_FUSES_ERROR;
                    break;
                }
                case WRITE_EEPROM: {
                    this.m_action = Action.WRITE_EEPROM_ERROR;
                    break;
                }
                case READ_EEPROM: {
                    this.m_action = Action.READ_EEPROM_ERROR;
                    break;
                }
                case VERIFY_EEPROM: {
                    this.m_action = Action.VERIFY_EEPROM_ERROR;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.m_errorMsg = e.getMessage();
            this.m_observable.actionThreadStateChanged(this, this.m_action);
        }
        this.m_action = Action.IDLE;
        this.m_observable.actionThreadStateChanged(this, this.m_action);
    }

    public String getLastErrorMsg() {
        return this.m_errorMsg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Observable
    extends CommonObservable<Observer> {
        public void actionThreadStateChanged(Object sender, Action newState) {
            for (Observer o : this.m_observerList) {
                if (o == sender) continue;
                o.actionThreadStateChanged(newState);
            }
        }
    }

    public static interface Observer {
        public void actionThreadStateChanged(Action var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        IDLE,
        WRITE_FLASH,
        WRITE_FLASH_DONE,
        WRITE_FLASH_ERROR,
        READ_FLASH,
        READ_FLASH_DONE,
        READ_FLASH_ERROR,
        VERIFY_FLASH,
        VERIFY_FLASH_DONE,
        VERIFY_FLASH_ERROR,
        WRITE_FUSES,
        WRITE_FUSES_DONE,
        WRITE_FUSES_ERROR,
        READ_FUSES,
        READ_FUSES_DONE,
        READ_FUSES_ERROR,
        VERIFY_FUSES,
        VERIFY_FUSES_DONE,
        VERIFY_FUSES_ERROR,
        WRITE_EEPROM,
        WRITE_EEPROM_DONE,
        WRITE_EEPROM_ERROR,
        READ_EEPROM,
        READ_EEPROM_DONE,
        READ_EEPROM_ERROR,
        VERIFY_EEPROM,
        VERIFY_EEPROM_DONE,
        VERIFY_EEPROM_ERROR;

    }
}

