/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.BrownOutDetection;
import avr8_burn_o_mat.Fuse;
import avr8_burn_o_mat.OscillatorOptions;
import avr8_burn_o_mat.XmlUtil;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVR {
    private Vector<Fuse> m_fuseList = new Vector();
    private String m_name;
    private String m_caption;
    private BrownOutDetection m_brownOutDetection;
    private OscillatorOptions m_oscillatorOptions;

    public AVR() {
    }

    public AVR(String name, String caption) {
        this.m_name = name;
        this.m_caption = caption;
    }

    public String getName() {
        return this.m_name;
    }

    public String getCaption() {
        return this.m_caption;
    }

    public void setFuseList(Vector<Fuse> fuseList) {
        this.m_fuseList = fuseList;
    }

    public Vector<Fuse> getFuseList() {
        return this.m_fuseList;
    }

    public boolean hasFuseByte(String fuseByte) {
        for (Fuse fuse : this.m_fuseList) {
            if (!fuseByte.equals(fuse.getFuseByte())) continue;
            return true;
        }
        return false;
    }

    public Vector<String> getUsedFuseBytes() {
        Vector<String> fuseBytes = new Vector<String>();
        for (Fuse fuse : this.m_fuseList) {
            boolean fuseIsAlreadyInList = false;
            for (String b : fuseBytes) {
                if (!b.equals(fuse.getFuseByte())) continue;
                fuseIsAlreadyInList = true;
                break;
            }
            if (fuseIsAlreadyInList) continue;
            fuseBytes.add(fuse.getFuseByte());
        }
        return fuseBytes;
    }

    public int getFuseByteData(String fuseByte) {
        int data = 0;
        for (Fuse fuse : this.m_fuseList) {
            if (!fuseByte.equals(fuse.getFuseByte()) || fuse.isProgrammed().booleanValue()) continue;
            data |= 1 << fuse.getBitNumber();
        }
        return data;
    }

    public void setFuseByteData(String fuseByte, int data) {
        for (Fuse fuse : this.m_fuseList) {
            if (!fuseByte.equals(fuse.getFuseByte())) continue;
            if ((data & 1 << fuse.getBitNumber()) == 0) {
                fuse.setFuseState(Fuse.FuseState.PROGRAMMED);
                continue;
            }
            fuse.setFuseState(Fuse.FuseState.UNPROGRAMMED);
        }
    }

    public void loadFromXml(Node nodeAvr) throws Exception {
        this.m_brownOutDetection = null;
        this.m_oscillatorOptions = null;
        this.m_fuseList.clear();
        this.m_name = XmlUtil.getAttr(nodeAvr, "name");
        this.m_caption = XmlUtil.getAttr(nodeAvr, "caption");
        for (Node nodeFuse = nodeAvr.getFirstChild(); nodeFuse != null; nodeFuse = nodeFuse.getNextSibling()) {
            if (!nodeFuse.getNodeName().equals("Fuse")) continue;
            Fuse fuse = new Fuse();
            fuse.loadFromXml(nodeFuse);
            this.m_fuseList.add(fuse);
        }
        for (Node nodeBod = nodeAvr.getFirstChild(); nodeBod != null; nodeBod = nodeBod.getNextSibling()) {
            if (!nodeBod.getNodeName().equals("BrownOutDetection")) continue;
            this.m_brownOutDetection = BrownOutDetection.createFromXmlNode(this.m_fuseList, nodeBod);
            break;
        }
        for (Node nodeOsciOpt = nodeAvr.getFirstChild(); nodeOsciOpt != null; nodeOsciOpt = nodeOsciOpt.getNextSibling()) {
            if (!nodeOsciOpt.getNodeName().equals("OscillatorOptions")) continue;
            this.m_oscillatorOptions = OscillatorOptions.createFromXmlNode(this.m_fuseList, nodeOsciOpt);
            break;
        }
    }

    public void saveFusesStateToXml(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element elem = doc.createElement("AVR");
        elem.setAttribute("name", this.m_name);
        elem.setAttribute("caption", this.m_caption);
        doc.appendChild(elem);
        for (Fuse fuse : this.m_fuseList) {
            fuse.saveStateToXml(doc, elem);
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new DOMSource(doc), new StreamResult(new FileWriter(file)));
    }

    public void loadFusesStateFromXml(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(file);
        Element nodeAvr = document.getDocumentElement();
        if (nodeAvr == null || !nodeAvr.getNodeName().equals("AVR")) {
            throw new Exception("missing root node AVR");
        }
        block0: for (Node nodeFuse = nodeAvr.getFirstChild(); nodeFuse != null; nodeFuse = nodeFuse.getNextSibling()) {
            if (!nodeFuse.getNodeName().equals("Fuse")) continue;
            String name = XmlUtil.getAttr(nodeFuse, "name");
            for (Fuse f : this.m_fuseList) {
                if (!f.getName().equals(name)) continue;
                f.loadStateFromXml(nodeFuse);
                continue block0;
            }
        }
    }

    public BrownOutDetection getBrownOutDetection() {
        return this.m_brownOutDetection;
    }

    public OscillatorOptions getOscillatorOptions() {
        return this.m_oscillatorOptions;
    }
}

