/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceScrollButton;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.ControlBackgroundComposite;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.RolloverControlListener;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.Trackable;

public class SubstanceScrollBarUI
extends BasicScrollBarUI
implements Trackable {
    protected Set lafWidgets;
    protected JButton mySecondDecreaseButton;
    protected JButton mySecondIncreaseButton;
    private ButtonModel thumbModel = new DefaultButtonModel();
    private static Map<String, BufferedImage> thumbVerticalMap = new HashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> thumbHorizontalMap = new HashMap<String, BufferedImage>();
    private MouseListener substanceMouseListener;
    private RolloverControlListener substanceThumbRolloverListener;
    private PropertyChangeListener substancePropertyListener;
    protected int scrollBarWidth;
    private static Map<String, BufferedImage> trackHorizontalMap = new HashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> trackVerticalMap = new HashMap<String, BufferedImage>();
    protected MouseListener substanceDebugUiListener;

    public void __org__jvnet__substance__SubstanceScrollBarUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Object object = jComponent.getClientProperty("lafwidgets.layout.alpha");
        if (object instanceof Float) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, ((Float)object).floatValue()));
        }
        this.__org__jvnet__substance__SubstanceScrollBarUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
    }

    public void installComponents() {
        this.__org__jvnet__substance__SubstanceScrollBarUI__installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__jvnet__substance__SubstanceScrollBarUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceScrollBarUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceScrollBarUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceScrollBarUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__SubstanceScrollBarUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceScrollBarUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallComponents() {
        this.__org__jvnet__substance__SubstanceScrollBarUI__uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceScrollBarUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceScrollBarUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceScrollBarUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static synchronized void reset() {
        thumbHorizontalMap.clear();
        thumbVerticalMap.clear();
    }

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceScrollBarUI(b);
    }

    private SubstanceScrollBarUI(JComponent b) {
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
    }

    protected JButton createGeneralDecreaseButton(int orientation, boolean isRegular) {
        int width = this.scrollBarWidth / 2;
        if (width % 2 == 0) {
            ++width;
        }
        int height = (int)(0.4 * (double)this.scrollBarWidth);
        Icon icon = SubstanceImageCreator.getArrowIcon(width + 2, height, orientation, SubstanceCoreUtilities.getActiveTheme(this.scrollbar, true));
        SubstanceScrollButton result = new SubstanceScrollButton(icon, orientation);
        result.setPreferredSize(new Dimension(this.scrollBarWidth, this.scrollBarWidth));
        this.synchDecreaseButtonTheme(result, isRegular);
        HashSet<SubstanceConstants.Side> openSides = new HashSet<SubstanceConstants.Side>();
        switch (orientation) {
            case 1: {
                openSides.add(SubstanceConstants.Side.BOTTOM);
                if (isRegular) break;
                openSides.add(SubstanceConstants.Side.TOP);
                break;
            }
            case 3: {
                openSides.add(SubstanceConstants.Side.LEFT);
                if (isRegular) break;
                openSides.add(SubstanceConstants.Side.RIGHT);
                break;
            }
            case 7: {
                openSides.add(SubstanceConstants.Side.RIGHT);
                if (isRegular) break;
                openSides.add(SubstanceConstants.Side.LEFT);
            }
        }
        result.putClientProperty("substancelaf.buttonopenSide", openSides);
        return result;
    }

    protected JButton createDecreaseButton(int orientation) {
        return this.createGeneralDecreaseButton(orientation, true);
    }

    private void synchDecreaseButtonTheme(JButton button, boolean isRegular) {
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(this.scrollbar, true);
        if (this.scrollbar.getOrientation() == 1) {
            if (isRegular) {
                button.putClientProperty("substancelaf.theme", theme.getSecondTheme());
            } else {
                button.putClientProperty("substancelaf.theme", theme.getFirstTheme());
            }
        } else if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
            if (isRegular) {
                button.putClientProperty("substancelaf.theme", theme.getFirstTheme());
            } else {
                button.putClientProperty("substancelaf.theme", theme.getSecondTheme());
            }
        } else if (isRegular) {
            button.putClientProperty("substancelaf.theme", theme.getSecondTheme());
        } else {
            button.putClientProperty("substancelaf.theme", theme.getFirstTheme());
        }
    }

    protected JButton createIncreaseButton(int orientation) {
        return this.createGeneralIncreaseButton(orientation, true);
    }

    protected JButton createGeneralIncreaseButton(int orientation, boolean isRegular) {
        int width = this.scrollBarWidth / 2;
        if (width % 2 == 0) {
            ++width;
        }
        int height = (int)(0.4 * (double)this.scrollBarWidth);
        Icon icon = SubstanceImageCreator.getArrowIcon(width + 2, height, orientation, SubstanceCoreUtilities.getActiveTheme(this.scrollbar, true));
        SubstanceScrollButton result = new SubstanceScrollButton(icon, orientation);
        result.setPreferredSize(new Dimension(this.scrollBarWidth, this.scrollBarWidth));
        this.synchIncreaseButtonTheme(result, isRegular);
        HashSet<SubstanceConstants.Side> openSides = new HashSet<SubstanceConstants.Side>();
        switch (orientation) {
            case 5: {
                openSides.add(SubstanceConstants.Side.TOP);
                if (isRegular) break;
                openSides.add(SubstanceConstants.Side.BOTTOM);
                break;
            }
            case 3: {
                openSides.add(SubstanceConstants.Side.LEFT);
                if (isRegular) break;
                openSides.add(SubstanceConstants.Side.RIGHT);
                break;
            }
            case 7: {
                openSides.add(SubstanceConstants.Side.RIGHT);
                if (isRegular) break;
                openSides.add(SubstanceConstants.Side.LEFT);
            }
        }
        result.putClientProperty("substancelaf.buttonopenSide", openSides);
        return result;
    }

    private void synchIncreaseButtonTheme(JButton button, boolean isRegular) {
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(this.scrollbar, true);
        if (this.scrollbar.getOrientation() == 1) {
            if (isRegular) {
                button.putClientProperty("substancelaf.theme", theme.getFirstTheme());
            } else {
                button.putClientProperty("substancelaf.theme", theme.getSecondTheme());
            }
        } else if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
            if (isRegular) {
                button.putClientProperty("substancelaf.theme", theme.getSecondTheme());
            } else {
                button.putClientProperty("substancelaf.theme", theme.getFirstTheme());
            }
        } else if (isRegular) {
            button.putClientProperty("substancelaf.theme", theme.getFirstTheme());
        } else {
            button.putClientProperty("substancelaf.theme", theme.getSecondTheme());
        }
    }

    private static synchronized BufferedImage getTrackHorizontal(JScrollBar scrollBar, Rectangle trackBounds, ComponentState compLeftState, ComponentState compRightState) {
        int width = Math.max(1, trackBounds.width);
        int height = Math.max(1, trackBounds.height);
        SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        String key = SubstanceCoreUtilities.getTheme(scrollBar, true).getDisplayName() + ":" + width + "*" + height + ":" + (compLeftState == null ? "null" : compLeftState.name()) + ":" + (compRightState == null ? "null" : compRightState.name()) + ":" + shaper.getDisplayName();
        BufferedImage result = trackHorizontalMap.get(key);
        if (result == null) {
            int radius = height / 2;
            if (shaper instanceof ClassicButtonShaper) {
                radius = 2;
            }
            result = SubstanceImageCreator.getCompositeRoundedBackground(scrollBar, width, height, radius, compLeftState, compRightState, false);
            trackHorizontalMap.put(key, result);
        }
        return result;
    }

    private static synchronized BufferedImage getTrackVertical(JScrollBar scrollBar, Rectangle trackBounds, ComponentState compTopState, ComponentState compBottomState) {
        int width = Math.max(1, trackBounds.width);
        int height = Math.max(1, trackBounds.height);
        SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        String key = SubstanceCoreUtilities.getTheme(scrollBar, true).getDisplayName() + ":" + width + "*" + height + ":" + (compTopState == null ? "null" : compTopState.name()) + ":" + (compBottomState == null ? "null" : compBottomState.name()) + ":" + shaper.getDisplayName();
        BufferedImage result = trackVerticalMap.get(key);
        if (result == null) {
            int radius = width / 2;
            if (shaper instanceof ClassicButtonShaper) {
                radius = 2;
            }
            result = SubstanceImageCreator.getRotated(SubstanceImageCreator.getCompositeRoundedBackground(scrollBar, height, width, radius, compTopState, compBottomState, true), 3);
            trackVerticalMap.put(key, result);
        }
        return result;
    }

    private static synchronized BufferedImage getThumbVertical(JScrollBar scrollBar, Rectangle thumbBounds, ButtonModel buttonModel) {
        ColorScheme colorScheme;
        int width = Math.max(1, thumbBounds.width);
        int height = Math.max(1, thumbBounds.height);
        ComponentState state = ComponentState.getState(buttonModel, null);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        kind = ComponentState.ColorSchemeKind.CURRENT;
        float cyclePos = state.getCycleCount();
        ColorScheme colorScheme2 = colorScheme = SubstanceCoreUtilities.getComponentTheme(scrollBar, kind).getColorScheme();
        FadeTracker fadeTracker = FadeTracker.getInstance();
        if (fadeTracker.isTracked(scrollBar, FadeTracker.FadeKind.ROLLOVER)) {
            ColorScheme defaultScheme = SubstanceCoreUtilities.getActiveScheme(scrollBar);
            if (state == ComponentState.DEFAULT) {
                colorScheme = SubstanceCoreUtilities.getActiveScheme(scrollBar);
                colorScheme2 = defaultScheme;
                cyclePos = 10.0f - fadeTracker.getFade10(scrollBar, FadeTracker.FadeKind.ROLLOVER);
            }
            if (state == ComponentState.ROLLOVER_UNSELECTED) {
                colorScheme2 = colorScheme;
                colorScheme = defaultScheme;
                cyclePos = fadeTracker.getFade10(scrollBar, FadeTracker.FadeKind.ROLLOVER);
            }
        }
        SubstanceGradientPainter painter = SubstanceLookAndFeel.getCurrentGradientPainter();
        SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        String key = width + ":" + height + ":" + kind.name() + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + ":" + cyclePos + ":" + painter.getDisplayName() + ":" + shaper.getDisplayName();
        BufferedImage result = thumbVerticalMap.get(key);
        if (result == null) {
            int radius = width / 2;
            if (shaper instanceof ClassicButtonShaper) {
                radius = 2;
            }
            GeneralPath contour = BaseButtonShaper.getBaseOutline(height, width, radius, null);
            result = painter.getContourBackground(height, width, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            result = SubstanceImageCreator.getRotated(result, 3);
            thumbVerticalMap.put(key, result);
        }
        return result;
    }

    private static synchronized BufferedImage getThumbHorizontal(JScrollBar scrollBar, Rectangle thumbBounds, ButtonModel buttonModel) {
        ColorScheme colorScheme;
        int width = Math.max(1, thumbBounds.width);
        int height = Math.max(1, thumbBounds.height);
        ComponentState state = ComponentState.getState(buttonModel, null);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        kind = ComponentState.ColorSchemeKind.CURRENT;
        float cyclePos = state.getCycleCount();
        ColorScheme colorScheme2 = colorScheme = SubstanceCoreUtilities.getComponentTheme(scrollBar, kind).getColorScheme();
        FadeTracker fadeTracker = FadeTracker.getInstance();
        if (fadeTracker.isTracked(scrollBar, FadeTracker.FadeKind.ROLLOVER)) {
            ColorScheme defaultScheme = SubstanceCoreUtilities.getActiveScheme(scrollBar);
            if (state == ComponentState.DEFAULT) {
                colorScheme = SubstanceCoreUtilities.getActiveScheme(scrollBar);
                colorScheme2 = defaultScheme;
                cyclePos = 10.0f - fadeTracker.getFade10(scrollBar, FadeTracker.FadeKind.ROLLOVER);
            }
            if (state == ComponentState.ROLLOVER_UNSELECTED) {
                colorScheme2 = colorScheme;
                colorScheme = defaultScheme;
                cyclePos = fadeTracker.getFade10(scrollBar, FadeTracker.FadeKind.ROLLOVER);
            }
        }
        SubstanceGradientPainter painter = SubstanceLookAndFeel.getCurrentGradientPainter();
        SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        String key = width + ":" + height + ":" + kind.name() + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + ":" + cyclePos + ":" + painter.getDisplayName() + ":" + shaper.getDisplayName();
        BufferedImage result = thumbHorizontalMap.get(key);
        if (result == null) {
            int radius = height / 2;
            if (shaper instanceof ClassicButtonShaper) {
                radius = 2;
            }
            GeneralPath contour = BaseButtonShaper.getBaseOutline(width, height, radius, null);
            result = painter.getContourBackground(width, height, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            thumbHorizontalMap.put(key, result);
        }
        return result;
    }

    protected ComponentState getState(JButton scrollButton) {
        ComponentState result = ComponentState.getState(scrollButton.getModel(), scrollButton);
        if (result == ComponentState.DEFAULT && SubstanceCoreUtilities.hasFlatProperty(this.scrollbar)) {
            result = null;
        }
        if (SubstanceCoreUtilities.isButtonNeverPainted(scrollButton)) {
            result = null;
        }
        return result;
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        if (!c.isEnabled()) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        SubstanceConstants.ScrollPaneButtonPolicyKind buttonPolicy = SubstanceCoreUtilities.getScrollPaneButtonsPolicyKind(this.scrollbar);
        ComponentState compTopState = ComponentState.DEFAULT;
        ComponentState compBottomState = ComponentState.DEFAULT;
        if (this.decrButton.isShowing() && this.incrButton.isShowing() && this.mySecondDecreaseButton.isShowing() && this.mySecondIncreaseButton.isShowing()) {
            switch (buttonPolicy) {
                case OPPOSITE: {
                    compTopState = this.getState(this.decrButton);
                    compBottomState = this.getState(this.incrButton);
                    break;
                }
                case ADJACENT: {
                    compBottomState = this.getState(this.mySecondDecreaseButton);
                    break;
                }
                case MULTIPLE: {
                    compTopState = this.getState(this.decrButton);
                    compBottomState = this.getState(this.mySecondDecreaseButton);
                    break;
                }
                case MULTIPLE_BOTH: {
                    compTopState = this.getState(this.mySecondIncreaseButton);
                    compBottomState = this.getState(this.mySecondDecreaseButton);
                }
            }
        }
        ControlBackgroundComposite composite = SubstanceCoreUtilities.getControlBackgroundComposite(this.scrollbar);
        if (this.scrollbar.getOrientation() == 1) {
            BufferedImage bi = SubstanceScrollBarUI.getTrackVertical(this.scrollbar, trackBounds, compTopState, compBottomState);
            BufferedImage result = SubstanceCoreUtilities.getBlankImage(bi.getWidth(), bi.getHeight());
            Graphics2D resultGr = result.createGraphics();
            resultGr.setComposite(composite.getBackgroundComposite(this.scrollbar, this.scrollbar.getParent(), -1, false));
            resultGr.drawImage((Image)bi, 0, 0, null);
            graphics.drawImage((Image)result, trackBounds.x, trackBounds.y, null);
            resultGr.dispose();
        } else {
            BufferedImage bi = this.scrollbar.getComponentOrientation().isLeftToRight() ? SubstanceScrollBarUI.getTrackHorizontal(this.scrollbar, trackBounds, compTopState, compBottomState) : SubstanceScrollBarUI.getTrackHorizontal(this.scrollbar, trackBounds, compBottomState, compTopState);
            BufferedImage result = SubstanceCoreUtilities.getBlankImage(bi.getWidth(), bi.getHeight());
            Graphics2D resultGr = result.createGraphics();
            resultGr.setComposite(composite.getBackgroundComposite(this.scrollbar, this.scrollbar.getParent(), -1, false));
            resultGr.drawImage((Image)bi, 0, 0, null);
            graphics.drawImage((Image)result, trackBounds.x, trackBounds.y, null);
            resultGr.dispose();
        }
        graphics.dispose();
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        boolean isVertical;
        if (!c.isEnabled()) {
            return;
        }
        JScrollBar scrollBar = (JScrollBar)c;
        this.thumbModel.setSelected(this.thumbModel.isSelected() || this.isDragging);
        boolean bl = isVertical = this.scrollbar.getOrientation() == 1;
        if (isVertical) {
            Rectangle adjustedBounds = new Rectangle(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
            BufferedImage thumbImage = SubstanceScrollBarUI.getThumbVertical(scrollBar, adjustedBounds, this.thumbModel);
            g.drawImage(thumbImage, adjustedBounds.x, adjustedBounds.y, null);
        } else {
            Rectangle adjustedBounds = new Rectangle(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
            BufferedImage thumbImage = SubstanceScrollBarUI.getThumbHorizontal(scrollBar, adjustedBounds, this.thumbModel);
            g.drawImage(thumbImage, adjustedBounds.x, adjustedBounds.y, null);
        }
    }

    public void paint(Graphics g, JComponent c) {
        g.setColor(this.scrollbar.getBackground());
        g.fillRect(c.getX(), c.getY(), c.getWidth(), c.getHeight());
        super.paint(g, c);
    }

    protected void __org__jvnet__substance__SubstanceScrollBarUI__installDefaults() {
        this.scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
        super.installDefaults();
    }

    protected void __org__jvnet__substance__SubstanceScrollBarUI__installComponents() {
        super.installComponents();
        switch (this.scrollbar.getOrientation()) {
            case 1: {
                this.mySecondDecreaseButton = this.createGeneralDecreaseButton(1, false);
                this.mySecondIncreaseButton = this.createGeneralIncreaseButton(5, false);
                this.synchDecreaseButtonTheme(this.mySecondDecreaseButton, false);
                this.synchIncreaseButtonTheme(this.mySecondIncreaseButton, false);
                break;
            }
            case 0: {
                if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    this.mySecondDecreaseButton = this.createGeneralDecreaseButton(7, false);
                    this.mySecondIncreaseButton = this.createGeneralIncreaseButton(3, false);
                    this.synchDecreaseButtonTheme(this.mySecondDecreaseButton, false);
                    this.synchIncreaseButtonTheme(this.mySecondIncreaseButton, false);
                    break;
                }
                this.mySecondDecreaseButton = this.createGeneralDecreaseButton(3, false);
                this.mySecondIncreaseButton = this.createGeneralIncreaseButton(7, false);
                this.synchDecreaseButtonTheme(this.mySecondDecreaseButton, false);
                this.synchIncreaseButtonTheme(this.mySecondIncreaseButton, false);
            }
        }
        this.scrollbar.add(this.mySecondDecreaseButton);
        this.scrollbar.add(this.mySecondIncreaseButton);
    }

    protected void __org__jvnet__substance__SubstanceScrollBarUI__uninstallComponents() {
        this.scrollbar.remove(this.mySecondDecreaseButton);
        this.scrollbar.remove(this.mySecondIncreaseButton);
        super.uninstallComponents();
    }

    protected void __org__jvnet__substance__SubstanceScrollBarUI__installListeners() {
        super.installListeners();
        this.substanceMouseListener = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }

            public void mouseExited(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }

            public void mousePressed(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }
        };
        this.incrButton.addMouseListener(this.substanceMouseListener);
        this.decrButton.addMouseListener(this.substanceMouseListener);
        this.mySecondDecreaseButton.addMouseListener(this.substanceMouseListener);
        this.mySecondIncreaseButton.addMouseListener(this.substanceMouseListener);
        this.substanceThumbRolloverListener = new RolloverControlListener(this, this.thumbModel);
        this.scrollbar.addMouseListener(this.substanceThumbRolloverListener);
        this.scrollbar.addMouseMotionListener(this.substanceThumbRolloverListener);
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("substancelaf.theme".equals(evt.getPropertyName())) {
                    SubstanceScrollBarUI.this.synchDecreaseButtonTheme(SubstanceScrollBarUI.this.decrButton, true);
                    SubstanceScrollBarUI.this.synchDecreaseButtonTheme(SubstanceScrollBarUI.this.mySecondDecreaseButton, false);
                    SubstanceScrollBarUI.this.synchIncreaseButtonTheme(SubstanceScrollBarUI.this.incrButton, true);
                    SubstanceScrollBarUI.this.synchIncreaseButtonTheme(SubstanceScrollBarUI.this.mySecondIncreaseButton, true);
                    return;
                }
            }
        };
        this.scrollbar.addPropertyChangeListener(this.substancePropertyListener);
        this.mySecondDecreaseButton.addMouseListener(this.buttonListener);
        this.mySecondIncreaseButton.addMouseListener(this.buttonListener);
        if (SubstanceLookAndFeel.isDebugUiMode()) {
            this.substanceDebugUiListener = new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    this.process(e);
                }

                public void mouseReleased(MouseEvent e) {
                    this.process(e);
                }

                protected void process(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        JPopupMenu popup = new JPopupMenu();
                        JMenuItem policyNone = new JMenuItem("Empty policy");
                        policyNone.addActionListener(new PolicyChanger(SubstanceConstants.ScrollPaneButtonPolicyKind.NONE));
                        popup.add(policyNone);
                        JMenuItem policyOpposite = new JMenuItem("Opposite policy");
                        policyOpposite.addActionListener(new PolicyChanger(SubstanceConstants.ScrollPaneButtonPolicyKind.OPPOSITE));
                        popup.add(policyOpposite);
                        JMenuItem policyAdjacent = new JMenuItem("Adjacent policy");
                        policyAdjacent.addActionListener(new PolicyChanger(SubstanceConstants.ScrollPaneButtonPolicyKind.ADJACENT));
                        popup.add(policyAdjacent);
                        JMenuItem policyMultiple = new JMenuItem("Multiple policy");
                        policyMultiple.addActionListener(new PolicyChanger(SubstanceConstants.ScrollPaneButtonPolicyKind.MULTIPLE));
                        popup.add(policyMultiple);
                        JMenuItem policyMultipleBoth = new JMenuItem("Multiple both policy");
                        policyMultipleBoth.addActionListener(new PolicyChanger(SubstanceConstants.ScrollPaneButtonPolicyKind.MULTIPLE_BOTH));
                        popup.add(policyMultipleBoth);
                        popup.show(SubstanceScrollBarUI.this.scrollbar, e.getX(), e.getY());
                    }
                }
            };
            this.scrollbar.addMouseListener(this.substanceDebugUiListener);
        }
    }

    protected void __org__jvnet__substance__SubstanceScrollBarUI__uninstallListeners() {
        this.incrButton.removeMouseListener(this.substanceMouseListener);
        this.decrButton.removeMouseListener(this.substanceMouseListener);
        this.mySecondDecreaseButton.removeMouseListener(this.substanceMouseListener);
        this.mySecondIncreaseButton.removeMouseListener(this.substanceMouseListener);
        this.substanceMouseListener = null;
        this.scrollbar.removeMouseListener(this.substanceThumbRolloverListener);
        this.scrollbar.removeMouseMotionListener(this.substanceThumbRolloverListener);
        this.substanceThumbRolloverListener = null;
        this.scrollbar.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.mySecondDecreaseButton.removeMouseListener(this.buttonListener);
        this.mySecondIncreaseButton.removeMouseListener(this.buttonListener);
        if (this.substanceDebugUiListener != null) {
            this.scrollbar.removeMouseListener(this.substanceDebugUiListener);
            this.substanceDebugUiListener = null;
        }
        super.uninstallListeners();
    }

    public boolean isInside(MouseEvent me) {
        Rectangle thumbB = this.getThumbBounds();
        if (thumbB == null) {
            return false;
        }
        return thumbB.contains(me.getX(), me.getY());
    }

    public void scrollByBlock(int direction) {
        int oldValue = this.scrollbar.getValue();
        int blockIncrement = this.scrollbar.getBlockIncrement(direction);
        int delta = blockIncrement * (direction > 0 ? 1 : -1);
        int newValue = oldValue + delta;
        if (delta > 0 && newValue < oldValue) {
            newValue = this.scrollbar.getMaximum();
        } else if (delta < 0 && newValue > oldValue) {
            newValue = this.scrollbar.getMinimum();
        }
        this.scrollbar.setValue(newValue);
    }

    public void scrollByUnits(int direction, int units) {
        for (int i = 0; i < units; ++i) {
            int delta = direction > 0 ? this.scrollbar.getUnitIncrement(direction) : -this.scrollbar.getUnitIncrement(direction);
            int oldValue = this.scrollbar.getValue();
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = this.scrollbar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = this.scrollbar.getMinimum();
            }
            if (oldValue == newValue) break;
            this.scrollbar.setValue(newValue);
        }
    }

    protected void layoutVScrollbar(JScrollBar sb) {
        SubstanceConstants.ScrollPaneButtonPolicyKind buttonPolicy = SubstanceCoreUtilities.getScrollPaneButtonsPolicyKind(this.scrollbar);
        this.mySecondDecreaseButton.setBounds(0, 0, 0, 0);
        switch (buttonPolicy) {
            case OPPOSITE: {
                super.layoutVScrollbar(sb);
                break;
            }
            case NONE: {
                this.layoutVScrollbarNone(sb);
                break;
            }
            case ADJACENT: {
                this.layoutVScrollbarAdjacent(sb);
                break;
            }
            case MULTIPLE: {
                this.layoutVScrollbarMultiple(sb);
                break;
            }
            case MULTIPLE_BOTH: {
                this.layoutVScrollbarMultipleBoth(sb);
            }
        }
    }

    protected void layoutHScrollbar(JScrollBar sb) {
        this.mySecondDecreaseButton.setBounds(0, 0, 0, 0);
        SubstanceConstants.ScrollPaneButtonPolicyKind buttonPolicy = SubstanceCoreUtilities.getScrollPaneButtonsPolicyKind(this.scrollbar);
        switch (buttonPolicy) {
            case OPPOSITE: {
                super.layoutHScrollbar(sb);
                break;
            }
            case NONE: {
                this.layoutHScrollbarNone(sb);
                break;
            }
            case ADJACENT: {
                this.layoutHScrollbarAdjacent(sb);
                break;
            }
            case MULTIPLE: {
                this.layoutHScrollbarMultiple(sb);
                break;
            }
            case MULTIPLE_BOTH: {
                this.layoutHScrollbarMultipleBoth(sb);
            }
        }
    }

    protected void layoutVScrollbarAdjacent(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int incrButtonH = itemW;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        int decrButton2H = itemW;
        int decrButton2Y = incrButtonY - decrButton2H;
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButton2H + incrButtonH;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = decrButton2Y - thumbH;
        if (value < (float)(sb.getMaximum() - sb.getVisibleAmount())) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            incrButtonH = decrButton2H = sbAvailButtonH / 2;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        this.decrButton.setBounds(0, 0, 0, 0);
        this.mySecondDecreaseButton.setBounds(itemX, incrButtonY - decrButton2H, itemW, decrButton2H);
        this.incrButton.setBounds(itemX, incrButtonY, itemW, incrButtonH);
        int itrackY = 0;
        int itrackH = decrButton2Y - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > decrButton2Y) {
                thumbY = decrButton2Y - thumbH;
            }
            if (thumbY < 0) {
                thumbY = 0;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void layoutVScrollbarNone(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int incrButtonH = 0;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        int decrButton2H = 0;
        int decrButton2Y = incrButtonY - decrButton2H;
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButton2H + incrButtonH;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = decrButton2Y - thumbH;
        if (value < (float)(sb.getMaximum() - sb.getVisibleAmount())) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            decrButton2H = 0;
            incrButtonH = 0;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.decrButton.setBounds(0, 0, 0, 0);
        this.mySecondDecreaseButton.setBounds(0, 0, 0, 0);
        this.incrButton.setBounds(0, 0, 0, 0);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        int itrackY = 0;
        int itrackH = decrButton2Y - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > decrButton2Y) {
                thumbY = decrButton2Y - thumbH;
            }
            if (thumbY < 0) {
                thumbY = 0;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void layoutVScrollbarMultiple(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int incrButtonH = itemW;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        int decrButton2H = itemW;
        int decrButton2Y = incrButtonY - decrButton2H;
        int decrButtonH = itemW;
        int decrButtonY = sbInsets.top;
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButton2H + incrButtonH + decrButtonH;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = decrButton2Y - thumbH;
        if (value < (float)(sb.getMaximum() - sb.getVisibleAmount())) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbY += decrButtonY + decrButtonH;
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            decrButton2H = decrButtonH = sbAvailButtonH / 2;
            incrButtonH = decrButtonH;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.decrButton.setBounds(itemX, decrButtonY, itemW, decrButtonH);
        this.mySecondDecreaseButton.setBounds(itemX, incrButtonY - decrButton2H, itemW, decrButton2H);
        this.incrButton.setBounds(itemX, incrButtonY, itemW, incrButtonH);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        int itrackY = decrButtonY + decrButtonH;
        int itrackH = decrButton2Y - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > decrButton2Y) {
                thumbY = decrButton2Y - thumbH;
            }
            if (thumbY < decrButtonY + decrButtonH) {
                thumbY = decrButtonY + decrButtonH + 1;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void layoutVScrollbarMultipleBoth(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int incrButtonH = itemW;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        int decrButton2H = itemW;
        int decrButton2Y = incrButtonY - decrButton2H;
        int decrButtonH = itemW;
        int decrButtonY = sbInsets.top;
        int incrButton2H = itemW;
        int incrButton2Y = decrButtonY + decrButtonH;
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButton2H + incrButtonH + decrButtonH + incrButton2H;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = decrButton2Y - thumbH;
        if (value < (float)(sb.getMaximum() - sb.getVisibleAmount())) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbY += incrButton2Y + incrButton2H;
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            decrButtonH = incrButton2H = sbAvailButtonH / 4;
            decrButton2H = incrButton2H;
            incrButtonH = incrButton2H;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.decrButton.setBounds(itemX, decrButtonY, itemW, decrButtonH);
        this.mySecondDecreaseButton.setBounds(itemX, incrButtonY - decrButton2H, itemW, decrButton2H);
        this.incrButton.setBounds(itemX, incrButtonY, itemW, incrButtonH);
        this.mySecondIncreaseButton.setBounds(itemX, decrButtonY + decrButtonH, itemW, incrButton2H);
        int itrackY = incrButton2Y + incrButton2H;
        int itrackH = decrButton2Y - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > decrButton2Y) {
                thumbY = decrButton2Y - thumbH;
            }
            if (thumbY < incrButton2Y + incrButton2H) {
                thumbY = incrButton2Y + incrButton2H + 1;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void layoutHScrollbarAdjacent(JScrollBar sb) {
        int sbAvailButtonW;
        int thumbX;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        boolean ltr = sb.getComponentOrientation().isLeftToRight();
        int decrButton2W = itemH;
        int incrButtonW = itemH;
        int incrButtonX = ltr ? sbSize.width - (sbInsets.right + incrButtonW) : sbInsets.left;
        int decrButton2X = ltr ? incrButtonX - decrButton2W : incrButtonX + decrButton2W;
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = decrButton2W + incrButtonW;
        float trackW = sbSize.width - (sbInsetsW + sbButtonsW);
        float min = sb.getMinimum();
        float max = sb.getMaximum();
        float extent = sb.getVisibleAmount();
        float range = max - min;
        float value = sb.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int n = thumbX = ltr ? decrButton2X - thumbW : sbInsets.left;
        if (value < max - (float)sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            if (ltr) {
                thumbX = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            } else {
                thumbX = (int)(0.5f + thumbRange * ((max - extent - value) / (range - extent)));
                thumbX += decrButton2X + decrButton2W;
            }
        }
        if ((sbAvailButtonW = sbSize.width - sbInsetsW) < sbButtonsW) {
            incrButtonW = decrButton2W = sbAvailButtonW / 2;
            incrButtonX = ltr ? sbSize.width - (sbInsets.right + incrButtonW) : sbInsets.left;
        }
        this.mySecondDecreaseButton.setBounds(decrButton2X, itemY, decrButton2W, itemH);
        this.incrButton.setBounds(incrButtonX, itemY, incrButtonW, itemH);
        this.decrButton.setBounds(0, 0, 0, 0);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        if (ltr) {
            int itrackX = sbInsets.left;
            int itrackW = decrButton2X - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        } else {
            int itrackX = decrButton2X + decrButton2W;
            int itrackW = sbSize.width - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        }
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (ltr) {
                if (thumbX + thumbW > decrButton2X) {
                    thumbX = decrButton2X - thumbW;
                }
                if (thumbX < 0) {
                    thumbX = 1;
                }
            } else {
                if (thumbX + thumbW > sbSize.width - sbInsets.left) {
                    thumbX = sbSize.width - sbInsets.left - thumbW;
                }
                if (thumbX < decrButton2X + decrButton2W) {
                    thumbX = decrButton2X + decrButton2W + 1;
                }
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    protected void layoutHScrollbarNone(JScrollBar sb) {
        int sbAvailButtonW;
        int thumbX;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        boolean ltr = sb.getComponentOrientation().isLeftToRight();
        int decrButton2W = 0;
        int incrButtonW = 0;
        int incrButtonX = ltr ? sbSize.width - (sbInsets.right + incrButtonW) : sbInsets.left;
        int decrButton2X = ltr ? incrButtonX - decrButton2W : incrButtonX + decrButton2W;
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = decrButton2W + incrButtonW;
        float trackW = sbSize.width - (sbInsetsW + sbButtonsW);
        float min = sb.getMinimum();
        float max = sb.getMaximum();
        float extent = sb.getVisibleAmount();
        float range = max - min;
        float value = sb.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int n = thumbX = ltr ? decrButton2X - thumbW : sbInsets.left;
        if (value < max - (float)sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            if (ltr) {
                thumbX = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            } else {
                thumbX = (int)(0.5f + thumbRange * ((max - extent - value) / (range - extent)));
                thumbX += decrButton2X + decrButton2W;
            }
        }
        if ((sbAvailButtonW = sbSize.width - sbInsetsW) < sbButtonsW) {
            decrButton2W = 0;
            incrButtonW = 0;
            incrButtonX = ltr ? sbSize.width - (sbInsets.right + incrButtonW) : sbInsets.left;
        }
        this.incrButton.setBounds(0, 0, 0, 0);
        this.decrButton.setBounds(0, 0, 0, 0);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        this.mySecondDecreaseButton.setBounds(0, 0, 0, 0);
        if (ltr) {
            int itrackX = sbInsets.left;
            int itrackW = decrButton2X - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        } else {
            int itrackX = decrButton2X + decrButton2W;
            int itrackW = sbSize.width - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        }
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (ltr) {
                if (thumbX + thumbW > decrButton2X) {
                    thumbX = decrButton2X - thumbW;
                }
                if (thumbX < 0) {
                    thumbX = 1;
                }
            } else {
                if (thumbX + thumbW > sbSize.width - sbInsets.left) {
                    thumbX = sbSize.width - sbInsets.left - thumbW;
                }
                if (thumbX < decrButton2X + decrButton2W) {
                    thumbX = decrButton2X + decrButton2W + 1;
                }
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    protected void layoutHScrollbarMultiple(JScrollBar sb) {
        int sbAvailButtonW;
        int thumbX;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        boolean ltr = sb.getComponentOrientation().isLeftToRight();
        int decrButton2W = itemH;
        int decrButtonW = itemH;
        int incrButtonW = itemH;
        int incrButtonX = ltr ? sbSize.width - (sbInsets.right + incrButtonW) : sbInsets.left;
        int decrButton2X = ltr ? incrButtonX - decrButton2W : incrButtonX + decrButton2W;
        int decrButtonX = ltr ? sbInsets.left : sbSize.width - sbInsets.right - decrButtonW;
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = decrButton2W + incrButtonW + decrButtonW;
        float trackW = sbSize.width - (sbInsetsW + sbButtonsW);
        float min = sb.getMinimum();
        float max = sb.getMaximum();
        float extent = sb.getVisibleAmount();
        float range = max - min;
        float value = sb.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int n = thumbX = ltr ? decrButton2X - thumbW : sbInsets.left;
        if (value < max - (float)sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            if (ltr) {
                thumbX = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
                thumbX += decrButtonX + decrButtonW;
            } else {
                thumbX = (int)(0.5f + thumbRange * ((max - extent - value) / (range - extent)));
                thumbX += decrButton2X + decrButton2W;
            }
        }
        if ((sbAvailButtonW = sbSize.width - sbInsetsW) < sbButtonsW) {
            decrButton2W = decrButtonW = sbAvailButtonW / 2;
            incrButtonW = decrButtonW;
            incrButtonX = ltr ? sbSize.width - (sbInsets.right + incrButtonW) : sbInsets.left;
        }
        this.mySecondDecreaseButton.setBounds(decrButton2X, itemY, decrButton2W, itemH);
        this.incrButton.setBounds(incrButtonX, itemY, incrButtonW, itemH);
        this.decrButton.setBounds(decrButtonX, itemY, decrButtonW, itemH);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        if (ltr) {
            int itrackX = decrButtonX + decrButtonW;
            int itrackW = decrButton2X - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        } else {
            int itrackX = decrButton2X + decrButton2W;
            int itrackW = decrButtonX - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        }
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (ltr) {
                if (thumbX + thumbW > decrButton2X) {
                    thumbX = decrButton2X - thumbW;
                }
                if (thumbX < decrButtonX + decrButtonW) {
                    thumbX = decrButtonX + decrButtonW + 1;
                }
            } else {
                if (thumbX + thumbW > decrButtonX) {
                    thumbX = decrButtonX - thumbW;
                }
                if (thumbX < decrButton2X + decrButton2W) {
                    thumbX = decrButton2X + decrButton2W + 1;
                }
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    protected void layoutHScrollbarMultipleBoth(JScrollBar sb) {
        int sbAvailButtonW;
        int thumbX;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        boolean ltr = sb.getComponentOrientation().isLeftToRight();
        int decrButton2W = itemH;
        int incrButton2W = itemH;
        int decrButtonW = itemH;
        int incrButtonW = itemH;
        int incrButtonX = ltr ? sbSize.width - (sbInsets.right + incrButtonW) : sbInsets.left;
        int decrButton2X = ltr ? incrButtonX - decrButton2W : incrButtonX + decrButton2W;
        int decrButtonX = ltr ? sbInsets.left : sbSize.width - sbInsets.right - decrButtonW;
        int incrButton2X = ltr ? decrButtonX + decrButtonW : decrButtonX - incrButton2W;
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = decrButton2W + incrButtonW + decrButtonW + incrButton2W;
        float trackW = sbSize.width - (sbInsetsW + sbButtonsW);
        float min = sb.getMinimum();
        float max = sb.getMaximum();
        float extent = sb.getVisibleAmount();
        float range = max - min;
        float value = sb.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int n = thumbX = ltr ? decrButton2X - thumbW : sbInsets.left;
        if (value < max - (float)sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            if (ltr) {
                thumbX = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
                thumbX += incrButton2X + incrButton2W;
            } else {
                thumbX = (int)(0.5f + thumbRange * ((max - extent - value) / (range - extent)));
                thumbX += decrButton2X + decrButton2W;
            }
        }
        if ((sbAvailButtonW = sbSize.width - sbInsetsW) < sbButtonsW) {
            decrButtonW = incrButton2W = sbAvailButtonW / 4;
            decrButton2W = incrButton2W;
            incrButtonW = incrButton2W;
            incrButtonX = ltr ? sbSize.width - (sbInsets.right + incrButtonW) : sbInsets.left;
        }
        this.mySecondDecreaseButton.setBounds(decrButton2X, itemY, decrButton2W, itemH);
        this.mySecondIncreaseButton.setBounds(incrButton2X, itemY, incrButton2W, itemH);
        this.incrButton.setBounds(incrButtonX, itemY, incrButtonW, itemH);
        this.decrButton.setBounds(decrButtonX, itemY, decrButtonW, itemH);
        if (ltr) {
            int itrackX = incrButton2X + incrButton2W;
            int itrackW = decrButton2X - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        } else {
            int itrackX = decrButton2X + decrButton2W;
            int itrackW = incrButton2X - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        }
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (ltr) {
                if (thumbX + thumbW > decrButton2X) {
                    thumbX = decrButton2X - thumbW;
                }
                if (thumbX < incrButton2X + incrButton2W) {
                    thumbX = incrButton2X + incrButton2W + 1;
                }
            } else {
                if (thumbX + thumbW > incrButton2X) {
                    thumbX = incrButton2X - thumbW;
                }
                if (thumbX < decrButton2X + decrButton2W) {
                    thumbX = decrButton2X + decrButton2W + 1;
                }
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceScrollBarUI: \n");
        sb.append("\t" + thumbHorizontalMap.size() + " thumb horizontal, " + thumbVerticalMap.size() + " thumb vertical");
        return sb.toString();
    }

    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new MyTrackListener();
    }

    protected BasicScrollBarUI.ArrowButtonListener createArrowButtonListener() {
        return new SubstanceArrowButtonListener();
    }

    private void updateThumbState(int x, int y) {
        Rectangle rect = this.getThumbBounds();
        this.setThumbRollover(rect.contains(x, y));
    }

    protected class PolicyChanger
    implements ActionListener {
        protected SubstanceConstants.ScrollPaneButtonPolicyKind newPolicy;

        public PolicyChanger(SubstanceConstants.ScrollPaneButtonPolicyKind newPolicy) {
            this.newPolicy = newPolicy;
        }

        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SubstanceScrollBarUI.this.scrollbar.putClientProperty("substancelaf.scrollPaneButtonsPolicy", (Object)PolicyChanger.this.newPolicy);
                    SubstanceScrollBarUI.this.scrollbar.doLayout();
                    SubstanceScrollBarUI.this.scrollbar.repaint();
                }
            });
        }
    }

    protected class SubstanceArrowButtonListener
    extends BasicScrollBarUI.ArrowButtonListener {
        boolean handledEvent;

        protected SubstanceArrowButtonListener() {
            super(SubstanceScrollBarUI.this);
        }

        public void mousePressed(MouseEvent e) {
            if (!SubstanceScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            int direction = e.getSource() == SubstanceScrollBarUI.this.incrButton || e.getSource() == SubstanceScrollBarUI.this.mySecondIncreaseButton ? 1 : -1;
            SubstanceScrollBarUI.this.scrollByUnit(direction);
            SubstanceScrollBarUI.this.scrollTimer.stop();
            SubstanceScrollBarUI.this.scrollListener.setDirection(direction);
            SubstanceScrollBarUI.this.scrollListener.setScrollByBlock(false);
            SubstanceScrollBarUI.this.scrollTimer.start();
            this.handledEvent = true;
            if (!SubstanceScrollBarUI.this.scrollbar.hasFocus() && SubstanceScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                SubstanceScrollBarUI.this.scrollbar.requestFocus();
            }
        }

        public void mouseReleased(MouseEvent e) {
            SubstanceScrollBarUI.this.scrollTimer.stop();
            this.handledEvent = false;
            SubstanceScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }
    }

    protected class MyTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;
        private transient int direction;

        protected MyTrackListener() {
            super(SubstanceScrollBarUI.this);
            this.direction = 1;
        }

        public void mouseReleased(MouseEvent e) {
            if (SubstanceScrollBarUI.this.isDragging) {
                SubstanceScrollBarUI.this.updateThumbState(e.getX(), e.getY());
            }
            if (SwingUtilities.isRightMouseButton(e) || !SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            Rectangle r = SubstanceScrollBarUI.this.getTrackBounds();
            SubstanceScrollBarUI.this.scrollbar.repaint(r.x, r.y, r.width, r.height);
            SubstanceScrollBarUI.this.trackHighlight = 0;
            SubstanceScrollBarUI.this.isDragging = false;
            this.offset = 0;
            SubstanceScrollBarUI.this.scrollTimer.stop();
            SubstanceScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || !SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.hasFocus() && SubstanceScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                SubstanceScrollBarUI.this.scrollbar.requestFocus();
            }
            SubstanceScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (SubstanceScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
                switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x;
                    }
                }
                SubstanceScrollBarUI.this.isDragging = true;
                return;
            }
            if (SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().height / 2;
                        break;
                    }
                    case 0: {
                        this.offset = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().width / 2;
                    }
                }
                SubstanceScrollBarUI.this.isDragging = true;
                this.setValueFrom(e);
                return;
            }
            SubstanceScrollBarUI.this.isDragging = false;
            Dimension sbSize = SubstanceScrollBarUI.this.scrollbar.getSize();
            this.direction = 1;
            switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (SubstanceScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int scrollbarCenter = sbSize.height / 2;
                        this.direction = this.currentMouseY < scrollbarCenter ? -1 : 1;
                        break;
                    }
                    int thumbY = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y;
                    this.direction = this.currentMouseY < thumbY ? -1 : 1;
                    break;
                }
                case 0: {
                    if (SubstanceScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int scrollbarCenter = sbSize.width / 2;
                        this.direction = this.currentMouseX < scrollbarCenter ? -1 : 1;
                    } else {
                        int thumbX = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x;
                        int n = this.direction = this.currentMouseX < thumbX ? -1 : 1;
                    }
                    if (SubstanceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) break;
                    this.direction = -this.direction;
                }
            }
            SubstanceScrollBarUI.this.scrollByBlock(this.direction);
            SubstanceScrollBarUI.this.scrollTimer.stop();
            SubstanceScrollBarUI.this.scrollListener.setDirection(this.direction);
            SubstanceScrollBarUI.this.scrollListener.setScrollByBlock(true);
            this.startScrollTimerIfNecessary();
        }

        public void mouseDragged(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || !SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.isEnabled() || SubstanceScrollBarUI.this.getThumbBounds().isEmpty()) {
                return;
            }
            if (SubstanceScrollBarUI.this.isDragging) {
                this.setValueFrom(e);
            } else {
                this.currentMouseX = e.getX();
                this.currentMouseY = e.getY();
                SubstanceScrollBarUI.this.updateThumbState(this.currentMouseX, this.currentMouseY);
                this.startScrollTimerIfNecessary();
            }
        }

        private void setValueFrom(MouseEvent e) {
            int thumbPos;
            boolean active = SubstanceScrollBarUI.this.isThumbRollover();
            BoundedRangeModel model = SubstanceScrollBarUI.this.scrollbar.getModel();
            Rectangle thumbR = SubstanceScrollBarUI.this.getThumbBounds();
            int thumbMin = 0;
            int thumbMax = 0;
            SubstanceConstants.ScrollPaneButtonPolicyKind buttonPolicy = SubstanceCoreUtilities.getScrollPaneButtonsPolicyKind(SubstanceScrollBarUI.this.scrollbar);
            if (SubstanceScrollBarUI.this.scrollbar.getOrientation() == 1) {
                switch (buttonPolicy) {
                    case OPPOSITE: {
                        thumbMin = SubstanceScrollBarUI.this.decrButton.getY() + SubstanceScrollBarUI.this.decrButton.getHeight();
                        thumbMax = SubstanceScrollBarUI.this.incrButton.getY() - thumbR.height;
                        break;
                    }
                    case ADJACENT: {
                        thumbMin = 0;
                        thumbMax = SubstanceScrollBarUI.this.mySecondDecreaseButton.getY() - thumbR.height;
                        break;
                    }
                    case NONE: {
                        thumbMin = 0;
                        thumbMax = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getSize().height - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getInsets().bottom - thumbR.height;
                        break;
                    }
                    case MULTIPLE: {
                        thumbMin = SubstanceScrollBarUI.this.decrButton.getY() + SubstanceScrollBarUI.this.decrButton.getHeight();
                        thumbMax = SubstanceScrollBarUI.this.mySecondDecreaseButton.getY() - thumbR.height;
                        break;
                    }
                    case MULTIPLE_BOTH: {
                        thumbMin = SubstanceScrollBarUI.this.mySecondIncreaseButton.getY() + SubstanceScrollBarUI.this.mySecondIncreaseButton.getHeight();
                        thumbMax = SubstanceScrollBarUI.this.mySecondDecreaseButton.getY() - thumbR.height;
                    }
                }
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getY() - this.offset));
                SubstanceScrollBarUI.this.setThumbBounds(thumbR.x, thumbPos, thumbR.width, thumbR.height);
            } else {
                if (SubstanceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    switch (buttonPolicy) {
                        case OPPOSITE: {
                            thumbMin = SubstanceScrollBarUI.this.decrButton.getX() + SubstanceScrollBarUI.this.decrButton.getWidth();
                            thumbMax = SubstanceScrollBarUI.this.incrButton.getX() - thumbR.width;
                            break;
                        }
                        case ADJACENT: {
                            thumbMin = 0;
                            thumbMax = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() - thumbR.width;
                            break;
                        }
                        case MULTIPLE: {
                            thumbMin = SubstanceScrollBarUI.this.decrButton.getX() + SubstanceScrollBarUI.this.decrButton.getWidth();
                            thumbMax = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() - thumbR.width;
                            break;
                        }
                        case MULTIPLE_BOTH: {
                            thumbMin = SubstanceScrollBarUI.this.mySecondIncreaseButton.getX() + SubstanceScrollBarUI.this.mySecondIncreaseButton.getWidth();
                            thumbMax = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() - thumbR.width;
                            break;
                        }
                        case NONE: {
                            thumbMin = 0;
                            thumbMax = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getSize().width - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getInsets().right - thumbR.width;
                        }
                    }
                } else {
                    switch (buttonPolicy) {
                        case OPPOSITE: {
                            thumbMin = SubstanceScrollBarUI.this.incrButton.getX() + SubstanceScrollBarUI.this.incrButton.getWidth();
                            thumbMax = SubstanceScrollBarUI.this.decrButton.getX() - thumbR.width;
                            break;
                        }
                        case ADJACENT: {
                            thumbMin = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() + SubstanceScrollBarUI.this.mySecondDecreaseButton.getWidth();
                            thumbMax = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getSize().width - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getInsets().right - thumbR.width;
                            break;
                        }
                        case MULTIPLE: {
                            thumbMin = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() + SubstanceScrollBarUI.this.mySecondDecreaseButton.getWidth();
                            thumbMax = SubstanceScrollBarUI.this.decrButton.getX() - thumbR.width;
                            break;
                        }
                        case MULTIPLE_BOTH: {
                            thumbMin = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() + SubstanceScrollBarUI.this.mySecondDecreaseButton.getWidth();
                            thumbMax = SubstanceScrollBarUI.this.mySecondIncreaseButton.getX() - thumbR.width;
                            break;
                        }
                        case NONE: {
                            thumbMin = 0;
                            thumbMax = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getSize().width - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getInsets().right - thumbR.width;
                        }
                    }
                }
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getX() - this.offset));
                SubstanceScrollBarUI.this.setThumbBounds(thumbPos, thumbR.y, thumbR.width, thumbR.height);
            }
            if (thumbPos == thumbMax) {
                if (SubstanceScrollBarUI.this.scrollbar.getOrientation() == 1 || SubstanceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    SubstanceScrollBarUI.this.scrollbar.setValue(model.getMaximum() - model.getExtent());
                } else {
                    SubstanceScrollBarUI.this.scrollbar.setValue(model.getMinimum());
                }
            } else {
                float valueMax = model.getMaximum() - model.getExtent();
                float valueRange = valueMax - (float)model.getMinimum();
                float thumbValue = thumbPos - thumbMin;
                float thumbRange = thumbMax - thumbMin;
                int value = SubstanceScrollBarUI.this.scrollbar.getOrientation() == 1 || SubstanceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight() ? (int)(0.5 + (double)(thumbValue / thumbRange * valueRange)) : (int)(0.5 + (double)((float)(thumbMax - thumbPos) / thumbRange * valueRange));
                SubstanceScrollBarUI.this.scrollbar.setValue(value + model.getMinimum());
            }
            SubstanceScrollBarUI.this.setThumbRollover(active);
        }

        private void startScrollTimerIfNecessary() {
            if (SubstanceScrollBarUI.this.scrollTimer.isRunning()) {
                return;
            }
            switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (this.direction > 0) {
                        if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y + ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().height >= ((MyTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseY) break;
                        SubstanceScrollBarUI.this.scrollTimer.start();
                        break;
                    }
                    if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y <= ((MyTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseY) break;
                    SubstanceScrollBarUI.this.scrollTimer.start();
                    break;
                }
                case 0: {
                    if (this.direction > 0) {
                        if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x + ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().width >= ((MyTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseX) break;
                        SubstanceScrollBarUI.this.scrollTimer.start();
                        break;
                    }
                    if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x <= ((MyTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseX) break;
                    SubstanceScrollBarUI.this.scrollTimer.start();
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (!SubstanceScrollBarUI.this.isDragging) {
                SubstanceScrollBarUI.this.updateThumbState(e.getX(), e.getY());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!SubstanceScrollBarUI.this.isDragging) {
                SubstanceScrollBarUI.this.setThumbRollover(false);
            }
        }
    }
}

