/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.RolloverControlListener;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.Trackable;

public class SubstanceSliderUI
extends BasicSliderUI
implements Trackable {
    protected Set lafWidgets;
    private static SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();
    private ButtonModel thumbModel = new DefaultButtonModel();
    private RolloverControlListener substanceRolloverListener;

    public void __org__jvnet__substance__SubstanceSliderUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Object object = jComponent.getClientProperty("lafwidgets.layout.alpha");
        if (object instanceof Float) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, ((Float)object).floatValue()));
        }
        this.__org__jvnet__substance__SubstanceSliderUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
    }

    public void __org__jvnet__substance__SubstanceSliderUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceSliderUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceSliderUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceSliderUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners(JSlider jSlider) {
        this.__org__jvnet__substance__SubstanceSliderUI__installListeners(jSlider);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceSliderUI__installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
    }

    public void installDefaults(JSlider jSlider) {
        this.__org__jvnet__substance__SubstanceSliderUI__installDefaults(jSlider);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallListeners(JSlider jSlider) {
        this.__org__jvnet__substance__SubstanceSliderUI__uninstallListeners(jSlider);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceSliderUI();
    }

    public SubstanceSliderUI() {
        super(null);
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
    }

    private Rectangle getPaintTrackRect() {
        int trackLeft = 0;
        int trackRight = 0;
        int trackTop = 0;
        int trackBottom = 0;
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - 1 - this.getThumbOverhang();
            trackTop = trackBottom - (this.getTrackWidth() - 1);
            trackRight = this.trackRect.width - 1;
        } else {
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                trackLeft = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                trackRight = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                trackLeft = this.getThumbOverhang();
                trackRight = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            trackBottom = this.trackRect.height - 1;
        }
        return new Rectangle(this.trackRect.x + trackLeft, this.trackRect.y + trackTop, trackRight - trackLeft, trackBottom - trackTop);
    }

    public void paintTrack(Graphics g) {
        Color fillColor2;
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean drawInverted = this.drawInverted();
        Rectangle paintRect = this.getPaintTrackRect();
        graphics.translate(paintRect.x, paintRect.y);
        int width = paintRect.width;
        int height = paintRect.height;
        boolean isDark = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme());
        ColorScheme borderColorScheme = this.slider.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(this.slider) : SubstanceCoreUtilities.getDefaultScheme(this.slider);
        Color borderColor1 = isDark ? borderColorScheme.getExtraLightColor() : borderColorScheme.getUltraDarkColor();
        Color borderColor2 = isDark ? borderColorScheme.getUltraLightColor() : borderColorScheme.getDarkColor();
        graphics.setStroke(new BasicStroke(1.1f, 1, 1));
        if (this.slider.getOrientation() == 0) {
            graphics.setPaint(new GradientPaint(0.0f, 0.0f, borderColor1, 0.0f, height - 1, borderColor2));
            graphics.drawRoundRect(0, 0, width, height, height, height);
        } else {
            graphics.setPaint(new GradientPaint(0.0f, 0.0f, borderColor1, width - 1, 0.0f, borderColor2));
            graphics.drawRoundRect(0, 0, width, height, width, width);
        }
        Color fillColor1 = isDark ? borderColorScheme.getUltraLightColor() : borderColorScheme.getUltraLightColor();
        Color color = fillColor2 = isDark ? borderColorScheme.getExtraLightColor() : borderColorScheme.getLightColor();
        if (this.slider.isEnabled()) {
            if (this.slider.getOrientation() == 0) {
                int fillMaxX;
                int fillMinX;
                int middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2 - paintRect.x;
                graphics.setPaint(new GradientPaint(0.0f, 1.0f, fillColor1, 0.0f, height - 1, fillColor2));
                if (drawInverted) {
                    fillMinX = middleOfThumb;
                    fillMaxX = width - 2;
                } else {
                    fillMinX = 1;
                    fillMaxX = middleOfThumb;
                }
                graphics.fillRoundRect(fillMinX, 1, fillMaxX - fillMinX + 2, height - 1, height - 2, height - 2);
            } else {
                int fillMaxY;
                int fillMinY;
                int middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2 - paintRect.y;
                graphics.setPaint(new GradientPaint(1.0f, 0.0f, fillColor1, width - 1, 0.0f, fillColor2));
                if (this.drawInverted()) {
                    fillMinY = 1;
                    fillMaxY = middleOfThumb;
                } else {
                    fillMinY = middleOfThumb;
                    fillMaxY = height - 2;
                }
                graphics.fillRoundRect(1, fillMinY, width - 1, fillMaxY - fillMinY + 2, width - 2, width - 2);
            }
        }
        g.translate(-paintRect.x, -paintRect.y);
    }

    public void paintThumb(Graphics g) {
        Rectangle knobBounds = this.thumbRect;
        g.translate(knobBounds.x, knobBounds.y);
        if (this.slider.getOrientation() == 0) {
            UIManager.getIcon("Slider.horizontalThumbIcon").paintIcon(this.slider, g, 0, 0);
        } else {
            UIManager.getIcon("Slider.verticalThumbIcon").paintIcon(this.slider, g, 0, 0);
        }
        g.translate(-knobBounds.x, -knobBounds.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void paint(Graphics g, JComponent c) {
        JComponent jComponent = c;
        synchronized (jComponent) {
            bgDelegate.update(g, c);
            boolean isOpaque = c.isOpaque();
            c.setOpaque(false);
            super.paint(g, c);
            c.setOpaque(isOpaque);
        }
    }

    public ButtonModel getButtonModel() {
        return this.thumbModel;
    }

    public boolean isInside(MouseEvent me) {
        Rectangle thumbB = this.thumbRect;
        if (thumbB == null) {
            return false;
        }
        return thumbB.contains(me.getX(), me.getY());
    }

    protected void __org__jvnet__substance__SubstanceSliderUI__installListeners(JSlider slider) {
        super.installListeners(slider);
        this.substanceRolloverListener = new RolloverControlListener(this, this.thumbModel);
        slider.addMouseListener(this.substanceRolloverListener);
        slider.addMouseMotionListener(this.substanceRolloverListener);
    }

    protected void __org__jvnet__substance__SubstanceSliderUI__uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener(this.substanceRolloverListener);
        slider.removeMouseMotionListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
    }

    public void paintFocus(Graphics g) {
        FadeTracker fadeTracker = FadeTracker.getInstance();
        SubstanceConstants.FocusKind focusKind = SubstanceCoreUtilities.getFocusKind(this.slider);
        if (focusKind == SubstanceConstants.FocusKind.NONE && !fadeTracker.isTracked(this.slider, FadeTracker.FadeKind.FOCUS)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float alpha = 1.0f;
        if (fadeTracker.isTracked(this.slider, FadeTracker.FadeKind.FOCUS)) {
            alpha = fadeTracker.getFade10(this.slider, FadeTracker.FadeKind.FOCUS) / 10.0f;
        }
        graphics.setComposite(TransitionLayout.getAlphaComposite(this.slider, alpha));
        ColorScheme currScheme = SubstanceCoreUtilities.getActiveScheme(this.slider);
        Color color = SubstanceCoreUtilities.isThemeDark(SubstanceCoreUtilities.getActiveTheme(this.slider, true)) ? SubstanceColorUtilities.getInterpolatedColor(currScheme.getUltraLightColor(), currScheme.getForegroundColor(), 0.4) : SubstanceColorUtilities.getInterpolatedColor(currScheme.getMidColor(), currScheme.getDarkColor(), 0.5);
        graphics.setColor(color);
        graphics.translate(this.focusRect.x, this.focusRect.y);
        GeneralPath contour = BaseButtonShaper.getBaseOutline(this.focusRect.width, this.focusRect.height, 3.0f, null);
        graphics.setStroke(new BasicStroke(1.1f, 0, 1, 0.0f, new float[]{2.0f, 1.0f}, 0.0f));
        graphics.draw(contour);
        graphics.dispose();
    }

    protected int getThumbOverhang() {
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    protected int getTrackWidth() {
        double kIdealTrackWidth = 7.0;
        double kIdealThumbHeight = 16.0;
        double kWidthScalar = 0.4375;
        if (this.slider.getOrientation() == 0) {
            return (int)(0.4375 * (double)this.thumbRect.height);
        }
        return (int)(0.4375 * (double)this.thumbRect.width);
    }
}

