/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.combo;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.LafWidgetUtilities;

public class ComboboxAutoCompletionWidget
extends LafWidgetAdapter {
    protected JComboBox comboBox;
    protected ComboBoxPropertyChangeHandler changeHandler;
    protected ComboBoxModel model;
    protected Component editor;
    protected boolean selecting = false;
    protected boolean hidePopupOnFocusLoss;
    protected boolean hitBackspace = false;
    protected boolean hitBackspaceOnSelection;
    protected ActionListener completionActionListener;
    protected PropertyChangeListener completionPropertyListener;
    protected KeyListener editorKeyListener;
    protected FocusListener editorFocusListener;
    protected CompletionPlainDocument completionDocument;
    protected ActionMap oldActionMap;

    public boolean isSimple() {
        return true;
    }

    public void setComponent(JComponent jcomp) {
        super.setComponent(jcomp);
        this.comboBox = (JComboBox)jcomp;
    }

    public void installUI() {
        ComboBoxEditor cbe = this.comboBox.getEditor();
        Component cbc = cbe.getEditorComponent();
        if (cbc instanceof JTextComponent) {
            this.installTextEditor((JTextComponent)cbc);
        } else {
            this.installEditor(cbc);
        }
    }

    public void installListeners() {
        this.changeHandler = new ComboBoxPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(this.changeHandler);
    }

    protected void installTextEditor(JTextComponent c) {
        if (this.comboBox.isEditable()) {
            this.completionDocument = new CompletionPlainDocument(this.comboBox);
            c.setDocument(this.completionDocument);
            this.model = this.comboBox.getModel();
            this.completionActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!ComboboxAutoCompletionWidget.this.selecting && ComboboxAutoCompletionWidget.this.completionDocument != null) {
                        ComboboxAutoCompletionWidget.this.completionDocument.highlightCompletedText(0);
                    }
                }
            };
            this.comboBox.addActionListener(this.completionActionListener);
            this.completionPropertyListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("model")) {
                        ComboboxAutoCompletionWidget.this.model = (ComboBoxModel)e.getNewValue();
                    }
                }
            };
            this.comboBox.addPropertyChangeListener(this.completionPropertyListener);
            this.editorKeyListener = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (ComboboxAutoCompletionWidget.this.comboBox.isDisplayable() && e.getKeyCode() != 10) {
                        ComboboxAutoCompletionWidget.this.comboBox.setPopupVisible(true);
                    }
                    ComboboxAutoCompletionWidget.this.hitBackspace = false;
                    switch (e.getKeyCode()) {
                        case 8: {
                            ComboboxAutoCompletionWidget.this.hitBackspace = true;
                            ComboboxAutoCompletionWidget.this.hitBackspaceOnSelection = ((JTextField)ComboboxAutoCompletionWidget.this.editor).getSelectionStart() != ((JTextField)ComboboxAutoCompletionWidget.this.editor).getSelectionEnd();
                            break;
                        }
                        case 127: {
                            if (LafWidgetUtilities.hasUseModelOnlyProperty(ComboboxAutoCompletionWidget.this.comboBox)) {
                                e.consume();
                                ComboboxAutoCompletionWidget.this.comboBox.getToolkit().beep();
                                break;
                            }
                            ((JTextField)ComboboxAutoCompletionWidget.this.editor).replaceSelection("");
                            break;
                        }
                        case 27: {
                            ComboboxAutoCompletionWidget.this.comboBox.getParent().dispatchEvent(e);
                        }
                    }
                }
            };
            this.hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
            this.editorFocusListener = new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (ComboboxAutoCompletionWidget.this.completionDocument != null) {
                        ComboboxAutoCompletionWidget.this.completionDocument.highlightCompletedText(0);
                    }
                }

                public void focusLost(FocusEvent e) {
                    if (ComboboxAutoCompletionWidget.this.hidePopupOnFocusLoss && ComboboxAutoCompletionWidget.this.comboBox != null) {
                        ComboboxAutoCompletionWidget.this.comboBox.setPopupVisible(false);
                    }
                }
            };
            this.installEditor(c);
            Object selected = this.comboBox.getSelectedItem();
            if (this.completionDocument != null) {
                if (selected != null) {
                    this.completionDocument.setText(selected.toString());
                }
                this.completionDocument.highlightCompletedText(0);
            }
        }
    }

    public void uninstallListeners() {
        this.comboBox.removePropertyChangeListener(this.changeHandler);
        this.changeHandler = null;
        if (this.comboBox.isEditable()) {
            this.uninstallTextEditor(null);
        }
        super.uninstallListeners();
    }

    protected void uninstallTextEditor(JTextComponent e) {
        this.completionDocument = null;
        this.comboBox.removeActionListener(this.completionActionListener);
        this.completionActionListener = null;
        this.comboBox.removePropertyChangeListener(this.completionPropertyListener);
        this.completionPropertyListener = null;
        if (e == null) {
            return;
        }
        if (this.editorKeyListener != null) {
            e.removeKeyListener(this.editorKeyListener);
            this.editorKeyListener = null;
        }
        if (this.editorFocusListener != null) {
            e.removeFocusListener(this.editorFocusListener);
            this.editorFocusListener = null;
        }
        if (this.oldActionMap != null) {
            this.comboBox.setActionMap(this.oldActionMap);
            this.oldActionMap = null;
        }
    }

    protected void installEditor(Component c) {
        if (c == null || this.editor == c) {
            return;
        }
        Component last = this.editor;
        if (last != null) {
            last.removeKeyListener(this.editorKeyListener);
            last.removeFocusListener(this.editorFocusListener);
        }
        this.editor = c;
        this.editor.addKeyListener(this.editorKeyListener);
        this.editor.addFocusListener(this.editorFocusListener);
        if (this.oldActionMap == null) {
            this.oldActionMap = this.comboBox.getActionMap();
            ActionMap newActionMap = new ActionMap();
            Object[] keys = this.oldActionMap.allKeys();
            for (int i = 0; i < keys.length; ++i) {
                if ("enterPressed".equals(keys[i])) continue;
                newActionMap.put(keys[i], this.oldActionMap.get(keys[i]));
            }
            this.comboBox.setActionMap(newActionMap);
        }
    }

    public boolean requiresCustomLafSupport() {
        return false;
    }

    public class ComboBoxPropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("editable")) {
                boolean oldValue = (Boolean)e.getOldValue();
                boolean newValue = (Boolean)e.getNewValue();
                if (!oldValue && newValue) {
                    ComboBoxEditor cbe = ComboboxAutoCompletionWidget.this.comboBox.getEditor();
                    Component cbc = cbe.getEditorComponent();
                    if (cbc instanceof JTextComponent) {
                        ComboboxAutoCompletionWidget.this.installTextEditor((JTextComponent)cbc);
                    } else {
                        ComboboxAutoCompletionWidget.this.installEditor(cbc);
                    }
                } else if (oldValue && !newValue) {
                    ComboboxAutoCompletionWidget.this.uninstallTextEditor(null);
                }
            }
            if (propertyName.equals("editor")) {
                ComboBoxEditor oldValue = (ComboBoxEditor)e.getOldValue();
                ComboBoxEditor newValue = (ComboBoxEditor)e.getNewValue();
                if (newValue != null && newValue != oldValue) {
                    Component pending;
                    Component old;
                    Component component = old = oldValue != null ? oldValue.getEditorComponent() : null;
                    if (old instanceof JTextComponent) {
                        ComboboxAutoCompletionWidget.this.uninstallTextEditor((JTextComponent)old);
                    }
                    if ((pending = newValue.getEditorComponent()) instanceof JTextComponent) {
                        ComboboxAutoCompletionWidget.this.installTextEditor((JTextComponent)pending);
                    } else {
                        ComboboxAutoCompletionWidget.this.installEditor(pending);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ComboboxAutoCompletionWidget.this.comboBox.doLayout();
                        }
                    });
                }
            }
            if (propertyName.equals("model") && ComboboxAutoCompletionWidget.this.comboBox.isEditable()) {
                ComboboxAutoCompletionWidget.this.uninstallTextEditor(null);
                ComboBoxEditor cbe = ComboboxAutoCompletionWidget.this.comboBox.getEditor();
                Component cbc = cbe.getEditorComponent();
                if (cbc instanceof JTextComponent) {
                    ComboboxAutoCompletionWidget.this.installTextEditor((JTextComponent)cbc);
                } else {
                    ComboboxAutoCompletionWidget.this.installEditor(cbc);
                }
            }
        }
    }

    protected class CompletionPlainDocument
    extends PlainDocument {
        protected JComboBox comboBox;
        protected ComboBoxModel model;

        public CompletionPlainDocument(JComboBox combo) {
            this.comboBox = combo;
            this.model = this.comboBox.getModel();
        }

        public void remove(int offs, int len) throws BadLocationException {
            if (ComboboxAutoCompletionWidget.this.selecting) {
                return;
            }
            if (ComboboxAutoCompletionWidget.this.hitBackspace) {
                if (offs > 0) {
                    if (ComboboxAutoCompletionWidget.this.hitBackspaceOnSelection) {
                        --offs;
                    }
                } else {
                    this.comboBox.getToolkit().beep();
                }
                this.highlightCompletedText(offs);
            } else {
                super.remove(offs, len);
            }
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (ComboboxAutoCompletionWidget.this.selecting) {
                return;
            }
            super.insertString(offs, str, a);
            Object item = this.lookupItem(this.getText(0, this.getLength()));
            if (LafWidgetUtilities.hasUseModelOnlyProperty(this.comboBox)) {
                if (item != null) {
                    this.setSelectedItem(item);
                } else {
                    item = this.comboBox.getSelectedItem();
                    offs -= str.length();
                    this.comboBox.getToolkit().beep();
                }
                this.setText(item.toString());
                this.highlightCompletedText(offs + str.length());
            } else if (item != null) {
                this.setSelectedItem(item);
                this.setText(item.toString());
                this.highlightCompletedText(offs + str.length());
            } else {
                offs -= str.length();
            }
        }

        private void setText(String text) {
            try {
                super.remove(0, this.getLength());
                super.insertString(0, text, null);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e.toString());
            }
        }

        private void highlightCompletedText(int start) {
            if (ComboboxAutoCompletionWidget.this.editor instanceof JTextComponent) {
                JTextComponent textEditor = (JTextComponent)ComboboxAutoCompletionWidget.this.editor;
                textEditor.setCaretPosition(textEditor.getDocument().getLength());
                textEditor.moveCaretPosition(start);
            }
        }

        private void setSelectedItem(Object item) {
            ComboboxAutoCompletionWidget.this.selecting = true;
            this.model.setSelectedItem(item);
            ComboboxAutoCompletionWidget.this.selecting = false;
        }

        private Object lookupItem(String pattern) {
            Object selectedItem = this.model.getSelectedItem();
            if (selectedItem != null && this.startsWithIgnoreCase(selectedItem.toString(), pattern)) {
                return selectedItem;
            }
            int n = this.model.getSize();
            for (int i = 0; i < n; ++i) {
                Object currentItem = this.model.getElementAt(i);
                if (currentItem == null || !this.startsWithIgnoreCase(currentItem.toString(), pattern)) continue;
                return currentItem;
            }
            return null;
        }

        private boolean startsWithIgnoreCase(String str1, String str2) {
            return str1.toUpperCase().startsWith(str2.toUpperCase());
        }
    }
}

