/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceProgressBarUI
extends BasicProgressBarUI {
    protected Set lafWidgets;
    private static Map<String, BufferedImage> stripeMap = new HashMap<String, BufferedImage>();
    private int animationIndex;
    protected ChangeListener substanceValueChangeListener;
    public static final FadeTracker.FadeKind PROGRESS_BAR_VALUE_CHANGED = new FadeTracker.FadeKind("substancelaf.progressBarValueChanged");
    private static final String PROGRESS_BAR_FROM = "substancelaf.internal.from";
    private static final String PROGRESS_BAR_TO = "substancelaf.internal.to";

    public void __org__jvnet__substance__SubstanceProgressBarUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Object object = jComponent.getClientProperty("lafwidgets.layout.alpha");
        if (object instanceof Float) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, ((Float)object).floatValue()));
        }
        this.__org__jvnet__substance__SubstanceProgressBarUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
    }

    public void __org__jvnet__substance__SubstanceProgressBarUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceProgressBarUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceProgressBarUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceProgressBarUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners() {
        this.__org__jvnet__substance__SubstanceProgressBarUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void installDefaults() {
        this.__org__jvnet__substance__SubstanceProgressBarUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallListeners() {
        this.__org__jvnet__substance__SubstanceProgressBarUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceProgressBarUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    public void uninstallDefaults() {
        this.__org__jvnet__substance__SubstanceProgressBarUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static synchronized void reset() {
        stripeMap.clear();
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceProgressBarUI();
    }

    protected void __org__jvnet__substance__SubstanceProgressBarUI__installDefaults() {
        super.installDefaults();
        this.progressBar.putClientProperty(PROGRESS_BAR_TO, this.progressBar.getValue());
    }

    protected void __org__jvnet__substance__SubstanceProgressBarUI__installListeners() {
        super.installListeners();
        BoundedRangeModel model = this.progressBar.getModel();
        if (model instanceof DefaultBoundedRangeModel) {
            this.substanceValueChangeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    FadeTracker fadeTracker = FadeTracker.getInstance();
                    if (!fadeTracker.isTracked(SubstanceProgressBarUI.this.progressBar, PROGRESS_BAR_VALUE_CHANGED)) {
                        SubstanceProgressBarUI.this.progressBar.putClientProperty(SubstanceProgressBarUI.PROGRESS_BAR_FROM, SubstanceProgressBarUI.this.progressBar.getClientProperty(SubstanceProgressBarUI.PROGRESS_BAR_TO));
                    }
                    SubstanceProgressBarUI.this.progressBar.putClientProperty(SubstanceProgressBarUI.PROGRESS_BAR_TO, SubstanceProgressBarUI.this.progressBar.getValue());
                    FadeTracker.getInstance().trackFadeIn(PROGRESS_BAR_VALUE_CHANGED, SubstanceProgressBarUI.this.progressBar, false, null);
                }
            };
            ((DefaultBoundedRangeModel)model).addChangeListener(this.substanceValueChangeListener);
        }
    }

    protected void __org__jvnet__substance__SubstanceProgressBarUI__uninstallListeners() {
        BoundedRangeModel model = this.progressBar.getModel();
        if (model instanceof DefaultBoundedRangeModel) {
            ((DefaultBoundedRangeModel)model).removeChangeListener(this.substanceValueChangeListener);
        }
        super.uninstallListeners();
    }

    private static synchronized BufferedImage getStripe(int baseSize, boolean isRotated, ColorScheme colorScheme) {
        String key = "" + baseSize + ":" + isRotated + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme);
        BufferedImage result = stripeMap.get(key);
        if (result == null) {
            result = SubstanceImageCreator.getStripe(baseSize, colorScheme.getUltraLightColor());
            if (isRotated) {
                result = SubstanceImageCreator.getRotated(result, 1);
            }
            stripeMap.put(key, result);
        }
        return result;
    }

    public void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        Graphics2D graphics = (Graphics2D)g;
        if (this.progressBar.getOrientation() == 0) {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth, barRectHeight + 1, SubstanceCoreUtilities.getDisabledScheme(this.progressBar), null, 0, false);
        } else {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth + 1, barRectHeight, SubstanceCoreUtilities.getDisabledScheme(this.progressBar), null, 0, true);
        }
        if (amountFull > 0) {
            ColorScheme fillColorScheme;
            ColorScheme colorScheme = fillColorScheme = this.progressBar.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(this.progressBar) : SubstanceCoreUtilities.getDefaultScheme(this.progressBar);
            if (this.progressBar.getOrientation() == 0) {
                int barWidth = amountFull;
                int barHeight = barRectHeight;
                if (barWidth > 0 && barHeight > 0) {
                    if (c.getComponentOrientation().isLeftToRight()) {
                        SubstanceImageCreator.paintProgressBar(g, b.left, b.top, barWidth, barHeight, fillColorScheme, false);
                    } else {
                        SubstanceImageCreator.paintProgressBar(g, b.left + barRectWidth - amountFull, b.top, barWidth, barHeight, fillColorScheme, false);
                    }
                }
            } else {
                int barWidth = this.progressBar.getHeight() - b.bottom - amountFull;
                int barHeight = barRectWidth;
                if (barWidth > 0 && barHeight > 0) {
                    SubstanceImageCreator.paintProgressBar(g, b.left, barWidth, barHeight, amountFull, fillColorScheme, true);
                }
            }
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    public void paintIndeterminate(Graphics g, JComponent c) {
        ColorScheme fillColorScheme;
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int valComplete = this.animationIndex;
        Graphics2D graphics = (Graphics2D)g;
        if (this.progressBar.getOrientation() == 0) {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth, barRectHeight + 1, SubstanceCoreUtilities.getDisabledScheme(this.progressBar), null, 0, false);
        } else {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth + 1, barRectHeight, SubstanceCoreUtilities.getDisabledScheme(this.progressBar), null, 0, true);
        }
        ColorScheme colorScheme = fillColorScheme = this.progressBar.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(this.progressBar) : SubstanceCoreUtilities.getDefaultScheme(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth, barRectHeight + 1, fillColorScheme, SubstanceProgressBarUI.getStripe(barRectHeight + 1, false, fillColorScheme), valComplete, false);
        } else {
            SubstanceImageCreator.paintRectangularStripedBackground(graphics, b.left, b.top, barRectWidth + 1, barRectHeight, fillColorScheme, SubstanceProgressBarUI.getStripe(barRectWidth + 1, true, fillColorScheme), 2 * barRectWidth + 1 - valComplete, true);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, barRectWidth, b);
        }
    }

    protected void incrementAnimationIndex() {
        int newValue = this.animationIndex + 1;
        Insets b = this.progressBar.getInsets();
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int threshold = 0;
        threshold = this.progressBar.getOrientation() == 0 ? 2 * barRectHeight + 1 : 2 * barRectWidth + 1;
        this.animationIndex = newValue % threshold;
        this.progressBar.repaint();
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceProgressBarUI: \n");
        sb.append("\t" + stripeMap.size() + " stripes");
        return sb.toString();
    }

    protected int getAmountFull(Insets b, int width, int height) {
        int amountFull = 0;
        BoundedRangeModel model = this.progressBar.getModel();
        long span = model.getMaximum() - model.getMinimum();
        double currentValue = model.getValue();
        FadeTracker fadeTracker = FadeTracker.getInstance();
        if (fadeTracker.isTracked(this.progressBar, PROGRESS_BAR_VALUE_CHANGED)) {
            double fade10 = fadeTracker.getFade10(this.progressBar, PROGRESS_BAR_VALUE_CHANGED);
            int from = (Integer)this.progressBar.getClientProperty(PROGRESS_BAR_FROM);
            int to = (Integer)this.progressBar.getClientProperty(PROGRESS_BAR_TO);
            currentValue = from + (int)(fade10 * (double)(to - from) / 10.0);
        }
        double percentComplete = (currentValue - (double)model.getMinimum()) / (double)span;
        if (model.getMaximum() - model.getMinimum() != 0) {
            amountFull = this.progressBar.getOrientation() == 0 ? (int)Math.round((double)width * percentComplete) : (int)Math.round((double)height * percentComplete);
        }
        return amountFull;
    }
}

