/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.tabbed;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JTabbedPane;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.tabbed.TabPreviewPainter;

public class DefaultTabPreviewPainter
extends TabPreviewPainter {
    public boolean hasPreview(JTabbedPane tabPane, int tabIndex) {
        return tabPane.getComponentAt(tabIndex) != null;
    }

    public void previewTab(JTabbedPane tabPane, int tabIndex, Graphics g, int x, int y, int w, int h) {
        Component tabComponent = tabPane.getComponentAt(tabIndex);
        if (tabComponent == null) {
            return;
        }
        int compWidth = tabComponent.getWidth();
        int compHeight = tabComponent.getHeight();
        if (compWidth > 0 && compHeight > 0) {
            BufferedImage tempCanvas = new BufferedImage(compWidth, compHeight, 2);
            Graphics tempCanvasGraphics = tempCanvas.getGraphics();
            tabComponent.paint(tempCanvasGraphics);
            double coef = Math.min((double)w / (double)compWidth, (double)h / (double)compHeight);
            if (coef < 1.0) {
                int sdWidth = (int)(coef * (double)compWidth);
                int sdHeight = (int)(coef * (double)compHeight);
                int dx = (w - sdWidth) / 2;
                int dy = (h - sdHeight) / 2;
                g.drawImage(LafWidgetUtilities.createThumbnail(tempCanvas, sdWidth), dx, dy, null);
            } else {
                g.drawImage(tempCanvas, 0, 0, null);
            }
        }
    }

    public boolean hasPreviewWindow(JTabbedPane tabPane, int tabIndex) {
        return true;
    }

    public boolean hasOverviewDialog(JTabbedPane tabPane) {
        return true;
    }
}

