/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.AVR;
import avr8_burn_o_mat.ActionThread;
import avr8_burn_o_mat.CustomTableCellRenderer;
import avr8_burn_o_mat.Fuse;
import avr8_burn_o_mat.FusesEditor;
import avr8_burn_o_mat.FusesObservable;
import avr8_burn_o_mat.FusesObserver;
import avr8_burn_o_mat.JPanelBrownOutDetection;
import avr8_burn_o_mat.JPanelFusesHexEditor;
import avr8_burn_o_mat.JPanelOscillatorOptions;
import avr8_burn_o_mat.TableModelFuses;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class JPanelFuses
extends JPanel
implements ActionThread.Observer,
FusesEditor,
FusesObserver {
    private TableModelFuses m_tableModelFuses;
    private AVR m_avr;
    private ActionThread m_actionThread;
    private JPanelBrownOutDetection m_panelBrownOutDetection;
    private JPanelFusesHexEditor m_panelFusesHexEditor;
    private JPanelOscillatorOptions m_panelOscillatorOptions;
    private FusesObservable m_fusesObservable;
    private JButton jButtonReadFuses;
    private JButton jButtonResetToDefault;
    private JButton jButtonVerifyFuses;
    private JButton jButtonWriteFuses;
    private JComboBox jComboBoxMode;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPaneBrownOutDetection;
    private JScrollPane jScrollPaneFuseHexEdit;
    private JScrollPane jScrollPaneFuseList;
    private JScrollPane jScrollPaneOscillatorOptions;
    private JTabbedPane jTabbedPaneFuses;
    private JTable jTableAvr;

    public JPanelFuses(ActionThread actionThread) {
        this.m_actionThread = actionThread;
        this.m_fusesObservable = new FusesObservable();
        this.m_fusesObservable.addObserver(this);
        this.m_tableModelFuses = new TableModelFuses(this);
        this.initComponents();
        if (this.m_actionThread != null) {
            this.m_actionThread.m_observable.addObserver(this);
        } else {
            this.jButtonReadFuses.setEnabled(false);
            this.jButtonWriteFuses.setEnabled(false);
            this.jButtonVerifyFuses.setEnabled(false);
        }
        this.m_panelBrownOutDetection = new JPanelBrownOutDetection(this);
        this.jScrollPaneBrownOutDetection.setViewportView(this.m_panelBrownOutDetection);
        this.m_panelFusesHexEditor = new JPanelFusesHexEditor(this);
        this.jScrollPaneFuseHexEdit.setViewportView(this.m_panelFusesHexEditor);
        this.jTableAvr.setModel(this.m_tableModelFuses);
        this.jTableAvr.setDefaultRenderer(String.class, new CustomTableCellRenderer(this.m_tableModelFuses));
        this.jTableAvr.getTableHeader().setReorderingAllowed(false);
    }

    public void setFuse(String fuseName, Fuse.FuseState fuseState) throws Exception {
        if (this.m_avr == null) {
            throw new Exception("Internal error: MCU not set!");
        }
        Vector<Fuse> fuseList = this.m_avr.getFuseList();
        for (Fuse fuse : fuseList) {
            if (!fuse.getName().equals(fuseName)) continue;
            fuse.setFuseState(fuseState);
            return;
        }
        throw new Exception("Internal error: invalid fuse name: " + fuseName);
    }

    public Fuse.FuseState getFuse(String fuseName) throws Exception {
        if (this.m_avr == null) {
            throw new Exception("Internal error: MCU not set!");
        }
        Vector<Fuse> fuseList = this.m_avr.getFuseList();
        for (Fuse fuse : fuseList) {
            if (!fuse.getName().equals(fuseName)) continue;
            return fuse.getFuseState();
        }
        throw new Exception("Internal error: invalid fuse name: " + fuseName);
    }

    public FusesObservable getFusesObservable() {
        return this.m_fusesObservable;
    }

    public void fusesChanged() {
        this.m_tableModelFuses.fuseListUpdate();
        this.packColumns();
    }

    public void actionThreadStateChanged(ActionThread.Action newState) {
        final ActionThread.Action newStateTmp = newState;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanelFuses.this.setState(newStateTmp);
            }
        });
    }

    public void setState(ActionThread.Action state) {
        switch (state) {
            case IDLE: {
                this.jButtonReadFuses.setEnabled(true);
                this.jButtonWriteFuses.setEnabled(true);
                this.jButtonVerifyFuses.setEnabled(true);
                this.jButtonResetToDefault.setEnabled(true);
                this.jComboBoxMode.setEnabled(true);
                this.jTableAvr.setEnabled(true);
                this.jTabbedPaneFuses.setEnabled(true);
                this.m_fusesObservable.fusesChanged(this);
                break;
            }
            default: {
                this.jButtonReadFuses.setEnabled(false);
                this.jButtonWriteFuses.setEnabled(false);
                this.jButtonVerifyFuses.setEnabled(false);
                this.jButtonResetToDefault.setEnabled(false);
                this.jComboBoxMode.setEnabled(false);
                this.jTableAvr.setEnabled(false);
                this.jTabbedPaneFuses.setEnabled(false);
            }
        }
    }

    public void setAVR(AVR avr) {
        this.m_avr = avr;
        this.m_tableModelFuses.setFuseList(this.m_avr.getFuseList());
        this.packColumns();
        this.m_panelBrownOutDetection.setAVR(avr);
        this.m_panelFusesHexEditor.setAVR(avr);
        this.setAvrOscillatorOptions(avr);
        this.validate();
        this.repaint();
    }

    public AVR getAVR() {
        return this.m_avr;
    }

    private void setAvrOscillatorOptions(AVR avr) {
        this.jScrollPaneOscillatorOptions.getViewport().removeAll();
        if (this.m_panelOscillatorOptions != null) {
            this.m_panelOscillatorOptions.destroy();
        }
        this.m_panelOscillatorOptions = null;
        if (avr.getOscillatorOptions() != null) {
            this.m_panelOscillatorOptions = avr.getOscillatorOptions().createPanel(this);
            this.jScrollPaneOscillatorOptions.setViewportView(this.m_panelOscillatorOptions);
        } else {
            this.jScrollPaneOscillatorOptions.setViewportView(new JLabel("not supported for selected MCU"));
        }
    }

    private void packColumns() {
        for (int c = 0; c < this.jTableAvr.getColumnCount(); ++c) {
            this.packColumn(this.jTableAvr, c, 5);
        }
    }

    private void packColumn(JTable table, int vColIndex, int margin) {
        TableModel model = table.getModel();
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn col = colModel.getColumn(vColIndex);
        int width = 0;
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        width = comp.getPreferredSize().width;
        for (int r = 0; r < table.getRowCount(); ++r) {
            renderer = table.getCellRenderer(r, vColIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        col.setPreferredWidth(width += 2 * margin);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButtonReadFuses = new JButton();
        this.jButtonWriteFuses = new JButton();
        this.jButtonVerifyFuses = new JButton();
        this.jButtonResetToDefault = new JButton();
        this.jComboBoxMode = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTabbedPaneFuses = new JTabbedPane();
        this.jScrollPaneFuseList = new JScrollPane();
        this.jTableAvr = new JTable();
        this.jScrollPaneFuseHexEdit = new JScrollPane();
        this.jScrollPaneBrownOutDetection = new JScrollPane();
        this.jScrollPaneOscillatorOptions = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0, 10, 10));
        this.jButtonReadFuses.setText("read fuses");
        this.jButtonReadFuses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelFuses.this.jButtonReadFusesActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonReadFuses);
        this.jButtonWriteFuses.setText("write fuses");
        this.jButtonWriteFuses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelFuses.this.jButtonWriteFusesActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonWriteFuses);
        this.jButtonVerifyFuses.setText("verify fuses");
        this.jButtonVerifyFuses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelFuses.this.jButtonVerifyFusesActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonVerifyFuses);
        this.jButtonResetToDefault.setText("reset to default");
        this.jButtonResetToDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelFuses.this.jButtonResetToDefaultActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonResetToDefault);
        this.jComboBoxMode.setModel(new DefaultComboBoxModel<String>(new String[]{"Mode: normal", "Mode: expert"}));
        this.jComboBoxMode.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JPanelFuses.this.jComboBoxModeItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.jComboBoxMode);
        this.add((Component)this.jPanel1, "North");
        this.jPanel2.setPreferredSize(new Dimension(10, 50));
        this.jPanel2.setLayout(new GridLayout(2, 1, 5, 5));
        this.jLabel1.setText("checked means programmed (bit = 0)");
        this.jPanel2.add(this.jLabel1);
        this.jLabel2.setText("unchecked means unprogrammed (bit = 1)");
        this.jPanel2.add(this.jLabel2);
        this.add((Component)this.jPanel2, "South");
        this.jTableAvr.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTableAvr.setAutoResizeMode(0);
        this.jTableAvr.setIntercellSpacing(new Dimension(3, 3));
        this.jTableAvr.setSelectionForeground(new Color(0, 0, 0));
        this.jTableAvr.setSelectionMode(0);
        this.jScrollPaneFuseList.setViewportView(this.jTableAvr);
        this.jTabbedPaneFuses.addTab("Fuse Editor", this.jScrollPaneFuseList);
        this.jTabbedPaneFuses.addTab("Fuse Hex Editor", this.jScrollPaneFuseHexEdit);
        this.jTabbedPaneFuses.addTab("Brown out detection", this.jScrollPaneBrownOutDetection);
        this.jTabbedPaneFuses.addTab("Oscillator/Clock Options", this.jScrollPaneOscillatorOptions);
        this.add((Component)this.jTabbedPaneFuses, "Center");
    }

    private void jButtonReadFusesActionPerformed(ActionEvent evt) {
        try {
            if (this.m_actionThread != null) {
                this.m_actionThread.readFuses(this.m_avr);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error reading Fuses: " + e.getMessage());
        }
    }

    private void jButtonWriteFusesActionPerformed(ActionEvent evt) {
        try {
            if (this.m_actionThread != null) {
                this.m_actionThread.writeFuses(this.m_avr);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error writing Fuses: " + e.getMessage());
        }
    }

    private void jButtonResetToDefaultActionPerformed(ActionEvent evt) {
        this.m_tableModelFuses.resetToDefault();
        this.m_fusesObservable.fusesChanged(this);
    }

    private void jComboBoxModeItemStateChanged(ItemEvent evt) {
        String s = (String)this.jComboBoxMode.getSelectedItem();
        if (s.equals("Mode: expert")) {
            this.m_tableModelFuses.setFuseMode(Fuse.FuseMode.EXPERT);
        } else {
            this.m_tableModelFuses.setFuseMode(Fuse.FuseMode.NORMAL);
        }
        this.packColumns();
    }

    private void jButtonVerifyFusesActionPerformed(ActionEvent evt) {
        try {
            if (this.m_actionThread != null) {
                this.m_actionThread.verifyFuses(this.m_avr);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error verifying Fuses: " + e.getMessage());
        }
    }
}

