/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.AVR;
import avr8_burn_o_mat.ActionThread;
import avr8_burn_o_mat.FileFilterXml;
import avr8_burn_o_mat.JPanelFuses;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;

public class FormFuses
extends JFrame {
    private JFileChooser m_fileChooserFuses = new JFileChooser();
    private AVR m_avr;
    private JPanelFuses m_panelFuses;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JSeparator jSeparator1;

    public FormFuses(ActionThread actionThread) {
        this.m_fileChooserFuses.setFileFilter(new FileFilterXml());
        this.initComponents();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("AVR8_Burn-O-Mat_Icon_16.png"));
        this.m_panelFuses = new JPanelFuses(actionThread);
        this.add(this.m_panelFuses);
        this.loadPreferences();
    }

    public void setAVR(AVR avr) {
        this.m_avr = avr;
        this.setTitle(this.m_avr.getCaption() + " Fuses");
        this.m_panelFuses.setAVR(avr);
        this.validate();
        this.repaint();
    }

    public void savePreferences() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            prefs.putInt("FormFuses_Width", this.getWidth());
            prefs.putInt("FormFuses_Height", this.getHeight());
            prefs.putInt("FormFuses_PosX", this.getX());
            prefs.putInt("FormFuses_PosY", this.getY());
            prefs.put("FileDialogLastDirFuses", this.m_fileChooserFuses.getCurrentDirectory().getPath());
            prefs.flush();
        }
        catch (Exception e) {
            System.err.println("Error while saving preferences: " + e.getMessage());
        }
    }

    public void loadPreferences() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            int w = prefs.getInt("FormFuses_Width", 600);
            int h = prefs.getInt("FormFuses_Height", 500);
            this.setSize(w, h);
            this.setPreferredSize(new Dimension(w, h));
            this.setLocation(prefs.getInt("FormFuses_PosX", 100), prefs.getInt("FormFuses_PosY", 100));
            String s = prefs.get("FileDialogLastDirFuses", "");
            if (s.length() > 0) {
                this.m_fileChooserFuses.setCurrentDirectory(new File(s));
            }
        }
        catch (Exception e) {
            System.err.println("Error while loading preferences: " + e.getMessage());
        }
    }

    private void initComponents() {
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItem3 = new JMenuItem();
        this.setTitle("Fuses");
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.jMenu1.setText("File");
        this.jMenuItem1.setText("save fuses to file");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormFuses.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setText("load fuses from file");
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormFuses.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenu1.add(this.jSeparator1);
        this.jMenuItem3.setText("close");
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormFuses.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        try {
            int state = this.m_fileChooserFuses.showOpenDialog(this);
            if (state == 0) {
                this.m_avr.loadFusesStateFromXml(this.m_fileChooserFuses.getSelectedFile());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error reading fuses from file: " + e.getMessage());
        }
        this.m_panelFuses.fusesChanged();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        try {
            int state = this.m_fileChooserFuses.showSaveDialog(this);
            if (state == 0) {
                this.m_avr.saveFusesStateToXml(this.m_fileChooserFuses.getSelectedFile());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error writing fuses to file! " + e.getMessage());
        }
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

