/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.AvrdudeControl;
import avr8_burn_o_mat.AvrdudeProgrammer;
import avr8_burn_o_mat.FileFilterAvrdude;
import avr8_burn_o_mat.FileFilterAvrdudeConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FormAvrdudeSettings
extends JFrame {
    private AvrdudeControl m_avrdudeCtrl;
    private JFileChooser m_fileChooserAvrdude = new JFileChooser();
    private JFileChooser m_fileChooserAvrdudeConfig = new JFileChooser();
    private JButton jButtonApply;
    private JButton jButtonAvrdude;
    private JButton jButtonAvrdudeConfig;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JCheckBox jCheckBoxDisableAutoErase;
    private JCheckBox jCheckBoxDisableFuseCheck;
    private JCheckBox jCheckBoxExitSpec;
    private JCheckBox jCheckBoxLeftResetActivated;
    private JCheckBox jCheckBoxLeftVccActivated;
    private JComboBox jComboBoxPort;
    private JComboBox jComboBoxProgrammer;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldAdditionalOptions;
    private JTextField jTextFieldAvrdude;
    private JTextField jTextFieldAvrdudeConfig;

    public FormAvrdudeSettings(AvrdudeControl avrdudeCtrl) {
        this.m_avrdudeCtrl = avrdudeCtrl;
        this.m_fileChooserAvrdude.setFileFilter(new FileFilterAvrdude());
        this.m_fileChooserAvrdudeConfig.setFileFilter(new FileFilterAvrdudeConfig());
        this.initComponents();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("AVR8_Burn-O-Mat_Icon_16.png"));
        this.setPreferredSize(new Dimension(600, 500));
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows")) {
            this.jComboBoxPort.addItem("lpt1");
            this.jComboBoxPort.addItem("lpt2");
            this.jComboBoxPort.addItem("lpt3");
            this.jComboBoxPort.addItem("lpt4");
            this.jComboBoxPort.addItem("lpt5");
            this.jComboBoxPort.addItem("lpt6");
            this.jComboBoxPort.addItem("lpt7");
            this.jComboBoxPort.addItem("lpt8");
            this.jComboBoxPort.addItem("com1");
            this.jComboBoxPort.addItem("com2");
            this.jComboBoxPort.addItem("com3");
            this.jComboBoxPort.addItem("com4");
            this.jComboBoxPort.addItem("com5");
            this.jComboBoxPort.addItem("com6");
            this.jComboBoxPort.addItem("com7");
            this.jComboBoxPort.addItem("com8");
        } else {
            this.jComboBoxPort.addItem("/dev/parport0");
            this.jComboBoxPort.addItem("/dev/parport1");
            this.jComboBoxPort.addItem("/dev/parport2");
            this.jComboBoxPort.addItem("/dev/parport3");
            this.jComboBoxPort.addItem("/dev/parport4");
            this.jComboBoxPort.addItem("/dev/parport5");
            this.jComboBoxPort.addItem("/dev/parport6");
            this.jComboBoxPort.addItem("/dev/parport7");
            this.jComboBoxPort.addItem("/dev/ttyUSB0");
            this.jComboBoxPort.addItem("/dev/ttyS0");
            this.jComboBoxPort.addItem("/dev/ttyS1");
            this.jComboBoxPort.addItem("/dev/ttyS2");
            this.jComboBoxPort.addItem("/dev/ttyS3");
            this.jComboBoxPort.addItem("/dev/ttyS4");
            this.jComboBoxPort.addItem("/dev/ttyS5");
            this.jComboBoxPort.addItem("/dev/ttyS6");
            this.jComboBoxPort.addItem("/dev/ttyS7");
        }
        this.jComboBoxPort.addItem("usb");
        this.loadPreferences();
    }

    private void updateProgrammerList() throws IOException {
        this.jComboBoxProgrammer.removeAllItems();
        Vector<AvrdudeProgrammer> items = new Vector<AvrdudeProgrammer>();
        for (AvrdudeProgrammer p : this.m_avrdudeCtrl.getProgrammerList()) {
            items.add(p);
        }
        Collections.sort(items);
        for (AvrdudeProgrammer p : items) {
            this.jComboBoxProgrammer.addItem(p);
        }
    }

    public void savePreferences() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            prefs.putInt("FormAvrdudeSettings_Width", this.getWidth());
            prefs.putInt("FormAvrdudeSettings_Height", this.getHeight());
            prefs.putInt("FormAvrdudeSettings_PosX", this.getX());
            prefs.putInt("FormAvrdudeSettings_PosY", this.getY());
            prefs.flush();
        }
        catch (Exception e) {
            System.err.println("Error while saving preferences: " + e.getMessage());
        }
    }

    public void loadPreferences() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            int w = prefs.getInt("FormAvrdudeSettings_Width", 600);
            int h = prefs.getInt("FormAvrdudeSettings_Height", 500);
            this.setSize(w, h);
            this.setPreferredSize(new Dimension(w, h));
            this.setLocation(prefs.getInt("FormAvrdudeSettings_PosX", 100), prefs.getInt("FormAvrdudeSettings_PosY", 100));
        }
        catch (Exception e) {
            System.err.println("Error while loading preferences: " + e.getMessage());
        }
    }

    private void applyChanges() {
        try {
            AvrdudeProgrammer programmer = (AvrdudeProgrammer)this.jComboBoxProgrammer.getSelectedItem();
            String port = (String)this.jComboBoxPort.getSelectedItem();
            this.m_avrdudeCtrl.setAvrdude(this.jTextFieldAvrdude.getText());
            this.m_avrdudeCtrl.setAvrdudeConfig(this.jTextFieldAvrdudeConfig.getText());
            this.m_avrdudeCtrl.setProgrammer(programmer);
            this.m_avrdudeCtrl.setPort(port);
            this.m_avrdudeCtrl.setDisableAutoErase(this.jCheckBoxDisableAutoErase.isSelected());
            this.m_avrdudeCtrl.setDisableFuseCheck(this.jCheckBoxDisableFuseCheck.isSelected());
            this.m_avrdudeCtrl.setExitSpecActivated(this.jCheckBoxExitSpec.isSelected());
            this.m_avrdudeCtrl.setLeftResetActivated(this.jCheckBoxLeftResetActivated.isSelected());
            this.m_avrdudeCtrl.setLeftVccActivated(this.jCheckBoxLeftVccActivated.isSelected());
            this.m_avrdudeCtrl.setAdditionalOptions(this.jTextFieldAdditionalOptions.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error applying changes: " + e.getMessage());
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldAvrdude = new JTextField();
        this.jButtonAvrdude = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldAvrdudeConfig = new JTextField();
        this.jButtonAvrdudeConfig = new JButton();
        this.jPanel1 = new JPanel();
        this.jComboBoxPort = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jComboBoxProgrammer = new JComboBox();
        this.jCheckBoxDisableAutoErase = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jTextFieldAdditionalOptions = new JTextField();
        this.jLabel6 = new JLabel();
        this.jCheckBoxExitSpec = new JCheckBox();
        this.jCheckBoxLeftResetActivated = new JCheckBox();
        this.jCheckBoxLeftVccActivated = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jCheckBoxDisableFuseCheck = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonApply = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("AVRDUDE Settings");
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                FormAvrdudeSettings.this.formComponentShown(evt);
            }
        });
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel1.setText("AVRDUDE location");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.jPanel4.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel4.add((Component)this.jTextFieldAvrdude, gridBagConstraints);
        this.jButtonAvrdude.setText("File");
        this.jButtonAvrdude.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormAvrdudeSettings.this.jButtonAvrdudeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.jPanel4.add((Component)this.jButtonAvrdude, gridBagConstraints);
        this.jLabel2.setText("alternative AVRDUDE configuration file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.jPanel4.add((Component)this.jLabel2, gridBagConstraints);
        this.jTextFieldAvrdudeConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormAvrdudeSettings.this.jTextFieldAvrdudeConfigActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel4.add((Component)this.jTextFieldAvrdudeConfig, gridBagConstraints);
        this.jButtonAvrdudeConfig.setText("File");
        this.jButtonAvrdudeConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormAvrdudeSettings.this.jButtonAvrdudeConfigActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.jPanel4.add((Component)this.jButtonAvrdudeConfig, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("AVRDUDE Options"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jComboBoxPort.setEditable(true);
        this.jComboBoxPort.setMinimumSize(new Dimension(150, 23));
        this.jComboBoxPort.setPreferredSize(new Dimension(150, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.jPanel1.add((Component)this.jComboBoxPort, gridBagConstraints);
        this.jLabel3.setText("Programmer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.jComboBoxProgrammer.setMinimumSize(new Dimension(200, 23));
        this.jComboBoxProgrammer.setPreferredSize(new Dimension(200, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.jPanel1.add((Component)this.jComboBoxProgrammer, gridBagConstraints);
        this.jCheckBoxDisableAutoErase.setText("disable auto erase for flash (-D)");
        this.jCheckBoxDisableAutoErase.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanel1.add((Component)this.jCheckBoxDisableAutoErase, gridBagConstraints);
        this.jLabel5.setText("additional options");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.jTextFieldAdditionalOptions.setMinimumSize(new Dimension(65, 25));
        this.jTextFieldAdditionalOptions.setPreferredSize(new Dimension(65, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.jPanel1.add((Component)this.jTextFieldAdditionalOptions, gridBagConstraints);
        this.jLabel6.setText("(port can be entered directly if not in list)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.jCheckBoxExitSpec.setText("Exit specification (-E)");
        this.jCheckBoxExitSpec.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                FormAvrdudeSettings.this.jCheckBoxExitSpecStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.jPanel1.add((Component)this.jCheckBoxExitSpec, gridBagConstraints);
        this.jCheckBoxLeftResetActivated.setText("reset will be left activated on program exit (-E reset)");
        this.jCheckBoxLeftResetActivated.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.jPanel1.add((Component)this.jCheckBoxLeftResetActivated, gridBagConstraints);
        this.jCheckBoxLeftVccActivated.setText("VCC will be left activated on exit (-E vcc)");
        this.jCheckBoxLeftVccActivated.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.jPanel1.add((Component)this.jCheckBoxLeftVccActivated, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.jCheckBoxDisableFuseCheck.setText("disable fuse check (-u)");
        this.jCheckBoxDisableFuseCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.jPanel1.add((Component)this.jCheckBoxDisableFuseCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanel4.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jButtonOk.setText("Ok");
        this.jButtonOk.setPreferredSize(new Dimension(75, 25));
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormAvrdudeSettings.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonOk, gridBagConstraints);
        this.jButtonApply.setText("Apply");
        this.jButtonApply.setPreferredSize(new Dimension(75, 25));
        this.jButtonApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormAvrdudeSettings.this.jButtonApplyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonApply, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormAvrdudeSettings.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanel4.add((Component)this.jPanel2, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jPanel4);
        this.getContentPane().add(this.jScrollPane1);
        this.pack();
    }

    private void jTextFieldAvrdudeConfigActionPerformed(ActionEvent evt) {
        try {
            this.updateProgrammerList();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error loading AVRDUDE config file: " + e.getMessage());
        }
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.applyChanges();
        this.setVisible(false);
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        this.applyChanges();
    }

    private void formComponentShown(ComponentEvent evt) {
        try {
            this.updateProgrammerList();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error loading AVRDUDE config file: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.jTextFieldAvrdude.setText(this.m_avrdudeCtrl.getAvrdude());
            this.jTextFieldAvrdudeConfig.setText(this.m_avrdudeCtrl.getAvrdudeConfig());
            this.jComboBoxProgrammer.setSelectedItem(this.m_avrdudeCtrl.getProgrammer());
            this.jComboBoxPort.setSelectedItem(this.m_avrdudeCtrl.getPort());
            this.jCheckBoxDisableAutoErase.setSelected(this.m_avrdudeCtrl.getDisableAutoErase());
            this.jCheckBoxDisableFuseCheck.setSelected(this.m_avrdudeCtrl.getDisableFuseCheck());
            this.jCheckBoxExitSpec.setSelected(this.m_avrdudeCtrl.getExitSpecActivated());
            this.jCheckBoxLeftResetActivated.setSelected(this.m_avrdudeCtrl.getLeftResetActivated());
            this.jCheckBoxLeftVccActivated.setSelected(this.m_avrdudeCtrl.getLeftVccActivated());
            this.jTextFieldAdditionalOptions.setText(this.m_avrdudeCtrl.getAdditionalOptions());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    private void jButtonAvrdudeConfigActionPerformed(ActionEvent evt) {
        int state = this.m_fileChooserAvrdudeConfig.showOpenDialog(null);
        if (state == 0) {
            File file = this.m_fileChooserAvrdudeConfig.getSelectedFile();
            this.jTextFieldAvrdudeConfig.setText(file.getPath());
        }
        try {
            this.updateProgrammerList();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error loading AVRDUDE config file: " + e.getMessage());
        }
    }

    private void jButtonAvrdudeActionPerformed(ActionEvent evt) {
        int state = this.m_fileChooserAvrdude.showOpenDialog(null);
        if (state == 0) {
            File file = this.m_fileChooserAvrdude.getSelectedFile();
            this.jTextFieldAvrdude.setText(file.getPath());
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jCheckBoxExitSpecStateChanged(ChangeEvent evt) {
        boolean enabled = this.jCheckBoxExitSpec.isSelected();
        this.jCheckBoxLeftResetActivated.setEnabled(enabled);
        this.jCheckBoxLeftVccActivated.setEnabled(enabled);
    }
}

