/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.Fuse;
import avr8_burn_o_mat.XmlUtil;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrownOutDetection {
    private Vector<Fuse> m_fuseList = new Vector();
    public Vector<Setting> m_settingList = new Vector();

    private BrownOutDetection() {
    }

    public int getSettingIndexFromFusesState() {
        for (int idx = 0; idx < this.m_settingList.size(); ++idx) {
            if (!this.m_settingList.elementAt(idx).fusesEqual(this.m_fuseList)) continue;
            return idx;
        }
        return -1;
    }

    public void applyFusesFromSetting(int idx) {
        this.m_settingList.elementAt(idx).applyFusesFromSetting(this.m_fuseList);
    }

    public static BrownOutDetection createFromXmlNode(Vector<Fuse> fuseList, Node node) throws Exception {
        BrownOutDetection bod = new BrownOutDetection();
        bod.loadFromXml(fuseList, node);
        return bod;
    }

    private void loadFromXml(Vector<Fuse> fuseList, Node node) throws Exception {
        this.readFusesFromXml(node, fuseList);
        this.readSettingsFromXml(node);
    }

    private void readFusesFromXml(Node node, Vector<Fuse> fuseList) throws Exception, DOMException {
        this.m_fuseList.clear();
        for (Node nodeFuse = node.getFirstChild(); nodeFuse != null; nodeFuse = nodeFuse.getNextSibling()) {
            if (!nodeFuse.getNodeName().equals("Fuse")) continue;
            String name = XmlUtil.getAttr(nodeFuse, "name");
            boolean found = false;
            for (Fuse f : fuseList) {
                if (!f.getName().equals(name)) continue;
                this.m_fuseList.add(f);
                found = true;
                break;
            }
            if (found) continue;
            throw new Exception("brown out detection fuse not found: " + name);
        }
        if (this.m_fuseList.size() == 0) {
            throw new Exception("error in brown out detection description, no fuses defined");
        }
    }

    private void readSettingsFromXml(Node node) throws Exception {
        this.m_settingList.clear();
        for (Node nodeSetting = node.getFirstChild(); nodeSetting != null; nodeSetting = nodeSetting.getNextSibling()) {
            if (!nodeSetting.getNodeName().equals("Setting")) continue;
            Setting setting = new Setting(XmlUtil.getAttr(nodeSetting, "caption"));
            for (int idx = 0; idx < this.m_fuseList.size(); ++idx) {
                FuseSetting fuseSetting;
                block9: {
                    String fuseSettingStr = XmlUtil.getAttr(nodeSetting, String.format("Fuse%d", idx + 1));
                    if (fuseSettingStr.isEmpty()) {
                        fuseSetting = FuseSetting.IGNORED;
                    } else {
                        try {
                            int n = Integer.parseInt(fuseSettingStr);
                            if (n == 0) {
                                fuseSetting = FuseSetting.PROGRAMMED;
                                break block9;
                            }
                            if (n == 1) {
                                fuseSetting = FuseSetting.UNPROGRAMMED;
                                break block9;
                            }
                            throw new Exception("fuse state must be 0 or 1");
                        }
                        catch (NumberFormatException e) {
                            throw new Exception("Fuse state is not a number!");
                        }
                    }
                }
                setting.m_fuseSettings.add(fuseSetting);
            }
            if (this.m_fuseList.size() != setting.m_fuseSettings.size()) {
                throw new Exception("internal error BrownOutDetection.readSettingsFromXml");
            }
            this.m_settingList.add(setting);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Setting {
        public Vector<FuseSetting> m_fuseSettings = new Vector();
        private String m_name;

        public Setting(String caption) {
            this.m_name = caption;
        }

        public String getName() {
            return this.m_name;
        }

        public boolean fusesEqual(Vector<Fuse> fuseList) {
            assert (fuseList.size() == this.m_fuseSettings.size());
            block5: for (int idx = 0; idx < fuseList.size(); ++idx) {
                Fuse.FuseState fuseState = fuseList.elementAt(idx).getFuseState();
                switch (this.m_fuseSettings.elementAt(idx)) {
                    case PROGRAMMED: {
                        if (fuseState == Fuse.FuseState.PROGRAMMED) continue block5;
                        return false;
                    }
                    case UNPROGRAMMED: {
                        if (fuseState == Fuse.FuseState.UNPROGRAMMED) continue block5;
                        return false;
                    }
                    case IGNORED: {
                        continue block5;
                    }
                    default: {
                        assert (false);
                        continue block5;
                    }
                }
            }
            return true;
        }

        public void applyFusesFromSetting(Vector<Fuse> fuseList) {
            assert (fuseList.size() == this.m_fuseSettings.size());
            block5: for (int idx = 0; idx < fuseList.size(); ++idx) {
                Fuse fuse = fuseList.elementAt(idx);
                switch (this.m_fuseSettings.elementAt(idx)) {
                    case PROGRAMMED: {
                        fuse.setFuseState(Fuse.FuseState.PROGRAMMED);
                        continue block5;
                    }
                    case UNPROGRAMMED: {
                        fuse.setFuseState(Fuse.FuseState.UNPROGRAMMED);
                        continue block5;
                    }
                    case IGNORED: {
                        continue block5;
                    }
                    default: {
                        assert (false);
                        continue block5;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FuseSetting {
        PROGRAMMED,
        UNPROGRAMMED,
        IGNORED;

    }
}

