#ifndef __KONFORKA_PQXX_PILE_H
#define __KONFORKA_PQXX_PILE_H

#include <pqxx/connection>
#include <konforka/resource_pile.h>

/**
 * @file
 * @brief libpqxx-based postgresql connections pile.
 */

namespace konforka {

    /**
     * @brief the base for pqxx-based connection classes.
     *
     * @param pqxxc_t the type of libpqxx connection (pqxx::connection,
     * pqxx::lazyconnection or pqxx::asyncconnection).
     */
    template<typename pqxxc_t>
	class pqxx_piled_connection_base : public resource_pile_base<string,pqxxc_t*, resource_pile_generic_ptr_factory<string,pqxxc_t> > {
	    public:
		/**
		 * @brief the constractor based on connection info.
		 *
		 * @param ci connection info string.
		 */
		pqxx_piled_connection_base(const string& ci)
		    : resource_pile_base<string,pqxxc_t*, resource_pile_generic_ptr_factory<string,pqxxc_t> >(ci) { }
		~pqxx_piled_connection_base() { this->drop(); }

		/**
		 * @brief cast the object to the reference to the corresponding
		 * libpqxx type.
		 */
		operator pqxxc_t&(void) { return *this->get_content(); }
		/**
		 * @brief cast the object to the const reference to the
		 * corresponding libpqxx type.
		 */
		operator const pqxxc_t&(void) const { return *this->get_content(); }
	};

    /**
     * @brief the implementation for piling pqxx::connection objects.
     */
    typedef pqxx_piled_connection_base<pqxx::connection> pqxx_piled_connection;
    /**
     * @brief the implementation for piling pqxx::lazyconnection objects.
     */
    typedef pqxx_piled_connection_base<pqxx::lazyconnection> pqxx_piled_lazy_connection;
    /**
     * @brief the implementation for piling pqxx::asyncconnection objects.
     */
    typedef pqxx_piled_connection_base<pqxx::asyncconnection> pqxx_piled_async_connection;
}

#endif /* __KONFORKA_PQXX_PILE_H */
/* vim:set ft=cpp: */
