/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class Plotter {
    public static final int XW_FINE = 1;
    public static final int XW_THICK = 2;
    public static final float DEFAULTLINE = 1.0f;
    public static final int[][] DASH_LIST = new int[][]{{2, 4, 2, 4}, {4, 4, 4, 4}, {8, 4, 8, 4}, {16, 4, 16, 4}, {12, 4, 2, 4}, {1, 7, 1, 7}};
    public static final int XW_SOLID = 0;
    public static final int XW_SPARSE = 6;
    public static final int MAX_COLOUR = 16;
    public static final int ARRAYSIZE = 1024;
    public static final int XW_MARK_LN = 1;
    public static final int XW_MARK_FAC = 2;
    public static final int OFF = 100;
    public static final int HOR = 100;
    public static final int VUD = 1000;
    public static final int T_RIGHT = 1;
    public static final int T_LEFT = 2;
    public static final int T_CENTRE = 4;
    public static final int T_ABOVE = 8;
    public static final int T_ABOVE_A = 256;
    public static final int T_BELOW = 16;
    public static final int T_BELOW_A = 128;
    public static final int T_BELOW_2 = 512;
    public static final int T_SUPER = 32;
    public static final int T_SUB = 64;
    public static final int ALL = -1;
    public static final float SCALE3D = 0.9f;
    public static final float ROOT2 = 1.4142135f;
    public static final double LOG10e = 0.434294482;
    public static final double DEFAULTLOGMIN = 0.0;
    public static final double D_WEHIRANGE = 256.0;
    public static final int SPLITIVRY = 5;
    public static final int LBLPLACES = 4;
    public static final int SPLITPLACES = 2;
    private boolean w_clip;
    private int w_err;
    private int ixnow;
    private int iynow;
    private int ixmin;
    private int iymin;
    private int ixmax;
    private int iymax;
    private int ix_pix_now;
    private int iy_pix_now;
    private int ix_pix_drag;
    private int iy_pix_drag;
    private Color[] xwColour;
    public int maxColour;
    private int currentColour;
    private int currentWeight;
    private LineStyle[] lineStyles;
    private int currentStyle;
    private int dot_size;
    private int xw_dragging;
    private int xw_drawing;
    private boolean xw_filling;
    private int xw_segging;
    private int xw_pointing;
    private int xw_recting;
    private float xmin;
    private float ymin;
    private float xmax;
    private float ymax;
    private float x3lo;
    private float x3rng;
    private float x3cntr;
    private float xscrnrng;
    private float xscrncntr;
    private float y3lo;
    private float y3rng;
    private float y3cntr;
    private float yscrnrng;
    private float yscrncntr;
    private float z3lo;
    private float z3rng;
    private float z3cntr;
    private float theta;
    private float phi;
    private float ct;
    private float st;
    private float cp;
    private float sp;
    private float xeye;
    private float yeye;
    private float zeye;
    private int xw_line_width;
    private int xw_line_style;
    private int[] xArray;
    private int[] yArray;
    private int nArray;
    private int pX;
    private int pY;
    private int pW;
    private int pH;
    private Color pBg;
    private Color pFg;
    private boolean screenPaint;
    public GDisplay gd;
    public Graphics2D g2;
    public Stroke defStroke;

    public Plotter(GDisplay gd) {
        this.gd = gd;
        this.pH = 0;
        this.pW = 0;
        this.maxColour = 16;
        this.xwColour = new Color[this.maxColour];
        this.setColours();
        this.xArray = new int[1024];
        this.yArray = new int[1024];
        this.defStroke = new BasicStroke(1.0f, 0, 2);
        this.lineStyles = new LineStyle[DASH_LIST.length + 1];
        this.lineStyles[0] = null;
        int i = 1;
        while (i <= DASH_LIST.length) {
            this.lineStyles[i] = new LineStyle(DASH_LIST[i - 1]);
            ++i;
        }
    }

    public void setColours() {
        int i = 0;
        while (i < this.maxColour) {
            if (i == 0) {
                this.xwColour[i] = Color.white;
            } else if (i == 1) {
                this.xwColour[i] = Color.black;
            } else if (i == 14) {
                this.xwColour[i] = Color.lightGray;
            } else if (i >= 15) {
                this.xwColour[i] = Color.darkGray;
            } else {
                float bright = 1.0f;
                float sat = 1.0f;
                float hue = (i - 2) % 3;
                hue += 0.5f * (float)((i - 2) / 3);
                hue -= 0.75f * (float)((i - 2) / 6);
                this.xwColour[i] = Color.getHSBColor(hue /= 3.0f, sat, bright);
            }
            ++i;
        }
    }

    public void set(Graphics g) {
        Dimension d = this.gd.dsp.getSize();
        this.pX = 0;
        this.pY = 0;
        this.pW = d.width;
        this.pH = d.height;
        this.g2 = (Graphics2D)g;
        this.g2.setStroke(this.defStroke);
        this.set_background();
        this.set_colour(1);
    }

    private float clipX(float x) {
        if (x < this.xmin || x > this.xmax) {
            return -1.0f;
        }
        return x;
    }

    private float clipY(float y) {
        if (y < this.ymin || y > this.ymax) {
            return -1.0f;
        }
        return y;
    }

    public float xMax() {
        return this.xmax;
    }

    public float yMax() {
        return this.ymax;
    }

    public float xMin() {
        return this.xmin;
    }

    public float yMin() {
        return this.ymin;
    }

    public int xAbs() {
        return this.pW;
    }

    public int yAbs() {
        return this.pH;
    }

    public int xPos() {
        return this.pX;
    }

    public int yPos() {
        return this.pY;
    }

    public void initPoly() {
        this.nArray = 0;
    }

    public void drawPoly(boolean fill) {
        if (fill) {
            this.g2.fill(new Polygon(this.xArray, this.yArray, this.nArray));
        } else {
            this.g2.draw(new Polygon(this.xArray, this.yArray, this.nArray));
        }
    }

    public GeneralPath makePolyline(int[] xA, int[] yA, int n) {
        GeneralPath path = new GeneralPath(0, n);
        path.moveTo(xA[0], yA[0]);
        int i = 0;
        while (i < n) {
            path.lineTo(xA[i], yA[i]);
            ++i;
        }
        return path;
    }

    public void drawLines() {
        if (this.currentStyle == 0) {
            this.g2.draw(this.makePolyline(this.xArray, this.yArray, this.nArray));
        } else {
            int i = 1;
            while (i < this.nArray) {
                this.drawLine(this.xArray[i - 1], this.yArray[i - 1], this.xArray[i], this.yArray[i]);
                ++i;
            }
        }
    }

    public void drawLine(int i1, int j1, int i2, int j2) {
        if (this.currentStyle == 0) {
            int ihi;
            int jhi;
            int ilo;
            int jlo;
            if (j1 > j2 && i1 == i2 || j1 == j2 && i1 > i2) {
                jlo = j2;
                ilo = i2;
                jhi = j1;
                ihi = i1;
            } else {
                jlo = j1;
                ilo = i1;
                jhi = j2;
                ihi = i2;
            }
            this.g2.draw(new Line2D.Double(ilo, jlo, ihi, jhi));
        } else {
            float len;
            LineStyle style = this.lineStyles[this.currentStyle];
            while ((len = this.distance(i1, j1, i2, j2)) > 0.0f) {
                int remainder = style.array[style.seg] - style.place;
                if ((int)len > remainder) {
                    int i = i1 + Math.round((float)((i2 - i1) * remainder) / len);
                    int j = j1 + Math.round((float)((j2 - j1) * remainder) / len);
                    if ((style.seg & 1) == 0) {
                        this.g2.draw(new Line2D.Double(i1, j1, i, j));
                    }
                    i1 = i;
                    j1 = j;
                    style.place = 0;
                    ++style.seg;
                    style.seg %= style.nSegs;
                    continue;
                }
                if ((style.seg & 1) == 0) {
                    this.g2.draw(new Line2D.Double(i1, j1, i2, j2));
                }
                style.place += (int)len;
                if (style.place < style.array[style.seg]) break;
                style.place = 0;
                ++style.seg;
                style.seg %= style.nSegs;
                break;
            }
        }
    }

    float distance(int i1, int j1, int i2, int j2) {
        return (float)Math.sqrt((i2 - i1) * (i2 - i1) + (j2 - j1) * (j2 - j1));
    }

    public void newpag() {
        this.xw_filling = false;
    }

    public void owindo() {
        this.swindo(0, this.pW, 0, this.pH);
        this.vwindo(0.0f, this.pW, 0.0f, this.pH);
        this.w_clip = true;
    }

    public void fill() {
        this.xw_filling = true;
    }

    void drawa(float x, float y) {
        this.drawa(x, y, false);
    }

    void drawa(float x, float y, boolean defer) {
        int[] iA = this.rescal(x, y);
        this.drwabs(iA[0], iA[1], defer);
    }

    void drawr(float x, float y) {
        this.drawr(x, y, false);
    }

    void drawr(float x, float y, boolean defer) {
        if (this.xmax == this.xmin || this.ymax == this.ymin) {
            return;
        }
        int i = (int)(x * (float)(this.ixmax - this.ixmin) / (this.xmax - this.xmin));
        int j = (int)(y * (float)(this.iymax - this.iymin) / (this.ymax - this.ymin));
        this.drwrel(i, j, defer);
    }

    void drwabs(int i, int j) {
        this.drwabs(i, j, false);
    }

    void drwabs(int i, int j, boolean defer) {
        int old_w_err = this.w_err;
        this.chkbnd(i, j);
        if (this.w_err == 0 && old_w_err == 0) {
            if (defer && this.nArray < 1024) {
                this.xArray[this.nArray] = i;
                this.yArray[this.nArray] = this.pH - j;
                ++this.nArray;
            } else {
                this.drawLine(this.ix_pix_now, this.iy_pix_now, i, this.pH - j);
            }
        }
        if (this.w_err <= 1) {
            this.ixnow = i;
            this.iynow = j;
            this.pixabs(i, j);
        }
    }

    void pixabs(int i, int j) {
        this.ix_pix_drag = this.ix_pix_now = i;
        this.iy_pix_drag = this.iy_pix_now = this.pH - j;
    }

    void drwrel(int i, int j) {
        this.drwrel(i, j, false);
    }

    void drwrel(int i, int j, boolean defer) {
        this.drwabs(i + this.ixnow, j + this.iynow, defer);
    }

    void movrel(int i, int j) {
        this.movabs(i + this.ixnow, j + this.iynow);
    }

    void movea(float x, float y) {
        int[] iA = this.rescal(x, y);
        this.movabs(iA[0], iA[1]);
    }

    void movabs(int i, int j) {
        this.chkbnd(i, j);
        if (this.w_err > 1) {
            j = 0;
            i = 0;
        }
        this.ixnow = i;
        this.iynow = j;
        this.pixabs(i, j);
    }

    void pointa(float x, float y) {
        this.pointa(x, y, 0);
    }

    void pointa(float x, float y, int size) {
        int[] iA = this.rescal(x, y);
        this.pntabs(iA[0], iA[1], size);
    }

    void pntabs(int i, int j) {
        this.pntabs(i, j, 0);
    }

    void pntabs(int i, int j, int wt) {
        boolean circle;
        this.chkbnd(i, j);
        if (this.w_err > 0) {
            return;
        }
        if (wt < 1) {
            wt = this.currentWeight < 1 ? 1 : this.currentWeight;
            wt = wt > 4 ? 4 : wt;
            circle = false;
        } else {
            circle = true;
        }
        int adjust = (wt - 1) / 2;
        if (circle) {
            this.g2.fill(new Ellipse2D.Float(i - adjust, this.pH - j - adjust, wt, wt));
        } else {
            this.g2.fill(new Rectangle(i - adjust, this.pH - j - adjust, wt, wt));
        }
        this.ixnow = i;
        this.iynow = j;
        this.pixabs(i, j);
    }

    public float projection3D(float x, float y, float z, float xv, float yv, float zv) {
        float xe = this.xeye - x;
        float ye = this.yeye - y;
        float ze = this.zeye - z;
        float dot = (xv * xe + yv * ye + zv * ze) / ((float)Math.sqrt(xe * xe + ye * ye + ze * ze) * (float)Math.sqrt(xv * xv + yv * yv + zv * zv));
        return dot;
    }

    public int[] perspective(float x, float y, float z) {
        float x3 = (x - this.x3cntr) * this.ct / this.x3rng - (y - this.y3cntr) * this.st / this.y3rng;
        float y3 = (y - this.y3cntr) * this.ct / this.y3rng + (x - this.x3cntr) * this.st / this.x3rng;
        float z3 = (z - this.z3cntr) * this.cp / this.z3rng + y3 * this.sp;
        float xscrn = x3 + (100.0f / this.xscrnrng - x3) * y3 / (1000.0f / this.yscrnrng + y3);
        float yscrn = z3 + (100.0f / this.yscrnrng - z3) * y3 / (1000.0f / this.yscrnrng + y3);
        int i = (int)(xscrn * this.xscrnrng + this.xscrncntr);
        int j = (int)(yscrn * this.yscrnrng + this.yscrncntr);
        int[] iA = new int[]{i, j};
        return iA;
    }

    public boolean hideZ3() {
        return this.perspective(this.x3lo, this.y3lo, this.z3lo)[0] <= this.perspective(this.x3lo, this.y3lo + this.y3rng, this.z3lo)[0] && this.perspective(this.x3lo + this.x3rng, this.y3lo, this.z3lo)[0] <= this.perspective(this.x3lo, this.y3lo, this.z3lo)[0];
    }

    void drawa3(float x, float y, float z) {
        this.drawa3(x, y, z, false);
    }

    void drawa3(float x, float y, float z, boolean defer) {
        int[] iA = this.perspective(x, y, z);
        this.drwabs(iA[0], iA[1], defer);
    }

    void movea3(float x, float y, float z) {
        int[] iA = this.perspective(x, y, z);
        this.movabs(iA[0], iA[1]);
    }

    void pointa3(float x, float y, float z) {
        this.pointa3(x, y, z, 0);
    }

    void pointa3(float x, float y, float z, int size) {
        int[] iA = this.perspective(x, y, z);
        this.pntabs(iA[0], iA[1], size);
    }

    public void base3(float[] res, float[] evry, double[] minLog, int[] ivry, float theta, float phi, boolean labels, boolean[] split, double[] splitEvry) {
        float ddy;
        int j;
        boolean done;
        int i;
        int ibeg;
        double value;
        float x;
        double factor;
        double offset;
        int minMantissa;
        int minDecade;
        double minValue;
        double maxValue;
        double maxLog;
        double sEvry = 1.0;
        this.vwindo3(0.0f, res[0], 0.0f, res[1], 0.0f, res[2], theta, phi);
        float dy = res[1] / 30.0f;
        if (evry[0] > 0.0f && ivry[0] < 0) {
            maxLog = evry[0];
            maxValue = Math.pow(10.0, maxLog);
            minValue = Math.pow(10.0, minLog[0]);
            minDecade = (int)minLog[0];
            if (minLog[0] < 0.0) {
                --minDecade;
            }
            minMantissa = (int)Math.ceil(Math.pow(10.0, minLog[0] - (double)minDecade));
            if (split[0]) {
                offset = 64.0 * (double)res[0] / 256.0;
                sEvry = 0.5 * splitEvry[0] * offset / minValue;
            } else {
                offset = 0.0;
            }
            factor = ((double)res[0] - offset) / (maxLog - minLog[0]);
            if (split[0]) {
                x = this.x3lo;
                value = -minValue;
                while (value <= minValue) {
                    this.movea3(x, dy * 2.0f, 0.0f);
                    this.drawa3(x, 0.0f, 0.0f);
                    if (labels && (value <= 0.0 || minMantissa > 1)) {
                        this.drwlbl(value, 20, 2);
                    }
                    x = (float)((double)x + offset / 2.0);
                    value += minValue;
                }
                ibeg = (int)(0.5 * offset / sEvry);
                i = -ibeg;
                while (i <= ibeg) {
                    x = this.x3lo + (float)(offset / 2.0) + (float)((double)i * sEvry);
                    this.movea3(x, dy, 0.0f);
                    this.drawa3(x, 0.0f, 0.0f);
                    ++i;
                }
            }
            done = false;
            ibeg = minMantissa;
            j = minDecade;
            while (!done) {
                i = ibeg;
                while (i < 10) {
                    double d;
                    value = (double)i * Math.pow(10.0, j);
                    if (d <= maxValue) {
                        x = (float)((this.log10(value) - minLog[0]) * factor + offset);
                        this.movea3(x, dy, 0.0f);
                        this.drawa3(x, 0.0f, 0.0f);
                        if (labels && i == 1 && (j > minDecade || split[0])) {
                            this.drwlbl(j, true, 20);
                        }
                    } else {
                        done = true;
                        break;
                    }
                    ++i;
                }
                ibeg = 1;
                ++j;
            }
        } else if (evry[0] > 0.0f && ivry[0] > 0) {
            i = 0;
            x = this.x3lo;
            while (x < this.x3lo + this.x3rng) {
                ddy = i % ivry[0] != 0 ? dy : dy * 2.0f;
                this.movea3(x, ddy, 0.0f);
                this.drawa3(x, 0.0f, 0.0f);
                if (labels && i % ivry[0] == 0) {
                    this.drwlbl(Math.round(x), false, 20, 4);
                }
                ++i;
                x += evry[0];
            }
        }
        dy = res[0] / 30.0f;
        if (evry[1] > 0.0f && ivry[1] < 0) {
            float y;
            maxLog = evry[1];
            maxValue = Math.pow(10.0, maxLog);
            minValue = Math.pow(10.0, minLog[1]);
            minDecade = (int)minLog[1];
            if (minLog[1] < 0.0) {
                --minDecade;
            }
            minMantissa = (int)Math.ceil(Math.pow(10.0, minLog[1] - (double)minDecade));
            if (split[1]) {
                offset = 64.0 * (double)res[1] / 256.0;
                sEvry = 0.5 * splitEvry[1] * offset / minValue;
            } else {
                offset = 0.0;
            }
            factor = ((double)res[1] - offset) / (maxLog - minLog[1]);
            if (split[1]) {
                y = this.y3lo;
                value = -minValue;
                while (value <= minValue) {
                    this.movea3(dy * 2.0f, y, 0.0f);
                    this.drawa3(0.0f, y, 0.0f);
                    if (labels && (value <= 0.0 || minMantissa > 1)) {
                        this.drwlbl(value, 20, 2);
                    }
                    y = (float)((double)y + offset / 2.0);
                    value += minValue;
                }
                ibeg = (int)(0.5 * offset / sEvry);
                i = -ibeg;
                while (i <= ibeg) {
                    y = this.y3lo + (float)(offset / 2.0) + (float)((double)i * sEvry);
                    this.movea3(dy, y, 0.0f);
                    this.drawa3(0.0f, y, 0.0f);
                    ++i;
                }
            }
            done = false;
            ibeg = minMantissa;
            j = minDecade;
            while (!done) {
                i = ibeg;
                while (i < 10) {
                    double d;
                    value = (double)i * Math.pow(10.0, j);
                    if (d <= maxValue) {
                        y = (float)((this.log10(value) - minLog[1]) * factor + offset);
                        this.movea3(dy, y, 0.0f);
                        this.drawa3(0.0f, y, 0.0f);
                        if (labels && i == 1 && (j > minDecade || split[1])) {
                            this.drwlbl(j, true, 20);
                        }
                    } else {
                        done = true;
                        break;
                    }
                    ++i;
                }
                ibeg = 1;
                ++j;
            }
        } else if (evry[1] > 0.0f && ivry[1] > 0) {
            i = 0;
            float y = this.y3lo;
            while (y < this.y3lo + this.y3rng) {
                ddy = i % ivry[1] != 0 ? dy : dy * 2.0f;
                this.movea3(ddy, y, 0.0f);
                this.drawa3(0.0f, y, 0.0f);
                if (labels && i % ivry[1] == 0) {
                    this.drwlbl(Math.round(y), false, 20, 4);
                }
                ++i;
                y += evry[1];
            }
        }
        this.movea3(0.0f, res[1], 0.0f);
        this.drawa3(0.0f, 0.0f, 0.0f);
        this.drawa3(res[0], 0.0f, 0.0f);
        this.drawa3(res[0], res[1], 0.0f);
        this.drawa3(0.0f, res[1], 0.0f);
    }

    public void axisZ3(float[] res, float[] evry, double[] minLog, int[] ivry, float theta, float phi, boolean labels, boolean rhs, boolean[] split, double[] splitEvry) {
        double sEvry = 1.0;
        this.vwindo3(0.0f, res[0], 0.0f, res[1], 0.0f, res[2], theta, phi);
        float dx = res[0] / 50.0f;
        int justify = rhs ? 65 : 66;
        if (evry[2] > 0.0f && ivry[2] < 0) {
            int i;
            int ibeg;
            double value;
            float z;
            double offset;
            double maxLog = evry[2];
            double maxValue = Math.pow(10.0, maxLog);
            double minValue = Math.pow(10.0, minLog[2]);
            int minDecade = (int)minLog[2];
            if (minLog[2] < 0.0) {
                --minDecade;
            }
            int minMantissa = (int)Math.ceil(Math.pow(10.0, minLog[2] - (double)minDecade));
            if (split[2]) {
                offset = 64.0 * (double)res[2] / 256.0;
                sEvry = 0.5 * splitEvry[2] * offset / minValue;
            } else {
                offset = 0.0;
            }
            double factor = ((double)res[2] - offset) / (maxLog - minLog[2]);
            if (split[2]) {
                z = this.z3lo;
                value = -minValue;
                while (value <= minValue) {
                    this.movea3(dx * 2.0f, 0.0f, z);
                    this.drawa3(0.0f, 0.0f, z);
                    if (labels && (value <= 0.0 || minMantissa > 1)) {
                        this.drwlbl(value, justify, 2);
                    }
                    z = (float)((double)z + offset / 2.0);
                    value += minValue;
                }
                ibeg = (int)(0.5 * offset / sEvry);
                i = -ibeg;
                while (i <= ibeg) {
                    z = this.z3lo + (float)(offset / 2.0) + (float)((double)i * sEvry);
                    this.movea3(dx, 0.0f, z);
                    this.drawa3(0.0f, 0.0f, z);
                    ++i;
                }
            }
            boolean done = false;
            ibeg = minMantissa;
            int j = minDecade;
            while (!done) {
                i = ibeg;
                while (i < 10) {
                    double d;
                    value = (double)i * Math.pow(10.0, j);
                    if (d <= maxValue) {
                        z = (float)((this.log10(value) - minLog[2]) * factor + offset);
                        this.movea3(dx, 0.0f, z);
                        this.drawa3(0.0f, 0.0f, z);
                        if (labels && i == 1) {
                            this.drwlbl(j, true, justify);
                        }
                    } else {
                        done = true;
                        break;
                    }
                    ++i;
                }
                ibeg = 1;
                ++j;
            }
        } else if (evry[2] > 0.0f && ivry[2] > 0) {
            int i = 0;
            float z = this.z3lo;
            while (z < this.z3lo + this.z3rng) {
                float ddx = i % ivry[2] != 0 ? dx : dx * 2.0f;
                this.movea3(ddx, 0.0f, z);
                this.drawa3(0.0f, 0.0f, z);
                if (labels && i % ivry[2] == 0) {
                    this.drwlbl(Math.round(z), false, justify, 4);
                }
                ++i;
                z += evry[2];
            }
        }
        this.movea3(0.0f, 0.0f, res[2]);
        this.drawa3(0.0f, 0.0f, 0.0f);
    }

    void vwindo3(float xlo, float xln, float ylo, float yln, float zlo, float zln) {
        this.vwindo3(xlo, xln, ylo, yln, zlo, zln, this.theta, this.phi);
    }

    void vwindo3(float xlo, float xln, float ylo, float yln, float zlo, float zln, float theta, float phi) {
        if (xln == 0.0f) {
            xln = 1.0f;
        }
        if (yln == 0.0f) {
            yln = 1.0f;
        }
        if (zln == 0.0f) {
            zln = 1.0f;
        }
        this.x3lo = xlo;
        this.x3cntr = xlo + xln * 0.5f;
        this.x3rng = xln;
        this.y3lo = ylo;
        this.y3cntr = ylo + yln * 0.5f;
        this.y3rng = yln;
        this.z3lo = zlo;
        this.z3cntr = zlo + zln * 0.5f;
        this.z3rng = zln;
        this.xscrnrng = 0.9f * (float)(this.ixmax - this.ixmin) / 1.4142135f;
        this.yscrnrng = 0.9f * (float)(this.iymax - this.iymin) / 2.0f;
        this.xscrncntr = (float)(this.ixmax + this.ixmin) * 0.5f;
        this.yscrncntr = (float)(this.iymax + this.iymin) * 0.5f;
        this.theta = theta;
        this.phi = phi;
        this.ct = (float)Math.cos(theta);
        this.st = (float)Math.sin(theta);
        this.cp = (float)Math.cos(phi);
        this.sp = (float)Math.sin(phi);
        this.zeye = 100.0f * this.cp * this.z3rng / this.yscrnrng + 1000.0f * this.sp;
        this.xeye = (100.0f * this.ct - 1000.0f * this.st) * this.x3rng / this.xscrnrng;
        this.yeye = (-1000.0f * this.ct - 100.0f * this.st) * this.y3rng / this.yscrnrng;
    }

    void recta(float x, float y, float w, float h) {
        this.recta(x, y, w, h, false);
    }

    void recta(float x, float y, float w, float h, boolean fill) {
        int[] iA = this.rescal(x, y);
        int[] iB = this.relscal(w, h);
        this.rctabs(iA[0], iA[1], iB[0], iB[1], fill);
    }

    void rctabs(int i, int j, int iw, int ih) {
        this.rctabs(i, j, iw, ih, false);
    }

    void rctabs(int i, int j, int iw, int ih, boolean fill) {
        this.chkbnd(i, j);
        if (this.w_err > 0) {
            return;
        }
        if (fill) {
            this.g2.fill(new Rectangle(i, this.pH - j, iw, ih));
        } else {
            this.g2.draw(new Rectangle(i, this.pH - j, iw, ih));
        }
    }

    void swindo(int i, int iln, int j, int jln) {
        this.ixmin = i < 0 || i >= this.pW ? 0 : i;
        this.ixmax = this.ixmin + iln > this.pW || iln <= 0 ? this.pW : this.ixmin + iln;
        this.iymin = j < 0 || j >= this.pH ? 0 : j;
        this.iymax = this.iymin + jln > this.pH || jln <= 0 ? 0 : this.iymin + jln;
    }

    void vwindo(float xlo, float xln, float ylo, float yln) {
        if (xln == 0.0f || yln == 0.0f) {
            return;
        }
        this.xmin = xlo;
        this.xmax = xlo + xln;
        this.ymin = ylo;
        this.ymax = ylo + yln;
    }

    float v_x(int i) {
        if (i < this.ixmin || i > this.ixmax || this.ixmax == this.ixmin) {
            return -1.0f;
        }
        return (float)(i - this.ixmin) * (this.xmax - this.xmin) / (float)(this.ixmax - this.ixmin) + this.xmin;
    }

    float v_y(int j_pix) {
        int j = this.pH - j_pix;
        if (j < this.iymin || j > this.iymax || this.iymax == this.iymin) {
            return -1.0f;
        }
        return (float)(j - this.iymin) * (this.ymax - this.ymin) / (float)(this.iymax - this.iymin) + this.ymin;
    }

    void graphicsCopy() {
        this.g2.setPaintMode();
    }

    void graphicsXor() {
        this.g2.setXORMode(this.pBg);
    }

    int[] relscal(float x, float y) {
        if (this.xmax == this.xmin || this.ymax == this.ymin) {
            return null;
        }
        int[] iA = new int[2];
        float r = x * (float)(this.ixmax - this.ixmin) / (this.xmax - this.xmin);
        if ((double)r < 32767.0) {
            iA[0] = (int)r + 1;
        }
        if ((double)(r = y * (float)(this.iymax - this.iymin) / (this.ymax - this.ymin)) < 32767.0) {
            iA[1] = (int)r + 1;
        }
        return iA;
    }

    int[] rescal(float x, float y) {
        if (this.xmax == this.xmin || this.ymax == this.ymin) {
            return null;
        }
        int[] iA = new int[2];
        float r = (x - this.xmin) * (float)(this.ixmax - this.ixmin) / (this.xmax - this.xmin) + (float)this.ixmin + 0.5f;
        if ((double)r < 32767.0) {
            iA[0] = (int)r;
        }
        if ((r = (y - this.ymin) * (float)(this.iymax - this.iymin) / (this.ymax - this.ymin) + (float)this.iymin + 0.5f) < 32767.0f) {
            iA[1] = (int)r;
        }
        return iA;
    }

    public int pixelCoordX(float x) {
        if (this.xmax == this.xmin) {
            return 0;
        }
        float r = (x - this.xmin) * (float)(this.ixmax - this.ixmin) / (this.xmax - this.xmin) + (float)this.ixmin + 0.5f;
        if ((double)r < 32767.0) {
            return (int)r;
        }
        return 0;
    }

    public int pixelCoordY(float y) {
        if (this.ymax == this.ymin) {
            return 0;
        }
        float r = (y - this.ymin) * (float)(this.iymax - this.iymin) / (this.ymax - this.ymin) + (float)this.iymin + 0.5f;
        if (r < 32767.0f) {
            return this.pH - (int)r;
        }
        return 0;
    }

    void chkbnd(int i, int j) {
        this.w_err = 0;
        if (this.w_clip && (i < this.ixmin || i > this.ixmax || j < this.iymin || j > this.iymax)) {
            this.w_err = 1;
        }
        if (i < 0 || i > this.pW || j < 0 || j > this.pH) {
            this.w_err = 2;
        }
    }

    void axes(float evry, int ivry, int direction, int mark, boolean grids, boolean labels, boolean split) {
        this.axes(evry, 0.0, ivry, direction, mark, grids, labels, split, 0.0);
    }

    void axes(float evry, double minLog, int ivry, int direction, int mark, boolean grids, boolean labels, boolean split, double splitEvry) {
        int j;
        boolean done;
        int i;
        int ibeg;
        double value;
        double factor;
        double offset;
        int igrid;
        int idx;
        double sEvry = 1.0;
        this.w_clip = false;
        int ixsid = this.ixmin;
        int iysid = this.iymin;
        float xsid = this.xmin;
        float ysid = this.ymin;
        int idy = idx = 1 * mark;
        double maxLog = evry;
        double maxValue = Math.pow(10.0, maxLog);
        double minValue = Math.pow(10.0, minLog);
        int minDecade = (int)minLog;
        if (minLog < 0.0) {
            --minDecade;
        }
        int minMantissa = (int)Math.ceil(Math.pow(10.0, minLog - (double)minDecade));
        if (direction > 1 || direction < -1) {
            int iddx;
            float y;
            igrid = this.ixmax - this.ixmin;
            if (direction < 0) {
                ixsid = this.ixmax;
                xsid = this.xmax;
                idx = -idx;
            }
            this.movabs(ixsid, this.iymax);
            this.drwabs(ixsid, this.iymin);
            if (evry > 0.0f && ivry < 0) {
                if (split) {
                    offset = 64.0 * (double)(this.ymax - this.ymin) / 256.0;
                    sEvry = 0.5 * splitEvry * offset / minValue;
                } else {
                    offset = 0.0;
                }
                factor = ((double)(this.ymax - this.ymin) - offset) / (maxLog - minLog);
                if (split) {
                    y = this.ymin;
                    value = -minValue;
                    while (value <= minValue) {
                        this.movea(xsid, y);
                        if (grids && y > this.ymin) {
                            this.drwgrid(igrid, 0);
                        }
                        this.drwrel(idx * 2, 0);
                        if (labels && direction > 0) {
                            this.drwlbl(value, 66, 2);
                        }
                        y = (float)((double)y + offset / 2.0);
                        value += minValue;
                    }
                    ibeg = (int)(0.5 * offset / sEvry);
                    i = -ibeg;
                    while (i <= ibeg) {
                        y = this.ymin + (float)(offset / 2.0) + (float)((double)i * sEvry);
                        this.movea(xsid, y);
                        this.drwrel(idx, 0);
                        ++i;
                    }
                }
                iddx = 2 * idx;
                done = false;
                ibeg = minMantissa;
                j = minDecade;
                while (!done) {
                    i = ibeg;
                    while (i < 10) {
                        double d;
                        value = (double)i * Math.pow(10.0, j);
                        if (d <= maxValue) {
                            y = (float)((this.log10(value) - minLog) * factor + offset);
                            this.movea(xsid, y);
                            if (grids && (i == 1 && j > 0 || i == 3)) {
                                this.drwgrid(igrid, 0);
                            }
                            this.drwrel(iddx, 0);
                            if (labels && i == 1 && direction > 0) {
                                this.drwlbl(j, true, 66);
                            }
                        } else {
                            done = true;
                            break;
                        }
                        ++i;
                    }
                    ibeg = 1;
                    ++j;
                }
            } else if (evry > 0.0f && ivry > 0) {
                i = 0;
                y = this.ymin;
                while (y <= this.ymax) {
                    iddx = i % ivry != 0 ? idx : idx * 2;
                    this.movea(xsid, y);
                    if (grids && i % ivry == 0 && i > 0) {
                        this.drwgrid(igrid, 0);
                    }
                    this.drwrel(iddx, 0);
                    if (labels && i % ivry == 0 && direction > 0) {
                        this.drwlbl(Math.round(y), false, 66, 4);
                    }
                    ++i;
                    y += evry;
                }
            }
        }
        if (direction != 2 && direction != -2) {
            igrid = this.iymax - this.iymin;
            if (direction < 0) {
                iysid = this.iymax;
                ysid = this.ymax;
                idy = -idy;
            }
            this.movabs(this.ixmax, iysid);
            this.drwabs(this.ixmin, iysid);
            if (evry > 0.0f && ivry < 0) {
                float x;
                if (split) {
                    offset = 64.0 * (double)(this.xmax - this.xmin) / 256.0;
                    sEvry = 0.5 * splitEvry * offset / minValue;
                } else {
                    offset = 0.0;
                }
                factor = ((double)(this.xmax - this.xmin) - offset) / (maxLog - minLog);
                if (split) {
                    x = this.xmin;
                    value = -minValue;
                    while (value <= minValue) {
                        this.movea(x, ysid);
                        if (grids && x > this.xmin) {
                            this.drwgrid(0, igrid);
                        }
                        this.drwrel(0, idx * 2);
                        if (labels && direction > 0) {
                            this.drwlbl(value, 20, 2);
                        }
                        x = (float)((double)x + offset / 2.0);
                        value += minValue;
                    }
                    ibeg = (int)(0.5 * offset / sEvry);
                    i = -ibeg;
                    while (i <= ibeg) {
                        x = this.xmin + (float)(offset / 2.0) + (float)((double)i * sEvry);
                        this.movea(x, ysid);
                        this.drwrel(0, idx);
                        ++i;
                    }
                }
                done = false;
                ibeg = minMantissa;
                int iddy = 2 * idy;
                j = minDecade;
                while (!done) {
                    i = ibeg;
                    while (i < 10) {
                        double d;
                        value = (double)i * Math.pow(10.0, j);
                        if (d <= maxValue) {
                            x = (float)((this.log10(value) - minLog) * factor + offset);
                            this.movea(x, ysid);
                            if (grids && (i == 1 && j > 0 || i == 3)) {
                                this.drwgrid(0, igrid);
                            }
                            this.drwrel(0, iddy);
                            if (labels && i == 1 && direction > 0) {
                                this.drwlbl(j, true, 20);
                            }
                        } else {
                            done = true;
                            break;
                        }
                        ++i;
                    }
                    ibeg = 1;
                    ++j;
                }
            } else if (evry > 0.0f && ivry > 0) {
                i = 0;
                float x = this.xmin;
                while (x < this.xmax) {
                    int iddy = i % ivry != 0 ? idy : idy * 2;
                    this.movea(x, ysid);
                    if (grids && i % ivry == 0 && i > 0) {
                        this.drwgrid(0, igrid);
                    }
                    this.drwrel(0, iddy);
                    if (labels && i % ivry == 0 && direction > 0) {
                        this.drwlbl(Math.round(x), false, 20, 4);
                    }
                    ++i;
                    x += evry;
                }
            }
        }
        this.w_clip = true;
    }

    void drwgrid(int i, int j) {
        int icol = this.currentColour;
        int isty = this.currentStyle;
        int iwt = this.currentWeight;
        this.set_colour(2);
        this.linestyle(1, 6);
        this.drwrel(i, j);
        this.movrel(-i, -j);
        this.set_colour(icol);
        this.linestyle(iwt, isty);
    }

    void linestyle(int weight, int style) {
        if (weight < 1) {
            weight = 1;
        }
        if (weight != this.currentWeight) {
            if ((float)weight == 1.0f) {
                this.g2.setStroke(this.defStroke);
            } else {
                this.g2.setStroke(new BasicStroke(weight, 0, 2));
            }
            this.currentWeight = weight;
        }
        if (style >= 0 && style < this.lineStyles.length) {
            this.currentStyle = style;
        }
    }

    private String displayFilter(String raw) {
        int len = raw.length();
        if (len > 0) {
            StringBuffer filtered = new StringBuffer(len);
            int i = 0;
            while (i < len) {
                char ch = raw.charAt(i);
                if (!Character.isISOControl(ch)) {
                    filtered.append(ch);
                }
                ++i;
            }
            return filtered.toString();
        }
        return null;
    }

    void drwtxt(String string, int size, int justify) {
        this.drwtxt(string, size, justify, 0, null);
    }

    void drwtxt(String string, int size, int justify, Rectangle rect) {
        this.drwtxt(string, size, justify, 0, rect);
    }

    void drwtxt(String string, int size, int justify, int rotation, Rectangle rect) {
        double sin;
        double cos;
        int j;
        int i;
        double angle = 0.0;
        Font font = new Font("SansSerif", 0, 10);
        FontMetrics fm = this.g2.getFontMetrics(font);
        int i_h_a = fm.getAscent();
        int i_h_d = fm.getDescent();
        int i_h_ma = fm.getMaxAdvance();
        int i_h = i_h_a + i_h_d;
        int i_w = string == null ? 0 : this.g2.getFontMetrics(font).stringWidth(string);
        double x_w = i_w;
        double y_h = i_h;
        double y_h_a = i_h_a;
        double y_h_d = y_h - y_h_a;
        if (rotation == 0) {
            i = i_w;
            j = 0;
            cos = 1.0;
            sin = 0.0;
        } else {
            rotation = (rotation + 360) % 360;
            angle = Math.toRadians(rotation);
            cos = Math.cos(angle);
            sin = Math.sin(angle);
            i = (int)(x_w * cos);
            j = (int)(x_w * sin);
        }
        if ((justify & 1) == 0) {
            if ((justify & 2) != 0) {
                this.movrel((int)(-x_w * cos), (int)(-x_w * sin));
            } else if ((justify & 4) != 0) {
                this.movrel((int)(-x_w * cos * 0.5), (int)(-x_w * sin * 0.5));
            }
        }
        if ((justify & 0x10) != 0) {
            this.movrel((int)(y_h * sin), (int)(-y_h * cos));
        } else if ((justify & 0x200) != 0) {
            this.movrel((int)(2.0 * y_h * sin), (int)(-2.0 * y_h * cos));
        } else if ((justify & 0x80) != 0) {
            this.movrel((int)(y_h_a * sin), (int)(-y_h_a * cos));
        } else if ((justify & 0x100) != 0) {
            this.movrel((int)(-y_h_d * sin), (int)(y_h_d * cos));
        } else if ((justify & 0x20) != 0) {
            i += (int)(y_h * sin * 0.5);
            j += (int)(-y_h * cos * 0.5);
            this.movrel((int)(-y_h * sin * 0.5), (int)(y_h * cos * 0.5));
        } else if ((justify & 0x40) != 0) {
            this.movrel((int)(y_h * sin * 0.5), (int)(-y_h * cos * 0.5));
        }
        if (string != null) {
            if (rotation != 0) {
                AffineTransform saveAT = this.g2.getTransform();
                AffineTransform rotAT = new AffineTransform();
                rotAT.translate(this.ix_pix_now, this.iy_pix_now);
                rotAT.rotate(-angle);
                this.g2.transform(rotAT);
                this.g2.setFont(font);
                this.g2.drawString(string, 0, 0);
                this.g2.setTransform(saveAT);
            } else {
                this.g2.setFont(font);
                this.g2.drawString(string, this.ix_pix_now, this.iy_pix_now);
            }
        }
        if (rect != null) {
            rect.x = this.ix_pix_now;
            rect.y = this.iy_pix_now;
            if (rotation == 0) {
                rect.width = i_w;
                rect.height = i_h;
                rect.y -= i_h;
            } else {
                rect.width = (int)(Math.abs(x_w * cos) + Math.abs(y_h * sin));
                rect.height = (int)(Math.abs(x_w * sin) + Math.abs(y_h * cos));
                if (rotation > 0 && rotation <= 90) {
                    rect.x -= (int)(y_h * sin);
                    rect.y -= rect.height;
                } else if (rotation > 90 && rotation <= 180) {
                    rect.x -= rect.width;
                    rect.y -= (int)(x_w * sin);
                } else if (rotation > 180 && rotation <= 270) {
                    rect.x += (int)(x_w * cos);
                } else {
                    rect.y -= (int)(y_h * cos);
                }
            }
        }
        this.movrel(i, j);
    }

    void txtLF(int num, int size) {
        Font font = new Font("SansSerif", 0, 10);
        int i_h = this.g2.getFontMetrics(font).getAscent() + this.g2.getFontMetrics(font).getDescent();
        this.movrel(0, -num * i_h);
    }

    private String truncateString(double val, int places) {
        boolean negative;
        int MAX = 4;
        int mask = (int)Math.pow(10.0, places);
        long ival = 0L;
        double pow = 0.0;
        boolean bl = negative = val < 0.0;
        if (negative) {
            val = -val;
        }
        int i = 4;
        while (i >= -4) {
            pow = Math.pow(10.0, i);
            ival = Math.round(val * pow);
            if (ival < (long)mask) break;
            --i;
        }
        val = (double)ival / pow;
        String s = String.valueOf(val);
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        } else if (s.startsWith("0.")) {
            s = s.substring(1, s.length());
        }
        if (negative) {
            return "-" + s;
        }
        return s;
    }

    void drwlbl(int i, boolean log, int justify) {
        this.drwlbl(i, log, justify, 0);
    }

    void drwlbl(double v, int justify, int places) {
        String s = this.truncateString(v, places);
        this.drwlbl(s, false, justify);
    }

    void drwlbl(int i, boolean log, int justify, int places) {
        int lng;
        if (log && i > 9) {
            return;
        }
        String s = String.valueOf(i);
        if (!log && places > 0 && (lng = s.length()) >= places && s.endsWith("000")) {
            s = String.valueOf(s.substring(0, lng - 3)) + "k";
        }
        this.drwlbl(s, log, justify);
    }

    void drwlbl(String s, boolean log, int justify) {
        if (log) {
            this.drwtxt("10 ", 1, justify);
            this.drwtxt(s, 1, 34);
        } else {
            this.drwtxt(s, 1, justify);
        }
    }

    public Color get_colour(int icol) {
        return this.xwColour[icol];
    }

    public void setHSBColour(float hue, float saturation, float brightness) {
        this.g2.setColor(Color.getHSBColor(hue, saturation, brightness));
    }

    public void setRGBColour(Color col) {
        this.g2.setColor(col);
    }

    public void setRGBColour(int r, int g, int b) {
        this.g2.setColor(new Color(r, g, b));
    }

    void set_background() {
        this.pBg = this.xwColour[0];
        this.pFg = this.xwColour[1];
        this.gd.dsp.setBackground(this.pBg);
    }

    void set_colour(int icol) {
        this.currentColour = icol % this.maxColour;
        this.g2.setColor(this.xwColour[icol % this.maxColour]);
    }

    void set_dot_size(int size) {
        if (size >= 0) {
            this.dot_size = size;
        }
    }

    void bleep(int volume) {
        Toolkit.getDefaultToolkit().beep();
    }

    double log10(double x) {
        return 0.434294482 * Math.log(x);
    }
}

