/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;

public class FileSpec {
    public static final byte CLEARBYTE = 32;
    public static final int DEFBUFSIZ = 1000000;
    public static final int MAXPARS = 64;
    public static final int WEHIRANGE = 256;
    public static final int ARRAYSIZE = 256;
    public static final int HC_SEGMENT = 32;
    public static final int CONSIZE = 64;
    public static final int MINSPLITCHAN = 64;
    public static final double SPLITDECADES = 3.0;
    public static final double LOG10e = 1.0 / Math.log(10.0);
    public static final int NEARN = 32;
    public static final int MAX_CELLS = 100000;
    public static final int VERT = 0;
    public static final int DOTS_N = 0;
    public static final int LEVELS = 0;
    public static final int COLOURS = 1;
    public static final int STYLES = 2;
    public static final int ROT = 3;
    public static final int TILT = 4;
    public static final int SCALEDIMENSION = 5;
    public static final int VERT0 = 0;
    public static final int LEVELS0 = 3;
    public static final int ROT0 = 30;
    public static final int TILT0 = 20;
    public static final int DOTS0 = 2000;
    public static final int R = 82;
    public static final int W = 87;
    public static final int C = 67;
    public static final int B = 66;
    public static final int AND = 42;
    public static final int OR = 43;
    public static final int NOT = 45;
    public static final int BRA = 40;
    public static final int KET = 41;
    private final int REGION = 1;
    private final int WINDOW = 2;
    private final int CLUSTER = 3;
    private final float MAXLOGRANGE = 6.0f;
    private final float STDLOGRANGE = 4.0f;
    private final int DEFTOTAL = 100;
    private final int MAXTOTAL = 10000;
    private final int STDLEVELS = 10;
    public static final int MAXLEVELS = 30;
    private final int MINDOTARRAY = 100000;
    private final double BACKGROUND = 3.0;
    private final float DIVATRANSPOSE = 4.1f;
    private final int INTSIZE = 4;
    private final int MAXBYTE = 255;
    private final int MAXPOSBYTE = 127;
    private final int REPEATMIN = 3;
    public static final double D_MINSPLITCHAN = 64.0;
    public static final long HALFMINSPLITCHAN = 32L;
    public static final double D_HALFMINSPLITCHAN = 32.0;
    public static final float F_WEHIRANGE = 256.0f;
    public static final double D_WEHIRANGE = 256.0;
    public GDisplay gd;
    public int num;
    public int id;
    public String name;
    public String pathname;
    public String fcsVersion;
    public byte mode;
    public byte datatype;
    public String title;
    public int total;
    public int gated;
    public int linked;
    public int acqPars;
    public int nPars;
    public String[] parname;
    public String[] parstain;
    public String[] label;
    public boolean[] logflg;
    public boolean[] flogflg;
    public boolean[] splitflg;
    public float[] logrng;
    public float[] resolution;
    public float[] timeFactor;
    public float timeStep;
    public boolean[] timePar;
    public Gate gate;
    public int gateIndex;
    public int clusterPar;
    public int clusterChan;
    public int smooth;
    public boolean compensate;
    public boolean ratio;
    public int[] scale;
    public float[] rScale;
    public int dArraySize;
    private int linkDimension;
    private int size2D = 0;
    public boolean linking;
    public boolean virgin;
    public int hdrStrt;
    public int hdrEnd;
    public int dataStrt;
    public int dataEnd;
    public byte[] header;
    public byte dlt;
    private boolean byteRev;
    private String date;
    private String btim;
    private String etim;
    private int[][] pWind;
    private int[][] gWind;
    private int[][][] sRiArray;
    private int[][][] sWiArray;
    private int[][][] sGiArray;
    private boolean[] r;
    private boolean[] w;
    private boolean[] g;
    private boolean localMap = false;
    private boolean localWin = false;
    private int cl;
    private int[][] n_n;
    public int[] pRange;
    public int[] linRange;
    public int[] gRange;
    public int[] pBits;
    public boolean remote;
    public boolean reReadable;
    private URL fileURL;
    private double[] aflt;
    public double[] maxLog;
    public double[] minSplitLog;
    public double[] minLog;
    public double[] minSplitVal;
    private double[] splitLogRng;
    private double[] splitLogFactor;
    private double[] logFactor;
    private double[] loValFactor;
    private double[] linFactor;
    private byte[] preamble;
    private byte[] buffer;
    private int bufIndex;
    private FileInputStream finp;
    private int cellN;
    private double[] fpar;
    private int[] scales;
    private int[] loLim;
    private int[] hiLim;
    public boolean[] compOn;
    public double[][] compMat;
    public double[] backGnd;
    final int BITINDEX = 2;
    final int GRNGINDEX = 2;
    public static final int PARNAMEINDEX = 2;
    final int PARSTAININDEX = 2;
    final int RNGINDEX = 2;
    final int PWDWINDEX = 2;
    final int GWDWINDEX = 2;
    final int ORIGINDEX = 6;
    final int LOGFLGINDEX = 10;
    final int LOGFLGFCSINDEX = 2;
    final int LOGFLGFCS2INDEX = 2;
    public static final int FCSPREAMBLESIZE = 58;
    public static final int FCSVERSIONSIZE = 10;
    public static final int FCSOFFSETSIZE = 8;
    final int nn_count = 16;
    final int nn_dist0 = 32;

    public FileSpec(String xpath) {
        String msgS = null;
        this.pathname = xpath;
        this.name = this.getNameFromPath(xpath);
        this.pRange = new int[64];
        this.linRange = new int[64];
        this.gRange = new int[64];
        this.pBits = new int[64];
        this.parname = new String[64];
        this.parstain = new String[64];
        this.label = new String[64];
        this.flogflg = new boolean[64];
        this.logflg = new boolean[64];
        this.splitflg = new boolean[64];
        this.logrng = new float[64];
        this.resolution = new float[64];
        this.timeFactor = new float[64];
        this.timePar = new boolean[64];
        this.scale = new int[5];
        this.r = new boolean[16];
        this.w = new boolean[16];
        this.g = new boolean[16];
        this.gate = null;
        this.gateIndex = -1;
        this.clusterPar = -1;
        this.linking = false;
        this.ratio = false;
        this.compensate = false;
        this.compMat = new double[64][64];
        this.backGnd = new double[64];
        this.compOn = new boolean[64];
        try {
            this.readHeader();
        }
        catch (Exception e) {
            msgS = String.valueOf(this.name) + " could not be opened";
        }
        this.fpar = new double[64];
        this.scales = new int[64];
        this.loLim = new int[64];
        this.hiLim = new int[64];
    }

    public static void copyBGFS(FileSpec toFS, FileSpec fromFS) {
        if (toFS != null && fromFS != null) {
            toFS.acqPars = fromFS.acqPars;
            toFS.nPars = fromFS.nPars;
            int i = 0;
            while (i < fromFS.nPars) {
                toFS.parname[i] = fromFS.parname[i];
                toFS.parstain[i] = fromFS.parstain[i];
                toFS.label[i] = fromFS.label[i];
                toFS.logflg[i] = fromFS.logflg[i];
                toFS.flogflg[i] = fromFS.flogflg[i];
                toFS.splitflg[i] = fromFS.splitflg[i];
                toFS.logrng[i] = fromFS.logrng[i];
                toFS.resolution[i] = fromFS.resolution[i];
                toFS.pRange[i] = fromFS.pRange[i];
                toFS.linRange[i] = fromFS.linRange[i];
                toFS.gRange[i] = fromFS.gRange[i];
                toFS.pBits[i] = fromFS.pBits[i];
                ++i;
            }
            toFS.header = fromFS.header;
        }
    }

    public static void copyFS(FileSpec toFS, FileSpec fromFS) {
        if (toFS != null && fromFS != null) {
            if (fromFS.gate != null) {
                toFS.gate = new Gate(fromFS.gate.s, fromFS.gate.name);
            }
            toFS.gateIndex = fromFS.gateIndex;
            toFS.clusterPar = fromFS.clusterPar;
            toFS.clusterChan = fromFS.clusterChan;
            toFS.smooth = fromFS.smooth;
            toFS.compensate = fromFS.compensate;
            toFS.ratio = fromFS.ratio;
            int i = 0;
            while (i < toFS.scale.length) {
                toFS.scale[i] = fromFS.scale[i];
                ++i;
            }
            if (fromFS.rScale != null) {
                toFS.rScale = new float[fromFS.rScale.length];
                i = 0;
                while (i < toFS.rScale.length) {
                    toFS.rScale[i] = fromFS.rScale[i];
                    ++i;
                }
            }
            i = 0;
            while (i < fromFS.nPars) {
                toFS.label[i] = fromFS.label[i];
                toFS.logflg[i] = fromFS.logflg[i];
                toFS.splitflg[i] = fromFS.splitflg[i];
                ++i;
            }
        }
    }

    public static byte[] numberedKey(byte[] key, int index, int par) {
        int lin;
        if (par > 99) {
            return null;
        }
        int lout = lin = key.length;
        if (par > 9) {
            ++lout;
        }
        byte[] nk = new byte[lout];
        int i = 0;
        int j = 0;
        while (i < lin) {
            if (i != index) {
                nk[j++] = key[i];
            } else {
                if (par > 9) {
                    nk[j++] = (byte)(48 + par / 10);
                }
                nk[j++] = (byte)(48 + par % 10);
            }
            ++i;
        }
        return nk;
    }

    public void readHeader() throws FileNotFCSTypeException, IllegalFCSFormatException, FileNotFoundException, IOException {
        DMatrix a;
        float f;
        float f2;
        int j;
        byte[] totalKey = new byte[]{36, 84, 79, 84};
        byte[] systemKey = new byte[]{36, 83, 89, 83};
        byte[] byteOrdKey = new byte[]{36, 66, 89, 84, 69, 79, 82, 68};
        byte[] parnumKey = new byte[]{36, 80, 65, 82};
        byte[] datatypeKey = new byte[]{36, 68, 65, 84, 65, 84, 89, 80, 69};
        byte[] bitKey = new byte[]{36, 80, 110, 66};
        byte[] rngKey = new byte[]{36, 80, 110, 82};
        byte[] grngKey = new byte[]{36, 71, 110, 82};
        byte[] parnameKey = new byte[]{36, 80, 110, 78};
        byte[] parstainKey = new byte[]{36, 80, 110, 83};
        byte[] pwdwKey = new byte[]{36, 80, 110, 87};
        byte[] gwdwKey = new byte[]{36, 71, 110, 87};
        byte[] origKey = new byte[]{79, 82, 73, 71, 95, 80, 110};
        byte[] logFlgKey = new byte[]{76, 79, 71, 95, 70, 76, 65, 71, 95, 80, 110};
        byte[] logFlgFcscn = new byte[]{36, 80, 110, 77};
        byte[] logFlgFcs2 = new byte[]{36, 80, 110, 69};
        byte[] dateKey = new byte[]{36, 68, 65, 84, 69};
        byte[] btimKey = new byte[]{36, 66, 84, 73, 77};
        byte[] etimKey = new byte[]{36, 69, 84, 73, 77};
        byte[] timeStepKey = new byte[]{36, 84, 73, 77, 69, 83, 84, 69, 80};
        byte[] timeTicksKey = new byte[]{84, 73, 77, 69, 84, 73, 67, 75, 83};
        byte[] titleKey = new byte[]{84, 73, 84, 76, 69};
        byte[] title2Key = new byte[]{83, 65, 77, 80, 76, 69, 32, 73, 68};
        byte[] modeKey = new byte[]{36, 77, 79, 68, 69};
        byte[] acqparnumKey = new byte[]{80, 65, 82, 73, 78};
        byte[] logrngKey = new byte[]{76, 79, 71, 95, 82, 65, 78, 71, 69};
        byte[] logFlgC30 = new byte[]{70, 76, 110, 32, 71, 65, 73, 78};
        byte[] logrngC30 = new byte[]{76, 79, 71, 32, 68, 69, 67, 65, 68, 69, 83};
        byte[] creatorKey = new byte[]{67, 82, 69, 65, 84, 79, 82};
        byte[] spillKey = new byte[]{83, 80, 73, 76, 76};
        byte[] compKey = new byte[]{65, 80, 80, 76, 89, 32, 67, 79, 77, 80, 69, 78, 83, 65, 84, 73, 79, 78};
        FileInputStream finp = null;
        Object remfinp = null;
        boolean notFound = true;
        boolean c30 = false;
        String flg = null;
        String sys = null;
        this.preamble = new byte[58];
        if (this.preamble == null) {
            return;
        }
        finp = new FileInputStream(this.pathname);
        if (finp.read(this.preamble) != 58) {
            throw new IllegalFCSFormatException(" has IllegalFCSFormat");
        }
        finp.close();
        int offset = 0;
        this.fcsVersion = new String(this.preamble, offset, 10);
        if (this.fcsVersion.indexOf("FCS") < 0) {
            throw new FileNotFCSTypeException("FileNotFCSType");
        }
        this.hdrStrt = Integer.parseInt(new String(this.preamble, offset += 10, 8).trim());
        this.hdrEnd = Integer.parseInt(new String(this.preamble, offset += 8, 8).trim());
        this.dataStrt = Integer.parseInt(new String(this.preamble, offset += 8, 8).trim());
        this.dataEnd = Integer.parseInt(new String(this.preamble, offset += 8, 8).trim());
        offset += 8;
        this.header = new byte[1 + this.hdrEnd - this.hdrStrt];
        finp = new FileInputStream(this.pathname);
        finp.skip(this.hdrStrt);
        if (finp.read(this.header) != this.header.length) {
            throw new IllegalFCSFormatException(" has IllegalFCSFormat");
        }
        try {
            finp.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dlt = this.header[0];
        this.acqPars = 0;
        int max = FileSpec.extractI(this.header, parnumKey, this.dlt);
        if (max <= 0) {
            this.nPars = 64;
        } else if (max > 64) {
            this.acqPars = max;
            this.nPars = 64;
        } else {
            this.nPars = max;
        }
        if (this.acqPars == 0 && (max = FileSpec.extractI(this.header, acqparnumKey, this.dlt)) > 0 && max <= 64) {
            this.acqPars = max;
        }
        int defined = 0;
        if (this.acqPars > 64) {
            max = this.acqPars;
            this.pRange = new int[max];
            this.linRange = new int[max];
            this.pBits = new int[max];
        } else {
            max = 64;
        }
        int i = 0;
        while (i < max) {
            this.pRange[i] = FileSpec.extractI(this.header, FileSpec.numberedKey(rngKey, 2, i + 1), this.dlt);
            if (this.pRange[i] > 0) {
                defined = i + 1;
            } else {
                this.pRange[i] = 256;
            }
            ++i;
        }
        i = 0;
        while (i < max) {
            this.pBits[i] = FileSpec.extractI(this.header, FileSpec.numberedKey(bitKey, 2, i + 1), this.dlt);
            if (this.pBits[i] > 0 && i >= defined) {
                defined = i + 1;
            }
            ++i;
        }
        if (defined <= 0) {
            throw new IllegalFCSFormatException(" has IllegalFCSFormat");
        }
        if (this.nPars > defined) {
            this.nPars = defined;
        }
        if (this.acqPars < this.nPars) {
            this.acqPars = this.nPars;
        }
        this.byteRev = false;
        int[] iA = this.extractIA(this.header, byteOrdKey, this.dlt);
        if (iA != null && iA.length >= 2 && iA[0] > iA[1]) {
            this.byteRev = true;
        }
        c30 = false;
        sys = FileSpec.extractS(this.header, systemKey, this.dlt);
        if (sys != null && (sys.indexOf("H.P.") == 0 || sys.indexOf("Mac") == 0 || sys.indexOf("HP") >= 0)) {
            this.byteRev = true;
            c30 = true;
        }
        if ((this.total = FileSpec.extractI(this.header, totalKey, this.dlt)) <= 0) {
            this.total = 100;
        } else if (this.total > 10000) {
            this.total = 10000;
        }
        this.mode = this.extractB(this.header, modeKey, this.dlt);
        if (this.mode != 76) {
            throw new IllegalFCSFormatException(" is not FCS List Mode");
        }
        this.datatype = this.extractB(this.header, datatypeKey, this.dlt);
        i = 0;
        while (i < this.nPars) {
            this.parname[i] = FileSpec.extractS(this.header, FileSpec.numberedKey(parnameKey, 2, i + 1), this.dlt);
            ++i;
        }
        i = 0;
        while (i < this.nPars) {
            this.parstain[i] = FileSpec.extractS(this.header, FileSpec.numberedKey(parstainKey, 2, i + 1), this.dlt);
            if (this.parstain[i] != null && this.parstain[i].trim().length() == 0) {
                this.parstain[i] = null;
            }
            ++i;
        }
        i = 0;
        while (i < this.nPars) {
            float[] fA = this.extractFA(this.header, FileSpec.numberedKey(logFlgFcs2, 2, i + 1), this.dlt);
            if (fA != null && fA[0] > 0.0f) {
                this.flogflg[i] = true;
                this.logrng[i] = fA[0];
            } else {
                this.flogflg[i] = false;
            }
            notFound = fA == null;
            ++i;
        }
        if (notFound) {
            i = 0;
            while (i < this.nPars) {
                float f3;
                this.logrng[i] = this.extractF(this.header, FileSpec.numberedKey(logFlgFcscn, 2, i + 1), this.dlt);
                if (f3 > 0.0f) {
                    this.flogflg[i] = true;
                    notFound = false;
                }
                ++i;
            }
        }
        if (notFound) {
            i = 0;
            while (i < this.nPars) {
                if (this.parname[i] != null && this.parname[i].length() == 3) {
                    j = 0;
                    while (j < 3) {
                        logFlgC30[j] = (byte)this.parname[i].charAt(j);
                        ++j;
                    }
                    flg = FileSpec.extractS(this.header, logFlgC30, this.dlt);
                    if (flg != null && flg.indexOf("LOG") >= 0) {
                        this.flogflg[i] = true;
                    }
                }
                notFound = flg == null;
                ++i;
            }
            this.logrng[0] = this.extractF(this.header, logrngC30, this.dlt);
        }
        if (notFound) {
            i = 0;
            while (i < this.nPars) {
                byte yn = this.extractB(this.header, FileSpec.numberedKey(logFlgKey, 10, i + 1), this.dlt);
                if (yn == 89) {
                    this.flogflg[i] = true;
                    this.logrng[i] = 0.0f;
                }
                ++i;
            }
            this.logrng[0] = this.extractF(this.header, logrngKey, this.dlt);
        }
        if (this.logrng[0] <= 0.0f || this.logrng[0] > 6.0f) {
            this.logrng[0] = 4.0f;
        }
        i = 1;
        while (i < this.nPars) {
            if (this.flogflg[i]) {
                this.logflg[i] = true;
            }
            if (this.logrng[i] <= 0.0f || this.logrng[i] > 6.0f) {
                this.logrng[i] = this.logrng[0];
            }
            ++i;
        }
        this.date = FileSpec.extractS(this.header, dateKey, this.dlt);
        this.btim = FileSpec.extractS(this.header, btimKey, this.dlt);
        this.etim = FileSpec.extractS(this.header, etimKey, this.dlt);
        this.timeStep = this.extractF(this.header, timeStepKey, this.dlt);
        if (f2 <= 0.0f) {
            float f4;
            this.timeStep = 0.001f * (float)FileSpec.extractI(this.header, timeTicksKey, this.dlt);
            if (f4 <= 0.0f) {
                this.timeStep = 0.125f;
            }
        }
        i = 0;
        while (i < this.nPars) {
            long itim = 0L;
            this.timePar[i] = false;
            this.resolution[i] = itim > 0L ? (float)itim : (this.timePar[i] ? (float)this.pRange[i] * this.timeStep : (float)this.pRange[i]);
            ++i;
        }
        this.title = FileSpec.extractS(this.header, titleKey, this.dlt);
        if (this.title == null) {
            this.title = FileSpec.extractS(this.header, title2Key, this.dlt);
        }
        max = this.acqPars > 64 ? 64 : this.acqPars;
        i = 0;
        while (i < max) {
            grngKey[2] = (byte)(49 + i);
            this.gRange[i] = FileSpec.extractI(this.header, FileSpec.numberedKey(grngKey, 2, i + 1), this.dlt);
            if (this.gRange[i] <= 0) {
                this.gRange[i] = 256;
            }
            ++i;
        }
        float DiVaVersion = this.extractFem(this.header, creatorKey, this.dlt);
        boolean transpose = f >= 4.1f;
        float[][] spMatrix = this.extractSpill(this.header, spillKey, this.dlt, this.parname, this.compOn, transpose);
        if (spMatrix != null && DMatrix.invert(a = new DMatrix(spMatrix), a.rows)) {
            i = 0;
            int k = 0;
            while (i < this.nPars) {
                if (i < this.compOn.length) {
                    if (this.compOn[i]) {
                        this.logflg[i] = true;
                        if (!this.flogflg[i]) {
                            this.splitflg[i] = true;
                        }
                        j = 0;
                        int l = 0;
                        while (j < this.nPars) {
                            if (j < this.compOn.length) {
                                if (this.compOn[j]) {
                                    if (k < a.rows && l < a.columns) {
                                        this.compMat[i][j] = a.m[k][l];
                                    }
                                    ++l;
                                } else {
                                    this.compMat[i][j] = i == j ? 1.0 : 0.0;
                                }
                            }
                            ++j;
                        }
                        ++k;
                    } else {
                        j = 0;
                        while (j < this.nPars) {
                            this.compMat[i][j] = j == i ? 1.0 : 0.0;
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        this.compensate = this.extractBool(this.header, compKey, this.dlt);
        i = 0;
        while (i < this.nPars) {
            if (this.parname[i].toLowerCase().startsWith("cl")) {
                this.splitflg[i] = false;
                this.logflg[i] = false;
                this.label[i] = null;
                if (i < this.compOn.length) {
                    this.compOn[i] = false;
                }
            }
            ++i;
        }
        this.maxLog = new double[this.nPars];
        this.minSplitLog = new double[this.nPars];
        this.minLog = new double[this.nPars];
        this.minSplitVal = new double[this.nPars];
        this.splitLogRng = new double[this.nPars];
        this.splitLogFactor = new double[this.nPars];
        this.logFactor = new double[this.nPars];
        this.loValFactor = new double[this.nPars];
        this.linFactor = new double[this.nPars];
        this.setSplitParameters();
    }

    public static boolean isFCS(String path) {
        FileInputStream finp = null;
        boolean result = false;
        byte[] preamb = new byte[10];
        if (preamb == null) {
            return result;
        }
        try {
            finp = new FileInputStream(path);
            if (finp.read(preamb) == 10) {
                result = true;
            }
            finp.close();
        }
        catch (Exception ex) {
            try {
                finp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = false;
        }
        if (result) {
            String fcsV = new String(preamb, 0, 10);
            if (fcsV.indexOf("FCS") != 0) {
                result = false;
            } else {
                try {
                    Float version = Float.valueOf(fcsV.substring(3));
                }
                catch (Exception ex2) {
                    result = false;
                }
            }
        }
        return result;
    }

    public static boolean isPresentation(String path) {
        String HEADER = "Weasel_P";
        String XMLHEADER = "<?xml";
        String BDFACS = "<bdfacs";
        byte[] preamb = new byte[70];
        boolean result = false;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
            fis.read(preamb);
            String presV = new String(preamb);
            if (presV.indexOf("Weasel_P") == 0) {
                result = true;
            } else if (presV.indexOf("<?xml") >= 0 && presV.indexOf("<bdfacs") > 0) {
                result = true;
            }
            fis.close();
        }
        catch (Exception ex) {
            try {
                fis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = false;
        }
        return result;
    }

    public static String[] getParnames(String path) {
        byte[] headr;
        FileInputStream finp;
        byte[] parnameKey;
        byte[] parnumKey;
        block10: {
            byte[] preamb;
            block9: {
                parnumKey = new byte[]{36, 80, 65, 82};
                parnameKey = new byte[]{36, 80, 110, 78};
                finp = null;
                preamb = new byte[58];
                if (preamb == null) {
                    return null;
                }
                try {
                    finp = new FileInputStream(path);
                    if (finp.read(preamb) == 58) break block9;
                    return null;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            finp.close();
            int offset = 0;
            String fcsV = new String(preamb, offset, 10);
            if (fcsV.indexOf("FCS") < 0) {
                return null;
            }
            int hdrS = Integer.parseInt(new String(preamb, offset += 10, 8).trim());
            int hdrE = Integer.parseInt(new String(preamb, offset += 8, 8).trim());
            int dataS = Integer.parseInt(new String(preamb, offset += 8, 8).trim());
            int dataE = Integer.parseInt(new String(preamb, offset += 8, 8).trim());
            offset += 8;
            preamb = null;
            headr = new byte[1 + hdrE - hdrS];
            try {
                finp = new FileInputStream(path);
                finp.skip(hdrS);
                if (finp.read(headr) == headr.length) break block10;
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        finp.close();
        byte dlt = headr[0];
        int max = FileSpec.extractI(headr, parnumKey, dlt);
        int nP = max <= 0 ? 64 : max;
        String[] pnames = new String[nP];
        int i = 0;
        while (i < nP) {
            pnames[i] = FileSpec.extractS(headr, FileSpec.numberedKey(parnameKey, 2, i + 1), dlt);
            ++i;
        }
        return pnames;
    }

    public void readData(GDisplay gd) throws FileNotFoundException, IllegalFCSFormatException, FCSParameterException, IOException {
        if (this.mode != 76) {
            throw new IllegalFCSFormatException("IllegalFCSFormat");
        }
        this.readList(gd);
    }

    private void clearArray(GDisplay gd, boolean mode1) {
        int i;
        if (gd.iArray != null) {
            i = 0;
            while (i < gd.iArray.length) {
                gd.iArray[i] = 0;
                ++i;
            }
        }
        if ((this.gd.style & 1) != 0 && gd.rArray != null) {
            i = 0;
            while (i < gd.rArray.length) {
                gd.rArray[i] = 0.0f;
                ++i;
            }
        }
        if (gd.oArray != null) {
            i = 0;
            while (i < 256) {
                int j = 0;
                while (j < 256) {
                    gd.oArray[i][j] = null;
                    ++j;
                }
                ++i;
            }
        }
    }

    private boolean createArray(GDisplay gd, boolean mode1, boolean mode2, boolean mode2d, boolean mode3, boolean outliers) {
        int iASize = 0;
        int rASize = 0;
        int dASize = 0;
        boolean toClear = false;
        dASize = this.scale[0] > 100000 ? this.scale[0] : 100000;
        int n = dASize = this.total < dASize ? this.total : dASize;
        if (mode3) {
            if ((gd.d3DArray == null || gd.d3DArray.length < dASize) && (gd.d3DArray = new Dot3D[dASize]) == null) {
                return false;
            }
            iASize = 0;
            this.dArraySize = gd.d3DArray.length;
        } else if (mode2d) {
            if ((gd.dArray == null || gd.dArray.length < dASize) && (gd.dArray = new Dot[dASize]) == null) {
                return false;
            }
            iASize = 65536;
            this.dArraySize = gd.dArray.length;
        } else if (mode2) {
            this.size2D = (this.gd.style & 0x100) != 0 ? 256 : 64;
            iASize = 65536;
            rASize = this.size2D * this.size2D;
            if ((this.gd.style & 1) != 0) {
                if (gd.rArray == null || gd.rArray.length < rASize) {
                    gd.rArray = new float[rASize];
                    if (gd.rArray == null || (this.rScale = new float[30]) == null) {
                        return false;
                    }
                } else {
                    toClear = true;
                }
                if (outliers) {
                    if (gd.oArray == null) {
                        gd.oArray = new Dot[256][256];
                    } else {
                        toClear = true;
                    }
                }
            }
        } else if (mode1) {
            iASize = 256 * this.nPars;
        }
        if (iASize > 0 && (gd.iArray == null || gd.iArray.length < iASize)) {
            gd.iArray = new int[iASize];
            if (gd.iArray == null) {
                return false;
            }
        } else {
            toClear = true;
        }
        if (toClear) {
            this.clearArray(gd, mode1);
        }
        return true;
    }

    public boolean prelude() {
        try {
            int readLength = this.dataEnd - this.dataStrt <= 1000000 ? this.dataEnd - this.dataStrt + 1 : 1000000;
            this.buffer = new byte[readLength];
            this.finp = new FileInputStream(this.pathname);
            this.finp.skip(this.dataStrt);
            this.cellN = 0;
            this.finp.read(this.buffer, 0, readLength);
            this.bufIndex = 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        int j = 0;
        while (j < this.acqPars) {
            if (j < this.nPars) {
                this.loLim[j] = this.byteRev ? this.pBits[j] / 8 - 1 : 0;
                this.hiLim[j] = this.byteRev ? 0 : this.pBits[j] / 8 - 1;
                this.scales[j] = this.pRange[j] > 127 ? this.pRange[j] / 127 : 1;
            } else {
                this.scales[j] = 1;
            }
            ++j;
        }
        return true;
    }

    public void postlude() {
        try {
            this.finp.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Note getNextNote(int every, int pitchPar, int volumePar, boolean incBuff) {
        boolean gotPar = this.getPar(every, incBuff);
        if (gotPar && volumePar >= 0 && pitchPar >= 0) {
            return new Note(this.fpar[pitchPar], this.fpar[volumePar]);
        }
        if (gotPar && pitchPar >= 0) {
            return new Note(this.fpar[pitchPar], 0.5);
        }
        return null;
    }

    private boolean getPar(int skip, boolean incBuff) {
        int ipar;
        long[] par = new long[this.nPars];
        int oldBufIndex = this.bufIndex;
        while (skip-- > 0) {
            ipar = 0;
            while (ipar < this.nPars) {
                long aByte;
                int iBy;
                par[ipar] = 0L;
                if (this.byteRev) {
                    iBy = this.loLim[ipar];
                    while (iBy >= this.hiLim[ipar]) {
                        aByte = this.buffer[this.bufIndex++] & 0xFF;
                        int n = ipar;
                        par[n] = par[n] + (aByte << 8 * iBy);
                        --iBy;
                    }
                } else {
                    iBy = this.loLim[ipar];
                    while (iBy <= this.hiLim[ipar]) {
                        aByte = this.buffer[this.bufIndex++] & 0xFF;
                        int n = ipar;
                        par[n] = par[n] + (aByte << 8 * iBy);
                        ++iBy;
                    }
                }
                if (this.datatype == 70) {
                    par[ipar] = (long)Float.intBitsToFloat((int)par[ipar]);
                } else {
                    int n = ipar;
                    par[n] = par[n] & (long)(this.pRange[ipar] - 1);
                }
                this.fpar[ipar] = FileSpec.realValueS(par[ipar], this.flogflg[ipar], this.logrng[ipar], this.pRange[ipar], false);
                ++ipar;
            }
            ipar = this.nPars;
            while (ipar < this.acqPars) {
                this.bufIndex += this.pBits[ipar] / 8;
                ++ipar;
            }
        }
        if (!incBuff) {
            this.bufIndex = oldBufIndex;
        }
        if (this.compensate) {
            this.calcComp(this.fpar);
        }
        this.channelValuesAll(this.fpar, par);
        ipar = 0;
        while (ipar < this.nPars) {
            this.fpar[ipar] = (double)par[ipar] / 256.0;
            ++ipar;
        }
        return true;
    }

    private void setSplitParameters() {
        int i = 0;
        while (i < this.nPars) {
            if (this.flogflg[i]) {
                this.maxLog[i] = this.logrng[i];
                this.minSplitLog[i] = 1.0;
                this.minLog[i] = 0.0;
                this.linRange[i] = (int)Math.pow(10.0, this.logrng[i]);
            } else {
                this.maxLog[i] = FileSpec.log10(this.pRange[i]);
                this.logrng[i] = (float)this.maxLog[i];
                this.minSplitLog[i] = -384.0 * LOG10e / 64.0 + this.maxLog[i];
                this.minLog[i] = this.maxLog[i] - 4.0;
                this.linRange[i] = this.pRange[i];
            }
            if (this.maxLog[i] <= 0.0) {
                this.maxLog[i] = 4.0;
            }
            if (this.minSplitLog[i] >= this.maxLog[i]) {
                this.minSplitLog[i] = 0.0;
            }
            this.minSplitVal[i] = Math.pow(10.0, this.minSplitLog[i]);
            this.splitLogFactor[i] = 192.0 / (this.maxLog[i] - this.minSplitLog[i]);
            this.logFactor[i] = 256.0 / (this.maxLog[i] - this.minLog[i]);
            this.loValFactor[i] = 32.0 / this.minSplitVal[i];
            this.linFactor[i] = 256.0 / (double)this.linRange[i];
            ++i;
        }
    }

    private boolean setRegionScales() {
        boolean localM = false;
        return localM;
    }

    private boolean setWindowScales() {
        boolean localM = false;
        return localM;
    }

    private void readList(GDisplay gd) throws FileNotFoundException, FCSParameterException, RuntimeException, IOException {
        boolean density = false;
        byte[] outBuffer = null;
        boolean outBufIndex = false;
        int[] linkX = null;
        double[] fpar = new double[this.nPars];
        float[] rV = new float[64];
        long[] par = new long[this.nPars];
        int[] loLim = new int[64];
        int[] hiLim = new int[64];
        boolean rev = false;
        int ncell = 0;
        this.gd = gd;
        boolean mode1 = this.gd.mode == 0;
        boolean dither = !mode1;
        boolean mode2 = this.gd.mode == 2;
        boolean mode2d = this.gd.mode == 1;
        boolean outliers = (gd.style & 0x2000) != 0;
        boolean mode3 = !mode1 && !mode2 && !mode2d;
        boolean bl = density = this.gd.mode == 2 && (this.gd.style & 1) != 0;
        int imax = mode2 || mode2d ? 3 : (mode3 ? 4 : 0);
        int i = 0;
        while (i < imax) {
            if (this.gd.parameter[i] >= this.nPars && (mode2 || mode2d || mode3)) {
                this.gd.parameter[i] = this.nPars - 1;
            }
            ++i;
        }
        i = imax;
        while (i < 64) {
            if (this.gd.parameter[i] >= this.nPars) {
                this.gd.parameter[i] = this.nPars - 1;
            }
            ++i;
        }
        if (this.nPars == 0) {
            throw new FCSParameterException("FCSParameterMismatch");
        }
        if (!this.createArray(gd, mode1, mode2, mode2d, mode3, outliers)) {
            throw new RuntimeException("Array creation exception");
        }
        int cellSiz = 0;
        int j = 0;
        while (j < this.acqPars) {
            cellSiz += this.pBits[j] / 8;
            if (j < this.nPars) {
                rev = this.byteRev;
                loLim[j] = rev ? this.pBits[j] / 8 - 1 : 0;
                hiLim[j] = rev ? 0 : this.pBits[j] / 8 - 1;
                int n = rev ? -1 : 1;
            }
            ++j;
        }
        int totSiz = cellSiz * this.total;
        int bufSiz = this.total > 100000 ? cellSiz * 100000 : totSiz;
        this.buffer = new byte[bufSiz];
        this.setSplitParameters();
        InputStream remfp = this.openStream();
        int oldGated = this.gated;
        this.gated = 0;
        int remSiz = totSiz;
        this.bufIndex = bufSiz;
        ncell = 0;
        while (ncell < this.total) {
            if (this.bufIndex >= bufSiz) {
                int bytesRead = this.fillBuffer(remfp, this.buffer, remSiz > bufSiz ? bufSiz : remSiz);
                if (bytesRead <= 0) {
                    remSiz += bytesRead;
                    this.total = ncell - bytesRead / cellSiz;
                } else {
                    remSiz -= bytesRead;
                }
                this.bufIndex = 0;
            }
            int ipar = 0;
            while (ipar < this.nPars) {
                long aByte;
                int iBy;
                par[ipar] = 0L;
                if (rev) {
                    iBy = loLim[ipar];
                    while (iBy >= hiLim[ipar]) {
                        aByte = this.buffer[this.bufIndex++] & 0xFF;
                        int n = ipar;
                        par[n] = par[n] + (aByte << 8 * iBy);
                        --iBy;
                    }
                } else {
                    iBy = loLim[ipar];
                    while (iBy <= hiLim[ipar]) {
                        aByte = this.buffer[this.bufIndex++] & 0xFF;
                        int n = ipar;
                        par[n] = par[n] + (aByte << 8 * iBy);
                        ++iBy;
                    }
                }
                if (this.datatype == 70) {
                    par[ipar] = (long)Float.intBitsToFloat((int)par[ipar]);
                } else {
                    int n = ipar;
                    par[n] = par[n] & (long)(this.pRange[ipar] - 1);
                }
                fpar[ipar] = FileSpec.realValueS(par[ipar], this.flogflg[ipar], this.logrng[ipar], this.pRange[ipar], dither);
                ++ipar;
            }
            ipar = this.nPars;
            while (ipar < this.acqPars) {
                this.bufIndex += this.pBits[ipar] / 8;
                ++ipar;
            }
            if (this.compensate) {
                this.calcComp(fpar);
            }
            if (this.ratio) {
                this.calcRatio(fpar);
            }
            this.channelValuesAll(fpar, par);
            if (mode1) {
                this.incrementHisto(gd, par);
            } else if (mode2 || mode2d) {
                this.incrementConto(gd, par);
                if (mode2d || outliers) {
                    this.incrementDotp(gd, par, mode2d, outliers);
                }
            } else if (mode3) {
                this.incrementDotp3D(gd, par);
            }
            ++this.gated;
            ++ncell;
        }
        remfp.close();
        if (density) {
            this.nearNeighbours(gd);
            this.kernConv(gd);
        }
        if (this.total > ncell) {
            this.total = ncell;
        }
        this.virgin = false;
        outBuffer = null;
    }

    void writeSkip(FileOutputStream f, int i) throws IOException {
        if (i > 0) {
            byte[] skip = new byte[i];
            while (i > 0) {
                skip[--i] = 32;
            }
            f.write(skip);
        }
    }

    private float getMedian(int[] ia, int parnum, int tot) {
        tot /= 2;
        int i = 0;
        int sum = 0;
        while (i < ia.length) {
            if ((sum += ia[i]) >= tot) break;
            ++i;
        }
        return (float)this.realValueFromChan(i, parnum, 0.5);
    }

    private float getMode(int[] ia, int parnum) {
        int i = 0;
        int high = 0;
        long imode = 0L;
        while (i < ia.length) {
            if (ia[i] > high) {
                high = ia[i];
                imode = i;
            }
            ++i;
        }
        return (float)this.realValueFromChan(imode, parnum, 0.5);
    }

    private InputStream openStream() throws FileNotFoundException, IOException {
        FileInputStream fp = new FileInputStream(this.pathname);
        if (fp == null) {
            throw new FileNotFoundException("File can't be opened");
        }
        ((InputStream)fp).skip(this.dataStrt);
        return fp;
    }

    private int fillBuffer(InputStream fp, byte[] buffer, int bufSiz) throws IOException {
        int bytesRead = 0;
        int thisBatch = 0;
        while (bytesRead < bufSiz && (thisBatch = fp.read(buffer, bytesRead, bufSiz - bytesRead)) >= 0) {
            bytesRead += thisBatch;
        }
        if (thisBatch < 0) {
            return -bytesRead;
        }
        return bytesRead;
    }

    public static String find(byte[] a, byte[] b, byte c) {
        int j = 0;
        int i = 1;
        while (i < a.length - b.length) {
            j = 0;
            while (j < b.length) {
                if (b[j] != a[i + j]) break;
                ++j;
            }
            if (j == b.length && a[i - 1] == c && a[i + j] == c) break;
            ++i;
        }
        if (j < b.length) {
            return null;
        }
        i += j + 1;
        j = i;
        while (j < a.length) {
            if (a[j] == c) break;
            ++j;
        }
        if (j >= a.length) {
            return null;
        }
        return new String(a, i, j - i);
    }

    public static String extractS(byte[] a, byte[] b, byte c) {
        return FileSpec.find(a, b, c);
    }

    private boolean extractBool(byte[] a, byte[] b, byte c) {
        String str = FileSpec.find(a, b, c);
        if (str == null) {
            return false;
        }
        return (str = str.toLowerCase()).startsWith("t") || str.startsWith("y");
    }

    public static int extractI(byte[] a, byte[] b, byte c) {
        int i;
        String str = FileSpec.find(a, b, c);
        if (str == null) {
            return -1;
        }
        try {
            i = Integer.parseInt(str.trim());
        }
        catch (NumberFormatException e) {
            try {
                i = (int)Float.parseFloat(str.trim());
            }
            catch (NumberFormatException e2) {
                i = 0;
            }
        }
        return i;
    }

    private float extractFem(byte[] a, byte[] b, byte c) {
        float f = -1.0f;
        String str = FileSpec.find(a, b, c);
        if (str != null) {
            StringTokenizer stk = new StringTokenizer(str);
            while (f < 0.0f && stk.hasMoreTokens()) {
                try {
                    f = Float.parseFloat(stk.nextToken());
                }
                catch (Exception e) {
                    f = -1.0f;
                }
            }
        }
        return f;
    }

    private float extractF(byte[] a, byte[] b, byte c) {
        float f = -1.0f;
        String str = FileSpec.find(a, b, c);
        if (str != null) {
            try {
                f = Float.parseFloat(str.trim());
            }
            catch (NumberFormatException ex) {
                f = -1.0f;
            }
        }
        return f;
    }

    private byte extractB(byte[] a, byte[] b, byte c) {
        String str = FileSpec.find(a, b, c);
        if (str == null) {
            return -1;
        }
        return (byte)str.charAt(0);
    }

    private int[] extractIA(byte[] a, byte[] b, byte c) {
        String str = FileSpec.find(a, b, c);
        if (str == null) {
            return null;
        }
        int[] iA = new int[2];
        int k = 0;
        int i = 0;
        while (i < 2) {
            int j = k;
            while (j < str.length()) {
                if (Character.isDigit(str.charAt(j))) break;
                ++j;
            }
            k = j + 1;
            while (k < str.length()) {
                if (!Character.isDigit(str.charAt(k))) break;
                ++k;
            }
            if (j == str.length()) {
                return null;
            }
            iA[i] = Integer.parseInt(str.substring(j, k));
            ++i;
        }
        return iA;
    }

    private float[][] extractSpill(byte[] a, byte[] b, byte c, String[] fpName, boolean[] compOn, boolean transpose) {
        int dim;
        int found = 0;
        String str = FileSpec.find(a, b, c);
        if (str == null) {
            return null;
        }
        StringTokenizer stk = new StringTokenizer(str, ",\t");
        try {
            dim = Integer.parseInt(stk.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        String[] spName = new String[dim];
        int[] spNum = new int[dim];
        float[][] spMatrix = new float[dim][dim];
        int j = 0;
        while (j < compOn.length) {
            compOn[j] = false;
            ++j;
        }
        int i = 0;
        while (i < dim && stk.hasMoreTokens()) {
            try {
                spName[i] = stk.nextToken();
            }
            catch (Exception e) {
                return null;
            }
            spNum[i] = -1;
            j = 0;
            while (j < fpName.length) {
                if (spName[i].equals(fpName[j])) {
                    spNum[i] = j;
                    if (j < compOn.length) {
                        compOn[j] = true;
                    }
                    ++found;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (found < dim) {
            return null;
        }
        i = 0;
        while (i < dim) {
            j = 0;
            while (j < dim) {
                try {
                    if (transpose) {
                        spMatrix[j][i] = Float.parseFloat(stk.nextToken());
                    } else {
                        spMatrix[i][j] = Float.parseFloat(stk.nextToken());
                    }
                }
                catch (Exception e) {
                    return null;
                }
                ++j;
            }
            ++i;
        }
        return spMatrix;
    }

    private float[] extractFA(byte[] a, byte[] b, byte c) {
        int MAXSIZE = 16;
        String str = FileSpec.find(a, b, c);
        if (str == null) {
            return null;
        }
        float[] fB = new float[16];
        StringTokenizer stk = new StringTokenizer(str, ", \t\n\r");
        int i = 0;
        while (i < 16 && stk.hasMoreTokens()) {
            try {
                fB[i] = Float.parseFloat(stk.nextToken());
                ++i;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (i > 0) {
            float[] fA = new float[i];
            int j = 0;
            while (j < i) {
                fA[j] = fB[j];
                ++j;
            }
            return fA;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private byte[] replaceVal(byte[] hdr, byte[] key, byte[] val) {
        j = 0;
        dlt = hdr[0];
        newHdr = new byte[hdr.length];
        i = 0;
        while (i < hdr.length) {
            newHdr[i] = hdr[i];
            ++i;
        }
        i = 0;
        while (i <= newHdr.length - key.length) {
            j = 0;
            while (j < key.length) {
                if (key[j] != newHdr[i + j]) break;
                ++j;
            }
            if (j == key.length) break;
            ++i;
        }
        if (j < key.length) {
            return null;
        }
        i += j + 1;
        j = i;
        while (j < newHdr.length) {
            if (newHdr[j] == dlt) break;
            ++j;
        }
        if (j < newHdr.length) ** GOTO lbl31
        return null;
lbl-1000:
        // 1 sources

        {
            newHdr[i] = i < j - val.length ? 32 : val[i - j + val.length];
            ++i;
lbl31:
            // 2 sources

            ** while (i < j)
        }
lbl32:
        // 1 sources

        return newHdr;
    }

    private byte[] modifyPreamble(byte[] preamble, int dataEnd) {
        byte[] val = String.valueOf(dataEnd).trim().getBytes();
        byte[] newPreamble = new byte[preamble.length];
        int index = 0;
        while (index < preamble.length) {
            newPreamble[index] = preamble[index];
            ++index;
        }
        int endIndex = 42;
        index = endIndex - 8;
        while (index < endIndex) {
            newPreamble[index] = index < endIndex - val.length ? 32 : val[index - endIndex + val.length];
            ++index;
        }
        return newPreamble;
    }

    public String getLabel(int num) {
        if (num < 0 || num >= 64) {
            return null;
        }
        String lbl = this.label[num];
        if (lbl != null && lbl.length() > 0) {
            return lbl;
        }
        lbl = this.parstain[num];
        if (lbl != null) {
            return lbl;
        }
        lbl = this.parname[num];
        if (lbl != null) {
            return lbl;
        }
        return new String("par" + num);
    }

    boolean interpretI(Gate g) {
        int c;
        boolean b = false;
        boolean b2 = false;
        boolean not = false;
        int op = 43;
        while (g.index < g.ia.length && (c = g.ia[g.index++]) != 41) {
            if (c == 82 || c == 66 || c == 87 || c == 67) {
                int n = g.ia[g.index++];
                if (c == 82) {
                    b2 = not ? !this.r[n] : this.r[n];
                } else if (c == 87) {
                    b2 = not ? !this.w[n] : this.w[n];
                } else if (c == 67) {
                    if (not) {
                        b2 = this.cl != n;
                    } else {
                        boolean bl = b2 = this.cl == n;
                    }
                }
                if (op == 43) {
                    b = b || b2;
                } else if (op == 42) {
                    b = b && b2;
                }
                op = 43;
                not = false;
                continue;
            }
            if (c == 40) {
                if (not) {
                    b2 = !this.interpretI(g);
                    not = false;
                } else {
                    b2 = this.interpretI(g);
                }
                if (op == 43) {
                    b = b || b2;
                } else if (op == 42) {
                    b = b && b2;
                }
                op = 43;
                continue;
            }
            if (c == 43 || c == 42) {
                op = c;
                continue;
            }
            if (c != 45) continue;
            not = true;
        }
        return b;
    }

    boolean interpret(Gate g) {
        char c;
        int number = 0;
        int type = 1;
        boolean b = false;
        boolean b2 = false;
        boolean not = false;
        int op = 43;
        while (g.index < g.s.length() && (c = g.s.charAt(g.index++)) != ')') {
            if (c == 'R') {
                type = 1;
                continue;
            }
            if (c == 'W') {
                type = 2;
                continue;
            }
            if (c == 'C') {
                type = 3;
                number = 0;
                continue;
            }
            if (c == '(') {
                if (not) {
                    b2 = !this.interpret(g);
                    not = false;
                } else {
                    b2 = this.interpret(g);
                }
                if (op == 43) {
                    b = b || b2;
                } else if (op == 42) {
                    b = b && b2;
                }
                op = 43;
                continue;
            }
            if (c == '.') {
                if (type != 3) continue;
                if (not) {
                    b2 = this.cl != number;
                    not = false;
                } else {
                    boolean bl = b2 = this.cl == number;
                }
                if (op == 43) {
                    b = b || b2;
                    continue;
                }
                if (op != 42) continue;
                b = b && b2;
                op = 43;
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (type == 3) {
                    number = number * 10 + (c - 48);
                    continue;
                }
                if (not) {
                    b2 = type == 1 ? !this.r[c - 48] : !this.w[c - 48];
                    not = false;
                } else {
                    b2 = type == 1 ? this.r[c - 48] : this.w[c - 48];
                }
                if (op == 43) {
                    b = b || b2;
                    continue;
                }
                if (op != 42) continue;
                b = b && b2;
                op = 43;
                continue;
            }
            if (c == '+' || c == '*') {
                op = c;
                continue;
            }
            if (c != '-') continue;
            not = true;
        }
        return b;
    }

    void incrementDotp(GDisplay gd, long[] par, boolean mode2d, boolean outliers) {
        if (outliers || this.gated < this.dArraySize) {
            byte rC = 1;
            int i = gd.cSymph.regionNum - 1;
            while (i >= 0) {
                if (this.r[i]) {
                    rC = (byte)(i + 2);
                    break;
                }
                --i;
            }
            byte gC = 1;
            i = gd.cSymph.gateNum - 1;
            while (i >= 0) {
                if (this.g[i]) {
                    gC = (byte)(i + 2);
                    break;
                }
                --i;
            }
            int col = 2 + (int)par[this.gd.parameter[3]];
            byte clC = col < 16 ? (byte)col : (byte)1;
            byte hC = (byte)(1 + (int)par[this.gd.parameter[3]] / 32);
            byte size = (byte)par[this.gd.parameter[7]];
            Dot dt = (gd.style & 0x800) != 0 ? new ColDot((int)par[this.gd.parameter[0]], (int)par[this.gd.parameter[1]], gC, rC, hC, clC, size, (byte)par[this.gd.parameter[4]], (byte)par[this.gd.parameter[5]], (byte)par[this.gd.parameter[6]]) : new Dot((int)par[this.gd.parameter[0]], (int)par[this.gd.parameter[1]], gC, rC, hC, clC, size);
            if (mode2d) {
                gd.dArray[this.gated] = dt;
            } else if (outliers) {
                gd.oArray[dt.x & 0xFF][dt.y & 0xFF] = dt;
            }
        }
    }

    void incrementDotp3D(GDisplay gd, long[] par) {
        if (this.gated < this.dArraySize) {
            byte rC = 1;
            int i = 0;
            while (i < gd.cSymph.regionNum) {
                if (this.r[i]) {
                    rC = (byte)(i + 2);
                    break;
                }
                ++i;
            }
            byte gC = 1;
            i = gd.cSymph.gateNum - 1;
            while (i >= 0) {
                if (this.g[i]) {
                    gC = (byte)(i + 2);
                    break;
                }
                --i;
            }
            int col = 2 + (int)par[this.gd.parameter[3]];
            byte clC = col < 16 ? (byte)col : (byte)1;
            byte hC = (byte)(1 + (int)par[this.gd.parameter[3]] / 32);
            byte size = (byte)par[this.gd.parameter[7]];
            gd.d3DArray[this.gated] = (gd.style & 0x800) != 0 ? new ColDot3D((int)par[this.gd.parameter[0]], (int)par[this.gd.parameter[1]], (int)par[this.gd.parameter[2]], gC, rC, hC, clC, size, (byte)par[this.gd.parameter[4]], (byte)par[this.gd.parameter[5]], (byte)par[this.gd.parameter[6]]) : new Dot3D((int)par[this.gd.parameter[0]], (int)par[this.gd.parameter[1]], (int)par[this.gd.parameter[2]], gC, rC, hC, clC, size);
        }
    }

    void incrementHisto(GDisplay gd, long[] par) {
        int i = 0;
        while (i < this.nPars) {
            int n = 256 * i + (int)par[i];
            gd.iArray[n] = gd.iArray[n] + 1;
            ++i;
        }
    }

    void incrementHisto(GDisplay gd, int[] par) {
        int i = 0;
        while (i < this.nPars) {
            int n = 256 * i + par[i];
            gd.iArray[n] = gd.iArray[n] + 1;
            ++i;
        }
    }

    void smoothAll(GDisplay gd) {
        if (gd.iArray != null) {
            int i = 0;
            while (i < this.nPars) {
                this.smooth(gd.iArray, 256 * i, 256);
                ++i;
            }
        }
    }

    void incrementConto(GDisplay gd, long[] par) {
        this.incrementConto(gd, (int)par[this.gd.parameter[0]], (int)par[this.gd.parameter[1]]);
    }

    void incrementConto(GDisplay gd, int i, int j) {
        int n = 256 * j + i;
        gd.iArray[n] = gd.iArray[n] + 1;
    }

    void nearNeighbours(GDisplay gd) {
        int rad_00 = 0;
        if (this.n_n == null || this.n_n.length != this.size2D) {
            this.n_n = new int[this.size2D][this.size2D];
        }
        int iAf = 256 / this.size2D;
        int i = 0;
        while (i < this.size2D) {
            int rad_0 = rad_00;
            int j = 0;
            while (j < this.size2D) {
                int radius;
                int m;
                int jiA;
                int count = 0;
                int iiA = 0;
                while (iiA < iAf) {
                    jiA = 0;
                    while (jiA < iAf) {
                        m = (i * iAf + iiA) * 256 + j * iAf + jiA;
                        count += gd.iArray[m];
                        ++jiA;
                    }
                    ++iiA;
                }
                if (count <= 0) {
                    this.n_n[i][j] = rad_0 + 1;
                    radius = rad_0;
                } else {
                    radius = rad_0;
                    while (radius < this.size2D) {
                        int range_sq = radius * radius;
                        int neighbs = 0;
                        int k = -radius;
                        while (k <= radius) {
                            int l = -radius;
                            while (l <= radius && neighbs < 32) {
                                if (k + i >= 0 && k + i < this.size2D && l + j >= 0 && l + j < this.size2D && k * k + l * l <= range_sq) {
                                    iiA = 0;
                                    while (iiA < iAf) {
                                        jiA = 0;
                                        while (jiA < iAf) {
                                            m = ((k + i) * iAf + iiA) * 256 + (l + j) * iAf + jiA;
                                            neighbs += gd.iArray[m];
                                            ++jiA;
                                        }
                                        ++iiA;
                                    }
                                }
                                ++l;
                            }
                            ++k;
                        }
                        if (neighbs >= 32) break;
                        ++radius;
                    }
                    this.n_n[i][j] = radius;
                }
                if (radius > 0) {
                    rad_0 = radius - 1;
                }
                if (j == 0) {
                    rad_00 = rad_0;
                }
                ++j;
            }
            ++i;
        }
    }

    void kernConv(GDisplay gd) {
        int factor = 256 / this.size2D;
        int fSmooth = this.smooth * this.size2D / 64;
        int i_y = 0;
        while (i_y < this.size2D) {
            int i_x = 0;
            while (i_x < this.size2D) {
                int count = 0;
                int jiA = 0;
                while (jiA < factor) {
                    int iiA = 0;
                    while (iiA < factor) {
                        count += gd.iArray[(i_y * factor + jiA) * 256 + i_x * factor + iiA];
                        ++iiA;
                    }
                    ++jiA;
                }
                if (count > 0) {
                    int n_n_d = this.n_n[i_y][i_x];
                    if (n_n_d < fSmooth) {
                        n_n_d = fSmooth;
                    }
                    float r0 = 1.0f / (float)(n_n_d * n_n_d);
                    int j = i_y - n_n_d;
                    while (j <= i_y + n_n_d) {
                        int i = i_x - n_n_d;
                        while (i <= i_x + n_n_d) {
                            float x = i_x - i;
                            float y = i_y - j;
                            float r_sq = r0 * (x * x + y * y);
                            if ((double)r_sq < 1.0) {
                                float kernel = (float)((double)r0 * (1.0 - (double)r_sq) * (1.0 - (double)r_sq));
                                int ias = i < 0 ? 0 : (i >= this.size2D ? this.size2D - 1 : i);
                                int jas = j < 0 ? 0 : (j >= this.size2D ? this.size2D - 1 : j);
                                int n = jas * this.size2D + ias;
                                gd.rArray[n] = gd.rArray[n] + (float)count * kernel;
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
                ++i_x;
            }
            ++i_y;
        }
    }

    private void calcComp(double[] fpar) {
        int i = 0;
        while (i < this.nPars) {
            double afltComp = 0.0;
            if (this.compOn[i]) {
                int j = 0;
                while (j < this.nPars) {
                    if (this.compOn[j]) {
                        double a = fpar[j];
                        if (j != i) {
                            a -= this.backGnd[j];
                        }
                        afltComp += this.compMat[i][j] * a;
                    }
                    ++j;
                }
                fpar[i] = afltComp;
            }
            ++i;
        }
    }

    public void calcRatio(double[] fpar) {
    }

    public long channelValueS(double val, int parnum) {
        long chan = this.logflg[parnum] ? (this.splitflg[parnum] ? (val < this.minSplitVal[parnum] ? 32L + Math.round(val * this.loValFactor[parnum]) : 64L + Math.round((FileSpec.log10(val) - this.minSplitLog[parnum]) * this.splitLogFactor[parnum])) : Math.round((FileSpec.log10(val) - this.minLog[parnum]) * this.logFactor[parnum])) : Math.round(val * this.linFactor[parnum]);
        chan = chan < 0L ? 0L : (chan >= 256L ? 255L : chan);
        return chan;
    }

    private void channelValuesAll(double[] val, long[] chan) {
        int i = 0;
        while (i < chan.length) {
            chan[i] = this.logflg[i] ? (this.splitflg[i] ? (val[i] < this.minSplitVal[i] ? 32L + Math.round(val[i] * this.loValFactor[i]) : 64L + Math.round((FileSpec.log10(val[i]) - this.minSplitLog[i]) * this.splitLogFactor[i])) : (val[i] <= 0.0 ? 0L : Math.round((FileSpec.log10(val[i]) - this.minLog[i]) * this.logFactor[i]))) : Math.round(val[i] * this.linFactor[i]);
            chan[i] = chan[i] < 0L ? 0L : (chan[i] >= 256L ? 255L : chan[i]);
            ++i;
        }
    }

    public static double log10(double x) {
        return LOG10e * Math.log(x);
    }

    public static double realValueS(double par, boolean log, double lRange, double pRange, boolean dither) {
        if (log) {
            if (dither) {
                par += Math.random();
            }
            return Math.pow(10.0, par * lRange / pRange);
        }
        return par;
    }

    public double realValueFromChan(long chan, int parnum, double dither) {
        double d_chan = dither >= 1.0 ? (double)chan + Math.random() : (double)chan + dither;
        double val = this.logflg[parnum] ? (this.splitflg[parnum] ? (chan < 64L ? (d_chan - 32.0) / this.loValFactor[parnum] : Math.pow(10.0, (d_chan - 64.0) / this.splitLogFactor[parnum] + this.minSplitLog[parnum])) : Math.pow(10.0, d_chan / this.logFactor[parnum] + this.minLog[parnum])) : d_chan / this.linFactor[parnum];
        return val;
    }

    public double realValueFromChan(double chan, int parnum) {
        double val = this.logflg[parnum] ? (this.splitflg[parnum] ? (chan < 64.0 ? (chan - 32.0) / this.loValFactor[parnum] : Math.pow(10.0, (chan - 64.0) / this.splitLogFactor[parnum] + this.minSplitLog[parnum])) : Math.pow(10.0, chan / this.logFactor[parnum] + this.minLog[parnum])) : chan / this.linFactor[parnum];
        return val;
    }

    void smooth(int[] array, int offset, int size) {
        float[] data = new float[256];
        if (size > 256) {
            return;
        }
        int j = 0;
        while (j < size) {
            data[j] = 0.0f;
            ++j;
        }
        j = 0;
        while (j < size) {
            float kernel;
            float r_sq;
            int sum = array[offset + j];
            int l = 1;
            while (l <= 32) {
                if (j - l >= 0) {
                    sum += array[offset + j - l];
                }
                if (j + l < size) {
                    sum += array[offset + j + l];
                }
                if (sum >= 16) break;
                ++l;
            }
            int nn_dist = l >= 32 ? 64 : 2 * (l + 1);
            float r_nn_sq = nn_dist * nn_dist;
            float norm = 0.0f;
            l = 1 - nn_dist;
            while (l <= nn_dist - 1) {
                r_sq = l * l;
                kernel = (r_nn_sq - r_sq) * (r_nn_sq - r_sq);
                norm += kernel;
                ++l;
            }
            norm = (float)array[offset + j] / norm;
            l = 1 - nn_dist;
            while (l <= nn_dist - 1) {
                r_sq = l * l;
                kernel = (r_nn_sq - r_sq) * (r_nn_sq - r_sq) * norm;
                int n = j + l;
                if (n < 0) {
                    n = 0;
                } else if (n >= size) {
                    n = size - 1;
                }
                int n2 = n;
                data[n2] = data[n2] + kernel;
                ++l;
            }
            ++j;
        }
        j = 0;
        while (j < size) {
            array[offset + j] = (int)((double)data[j] + 0.5);
            ++j;
        }
    }

    private String completePath(String dir, String name) {
        if (dir == null || name == null) {
            return null;
        }
        if ((dir = dir.trim()).endsWith(String.valueOf(File.separatorChar))) {
            return String.valueOf(dir) + name;
        }
        return String.valueOf(dir) + File.separatorChar + name;
    }

    private String getNameFromPath(String path) {
        if (path == null || path.length() <= 0) {
            return null;
        }
        int index = path.lastIndexOf(File.separatorChar);
        if (index > 0) {
            return path.substring(index + 1);
        }
        return null;
    }
}

