/*
 * Decompiled with CFR 0.152.
 */
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

class FileListTransferHandler
extends TransferHandler {
    private DataFlavor fileFlavor = DataFlavor.javaFileListFlavor;
    private FileViewPanel fvp;

    public FileListTransferHandler(FileViewPanel fvp) {
        this.fvp = fvp;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        block8: {
            if (!this.canImport(c, t.getTransferDataFlavors())) {
                return false;
            }
            try {
                if (!this.hasFileFlavor(t.getTransferDataFlavors())) break block8;
                Object str = null;
                List files = (List)t.getTransferData(this.fileFlavor);
                int i = 0;
                while (i < files.size()) {
                    File file = (File)files.get(i);
                    try {
                        if (this.fvp != null) {
                            this.fvp.insertFile(file, false, i == files.size() - 1);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                return true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasFileFlavor(flavors);
    }

    private boolean hasFileFlavor(DataFlavor[] flavors) {
        int i = 0;
        while (i < flavors.length) {
            if (this.fileFlavor.equals(flavors[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

