/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.vcf;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.interval.BioType;
import org.snpeff.interval.Custom;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Intergenic;
import org.snpeff.interval.Intron;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Motif;
import org.snpeff.interval.NextProt;
import org.snpeff.interval.ProteinProteinInteractionLocus;
import org.snpeff.interval.ProteinStructuralInteractionLocus;
import org.snpeff.interval.Regulation;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.util.Gpr;
import org.snpeff.util.Tuple;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEntry;

public class VcfEffect {
    public static boolean debug = false;
    public static String[] ANN_FIELD_NAMES = new String[]{"ALLELE", "GT", "GENOTYPE", "EFFECT", "ANNOTATION", "IMPACT", "GENE", "GENEID", "FEATURE", "FEATUREID", "TRID", "BIOTYPE", "RANK", "EXID", "HGVS_C", "HGVS_DNA", "CODON", "HGVS", "HGVS_P", "HGVS_PROT", "AA", "POS_CDNA", "CDNA_POS", "LEN_CDNA", "CDNA_LEN", "POS_CDS", "CDS_POS", "LEN_CDS", "CDS_LEN", "POS_AA", "AA_POS", "LEN_AA", "AA_LEN", "DISTANCE", "ERRORS", "WARNINGS", "INFOS"};
    public static String[] EFF_FIELD_NAMES = new String[]{"EFFECT", "IMPACT", "FUNCLASS", "CODON", "AA", "HGVS", "AA_LEN", "GENE", "BIOTYPE", "CODING", "TRID", "RANK", "EXID", "GT", "GENOTYPE_NUMBER", "GENOTYPE", "ERRORS", "WARNINGS", "INFOS"};
    EffFormatVersion formatVersion;
    String vcfFieldString;
    String[] vcfFieldStrings;
    String effString;
    EffectType effectType;
    String effectTypesStr;
    List<EffectType> effectTypes;
    String effectDetails;
    int aaLen;
    int aaPos;
    int cdsLen;
    int cdsPos;
    int cDnaLen;
    int cDnaPos;
    int distance;
    int rank;
    int rankMax;
    BioType bioType;
    String codon;
    String aa;
    String hgvsC;
    String hgvsP;
    VariantEffect.Coding coding;
    String genotype;
    String errorsWarnings;
    String geneName;
    String geneId;
    String featureType;
    String featureId;
    String transcriptId;
    String exonId;
    VariantEffect.EffectImpact impact;
    VariantEffect.FunctionalClass funClass;
    VariantEffect variantEffect;
    boolean useSequenceOntology;
    boolean useHgvs;
    boolean useGeneId;
    boolean useFirstEffect;

    public static String infoFieldName(EffFormatVersion formatVersion) {
        if (formatVersion == null) {
            return "ANN";
        }
        return formatVersion.infoFieldName();
    }

    public static String vcfEffSafe(String str) {
        return str.replaceAll("(\\s|\\(|\\)|\\[|\\]|;|,|\\|)+", "_");
    }

    public VcfEffect(String effectString) {
        this.init();
        this.formatVersion = null;
        this.vcfFieldString = effectString;
        this.parse();
    }

    public VcfEffect(String effectString, EffFormatVersion formatVersion) {
        this.init();
        this.formatVersion = formatVersion;
        this.vcfFieldString = effectString;
        this.parse();
    }

    public VcfEffect(VariantEffect variantEffect, EffFormatVersion formatVersion) {
        this(variantEffect, formatVersion, true, false);
    }

    public VcfEffect(VariantEffect variantEffect, EffFormatVersion formatVersion, boolean useSequenceOntology, boolean useFirstEffect) {
        this.init();
        this.formatVersion = formatVersion;
        this.variantEffect = variantEffect;
        this.useSequenceOntology = useSequenceOntology;
        this.useFirstEffect = useFirstEffect;
        this.set(variantEffect);
    }

    void add(StringBuilder sb, Object obj) {
        if (obj != null) {
            sb.append(VcfEntry.vcfInfoEncode(obj.toString()));
        }
        sb.append("|");
    }

    public void addEffectType(EffectType effectType) {
        this.effectTypes.add(effectType);
        this.effectType = null;
    }

    String createAnnField() {
        StringBuilder effBuff = new StringBuilder();
        this.add(effBuff, this.genotype);
        this.add(effBuff, this.effectTypesStr);
        this.add(effBuff, (Object)this.impact);
        this.add(effBuff, this.geneName);
        this.add(effBuff, this.geneId);
        this.add(effBuff, this.featureType);
        this.add(effBuff, this.featureId);
        this.add(effBuff, (Object)this.bioType);
        if (this.rank >= 0) {
            this.add(effBuff, this.rank + "/" + this.rankMax);
        } else {
            effBuff.append("|");
        }
        this.add(effBuff, this.hgvsC);
        this.add(effBuff, this.hgvsP);
        if (this.cDnaPos >= 0) {
            this.add(effBuff, this.cDnaPos + "/" + this.cDnaLen);
        } else {
            effBuff.append("|");
        }
        if (this.cdsPos >= 0) {
            this.add(effBuff, this.cdsPos + "/" + this.cdsLen);
        } else {
            effBuff.append("|");
        }
        if (this.aaPos >= 0) {
            this.add(effBuff, this.aaPos + "/" + this.aaLen);
        } else {
            effBuff.append("|");
        }
        if (this.distance >= 0) {
            this.add(effBuff, this.distance);
        } else {
            effBuff.append("|");
        }
        effBuff.append(this.errorsWarnings);
        return effBuff.toString();
    }

    String createEffField() {
        StringBuilder effBuff = new StringBuilder();
        effBuff.append(this.effectTypesStr);
        effBuff.append("(");
        effBuff.append((Object)this.impact);
        effBuff.append("|");
        effBuff.append(this.funClass == VariantEffect.FunctionalClass.NONE ? "" : this.funClass.toString());
        effBuff.append("|");
        if (!this.codon.isEmpty()) {
            effBuff.append(this.codon);
        } else if (this.distance >= 0) {
            effBuff.append(this.distance);
        }
        effBuff.append("|");
        if (this.useHgvs) {
            StringBuilder hgvs = new StringBuilder();
            if (this.hgvsP != null) {
                hgvs.append(VcfEntry.vcfInfoEncode(this.hgvsP));
            }
            if (this.hgvsC != null) {
                if (hgvs.length() > 0) {
                    hgvs.append('/');
                }
                hgvs.append(VcfEntry.vcfInfoEncode(this.hgvsC));
            }
            effBuff.append(hgvs.toString());
        } else {
            effBuff.append(this.aa);
        }
        effBuff.append("|");
        if (this.formatVersion != EffFormatVersion.FORMAT_EFF_2) {
            effBuff.append(this.aaLen >= 0 ? Integer.valueOf(this.aaLen) : "");
            effBuff.append("|");
        }
        if (this.variantEffect != null) {
            Gene gene = this.variantEffect.getGene();
            Transcript tr = this.variantEffect.getTranscript();
            if (gene != null) {
                effBuff.append(VcfEntry.vcfInfoValueSafe(this.useGeneId ? this.geneId : this.geneName));
                effBuff.append("|");
                if (tr != null) {
                    if (tr.getBioType() != null && tr.getBioType() != null) {
                        effBuff.append((Object)tr.getBioType());
                    } else {
                        effBuff.append(tr.isProteinCoding() ? "protein_coding" : "");
                    }
                }
                effBuff.append("|");
                String coding = "";
                if (gene.getGenome().hasCodingInfo()) {
                    coding = gene.isProteinCoding() ? VariantEffect.Coding.CODING.toString() : VariantEffect.Coding.NON_CODING.toString();
                }
                effBuff.append(coding);
                effBuff.append("|");
            } else if (this.variantEffect.isRegulation()) {
                Regulation reg = (Regulation)this.variantEffect.getMarker();
                effBuff.append("|" + reg.getRegulationType() + "||");
            } else if (this.variantEffect.isCustom()) {
                Marker m = this.variantEffect.getMarker();
                if (m != null) {
                    effBuff.append("|" + VcfEntry.vcfInfoValueSafe(m.getId()) + "||");
                } else {
                    effBuff.append("|||");
                }
            } else {
                effBuff.append("|||");
            }
        } else {
            effBuff.append(VcfEntry.vcfInfoValueSafe(this.useGeneId ? this.geneId : this.geneName));
            effBuff.append("|");
            effBuff.append((Object)this.bioType);
            effBuff.append("|");
            effBuff.append((Object)this.coding);
            effBuff.append("|");
        }
        effBuff.append(VcfEntry.vcfInfoValueSafe(this.transcriptId));
        effBuff.append("|");
        effBuff.append(this.rank >= 0 ? Integer.valueOf(this.rank) : "");
        if (this.formatVersion == EffFormatVersion.FORMAT_EFF_4) {
            effBuff.append("|");
            effBuff.append(this.genotype);
        }
        if (!this.errorsWarnings.isEmpty()) {
            effBuff.append("|");
            effBuff.append(this.errorsWarnings);
        }
        effBuff.append(")");
        return effBuff.toString();
    }

    String createInfoField() {
        if (this.formatVersion == null || this.formatVersion.isAnn()) {
            return this.createAnnField();
        }
        return this.createEffField();
    }

    public EffFormatVersion formatVersion() {
        if (this.formatVersion != null && this.formatVersion.isFullVersion()) {
            return this.formatVersion;
        }
        if (this.formatVersion == null) {
            this.formatVersion = this.formatVersion(this.vcfFieldString);
        }
        if (this.vcfFieldStrings == null) {
            this.vcfFieldStrings = this.split(this.vcfFieldString);
        }
        if (this.formatVersion.isAnn()) {
            this.formatVersion = EffFormatVersion.FORMAT_ANN_1;
        } else if (this.formatVersion.isEff()) {
            int len = this.vcfFieldStrings.length;
            String lastField = this.vcfFieldStrings[len - 2];
            if (lastField.startsWith("ERROR") || lastField.startsWith("WARNING") || lastField.startsWith("INFO")) {
                --len;
            }
            this.formatVersion = len <= 11 ? EffFormatVersion.FORMAT_EFF_2 : (len <= 12 ? EffFormatVersion.FORMAT_EFF_3 : EffFormatVersion.FORMAT_EFF_4);
        } else {
            throw new RuntimeException("Unimplemented formatVersion '" + (Object)((Object)this.formatVersion) + "'");
        }
        return this.formatVersion;
    }

    protected EffFormatVersion formatVersion(String effectString) {
        String paren;
        String[] fields;
        int idxLp = effectString.indexOf(40);
        if (idxLp < 0) {
            return EffFormatVersion.FORMAT_ANN;
        }
        int idxRp = effectString.lastIndexOf(41);
        if (idxLp < idxRp && (fields = (paren = effectString.substring(idxLp + 1, idxRp)).split("\\|", -1)).length >= 9) {
            return EffFormatVersion.FORMAT_EFF;
        }
        return EffFormatVersion.FORMAT_ANN;
    }

    public String getAa() {
        return this.aa;
    }

    public int getAaLen() {
        return this.aaLen;
    }

    public int getAaPos() {
        return this.aaPos;
    }

    public String getAllele() {
        return this.genotype;
    }

    public BioType getBioType() {
        return this.bioType;
    }

    public int getcDnaLen() {
        return this.cDnaLen;
    }

    public int getcDnaPos() {
        return this.cDnaPos;
    }

    public int getCdsLen() {
        return this.cdsLen;
    }

    public int getCdsPos() {
        return this.cdsPos;
    }

    public VariantEffect.Coding getCoding() {
        return this.coding;
    }

    public String getCodon() {
        return this.codon;
    }

    public int getDistance() {
        return this.distance;
    }

    public String getEffectDetails() {
        return this.effectDetails;
    }

    public String getEffectsStr() {
        StringBuilder sb = new StringBuilder();
        for (EffectType et : this.effectTypes) {
            if (sb.length() > 0) {
                sb.append(this.formatVersion.separator());
            }
            sb.append((Object)et);
        }
        return sb.toString();
    }

    public String getEffectsStrSo() {
        StringBuilder sb = new StringBuilder();
        for (EffectType et : this.effectTypes) {
            if (sb.length() > 0) {
                sb.append(this.formatVersion.separator());
            }
            sb.append(et.toSequenceOntology(this.formatVersion, null));
        }
        return sb.toString();
    }

    public EffectType getEffectType() {
        if (this.effectType != null) {
            return this.effectType;
        }
        if (this.effectTypes == null || this.effectTypes.isEmpty()) {
            return EffectType.NONE;
        }
        this.effectType = EffectType.NONE;
        for (EffectType et : this.effectTypes) {
            if (et.compareTo(this.effectType) >= 0) continue;
            this.effectType = et;
        }
        return this.effectType;
    }

    public List<EffectType> getEffectTypes() {
        return this.effectTypes;
    }

    public String getEffectTypesStr() {
        return this.effectTypesStr;
    }

    public String getEffString() {
        return this.effString;
    }

    public String getErrorsWarning() {
        return this.errorsWarnings;
    }

    public String getExonId() {
        return this.exonId;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public String getFeatureType() {
        return this.featureType;
    }

    public String getFieldByName(String fieldName) {
        switch (fieldName) {
            case "ALLELE": 
            case "GT": 
            case "GENOTYPE": 
            case "GENOTYPE_NUMBER": {
                return this.genotype;
            }
            case "EFFECT": 
            case "ANNOTATION": {
                return this.effString;
            }
            case "IMPACT": {
                return this.impact != null ? this.impact.toString() : "";
            }
            case "FUNCLASS": {
                return this.funClass != null ? this.funClass.toString() : "";
            }
            case "GENE": {
                return this.geneName;
            }
            case "GENEID": {
                return this.geneId;
            }
            case "FEATURE": 
            case "FEATURE_TYPE": {
                return this.featureType;
            }
            case "FEATUREID": {
                return this.featureId;
            }
            case "TRID": {
                return this.transcriptId;
            }
            case "BIOTYPE": {
                return this.bioType == null ? "" : this.bioType.toString();
            }
            case "RANK": {
                return Integer.toString(this.rank);
            }
            case "EXID": {
                return this.exonId;
            }
            case "RANK_MAX": {
                return Integer.toString(this.rankMax);
            }
            case "HGVS_C": 
            case "HGVS_DNA": {
                return this.hgvsC;
            }
            case "CODON": {
                return this.codon;
            }
            case "HGVS": 
            case "HGVS_P": 
            case "HGVS_PROT": {
                return this.hgvsP;
            }
            case "AA": {
                return this.aa;
            }
            case "POS_CDNA": 
            case "CDNA_POS": {
                return Integer.toString(this.cDnaPos);
            }
            case "LEN_CDNA": 
            case "CDNA_LEN": {
                return Integer.toString(this.cDnaLen);
            }
            case "POS_CDS": 
            case "CDS_POS": {
                return Integer.toString(this.cdsPos);
            }
            case "LEN_CDS": 
            case "CDS_LEN": {
                return Integer.toString(this.cdsLen);
            }
            case "POS_AA": 
            case "AA_POS": {
                return Integer.toString(this.aaPos);
            }
            case "LEN_AA": 
            case "AA_LEN": {
                return Integer.toString(this.aaLen);
            }
            case "CODING": {
                return this.coding != null ? this.coding.toString() : "";
            }
            case "DISTANCE": {
                return Integer.toString(this.distance);
            }
            case "ERRORS": 
            case "WARNINGS": 
            case "INFOS": {
                return this.errorsWarnings;
            }
        }
        throw new RuntimeException("Field '" + fieldName + "' not found.");
    }

    public EffFormatVersion getFormatVersion() {
        return this.formatVersion;
    }

    public VariantEffect.FunctionalClass getFunClass() {
        return this.funClass;
    }

    public String getGeneId() {
        return this.geneId;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public String getGenotype() {
        return this.genotype;
    }

    public String getHgvsC() {
        return this.hgvsC;
    }

    public String getHgvsDna() {
        return this.hgvsC;
    }

    public String getHgvsP() {
        return this.hgvsP;
    }

    public String getHgvsProt() {
        return this.hgvsP;
    }

    public VariantEffect.EffectImpact getImpact() {
        return this.impact;
    }

    public int getRank() {
        return this.rank;
    }

    public int getRankMax() {
        return this.rankMax;
    }

    public String getTranscriptId() {
        return this.transcriptId;
    }

    public String getVcfFieldString() {
        return this.vcfFieldString;
    }

    public String getVcfFieldString(int index) {
        if (index >= this.vcfFieldStrings.length) {
            return null;
        }
        return this.vcfFieldStrings[index];
    }

    public boolean hasEffectType(EffectType effType) {
        if (this.effectTypes == null) {
            return false;
        }
        for (EffectType et : this.effectTypes) {
            if (et != effType) continue;
            return true;
        }
        return false;
    }

    void init() {
        this.rankMax = -1;
        this.rank = -1;
        this.distance = -1;
        this.cDnaPos = -1;
        this.cDnaLen = -1;
        this.cdsPos = -1;
        this.cdsLen = -1;
        this.aaPos = -1;
        this.aaLen = -1;
        this.errorsWarnings = "";
        this.exonId = "";
        this.transcriptId = "";
        this.featureId = "";
        this.featureType = "";
        this.geneId = "";
        this.geneName = "";
        this.errorsWarnings = "";
        this.genotype = "";
        this.hgvsP = "";
        this.hgvsC = "";
        this.aa = "";
        this.codon = "";
        this.effectDetails = "";
        this.effectTypesStr = "";
        this.effString = "";
        this.vcfFieldString = "";
        this.bioType = null;
        this.impact = null;
        this.funClass = VariantEffect.FunctionalClass.NONE;
        this.useSequenceOntology = true;
        this.useHgvs = true;
        this.useGeneId = false;
    }

    void parse() {
        if (this.formatVersion == null || !this.formatVersion.isFullVersion()) {
            this.formatVersion = this.formatVersion();
        }
        this.vcfFieldStrings = this.split(this.vcfFieldString);
        if (this.formatVersion.isAnn()) {
            this.parseAnn();
        } else {
            this.parseEff();
        }
    }

    void parseAnn() {
        int index = 0;
        this.genotype = this.vcfFieldStrings[index++];
        this.effString = this.vcfFieldStrings[index];
        this.effectTypesStr = this.vcfFieldStrings[index];
        this.effectTypes = this.parseEffect(this.vcfFieldStrings[index]);
        int n = ++index;
        this.impact = VariantEffect.EffectImpact.valueOf(this.vcfFieldStrings[n]);
        int n2 = ++index;
        this.geneName = this.vcfFieldStrings[n2];
        int n3 = ++index;
        this.geneId = this.vcfFieldStrings[n3];
        int n4 = ++index;
        this.featureType = this.vcfFieldStrings[n4];
        int n5 = ++index;
        ++index;
        this.featureId = this.vcfFieldStrings[n5];
        if (this.featureType.equals("transcript")) {
            this.transcriptId = this.featureId;
        }
        this.bioType = BioType.parse(this.vcfFieldStrings[index++]);
        Tuple<Integer, Integer> ints = this.parseSlash(this.vcfFieldStrings[index++]);
        this.rank = (Integer)ints.first;
        this.rankMax = (Integer)ints.second;
        this.codon = this.hgvsC = VcfEntry.vcfInfoDecode(this.vcfFieldStrings[index++]);
        this.aa = this.hgvsP = VcfEntry.vcfInfoDecode(this.vcfFieldStrings[index++]);
        ints = this.parseSlash(this.vcfFieldStrings[index++]);
        this.cDnaPos = (Integer)ints.first;
        this.cDnaLen = (Integer)ints.second;
        ints = this.parseSlash(this.vcfFieldStrings[index++]);
        this.cdsPos = (Integer)ints.first;
        this.cdsLen = (Integer)ints.second;
        ints = this.parseSlash(this.vcfFieldStrings[index++]);
        this.aaPos = (Integer)ints.first;
        this.aaLen = (Integer)ints.second;
        this.distance = Gpr.parseIntSafe(this.vcfFieldStrings[index++]);
        this.errorsWarnings = this.vcfFieldStrings[index++];
    }

    void parseEff() {
        try {
            int index = 0;
            this.effString = this.vcfFieldStrings[index];
            this.effectTypesStr = this.vcfFieldStrings[index];
            this.effectTypes = this.parseEffect(this.vcfFieldStrings[index]);
            this.effectDetails = this.parseEffectDetails(this.vcfFieldStrings[index]);
            if (this.vcfFieldStrings.length > ++index && !this.vcfFieldStrings[index].isEmpty()) {
                this.impact = VariantEffect.EffectImpact.valueOf(this.vcfFieldStrings[index]);
            }
            if (this.vcfFieldStrings.length > ++index && !this.vcfFieldStrings[index].isEmpty()) {
                this.funClass = VariantEffect.FunctionalClass.valueOf(this.vcfFieldStrings[index]);
            }
            if (this.vcfFieldStrings.length > ++index && !this.vcfFieldStrings[index].isEmpty()) {
                this.codon = this.vcfFieldStrings[index];
            }
            if (this.vcfFieldStrings.length > ++index && !this.vcfFieldStrings[index].isEmpty()) {
                this.aa = this.vcfFieldStrings[index];
            }
            if (this.aa.indexOf(47) > 0) {
                String[] f2 = this.aa.split("/");
                if (f2.length > 0 && f2[0].startsWith("p.")) {
                    this.hgvsP = VcfEntry.vcfInfoDecode(f2[0]);
                }
                if (f2.length > 1 && (f2[1].startsWith("c.") || f2[1].startsWith("n."))) {
                    this.hgvsC = VcfEntry.vcfInfoDecode(f2[1]);
                }
            } else if (this.aa.startsWith("c.") || this.aa.startsWith("n.")) {
                this.hgvsC = this.aa = VcfEntry.vcfInfoDecode(this.aa);
            }
            ++index;
            if (this.formatVersion != EffFormatVersion.FORMAT_EFF_2) {
                this.aaLen = this.vcfFieldStrings.length > index && !this.vcfFieldStrings[index].isEmpty() ? Gpr.parseIntSafe(this.vcfFieldStrings[index]) : 0;
                ++index;
            }
            if (this.vcfFieldStrings.length > index && !this.vcfFieldStrings[index].isEmpty()) {
                this.geneName = this.vcfFieldStrings[index];
            }
            if (this.vcfFieldStrings.length > ++index && !this.vcfFieldStrings[index].isEmpty()) {
                this.bioType = BioType.parse(this.vcfFieldStrings[index]);
            }
            if (this.vcfFieldStrings.length > ++index && !this.vcfFieldStrings[index].isEmpty()) {
                this.coding = VariantEffect.Coding.valueOf(this.vcfFieldStrings[index]);
            }
            if (this.vcfFieldStrings.length > ++index && !this.vcfFieldStrings[index].isEmpty()) {
                this.transcriptId = this.vcfFieldStrings[index];
            }
            if (this.vcfFieldStrings.length > ++index && !this.vcfFieldStrings[index].isEmpty()) {
                this.exonId = this.vcfFieldStrings[index];
            }
            ++index;
            if (this.formatVersion == EffFormatVersion.FORMAT_EFF_4) {
                this.genotype = this.vcfFieldStrings.length > index && !this.vcfFieldStrings[index].isEmpty() ? this.vcfFieldStrings[index] : "";
                ++index;
            }
            if (this.vcfFieldStrings.length > index && !this.vcfFieldStrings[index].isEmpty()) {
                this.errorsWarnings = this.vcfFieldStrings[index];
            }
            ++index;
        }
        catch (Exception e) {
            String fields = "";
            for (int i = 0; i < this.vcfFieldStrings.length; ++i) {
                fields = fields + "\t" + i + " : '" + this.vcfFieldStrings[i] + "'\n";
            }
            throw new RuntimeException("Error parsing:\n\t'" + this.vcfFieldString + "'\n\t EFF formatVersion : " + (Object)((Object)this.formatVersion) + "\n" + fields, e);
        }
    }

    List<EffectType> parseEffect(String eff) {
        int idx = eff.indexOf(91);
        if (idx > 0) {
            eff = eff.substring(0, idx);
        }
        LinkedList<EffectType> effs = new LinkedList<EffectType>();
        if (eff.isEmpty()) {
            return effs;
        }
        if (eff.indexOf("+") >= 0) {
            for (String es : eff.split("\\+")) {
                effs.add(EffectType.parse(this.formatVersion, es));
            }
        } else {
            for (String es : eff.split(this.formatVersion.separatorSplit())) {
                effs.add(EffectType.parse(this.formatVersion, es));
            }
        }
        return effs;
    }

    String parseEffectDetails(String eff) {
        int idx = eff.indexOf(91);
        if (idx < 0) {
            return "";
        }
        return eff.substring(idx + 1, eff.length() - 1);
    }

    Tuple<Integer, Integer> parseSlash(String str) {
        int i1 = -1;
        int i2 = -1;
        if (str != null && !str.isEmpty()) {
            String[] fields = str.split("/");
            if (fields.length >= 2) {
                i1 = Gpr.parseIntSafe(fields[0]);
                i2 = Gpr.parseIntSafe(fields[1]);
            } else {
                i1 = Gpr.parseIntSafe(fields[0]);
            }
        }
        return new Tuple<Integer, Integer>(i1, i2);
    }

    void set(VariantEffect variantEffect) {
        List<Gene> genes;
        Variant variant = variantEffect.getVariant();
        Gene gene = variantEffect.getGene();
        Marker marker = variantEffect.getMarker();
        Transcript tr = variantEffect.getTranscript();
        this.genotype = variant.getGenotype() != null ? variant.getGenotype() : (!variant.isVariant() ? variant.getReference() : variant.getAlt());
        this.effectType = variantEffect.getEffectType();
        this.effectTypes = variantEffect.getEffectTypes();
        this.effectTypesStr = this.formatVersion.isAnn() ? variantEffect.getEffectTypeString(true, this.useFirstEffect, this.formatVersion) : variantEffect.effect(true, false, false, this.useSequenceOntology, this.useFirstEffect);
        this.impact = variantEffect.getEffectImpact();
        this.funClass = variantEffect.getFunctionalClass();
        List<Gene> list2 = genes = variantEffect.isMultipleGenes() ? variantEffect.getGenes() : null;
        if (genes != null) {
            this.setGeneNameIdMultiple(variantEffect);
        } else if (gene != null) {
            this.geneName = gene.getGeneName();
            this.geneId = gene.getId();
        } else if (marker instanceof Intergenic) {
            this.geneName = ((Intergenic)marker).getName();
            this.geneId = marker.getId();
        } else {
            this.geneId = "";
            this.geneName = "";
        }
        this.featureId = "";
        this.featureType = "";
        if (marker != null) {
            if (marker instanceof Custom) {
                this.featureType = (Object)((Object)marker.getType()) + this.formatVersion.separator() + ((Custom)marker).getLabel();
                this.featureId = marker.getId();
            } else if (marker instanceof Regulation) {
                Regulation reg = (Regulation)marker;
                this.featureType = (Object)((Object)reg.getType()) + this.formatVersion.separator() + reg.getName() + ":" + reg.getRegulationType();
                this.featureId = marker.getId();
            } else if (marker instanceof NextProt) {
                this.featureType = marker.getId();
                this.featureId = ((NextProt)marker).getTranscriptId();
            } else if (marker instanceof Motif) {
                Motif motif = (Motif)marker;
                this.featureType = motif.getPwmName();
                this.featureId = motif.getPwmId();
            } else if (marker instanceof ProteinStructuralInteractionLocus) {
                this.featureType = "interaction";
                this.featureId = marker.getId();
            } else if (marker instanceof ProteinProteinInteractionLocus) {
                this.featureType = "interaction";
                this.featureId = marker.getId();
            } else if (tr != null) {
                this.featureType = "transcript";
                this.featureId = this.transcriptId = tr.getId();
                if (tr.getVersion() != null && !tr.getVersion().isEmpty()) {
                    this.featureId = this.featureId + "." + tr.getVersion();
                }
            } else {
                this.featureType = marker.getType().toSequenceOntology(this.formatVersion, null);
                this.featureId = marker.getId();
            }
        }
        this.bioType = tr != null ? (tr.getBioType() != null && tr.getBioType() != null ? tr.getBioType() : BioType.coding(tr.isProteinCoding())) : null;
        this.setRank();
        this.codon = variantEffect.getCodonChangeMax();
        this.aa = variantEffect.getAaChange();
        this.hgvsC = variantEffect.getHgvsDna();
        this.hgvsP = variantEffect.getHgvsProt();
        if (tr != null) {
            this.cDnaPos = variantEffect.getcDnaPos();
            if (this.cDnaPos >= 0 && this.formatVersion.isAnn()) {
                ++this.cDnaPos;
            }
            this.cDnaLen = tr.mRna().length();
        } else {
            this.cDnaLen = -1;
            this.cDnaPos = -1;
        }
        if (tr != null) {
            this.cdsPos = variantEffect.getCodonNum() * 3 + variantEffect.getCodonIndex();
            if (this.cdsPos >= 0 && this.formatVersion.isAnn()) {
                ++this.cdsPos;
            }
            this.cdsLen = variantEffect.getCdsLength();
        } else {
            this.cdsLen = -1;
            this.cdsPos = -1;
        }
        if (tr != null) {
            this.aaPos = variantEffect.getCodonNum();
            if (this.aaPos >= 0 && this.formatVersion.isAnn()) {
                ++this.aaPos;
            }
            this.aaLen = variantEffect.getAaLength();
        } else {
            this.aaLen = -1;
            this.aaPos = -1;
        }
        this.distance = variantEffect.getDistance();
        if (variantEffect.hasError() || variantEffect.hasWarning()) {
            StringBuilder err2 = new StringBuilder();
            if (!variantEffect.getError().isEmpty()) {
                err2.append(variantEffect.getError());
            }
            if (!variantEffect.getWarning().isEmpty()) {
                if (err2.length() > 0) {
                    err2.append(this.formatVersion.separator());
                }
                err2.append(variantEffect.getWarning());
            }
            this.errorsWarnings = err2.toString();
        }
    }

    public void setAa(String aa) {
        this.aa = aa;
    }

    public void setAaLen(int aaLen) {
        this.aaLen = aaLen;
    }

    public void setBioType(BioType bioType) {
        this.bioType = bioType;
    }

    public void setCoding(VariantEffect.Coding coding) {
        this.coding = coding;
    }

    public void setCodon(String codon) {
        this.codon = codon;
    }

    public void setEffectDetails(String effectDetails) {
        this.effectDetails = effectDetails;
    }

    public void setEffectType(EffectType effect) {
        this.effectTypes = new LinkedList<EffectType>();
        this.addEffectType(effect);
    }

    public void setExonId(String exonId) {
        this.exonId = exonId;
    }

    public void setFormatVersion(EffFormatVersion formatVersion) {
        this.formatVersion = formatVersion;
    }

    public void setFunClass(VariantEffect.FunctionalClass funClass) {
        this.funClass = funClass;
    }

    public void setGeneId(String geneId) {
        this.geneId = geneId;
    }

    public void setGeneName(String geneName) {
        this.geneName = geneName;
    }

    void setGeneNameIdMultiple(VariantEffect variantEffect) {
        List<Gene> genes = variantEffect.getGenes();
        Collections.sort(genes, new Comparator<Gene>(){

            @Override
            public int compare(Gene g1, Gene g2) {
                return g1.getGeneName().compareTo(g2.getGeneName());
            }
        });
        StringBuilder geneNames = new StringBuilder();
        StringBuilder geneIds = new StringBuilder();
        String sep = "";
        for (Gene g : genes) {
            geneNames.append(sep + g.getGeneName());
            geneIds.append(sep + g.getId());
            if (!sep.isEmpty()) continue;
            sep = this.formatVersion.separator();
        }
        this.geneName = geneNames.toString();
        this.geneId = geneIds.toString();
    }

    public void setGenotype(String genotype) {
        this.genotype = genotype;
    }

    public void setImpact(VariantEffect.EffectImpact impact) {
        this.impact = impact;
    }

    void setRank() {
        Transcript tr = this.variantEffect.getTranscript();
        Exon ex = this.variantEffect.getExon();
        this.rank = -1;
        if (ex != null) {
            this.rank = ex.getRank();
            this.rankMax = tr.numChilds();
            return;
        }
        Intron intron = this.variantEffect.getIntron();
        if (intron != null) {
            this.rank = intron.getRank();
            this.rankMax = Math.max(0, tr.numChilds() - 1);
            return;
        }
        if (tr == null) {
            return;
        }
        Variant variant = this.variantEffect.getVariant();
        for (Exon e : tr) {
            if (!e.intersects(variant)) continue;
            this.rank = e.getRank();
            this.rankMax = tr.numChilds();
            return;
        }
        List<Intron> introns = tr.introns();
        for (Intron in : introns) {
            if (!in.intersects(variant)) continue;
            this.rank = in.getRank();
            this.rankMax = introns.size();
            return;
        }
        this.rankMax = -1;
        this.rank = -1;
    }

    public void setTranscriptId(String transcriptId) {
        this.transcriptId = transcriptId;
    }

    public void setUseFirstEffect(boolean useFirstEffect) {
        this.useFirstEffect = useFirstEffect;
    }

    public void setUseGeneId(boolean useGeneId) {
        this.useGeneId = useGeneId;
    }

    public void setUseHgvs(boolean useHgvs) {
        this.useHgvs = useHgvs;
    }

    public String[] split(String eff) {
        if (this.formatVersion.isAnn()) {
            return eff.replace('|', '\t').split("\t", -1);
        }
        if (this.formatVersion.isEff()) {
            int idxBr = eff.indexOf(91);
            int idxParen = eff.indexOf(40);
            String eff0 = null;
            if (idxBr >= 0 && idxBr < idxParen) {
                int idxRbr = eff.indexOf(93);
                eff0 = eff.substring(0, idxRbr + 1);
                eff = eff.substring(idxRbr);
            }
            eff = eff.replace('(', '\t');
            eff = eff.replace('|', '\t');
            eff = eff.replace(')', '\t');
            String[] effs = eff.split("\t", -1);
            if (eff0 != null) {
                effs[0] = eff0;
            }
            return effs;
        }
        throw new RuntimeException("Unimplemented format version '" + (Object)((Object)this.formatVersion) + "'");
    }

    public String toString() {
        if (this.formatVersion == null || this.formatVersion.isAnn()) {
            return this.createAnnField();
        }
        return this.createEffField();
    }
}

