/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.snpeff.codons.CodonTable;
import org.snpeff.codons.CodonTables;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.stats.CountByType;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class Config
implements Serializable,
Iterable<String> {
    private static final long serialVersionUID = 877453207407217465L;
    public static final String DEFAULT_CONFIG_FILE = "snpEff.config";
    public static final String DEFAULT_DATA_DIR = "./data";
    public static String GENOMES_DIR = "genomes";
    public static int MAX_WARNING_COUNT = 20;
    public static String DEFAULT_COORDINATES = "GRCh37";
    public static final String KEY_BUNDLE_SUFIX = ".bundle";
    public static final String KEY_CODON_PREFIX = "codon.";
    public static final String KEY_CODONTABLE_SUFIX = ".codonTable";
    public static final String KEY_COORDINATES = "coordinates";
    public static final String KEY_DATA_DIR = "data.dir";
    public static final String KEY_DATABASE_LOCAL = "database";
    public static final String KEY_DATABASE_REPOSITORY = "database.repository";
    public static final String KEY_DBNSFP_FIELDS = "dbnsfp.fields";
    public static final String KEY_GENOME_SUFIX = ".genome";
    public static final String KEY_LOF_IGNORE_PROTEIN_CODING_AFTER = "lof.ignoreProteinCodingAfter";
    public static final String KEY_LOF_IGNORE_PROTEIN_CODING_BEFORE = "lof.ignoreProteinCodingBefore";
    public static final String KEY_LOF_DELETE_PROTEIN_CODING_BASES = "lof.deleteProteinCodingBases";
    public static final String KEY_REFERENCE_SUFIX = ".reference";
    public static final String KEY_VERSIONS_URL = "versions.url";
    private static Config configInstance = null;
    boolean debug = false;
    boolean verbose = false;
    boolean treatAllAsProteinCoding;
    boolean onlyRegulation;
    boolean errorOnMissingChromo;
    boolean errorChromoHit;
    boolean expandIub = true;
    boolean hgvs = true;
    boolean hgvsShift = true;
    boolean hgvsOneLetterAa = false;
    boolean hgvsOld = false;
    boolean hgvsTrId = false;
    double lofIgnoreProteinCodingAfter;
    double lofIgnoreProteinCodingBefore;
    double lofDeleteProteinCodingBases;
    String configFileName = "";
    String configDirPath = "";
    String dataDir;
    String genomeVersion;
    Properties properties;
    Genome genome;
    HashMap<String, Genome> genomeById;
    HashMap<String, String> referenceById;
    HashMap<String, String> nameById;
    HashMap<String, String> bundleByGenomeId;
    SnpEffectPredictor snpEffectPredictor;
    String databaseRepository = "";
    String versionsUrl = "";
    CountByType warningsCounter = new CountByType();

    public static Config get() {
        return configInstance;
    }

    public static Config reset() {
        configInstance = null;
        return null;
    }

    public Config(String genomeVersion) {
        this.init(genomeVersion, DEFAULT_CONFIG_FILE, null, null);
    }

    public Config(String genomeVersion, String configFileName) {
        this.init(genomeVersion, configFileName, null, null);
    }

    public Config(String genomeVersion, String configFileName, String dataDir, Map<String, String> override) {
        this.init(genomeVersion, configFileName, dataDir, override);
    }

    public Config(String genomeVersion, String configFileName, String dataDir, Map<String, String> override, boolean verbose) {
        this.verbose = verbose;
        this.init(genomeVersion, configFileName, dataDir, override);
    }

    String canonicalDir(String dirName) {
        if (dirName.startsWith("~/")) {
            dirName = Gpr.HOME + "/" + dirName.substring(2);
        } else if (dirName.startsWith("~")) {
            dirName = Gpr.HOME + "/" + dirName.substring(1);
        } else if (!dirName.startsWith("/")) {
            dirName = this.configDirPath + "/" + dirName;
        }
        while (dirName.endsWith("/")) {
            dirName = dirName.substring(0, dirName.length() - 1);
        }
        return dirName;
    }

    void createCodonTables(String genomeId, Properties properties) {
        for (Object k : properties.keySet()) {
            String key = k.toString().trim();
            if (!key.startsWith(KEY_CODON_PREFIX)) continue;
            String name = key.toString().substring(KEY_CODON_PREFIX.length());
            String table = properties.getProperty(key);
            CodonTable codonTable = new CodonTable(name, table);
            CodonTables.getInstance().add(codonTable);
        }
        for (Object key : properties.keySet()) {
            String keyStr = key.toString();
            if (!keyStr.endsWith(KEY_CODONTABLE_SUFIX) || !keyStr.startsWith(genomeId + ".")) continue;
            int chrNameEnd = keyStr.length() - KEY_CODONTABLE_SUFIX.length();
            int chrNameStart = genomeId.length() + 1;
            int chrNameLen = chrNameEnd - chrNameStart;
            String chromo = null;
            if (chrNameLen > 0) {
                chromo = keyStr.substring(chrNameStart, chrNameEnd);
            }
            String codonTableName = properties.getProperty(key.toString());
            CodonTable codonTable = CodonTables.getInstance().getTable(codonTableName);
            if (codonTable == null) {
                throw new RuntimeException("Error parsing property '" + key + "'. No such codon table '" + codonTableName + "'");
            }
            Genome gen = this.getGenome(genomeId);
            if (gen == null) {
                throw new RuntimeException("Error parsing property '" + key + "'. No such genome '" + genomeId + "'");
            }
            if (chromo != null) {
                Chromosome chr = gen.getOrCreateChromosome(chromo);
                CodonTables.getInstance().set(this.genomeById.get(genomeId), chr, codonTable);
                continue;
            }
            CodonTables.getInstance().set(this.genomeById.get(genomeId), codonTable);
        }
    }

    public URL downloadUrl(String genomeVer) {
        try {
            String bundleName;
            String version = "4.3";
            version = version.replace('.', '_');
            String urlRoot = this.getDatabaseRepository();
            if (urlRoot == null || urlRoot.isEmpty()) {
                throw new RuntimeException("Cannot find database repository. Missing 'database.repository' property in config file?");
            }
            StringBuilder urlsb = new StringBuilder();
            urlsb.append(urlRoot);
            if (urlsb.charAt(urlRoot.length() - 1) != '/') {
                urlsb.append("/");
            }
            if ((bundleName = this.getBundleName(genomeVer)) != null) {
                urlsb.append("v" + version + "/snpEff_v" + version + "_" + bundleName + ".zip");
            } else {
                urlsb.append("v" + version + "/snpEff_v" + version + "_" + genomeVer + ".zip");
            }
            return new URL(urlsb.toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getBaseFileNameGenes() {
        return this.dataDir + "/" + this.genome.getVersion() + "/genes";
    }

    public String getBaseFileNameMotif() {
        return this.getDirDataGenomeVersion() + "/motif";
    }

    public String getBaseFileNameRegulation() {
        return this.getDirDataGenomeVersion() + "/regulation";
    }

    public String getBaseFileNameSequence() {
        return this.getDirData() + "/" + this.genome.getVersion() + "/sequence";
    }

    public String getBundleName(String genomeVer) {
        return this.bundleByGenomeId.get(genomeVer);
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public String getCoordinates() {
        String coords = this.getString(this.genomeVersion + "." + KEY_COORDINATES);
        if (coords != null) {
            return coords;
        }
        coords = this.genomeVersion.split("\\.")[0];
        return coords.isEmpty() ? DEFAULT_COORDINATES : coords;
    }

    public String getDatabaseLocal(String dbName) {
        String dbLocal = this.properties.getProperty(this.getDatabaseLocalKey(dbName), "");
        if (dbLocal.isEmpty()) {
            return "";
        }
        return this.canonicalDir(dbLocal);
    }

    public String getDatabaseLocalKey(String dbName) {
        String coordinates = this.getCoordinates();
        if (coordinates == null) {
            throw new RuntimeException("Cannot find coordinates config entry for genome '" + this.genomeVersion + "'");
        }
        return "database." + dbName + "." + coordinates;
    }

    public String getDatabaseRepository() {
        return this.databaseRepository;
    }

    public String getDatabaseRepository(String dbName) {
        String coordinates = this.getCoordinates();
        if (coordinates == null) {
            throw new RuntimeException("Cannot find coordinates config entry for genome '" + this.genomeVersion + "'");
        }
        return this.properties.getProperty("database.repository." + dbName + "." + coordinates, "");
    }

    public URL getDatabaseRepositoryUrl(String dbName) {
        String repo = this.getDatabaseRepository(dbName);
        if (repo == null || repo.isEmpty()) {
            return null;
        }
        try {
            return new URL(repo);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDbNsfpFields() {
        String coordinates = this.getCoordinates();
        if (coordinates == null) {
            if (this.verbose) {
                System.err.println("Cannot find coordinates config entry for genome '" + this.genomeVersion + "'");
            }
            return null;
        }
        return this.properties.getProperty("dbnsfp.fields." + coordinates, "");
    }

    public String getDirData() {
        return this.dataDir;
    }

    public String getDirDataGenomeVersion() {
        return this.dataDir + "/" + this.genome.getVersion();
    }

    public String getDirMain() {
        File dir = new File(this.dataDir);
        return dir.getParent();
    }

    public String getDirRegulationBed() {
        return this.getDirDataGenomeVersion() + "/regulation.bed/";
    }

    public double getDouble(String propertyName, double defaultValue) {
        String val = this.getString(propertyName);
        if (val == null) {
            return defaultValue;
        }
        return Gpr.parseDoubleSafe(val);
    }

    public List<String> getFileListGenomeFasta() {
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.getDirData() + "/genomes/" + this.genome.getVersion() + ".fa");
        files.add(this.getDirData() + "/" + this.genome.getVersion() + "/sequences.fa");
        return files;
    }

    public String getFileNameCds() {
        return this.getDirDataGenomeVersion() + "/cds.fa";
    }

    public String getFileNameGenomeFasta() {
        for (String f2 : this.getFileListGenomeFasta()) {
            if (new File(f2).exists()) {
                return f2;
            }
            if (!new File(f2 + ".gz").exists()) continue;
            return f2;
        }
        return null;
    }

    public String getFileNameProteins() {
        return this.getDirDataGenomeVersion() + "/protein.fa";
    }

    public String getFileNameSequence() {
        return this.getBaseFileNameSequence() + ".bin";
    }

    public String getFileNameSequence(String chr) {
        String chrNameSafe = Gpr.sanityzeFileName(chr);
        return this.getBaseFileNameSequence() + "." + chrNameSafe + ".bin";
    }

    public String getFileSnpEffectPredictor() {
        return this.getDirData() + "/" + this.genome.getVersion() + "/snpEffectPredictor.bin";
    }

    public Genome getGenome() {
        return this.genome;
    }

    public Genome getGenome(String genomeId) {
        return this.genomeById.get(genomeId);
    }

    public String getGenomeVersion() {
        return this.genomeVersion;
    }

    public double getLofDeleteProteinCodingBases() {
        return this.lofDeleteProteinCodingBases;
    }

    public double getLofIgnoreProteinCodingAfter() {
        return this.lofIgnoreProteinCodingAfter;
    }

    public double getLofIgnoreProteinCodingBefore() {
        return this.lofIgnoreProteinCodingBefore;
    }

    public long getLong(String propertyName, long defaultValue) {
        String val = this.getString(propertyName);
        if (val == null) {
            return defaultValue;
        }
        return Gpr.parseLongSafe(val);
    }

    public String getName(String genomeVersion) {
        return this.nameById.get(genomeVersion);
    }

    public String getReference(String genomeVersion) {
        return this.referenceById.get(genomeVersion);
    }

    String getRelativeConfigPath() {
        URL url = Config.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            File path = new File(url.toURI());
            return path.getParent();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get path '" + url + "'", e);
        }
    }

    public SnpEffectPredictor getSnpEffectPredictor() {
        return this.snpEffectPredictor;
    }

    public String getString(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public String getString(String propertyName, String defaultValue) {
        return this.properties.getProperty(propertyName, defaultValue);
    }

    public String getVersionsUrl() {
        return this.versionsUrl;
    }

    void init(String genomeVersion, String configFileName, String dataDir, Map<String, String> override) {
        this.treatAllAsProteinCoding = false;
        this.onlyRegulation = false;
        this.errorOnMissingChromo = true;
        this.errorChromoHit = true;
        this.configFileName = configFileName;
        this.genomeVersion = genomeVersion;
        this.dataDir = dataDir;
        this.readConfig(configFileName, override);
        this.genome = this.genomeById.get(genomeVersion);
        if (!genomeVersion.isEmpty() && this.genome == null) {
            throw new RuntimeException("No such genome '" + genomeVersion + "'");
        }
        configInstance = this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isErrorChromoHit() {
        return this.errorChromoHit;
    }

    public boolean isErrorOnMissingChromo() {
        return this.errorOnMissingChromo;
    }

    public boolean isExpandIub() {
        return this.expandIub;
    }

    public boolean isHgvs() {
        return this.hgvs;
    }

    public boolean isHgvs1LetterAA() {
        return this.hgvsOneLetterAa;
    }

    public boolean isHgvsOld() {
        return this.hgvsOld;
    }

    public boolean isHgvsShift() {
        return this.hgvsShift;
    }

    public boolean isHgvsTrId() {
        return this.hgvsTrId;
    }

    public boolean isOnlyRegulation() {
        return this.onlyRegulation;
    }

    public boolean isTreatAllAsProteinCoding() {
        return this.treatAllAsProteinCoding;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public Iterator<String> iterator() {
        return this.nameById.keySet().iterator();
    }

    public List<String> keys() {
        Set<Object> keyset = this.properties.keySet();
        ArrayList<String> l = new ArrayList<String>(keyset.size());
        for (Object o : keyset) {
            l.add(o.toString());
        }
        return l;
    }

    boolean loadProperties(String configFileName) {
        try {
            File confFile = new File(configFileName);
            if (this.verbose) {
                Timer.showStdErr("Reading config file: " + confFile.getCanonicalPath());
            }
            if (Gpr.canRead(configFileName)) {
                this.properties.load(new FileReader(confFile));
                this.configDirPath = confFile.getCanonicalFile().getParent();
                return true;
            }
        }
        catch (Exception e) {
            this.properties = null;
            this.configDirPath = "";
            throw new RuntimeException(e);
        }
        return false;
    }

    public SnpEffectPredictor loadSnpEffectPredictor() {
        this.snpEffectPredictor = SnpEffectPredictor.load(this);
        this.genome = this.snpEffectPredictor.genome;
        this.snpEffectPredictor.setDebug(this.debug);
        return this.snpEffectPredictor;
    }

    private void readConfig(String configFileName, Map<String, String> override) {
        configFileName = this.readProperties(configFileName, override);
        if (this.dataDir == null) {
            this.dataDir = this.properties.getProperty(KEY_DATA_DIR, DEFAULT_DATA_DIR);
        }
        this.dataDir = this.canonicalDir(this.dataDir);
        this.databaseRepository = this.properties.getProperty(KEY_DATABASE_REPOSITORY, "");
        this.genomeById = new HashMap();
        this.referenceById = new HashMap();
        this.nameById = new HashMap();
        ArrayList<String> keys = new ArrayList<String>();
        for (Object k : this.properties.keySet()) {
            keys.add(k.toString());
        }
        Collections.sort(keys);
        for (String key : keys) {
            if (!key.endsWith(KEY_GENOME_SUFIX)) continue;
            String genVer = key.substring(0, key.length() - KEY_GENOME_SUFIX.length());
            String name = this.properties.getProperty(genVer + KEY_GENOME_SUFIX);
            this.nameById.put(genVer, name);
            String ref = this.properties.getProperty(genVer + KEY_REFERENCE_SUFIX);
            this.referenceById.put(genVer, ref);
        }
        this.bundleByGenomeId = new HashMap();
        for (String key : keys) {
            if (!key.endsWith(KEY_BUNDLE_SUFIX)) continue;
            String bundleName = key.substring(0, key.length() - KEY_BUNDLE_SUFIX.length());
            String entries = this.properties.getProperty(key);
            for (String gen : entries.split("\\s+")) {
                gen = gen.trim();
                this.bundleByGenomeId.put(gen, bundleName);
            }
        }
        if (!this.genomeVersion.isEmpty()) {
            this.readGenomeConfig(this.genomeVersion, this.properties);
            this.createCodonTables(this.genomeVersion, this.properties);
        }
        this.setFromProperties();
    }

    void readGenomeConfig(String genVer, Properties properties) {
        block4: {
            String genomePropsFileName = this.dataDir + "/" + genVer + "/snpEff.config";
            try {
                Properties genomeProps = new Properties();
                genomeProps.load(new FileReader(new File(genomePropsFileName)));
                for (Object propKey : genomeProps.keySet()) {
                    String pk = propKey.toString();
                    String propVal = genomeProps.getProperty(pk);
                    if (properties.getProperty(pk) == null) {
                        properties.setProperty(pk, propVal);
                        continue;
                    }
                    System.err.println("Ignoring property '" + pk + "' in file '" + genomePropsFileName + "'");
                }
            }
            catch (Exception e) {
                if (!this.debug) break block4;
                System.err.println("File '" + genomePropsFileName + "' not found");
            }
        }
        this.genome = new Genome(genVer, properties);
        this.genomeById.put(genVer, this.genome);
    }

    String readProperties(String configFileName) {
        this.properties = new Properties();
        try {
            File confFile = new File(configFileName);
            if (this.loadProperties(configFileName)) {
                return configFileName;
            }
            if (confFile.isAbsolute()) {
                throw new RuntimeException("Cannot read config file '" + confFile.getCanonicalPath() + "'");
            }
            String confPath = this.getRelativeConfigPath() + "/" + configFileName;
            confFile = new File(confPath);
            if (this.loadProperties(confPath)) {
                return confPath;
            }
            throw new RuntimeException("Cannot read config file '" + configFileName + "'\n");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Cannot find config file '" + configFileName + "'");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    String readProperties(String configFileName, Map<String, String> override) {
        String configFile = this.readProperties(configFileName);
        if (override != null) {
            for (String key : override.keySet()) {
                this.properties.setProperty(key, override.get(key));
            }
        }
        return configFile;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setErrorChromoHit(boolean errorChromoHit) {
        this.errorChromoHit = errorChromoHit;
    }

    public void setErrorOnMissingChromo(boolean errorOnMissingChromo) {
        this.errorOnMissingChromo = errorOnMissingChromo;
    }

    public void setExpandIub(boolean expandIub) {
        this.expandIub = expandIub;
    }

    void setFromProperties() {
        this.versionsUrl = this.getString(KEY_VERSIONS_URL);
        this.lofIgnoreProteinCodingAfter = this.getDouble(KEY_LOF_IGNORE_PROTEIN_CODING_AFTER, 0.95);
        this.lofIgnoreProteinCodingBefore = this.getDouble(KEY_LOF_IGNORE_PROTEIN_CODING_BEFORE, 0.05);
        this.lofDeleteProteinCodingBases = this.getDouble(KEY_LOF_DELETE_PROTEIN_CODING_BASES, 0.5);
    }

    public void setHgvsOld(boolean hgvsDnaOld) {
        this.hgvsOld = hgvsDnaOld;
    }

    public void setHgvsOneLetterAA(boolean hgvsOneLetterAa) {
        this.hgvsOneLetterAa = hgvsOneLetterAa;
    }

    public void setHgvsShift(boolean hgvsShift) {
        this.hgvsShift = hgvsShift;
    }

    public void setHgvsTrId(boolean hgvsTrId) {
        this.hgvsTrId = hgvsTrId;
    }

    public void setOnlyRegulation(boolean onlyRegulation) {
        this.onlyRegulation = onlyRegulation;
    }

    public void setSnpEffectPredictor(SnpEffectPredictor snpEffectPredictor) {
        this.snpEffectPredictor = snpEffectPredictor;
    }

    public void setString(String propertyName, String value2) {
        this.properties.setProperty(propertyName, value2);
    }

    public void setTreatAllAsProteinCoding(boolean treatAllAsProteinCoding) {
        this.treatAllAsProteinCoding = treatAllAsProteinCoding;
    }

    public void setUseHgvs(boolean useHgvs) {
        this.hgvs = useHgvs;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>();
        for (Object object : this.properties.keySet()) {
            keys.add(object.toString());
        }
        Collections.sort(keys);
        for (String string2 : keys) {
            sb.append("\t" + string2 + " = '" + this.properties.getProperty(string2) + "'\n");
        }
        for (String string3 : this) {
            String name = this.nameById.get(string3).replace('_', ' ');
            String ref = this.referenceById.get(string3);
            sb.append("\t" + string3);
            sb.append("\t" + name);
            if (ref != null) {
                sb.append("\t" + ref);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void warning(String warningType, String details) {
        long count2 = this.warningsCounter.inc(warningType);
        if (this.debug || count2 < (long)MAX_WARNING_COUNT) {
            if (this.debug) {
                Gpr.debug(warningType + details, 1);
            } else {
                System.err.println(warningType + details);
            }
        } else if (count2 <= (long)MAX_WARNING_COUNT) {
            String msg = "Too many '" + warningType + "' warnings, no further warnings will be shown:\n" + warningType + details;
            if (this.debug) {
                Gpr.debug(msg, 1);
            } else {
                System.err.println(msg);
            }
        }
    }
}

