/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fileIterator;

import java.io.IOException;
import java.util.LinkedList;
import org.snpeff.fileIterator.VariantFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Variant;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;

public class VariantTxtFileIterator
extends VariantFileIterator {
    LinkedList<Variant> fifo = new LinkedList();

    public VariantTxtFileIterator(String fileName) {
        super(fileName);
    }

    public VariantTxtFileIterator(String fileName, Genome genome) {
        super(fileName, genome);
    }

    @Override
    public boolean hasNext() {
        if (!this.fifo.isEmpty()) {
            return true;
        }
        return super.hasNext();
    }

    @Override
    public Variant next() {
        if (!this.fifo.isEmpty()) {
            return this.fifo.removeFirst();
        }
        return (Variant)super.next();
    }

    @Override
    protected Variant readNext() {
        try {
            while (this.ready()) {
                String line = this.readLine();
                if (line == null) {
                    return null;
                }
                if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                String[] fields = line.split("\t");
                if (fields.length >= 4) {
                    String chromosome = fields[0].trim();
                    Chromosome chromo = this.getChromosome(chromosome);
                    this.sanityCheckChromo(chromosome, chromo);
                    int start = this.parsePosition(fields[1]);
                    String reference = fields[2];
                    String change = fields[3];
                    int strand = 1;
                    if (fields.length >= 5) {
                        String strandStr = fields[4];
                        if (strandStr.charAt(0) == '+') {
                            strand = 1;
                        } else if (strandStr.charAt(0) == '-') {
                            strand = -1;
                        }
                    }
                    if (strand < 0) {
                        reference = GprSeq.reverseWc(reference);
                        change = GprSeq.reverseWc(change);
                    }
                    String id = "";
                    if (fields.length >= 8) {
                        id = fields[7];
                    }
                    this.fifo = (LinkedList)Variant.factory(chromo, start, reference, change, id, true);
                    return this.fifo.removeFirst();
                }
                throw new RuntimeException("Error reading file '" + this.fileName + "' line " + this.lineNum + " (number of fields is " + fields.length + "):\t" + line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    void showFifo() {
        Gpr.debug("Fifo:" + this.fifo.size());
        for (Variant v : this.fifo) {
            System.err.println("\t\t" + v);
        }
    }
}

