/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.biojava.bio.structure.align.ce.StartupParameters;
import org.biojava.bio.structure.io.PDBFileReader;
import org.biojava3.core.util.PrettyXMLWriter;
import org.biojava3.core.util.XMLWriter;

public class UserConfiguration {
    String pdbFilePath;
    String cacheFilePath;
    boolean isSplit = true;
    private boolean autoFetch = true;
    String fileFormat;
    public static final String PDB_FORMAT = "PDB";
    public static final String MMCIF_FORMAT = "mmCif";
    public static final String TMP_DIR = "java.io.tmpdir";
    public static final String PDB_DIR = "PDB_DIR";

    public UserConfiguration() {
        String tmpCache;
        Map<String, String> env;
        String userProvidedDir = System.getProperty(PDB_DIR);
        this.pdbFilePath = userProvidedDir != null ? userProvidedDir : ((env = System.getenv()).containsKey(PDB_DIR) ? env.get(PDB_DIR) : System.getProperty(TMP_DIR));
        if (!this.pdbFilePath.endsWith(PDBFileReader.lineSplit)) {
            this.pdbFilePath = this.pdbFilePath + PDBFileReader.lineSplit;
        }
        if ((tmpCache = System.getProperty("PDB_CACHE_DIR")) == null || tmpCache.equals("")) {
            tmpCache = this.pdbFilePath;
        }
        this.cacheFilePath = tmpCache;
        this.fileFormat = PDB_FORMAT;
    }

    public String getPdbFilePath() {
        return this.pdbFilePath;
    }

    public void setPdbFilePath(String pdbFilePath) {
        this.pdbFilePath = pdbFilePath;
    }

    public String getCacheFilePath() {
        return this.cacheFilePath;
    }

    public void setCacheFilePath(String cacheFilePath) {
        this.cacheFilePath = cacheFilePath;
    }

    public boolean isSplit() {
        return this.isSplit;
    }

    public void setSplit(boolean isSplit) {
        this.isSplit = isSplit;
    }

    public boolean getAutoFetch() {
        return this.autoFetch;
    }

    public void setAutoFetch(boolean autoFetch) {
        this.autoFetch = autoFetch;
    }

    public XMLWriter toXML(PrintWriter pw) throws IOException {
        PrettyXMLWriter xw = new PrettyXMLWriter(pw);
        this.toXML(xw);
        return xw;
    }

    public XMLWriter toXML(XMLWriter xw) throws IOException {
        xw.printRaw("<?xml version='1.0' standalone='no' ?>");
        xw.openTag("JFatCatConfig");
        xw.openTag("PDBFILEPATH");
        String tempdir = System.getProperty(TMP_DIR);
        if (!this.pdbFilePath.equals(tempdir)) {
            xw.attribute("path", this.pdbFilePath);
        }
        xw.attribute("split", this.isSplit + "");
        xw.attribute("autofetch", this.autoFetch + "");
        xw.attribute("fileFormat", this.fileFormat);
        xw.closeTag("PDBFILEPATH");
        xw.closeTag("JFatCatConfig");
        return xw;
    }

    public static UserConfiguration fromStartupParams(StartupParameters params) {
        UserConfiguration config = new UserConfiguration();
        config.setPdbFilePath(params.getPdbFilePath());
        config.setAutoFetch(params.isAutoFetch());
        config.setSplit(params.isPdbDirSplit());
        config.setFileFormat(PDB_FORMAT);
        return config;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }
}

