/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.seq;

import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.AbstractStructureAlignment;
import org.biojava.bio.structure.align.StructureAlignment;
import org.biojava.bio.structure.align.ce.CECalculator;
import org.biojava.bio.structure.align.ce.CeParameters;
import org.biojava.bio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.bio.structure.align.model.AFPChain;
import org.biojava.bio.structure.align.seq.SmithWaterman3DParameters;
import org.biojava.bio.structure.align.seq.SmithWatermanUserArgumentProcessor;
import org.biojava.bio.structure.align.util.AFPAlignmentDisplay;
import org.biojava3.alignment.Alignments;
import org.biojava3.alignment.SimpleGapPenalty;
import org.biojava3.alignment.SubstitutionMatrixHelper;
import org.biojava3.alignment.template.GapPenalty;
import org.biojava3.alignment.template.PairwiseSequenceAligner;
import org.biojava3.alignment.template.SequencePair;
import org.biojava3.alignment.template.SubstitutionMatrix;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.compound.AminoAcidCompound;
import org.biojava3.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.Sequence;

public class SmithWaterman3Daligner
extends AbstractStructureAlignment
implements StructureAlignment {
    public static final String algorithmName = "Smith-Waterman superposition";
    private static final String version = "1.0";
    SmithWaterman3DParameters params = new SmithWaterman3DParameters();

    public static void main(String[] args) {
        args = new String[]{"-pdb1", "1cdg.A", "-pdb2", "1tim.A", "-pdbFilePath", "/tmp/", "-show3d", "-printFatCat"};
        SmithWaterman3Daligner algorithm = new SmithWaterman3Daligner();
        if (args.length == 0) {
            System.out.println(algorithm.printHelp());
            return;
        }
        if (args.length == 1 && (args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("--help"))) {
            System.out.println(algorithm.printHelp());
            return;
        }
        SmithWatermanUserArgumentProcessor processor = new SmithWatermanUserArgumentProcessor();
        processor.process(args);
    }

    @Override
    public AFPChain align(Atom[] ca1, Atom[] ca2) throws StructureException {
        if (this.params == null) {
            this.params = new SmithWaterman3DParameters();
        }
        return this.align(ca1, ca2, this.params);
    }

    @Override
    public AFPChain align(Atom[] ca1, Atom[] ca2, Object parameters) throws StructureException {
        if (parameters == null) {
            throw new IllegalArgumentException("Got null instead of SmithWaterman3DParameters!");
        }
        if (!(parameters instanceof SmithWaterman3DParameters)) {
            throw new IllegalArgumentException("provided parameter object is not of type SmithWaterman3DParameters, but " + parameters.getClass().getName());
        }
        this.params = (SmithWaterman3DParameters)parameters;
        AFPChain afpChain = new AFPChain();
        try {
            String seq1 = StructureTools.convertAtomsToSeq(ca1);
            String seq2 = StructureTools.convertAtomsToSeq(ca2);
            ProteinSequence s1 = new ProteinSequence(seq1);
            ProteinSequence s2 = new ProteinSequence(seq2);
            SubstitutionMatrix matrix = SubstitutionMatrixHelper.getBlosum65();
            SimpleGapPenalty penalty = new SimpleGapPenalty();
            penalty.setOpenPenalty(this.params.getGapOpen().shortValue());
            penalty.setExtensionPenalty(this.params.getGapExtend().shortValue());
            PairwiseSequenceAligner smithWaterman = Alignments.getPairwiseAligner((Sequence)s1, (Sequence)s2, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.LOCAL, (GapPenalty)penalty, (SubstitutionMatrix)matrix);
            SequencePair pair2 = smithWaterman.getPair();
            afpChain = this.convert(ca1, ca2, (SequencePair<ProteinSequence, AminoAcidCompound>)pair2, (PairwiseSequenceAligner<ProteinSequence, AminoAcidCompound>)smithWaterman);
        }
        catch (Exception e) {
            throw new StructureException(e.getMessage(), e);
        }
        return afpChain;
    }

    private AFPChain convert(Atom[] ca1, Atom[] ca2, SequencePair<ProteinSequence, AminoAcidCompound> pair2, PairwiseSequenceAligner<ProteinSequence, AminoAcidCompound> smithWaterman) throws StructureException {
        AFPChain afpChain = new AFPChain();
        int ca1Length = ca1.length;
        int ca2Length = ca2.length;
        afpChain.setAlignScore(smithWaterman.getScore());
        afpChain.setCa1Length(ca1Length);
        afpChain.setCa2Length(ca2Length);
        int nrCols = pair2.getLength();
        int nAtom = 0;
        int nGaps = 0;
        Atom[] strBuf1 = new Atom[nrCols];
        Atom[] strBuf2 = new Atom[nrCols];
        char[] alnseq1 = new char[ca1Length + ca2Length + 1];
        char[] alnseq2 = new char[ca1Length + ca2Length + 1];
        char[] alnsymb = new char[ca1Length + ca2Length + 1];
        AminoAcidCompound gapSymbol = AminoAcidCompoundSet.getAminoAcidCompoundSet().getCompoundForString("-");
        int pos = 0;
        int nrIdent = 0;
        int nrSim = 0;
        int[] align_se1 = new int[nrCols + 1];
        int[] align_se2 = new int[nrCols + 1];
        for (int i = 1; i <= nrCols; ++i) {
            char l1;
            int myI = i - 1;
            Compound s1 = pair2.getCompoundAt(1, i);
            Compound s2 = pair2.getCompoundAt(2, i);
            int pos1 = pair2.getIndexInQueryAt(i) - 1;
            int pos2 = pair2.getIndexInTargetAt(i) - 1;
            if (!s1.equals(gapSymbol) && !s2.equals(gapSymbol)) {
                strBuf1[nAtom] = ca1[pos1];
                strBuf2[nAtom] = ca2[pos2];
                l1 = SmithWaterman3Daligner.getOneLetter(ca1[pos1].getGroup());
                char l2 = SmithWaterman3Daligner.getOneLetter(ca2[pos2].getGroup());
                alnseq1[myI] = Character.toUpperCase(l1);
                alnseq2[myI] = Character.toUpperCase(l2);
                alnsymb[myI] = 32;
                if (l1 == l2) {
                    ++nrIdent;
                    ++nrSim;
                    alnsymb[myI] = 124;
                } else if (AFPAlignmentDisplay.aaScore(l1, l2) > 0) {
                    ++nrSim;
                    alnsymb[myI] = 58;
                }
                align_se1[myI] = pos1;
                align_se2[myI] = pos2;
                ++pos;
                ++nAtom;
                continue;
            }
            ++nGaps;
            alnsymb[myI] = 32;
            align_se1[myI] = -1;
            align_se2[myI] = -1;
            if (s1.equals(gapSymbol)) {
                alnseq1[myI] = 45;
            } else {
                l1 = SmithWaterman3Daligner.getOneLetter(ca1[pos1].getGroup());
                alnseq1[myI] = Character.toUpperCase(l1);
                align_se1[myI] = pos1;
            }
            if (s2.equals(gapSymbol)) {
                alnseq2[myI] = 45;
                continue;
            }
            char l2 = SmithWaterman3Daligner.getOneLetter(ca2[pos2].getGroup());
            alnseq2[myI] = Character.toUpperCase(l2);
            align_se2[myI] = pos2;
        }
        afpChain.setAlnbeg1(pair2.getIndexInQueryAt(1) - 1);
        afpChain.setAlnbeg2(pair2.getIndexInTargetAt(1) - 1);
        afpChain.setGapLen(nGaps);
        afpChain.setAlnseq1(alnseq1);
        afpChain.setAlnseq2(alnseq2);
        afpChain.setAlnsymb(alnsymb);
        afpChain.setIdentity((double)nrIdent * 1.0 / (double)pos);
        afpChain.setSimilarity((double)nrSim * 1.0 / (double)pos);
        afpChain.setAlnLength(nrCols);
        afpChain.setOptLength(nAtom);
        int[] optLen = new int[]{nAtom};
        afpChain.setOptLen(optLen);
        if (nAtom < 4) {
            return afpChain;
        }
        CeParameters params = new CeParameters();
        CECalculator cecalc = new CECalculator(params);
        double rmsd = cecalc.calc_rmsd(strBuf1, strBuf2, nAtom, true, false);
        afpChain.setBlockRmsd(new double[]{rmsd});
        afpChain.setOptRmsd(new double[]{rmsd});
        afpChain.setTotalRmsdOpt(rmsd);
        afpChain.setChainRmsd(rmsd);
        cecalc.setnAtom(nAtom);
        cecalc.setAlign_se1(align_se1);
        cecalc.setAlign_se2(align_se2);
        cecalc.setLcmp(nrCols);
        cecalc.convertAfpChain(afpChain, ca1, ca2);
        afpChain.setAlgorithmName(algorithmName);
        afpChain.setVersion(version);
        return afpChain;
    }

    private static char getOneLetter(Group g) {
        try {
            Character c = StructureTools.get1LetterCode(g.getPDBName());
            return c.charValue();
        }
        catch (Exception e) {
            return 'X';
        }
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public ConfigStrucAligParams getParameters() {
        return this.params;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public void setParameters(ConfigStrucAligParams parameters) {
        if (!(parameters instanceof SmithWaterman3DParameters)) {
            throw new IllegalArgumentException("provided parameter object is not of type SmithWaterman3DParameters");
        }
        this.params = (SmithWaterman3DParameters)parameters;
    }
}

