/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align;

import java.io.File;
import java.util.SortedSet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.CallableStructureAlignment;
import org.biojava.bio.structure.align.StructureAlignment;
import org.biojava.bio.structure.align.ce.CeParameters;
import org.biojava.bio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.bio.structure.align.client.FarmJobParameters;
import org.biojava.bio.structure.align.client.JFatCatClient;
import org.biojava.bio.structure.align.client.PdbPair;
import org.biojava.bio.structure.align.client.StructureName;
import org.biojava.bio.structure.align.model.AFPChain;
import org.biojava.bio.structure.align.util.AtomCache;
import org.biojava.bio.structure.align.util.SynchronizedOutFile;
import org.biojava.bio.structure.domain.DomainProvider;
import org.biojava.bio.structure.domain.DomainProviderFactory;
import org.biojava.bio.structure.domain.RemoteDomainProvider;
import org.biojava.bio.structure.io.PDBFileReader;
import org.biojava3.core.util.ConcurrencyTools;

public class MultiThreadedDBSearch {
    AtomicBoolean interrupted = new AtomicBoolean(false);
    StructureAlignment algorithm;
    String outFile;
    String name1;
    int nrCPUs;
    AtomCache cache;
    File resultList;
    SortedSet<String> representatives;
    boolean domainSplit;
    Structure structure1;
    String customFile1;
    String customChain1;

    public MultiThreadedDBSearch(String name, Structure structure, String outFile, StructureAlignment algorithm, int nrCPUs, boolean domainSplit) {
        this.name1 = name;
        this.structure1 = structure;
        this.outFile = outFile;
        this.algorithm = algorithm;
        this.nrCPUs = nrCPUs;
        this.domainSplit = domainSplit;
        this.cache = new AtomCache();
        String serverLocation = FarmJobParameters.DEFAULT_SERVER_URL;
        if (this.representatives == null) {
            SortedSet<String> repre = JFatCatClient.getRepresentatives(serverLocation, 40);
            System.out.println("got  " + repre.size() + " representatives for comparison");
            this.representatives = repre;
        }
    }

    public String getCustomFile1() {
        return this.customFile1;
    }

    public void setCustomFile1(String customFile1) {
        this.customFile1 = customFile1;
    }

    public String getCustomChain1() {
        return this.customChain1;
    }

    public void setCustomChain1(String customChain1) {
        this.customChain1 = customChain1;
    }

    public AtomCache getAtomCache() {
        return this.cache;
    }

    public void setAtomCache(AtomCache cache) {
        this.cache = cache;
    }

    public StructureAlignment getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(StructureAlignment algo) {
        this.algorithm = algo;
    }

    public String getOutFile() {
        return this.outFile;
    }

    public void setOutFile(String outFile) {
        this.outFile = outFile;
    }

    public static String getLegend(String algorithmName) {
        if (algorithmName.equalsIgnoreCase("jCE") || algorithmName.equalsIgnoreCase("jCE-sidechain") || algorithmName.equalsIgnoreCase("jCE Circular Permutation")) {
            return "# name1\tname2\tscore\tz-score\trmsd\tlen1\tlen2\tcov1\tcov2\t%ID\tDescription\t ";
        }
        return "# name1\tname2\tscore\tprobability\trmsd\tlen1\tlen2\tcov1\tcov2\t%ID\tDescription\t ";
    }

    public File getResultFile() {
        return this.resultList;
    }

    public void setResultFile(File resultList) {
        this.resultList = resultList;
    }

    public void run() {
        SynchronizedOutFile out;
        this.checkLocalFiles();
        if (this.interrupted.get()) {
            return;
        }
        String header = "# algorithm:" + this.algorithm.getAlgorithmName();
        String legend = MultiThreadedDBSearch.getLegend(this.algorithm.getAlgorithmName());
        File outFileF = new File(this.outFile);
        if (!outFileF.isDirectory()) {
            System.err.println(outFileF.getAbsolutePath() + " is not a directory, can't create result files in there... ");
            this.interrupt();
            this.cleanup();
        }
        if (this.name1 == null) {
            this.name1 = "CUSTOM";
        }
        this.resultList = new File(outFileF, "results_" + this.name1 + ".out");
        System.out.println("writing results to " + this.resultList.getAbsolutePath());
        try {
            CeParameters ceParams;
            ConfigStrucAligParams params;
            out = new SynchronizedOutFile(this.resultList);
            out.write(header);
            out.write(AFPChain.newline);
            out.write(legend);
            out.write(AFPChain.newline);
            if (this.name1.equals("CUSTOM")) {
                String config1 = "#param:file1=" + this.customFile1;
                out.write(config1);
                out.write(AFPChain.newline);
                if (this.customChain1 != null) {
                    String config2 = "#param:chain1=" + this.customChain1;
                    out.write(config2);
                    out.write(AFPChain.newline);
                }
            }
            if (this.algorithm.getAlgorithmName().startsWith("jCE") && (params = this.algorithm.getParameters()) instanceof CeParameters && (ceParams = (CeParameters)params).getScoringStrategy() != 0) {
                String scoring = "#param:scoring=" + ceParams.getScoringStrategy();
                out.write(scoring);
                out.write(AFPChain.newline);
            }
            out.flush();
        }
        catch (Exception e) {
            System.err.println("Error while loading representative structure " + this.name1);
            e.printStackTrace();
            this.interrupt();
            this.cleanup();
            return;
        }
        DomainProvider domainProvider = DomainProviderFactory.getDomainProvider();
        ConcurrencyTools.setThreadPoolSize(this.nrCPUs);
        Atom[] ca1 = StructureTools.getAtomCAArray(this.structure1);
        int nrJobs = 0;
        for (String repre : this.representatives) {
            if (this.domainSplit) {
                SortedSet<String> domainNames = domainProvider.getDomainNames(repre);
                if (domainNames == null || domainNames.size() == 0) {
                    this.submit(this.name1, repre, ca1, this.algorithm, outFileF, out, this.cache);
                    ++nrJobs;
                    continue;
                }
                for (String domain : domainNames) {
                    this.submit(this.name1, domain, ca1, this.algorithm, outFileF, out, this.cache);
                    ++nrJobs;
                }
                continue;
            }
            this.submit(this.name1, repre, ca1, this.algorithm, outFileF, out, this.cache);
            ++nrJobs;
        }
        ThreadPoolExecutor pool = ConcurrencyTools.getThreadPool();
        System.out.println(pool.getPoolSize());
        long startTime = System.currentTimeMillis();
        try {
            while (pool.getCompletedTaskCount() < (long)(nrJobs - 1) && !this.interrupted.get()) {
                Thread.sleep(2000L);
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.interrupt();
            this.cleanup();
        }
        if (domainProvider instanceof RemoteDomainProvider) {
            RemoteDomainProvider remote2 = (RemoteDomainProvider)domainProvider;
            remote2.flushCache();
        }
        long now = System.currentTimeMillis();
        System.out.println("Calculation took : " + (now - startTime) / 1000L + " sec.");
        System.out.println(pool.getCompletedTaskCount() + " " + pool.getPoolSize() + " " + pool.getActiveCount() + " " + pool.getTaskCount());
    }

    private void checkLocalFiles() {
        System.out.println("Checking local PDB installation in directory: " + this.cache.getPath());
        File f2 = new File(this.cache.getPath());
        if (!f2.isDirectory()) {
            System.err.println("The path " + f2.getAbsolutePath() + " should point to a directory!");
        }
        if (!f2.canWrite()) {
            System.err.println("You do not have permission to write to " + f2.getAbsolutePath() + ". There could be a problem if the PDB installation is not up-to-date with fetching missing PDB files.");
        }
        DomainProvider domainProvider = DomainProviderFactory.getDomainProvider();
        for (String repre : this.representatives) {
            if (this.interrupted.get()) {
                return;
            }
            if (this.domainSplit) {
                SortedSet<String> domainNames = domainProvider.getDomainNames(repre);
                if (domainNames == null || domainNames.size() == 0) {
                    this.checkFile(repre);
                    continue;
                }
                for (String domain : domainNames) {
                    this.checkFile(domain);
                }
                continue;
            }
            this.checkFile(repre);
        }
        if (domainProvider instanceof RemoteDomainProvider) {
            RemoteDomainProvider remoteP = (RemoteDomainProvider)domainProvider;
            remoteP.flushCache();
        }
        System.out.println("done checking local files...");
    }

    private void checkFile(String repre) {
        StructureName name = new StructureName(repre);
        PDBFileReader reader = new PDBFileReader();
        reader.setAutoFetch(true);
        reader.setPath(this.cache.getPath());
        reader.setFileParsingParameters(this.cache.getFileParsingParams());
        reader.setPdbDirectorySplit(this.cache.isSplit());
        if (!reader.checkFileExists(name.getPdbId())) {
            reader.downloadPDB(name.getPdbId());
        }
    }

    private void submit(String name12, String repre, Atom[] ca1, StructureAlignment algorithm, File outFileF, SynchronizedOutFile out, AtomCache cache) {
        CallableStructureAlignment ali = new CallableStructureAlignment();
        PdbPair pair2 = new PdbPair(this.name1, repre);
        try {
            ali.setCa1(ca1);
        }
        catch (Exception e) {
            e.printStackTrace();
            ConcurrencyTools.shutdown();
            return;
        }
        ali.setAlgorithmName(algorithm.getAlgorithmName());
        ali.setParameters(algorithm.getParameters());
        ali.setPair(pair2);
        ali.setOutFile(out);
        ali.setOutputDir(outFileF);
        ali.setCache(cache);
        ConcurrencyTools.submit(ali);
    }

    public void interrupt() {
        this.interrupted.set(true);
        ThreadPoolExecutor pool = ConcurrencyTools.getThreadPool();
        pool.shutdownNow();
        DomainProvider domainProvider = DomainProviderFactory.getDomainProvider();
        if (domainProvider instanceof RemoteDomainProvider) {
            RemoteDomainProvider remote2 = (RemoteDomainProvider)domainProvider;
            remote2.flushCache();
        }
    }

    public void cleanup() {
        this.structure1 = null;
    }
}

