/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.util.RandomAccess;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.DoubleCarryCRT;
import org.apfloat.internal.DoubleModConstants;
import org.apfloat.internal.DoubleModMath;
import org.apfloat.internal.ParallelNTTStrategy;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.spi.ConvolutionStrategy;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;
import org.apfloat.spi.NTTStrategy;

public class Double3NTTConvolutionStrategy
extends DoubleModMath
implements ConvolutionStrategy {
    private NTTStrategy transform;
    private DoubleCarryCRT carryCRT;
    private ParallelRunner parallelRunner;
    private boolean locked;

    public Double3NTTConvolutionStrategy(int radix, NTTStrategy transform2) {
        this.transform = transform2;
        this.carryCRT = new DoubleCarryCRT(radix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStorage convolute(DataStorage x2, DataStorage y, long resultSize) throws ApfloatRuntimeException {
        DataStorage result2;
        if (x2 == y) {
            return this.autoConvolute(x2, resultSize);
        }
        long length = this.transform.getTransformLength(x2.getSize() + y.getSize());
        this.lock(length);
        try {
            DataStorage resultMod0 = this.convoluteOne(x2, y, length, 0, false);
            DataStorage resultMod1 = this.convoluteOne(x2, y, length, 1, false);
            DataStorage resultMod2 = this.convoluteOne(x2, y, length, 2, true);
            result2 = this.carryCRT.carryCRT(resultMod0, resultMod1, resultMod2, resultSize);
        }
        finally {
            this.unlock();
        }
        return result2;
    }

    private DataStorage convoluteOne(DataStorage x2, DataStorage y, long length, int modulus, boolean cached) throws ApfloatRuntimeException {
        DataStorage tmpY = Double3NTTConvolutionStrategy.createCachedDataStorage(length);
        tmpY.copyFrom(y, length);
        this.transform.transform(tmpY, modulus);
        tmpY = Double3NTTConvolutionStrategy.createDataStorage(tmpY);
        DataStorage tmpX = Double3NTTConvolutionStrategy.createCachedDataStorage(length);
        tmpX.copyFrom(x2, length);
        this.transform.transform(tmpX, modulus);
        this.multiplyInPlace(tmpX, tmpY, modulus);
        this.transform.inverseTransform(tmpX, modulus, length);
        tmpX = cached ? tmpX : Double3NTTConvolutionStrategy.createDataStorage(tmpX);
        return tmpX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStorage autoConvolute(DataStorage x2, long resultSize) throws ApfloatRuntimeException {
        DataStorage result2;
        long length = this.transform.getTransformLength(x2.getSize() * 2L);
        this.lock(length);
        try {
            DataStorage resultMod0 = this.autoConvoluteOne(x2, length, 0, false);
            DataStorage resultMod1 = this.autoConvoluteOne(x2, length, 1, false);
            DataStorage resultMod2 = this.autoConvoluteOne(x2, length, 2, true);
            result2 = this.carryCRT.carryCRT(resultMod0, resultMod1, resultMod2, resultSize);
        }
        finally {
            this.unlock();
        }
        return result2;
    }

    private DataStorage autoConvoluteOne(DataStorage x2, long length, int modulus, boolean cached) throws ApfloatRuntimeException {
        DataStorage tmp = Double3NTTConvolutionStrategy.createCachedDataStorage(length);
        tmp.copyFrom(x2, length);
        this.transform.transform(tmp, modulus);
        this.squareInPlace(tmp, modulus);
        this.transform.inverseTransform(tmp, modulus, length);
        tmp = cached ? tmp : Double3NTTConvolutionStrategy.createDataStorage(tmp);
        return tmp;
    }

    private void multiplyInPlace(final DataStorage sourceAndDestination, final DataStorage source, int modulus) throws ApfloatRuntimeException {
        assert (sourceAndDestination != source);
        final long size2 = sourceAndDestination.getSize();
        this.setModulus(DoubleModConstants.MODULUS[modulus]);
        if (size2 <= Integer.MAX_VALUE && this.parallelRunner != null && sourceAndDestination instanceof RandomAccess && source instanceof RandomAccess) {
            ParallelRunnable parallelRunnable = new ParallelRunnable(){

                public int getLength() {
                    return (int)size2;
                }

                public Runnable getRunnable(int offset, int length) {
                    return new MultiplyInPlaceRunnable(sourceAndDestination, source, offset, length);
                }
            };
            this.parallelRunner.runParallel(parallelRunnable);
        } else {
            new MultiplyInPlaceRunnable(sourceAndDestination, source, 0L, size2).run();
        }
    }

    private void squareInPlace(final DataStorage sourceAndDestination, int modulus) throws ApfloatRuntimeException {
        final long size2 = sourceAndDestination.getSize();
        this.setModulus(DoubleModConstants.MODULUS[modulus]);
        if (size2 <= Integer.MAX_VALUE && this.parallelRunner != null && sourceAndDestination instanceof RandomAccess) {
            ParallelRunnable parallelRunnable = new ParallelRunnable(){

                public int getLength() {
                    return (int)size2;
                }

                public Runnable getRunnable(int offset, int length) {
                    return new SquareInPlaceRunnable(sourceAndDestination, offset, length);
                }
            };
            this.parallelRunner.runParallel(parallelRunnable);
        } else {
            new SquareInPlaceRunnable(sourceAndDestination, 0L, size2).run();
        }
    }

    private void lock(long length) {
        assert (!this.locked);
        if (this.transform instanceof ParallelNTTStrategy) {
            ApfloatContext ctx = ApfloatContext.getContext();
            int numberOfProcessors = ctx.getNumberOfProcessors();
            this.parallelRunner = new ParallelRunner(numberOfProcessors);
            ((ParallelNTTStrategy)this.transform).setParallelRunner(this.parallelRunner);
            this.carryCRT.setParallelRunner(this.parallelRunner);
            if (length > ctx.getSharedMemoryTreshold() / 8L) {
                Object key = ctx.getSharedMemoryLock();
                this.parallelRunner.lock(key);
                this.locked = true;
            }
        }
    }

    private void unlock() {
        if (this.locked) {
            this.parallelRunner.unlock();
        }
    }

    private static DataStorage createCachedDataStorage(long size2) throws ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = ctx.getBuilderFactory().getDataStorageBuilder();
        return dataStorageBuilder.createCachedDataStorage(size2 * 8L);
    }

    private static DataStorage createDataStorage(DataStorage dataStorage) throws ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = ctx.getBuilderFactory().getDataStorageBuilder();
        return dataStorageBuilder.createDataStorage(dataStorage);
    }

    private class SquareInPlaceRunnable
    implements Runnable {
        private DataStorage sourceAndDestination;
        private long offset;
        private long length;

        public SquareInPlaceRunnable(DataStorage sourceAndDestination, long offset, long length) {
            this.sourceAndDestination = sourceAndDestination;
            this.offset = offset;
            this.length = length;
        }

        public void run() {
            DataStorage.Iterator iterator2 = this.sourceAndDestination.iterator(3, this.offset, this.offset + this.length);
            while (this.length > 0L) {
                double value2 = iterator2.getDouble();
                iterator2.setDouble(Double3NTTConvolutionStrategy.this.modMultiply(value2, value2));
                iterator2.next();
                --this.length;
            }
        }
    }

    private class MultiplyInPlaceRunnable
    implements Runnable {
        private DataStorage sourceAndDestination;
        private DataStorage source;
        private long offset;
        private long length;

        public MultiplyInPlaceRunnable(DataStorage sourceAndDestination, DataStorage source, long offset, long length) {
            this.sourceAndDestination = sourceAndDestination;
            this.source = source;
            this.offset = offset;
            this.length = length;
        }

        public void run() {
            DataStorage.Iterator dest = this.sourceAndDestination.iterator(3, this.offset, this.offset + this.length);
            DataStorage.Iterator src = this.source.iterator(1, this.offset, this.offset + this.length);
            while (this.length > 0L) {
                dest.setDouble(Double3NTTConvolutionStrategy.this.modMultiply(dest.getDouble(), src.getDouble()));
                dest.next();
                src.next();
                --this.length;
            }
        }
    }
}

