/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.Data;
import com.googlecode.charts4j.collect.ImmutableList;
import com.googlecode.charts4j.collect.Lists;
import com.googlecode.charts4j.collect.Preconditions;
import com.googlecode.charts4j.collect.PrimitiveArrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataUtil {
    private DataUtil() {
        throw new AssertionError();
    }

    public static Data scaleWithinRange(double min2, double max2, double[] data2) {
        Preconditions.checkArgument(max2 - min2 > 0.0, "min >= max!");
        return Data.newData(DataUtil.privateScale(data2, min2, max2));
    }

    public static Data scaleWithinRange(double min2, double max2, List<? extends Number> data2) {
        return DataUtil.scaleWithinRange(min2, max2, DataUtil.toDoubleArray(Lists.copyOf(data2)));
    }

    public static Data scale(double ... data2) {
        Preconditions.checkNotNull(data2, "data is null or contents of data is null.");
        double min2 = Collections.min(PrimitiveArrays.asList(data2));
        double max2 = Collections.max(PrimitiveArrays.asList(data2));
        Preconditions.checkArgument(min2 < max2, "Cannot scale this data. It is ill conditioned.");
        return Data.newData(DataUtil.privateScale(data2, min2, max2));
    }

    public static Data scale(List<? extends Number> data2) {
        Preconditions.checkContentsNotNull(data2, "data is null or contents of data is null.");
        return DataUtil.scale(DataUtil.toDoubleArray(Lists.copyOf(data2)));
    }

    public static List<Data> scale(double[][] data2) {
        Preconditions.checkNotNull(data2, "data cannot be null");
        List<Double> allData = Lists.newLinkedList();
        double[][] arr$ = data2;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[] d;
            for (double doub : d = arr$[i$]) {
                allData.add(doub);
            }
        }
        double min2 = (Double)Collections.min(allData);
        double max2 = (Double)Collections.max(allData);
        List<Data> list2 = Lists.newLinkedList();
        for (double[] d : data2) {
            list2.add(DataUtil.scaleWithinRange(min2, max2, d));
        }
        return list2;
    }

    public static List<Data> scaleDataList(List<? extends List<? extends Number>> data2) {
        Preconditions.checkContentsNotNull(data2, "data is null or contents of data is null.");
        double[][] d = new double[data2.size()][];
        int j = 0;
        for (List<? extends Number> list2 : data2) {
            Preconditions.checkContentsNotNull(list2, "data is null or contents of data is null.");
            double[] plotData = new double[list2.size()];
            int i = 0;
            for (Number number2 : list2) {
                plotData[i++] = number2.doubleValue();
            }
            d[j++] = plotData;
        }
        return DataUtil.scale(d);
    }

    static double[] toDoubleArray(ImmutableList<? extends Number> data2) {
        double[] d = new double[data2.size()];
        for (int i = 0; i < d.length; ++i) {
            d[i] = data2.get(i).doubleValue();
        }
        return d;
    }

    private static double[] privateScale(double[] doubleArray, double min2, double max2) {
        Preconditions.checkNotNull(doubleArray, "doubleArray cannot be null");
        Preconditions.checkArgument(max2 - min2 > 0.0, "min > max!");
        double[] scaledData = new double[doubleArray.length];
        for (int j = 0; j < doubleArray.length; ++j) {
            scaledData[j] = (doubleArray[j] - min2) / (max2 - min2) * 100.0;
        }
        return scaledData;
    }
}

