/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.beta;
import DistLib.gamma;
import DistLib.misc;
import DistLib.normal;
import DistLib.poisson;
import DistLib.uniform;

public class negative_binomial {
    public static double density(double x2, double n, double p) {
        if (Double.isNaN(x2) || Double.isNaN(n) || Double.isNaN(p)) {
            return x2 + n + p;
        }
        x2 = Math.floor(x2 + 0.5);
        if ((n = Math.floor(n + 0.5)) < 1.0 || p <= 0.0 || p >= 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 < 0.0) {
            return 0.0;
        }
        if (Double.isInfinite(x2)) {
            return 0.0;
        }
        return Math.exp(misc.lfastchoose(x2 + n - 1.0, x2) + n * Math.log(p) + x2 * Math.log(1.0 - p));
    }

    public static double cumulative(double x2, double n, double p) {
        if (Double.isNaN(x2) || Double.isNaN(n) || Double.isNaN(p)) {
            return x2 + n + p;
        }
        if (Double.isInfinite(n) || Double.isInfinite(p)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        x2 = Math.floor(x2 + 0.5);
        if ((n = Math.floor(n + 0.5)) < 1.0 || p <= 0.0 || p >= 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 < 0.0) {
            return 0.0;
        }
        if (Double.isInfinite(x2)) {
            return 1.0;
        }
        return beta.cumulative(p, n, x2 + 1.0);
    }

    public static double quantile(double x2, double n, double p) {
        if (Double.isNaN(x2) || Double.isNaN(n) || Double.isNaN(p)) {
            return x2 + n + p;
        }
        if (Double.isInfinite(x2)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        n = Math.floor(n + 0.5);
        if (x2 < 0.0 || x2 > 1.0 || p <= 0.0 || p >= 1.0 || n <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 == 0.0) {
            return 0.0;
        }
        if (x2 == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double Q = 1.0 / p;
        double P = (1.0 - p) * Q;
        double mu = n * P;
        double sigma = Math.sqrt(n * P * Q);
        double gamma2 = (Q + P) / sigma;
        double z = normal.quantile(x2, 0.0, 1.0);
        double y = Math.floor(mu + sigma * (z + gamma2 * (z * z - 1.0) / 6.0) + 0.5);
        if ((z = negative_binomial.cumulative(y, n, p)) >= x2) {
            while (true) {
                double d;
                z = negative_binomial.cumulative(y - 1.0, n, p);
                if (d < x2) {
                    return y;
                }
                y -= 1.0;
            }
        }
        while (true) {
            double d;
            z = negative_binomial.cumulative(y + 1.0, n, p);
            if (d >= x2) {
                return y + 1.0;
            }
            y += 1.0;
        }
    }

    public static double random(double n, double p, uniform PRNG) {
        if (Double.isInfinite(n = Math.floor(n + 0.5)) || Double.isInfinite(p) || n <= 0.0 || p <= 0.0 || p >= 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        return poisson.random(gamma.random(n, (1.0 - p) / p, PRNG), PRNG);
    }
}

