/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.exponential;
import DistLib.misc;
import DistLib.normal;
import DistLib.uniform;

public class gamma {
    private static double third = 0.3333333333333333;
    private static double zero = 0.0;
    private static double one = 1.0;
    private static double two = 2.0;
    private static double oflo = 1.0E37;
    private static double three = 3.0;
    private static double nine = 9.0;
    private static double xbig = 1.0E8;
    private static double plimit = 1000.0;
    private static double elimit = -88.0;
    private static double C7 = 4.67;
    private static double C8 = 6.66;
    private static double C9 = 6.73;
    private static double C10 = 13.32;
    private static double C11 = 60.0;
    private static double C12 = 70.0;
    private static double C13 = 84.0;
    private static double C14 = 105.0;
    private static double C15 = 120.0;
    private static double C16 = 127.0;
    private static double C17 = 140.0;
    private static double C18 = 1175.0;
    private static double C19 = 210.0;
    private static double C20 = 252.0;
    private static double C21 = 2264.0;
    private static double C22 = 294.0;
    private static double C23 = 346.0;
    private static double C24 = 420.0;
    private static double C25 = 462.0;
    private static double C26 = 606.0;
    private static double C27 = 672.0;
    private static double C28 = 707.0;
    private static double C29 = 735.0;
    private static double C30 = 889.0;
    private static double C31 = 932.0;
    private static double C32 = 966.0;
    private static double C33 = 1141.0;
    private static double C34 = 1182.0;
    private static double C35 = 1278.0;
    private static double C36 = 1740.0;
    private static double C37 = 2520.0;
    private static double C38 = 5040.0;
    private static double EPS0 = 5.0E-7;
    private static double EPS1 = 0.01;
    private static double EPS2 = 5.0E-7;
    private static double MAXIT = 20.0;
    private static double pMIN = 2.0E-6;
    private static double pMAX = 0.999998;
    private static double a1 = 0.3333333;
    private static double a2 = -0.250003;
    private static double a3 = 0.2000062;
    private static double a4 = -0.1662921;
    private static double a5 = 0.1423657;
    private static double a6 = -0.1367177;
    private static double a7 = 0.1233795;
    private static double e1 = 1.0;
    private static double e2 = 0.4999897;
    private static double e3 = 0.166829;
    private static double e4 = 0.0407753;
    private static double e5 = 0.010293;
    private static double q1 = 0.04166669;
    private static double q2 = 0.02083148;
    private static double q3 = 0.00801191;
    private static double q4 = 0.00144121;
    private static double q5 = -7.388E-5;
    private static double q6 = 2.4511E-4;
    private static double q7 = 2.424E-4;
    private static double sqrt32 = 5.656854;
    private static double aa = 0.0;
    private static double aaa = 0.0;
    private static double b;
    private static double c;
    private static double d;
    private static double e;
    private static double p;
    private static double q;
    private static double r;
    private static double s;
    private static double t;
    private static double u;
    private static double v;
    private static double w;
    private static double x;
    private static double q0;
    private static double s2;
    private static double si;

    public static double density(double x2, double shape, double scale) {
        if (Double.isNaN(x2) || Double.isNaN(shape) || Double.isNaN(scale)) {
            return x2 + shape + scale;
        }
        if (shape <= 0.0 || scale <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 < 0.0) {
            return 0.0;
        }
        if (x2 == 0.0) {
            if (shape < 1.0) {
                throw new ArithmeticException("Math Error: RANGE");
            }
            if (shape > 1.0) {
                return 0.0;
            }
            return 1.0 / scale;
        }
        return Math.exp((shape - 1.0) * Math.log(x2 /= scale) - misc.lgammafn(shape) - x2) / scale;
    }

    public static double cumulative(double x2, double p, double scale) {
        double sum2;
        if (Double.isNaN(x2) || Double.isNaN(p) || Double.isNaN(scale)) {
            return x2 + p + scale;
        }
        if (p <= zero || scale <= zero) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if ((x2 /= scale) <= zero) {
            return 0.0;
        }
        if (p > plimit) {
            double pn1 = Math.sqrt(p) * three * (Math.pow(x2 / p, third) + one / (p * nine) - one);
            return normal.cumulative(pn1, 0.0, 1.0);
        }
        if (x2 > xbig) {
            return one;
        }
        if (x2 <= one || x2 < p) {
            double arg = p * Math.log(x2) - x2 - misc.lgammafn(p + one);
            double c = one;
            sum2 = one;
            double a = p;
            do {
                c = c * x2 / (a += one);
                sum2 += c;
            } while (c > 2.220446049250313E-16);
            arg += Math.log(sum2);
            sum2 = zero;
            if (arg >= elimit) {
                sum2 = Math.exp(arg);
            }
        } else {
            double arg = p * Math.log(x2) - x2 - misc.lgammafn(p);
            double a = one - p;
            double b = a + x2 + one;
            double c = zero;
            double pn1 = one;
            double pn2 = x2;
            double pn3 = x2 + one;
            double pn4 = x2 * b;
            sum2 = pn3 / pn4;
            while (true) {
                double an = (a += one) * (c += one);
                double pn5 = (b += two) * pn3 - an * pn1;
                double pn6 = b * pn4 - an * pn2;
                if (Math.abs(pn6) > zero) {
                    double rn = pn5 / pn6;
                    if (Math.abs(sum2 - rn) <= Math.min(2.220446049250313E-16, 2.220446049250313E-16 * rn)) break;
                    sum2 = rn;
                }
                pn1 = pn3;
                pn2 = pn4;
                pn3 = pn5;
                pn4 = pn6;
                if (!(Math.abs(pn5) >= oflo)) continue;
                pn1 /= oflo;
                pn2 /= oflo;
                pn3 /= oflo;
                pn4 /= oflo;
            }
            arg += Math.log(sum2);
            sum2 = one;
            if (arg >= elimit) {
                sum2 = one - Math.exp(arg);
            }
        }
        return sum2;
    }

    public static double quantile(double p, double alpha, double scale) {
        double p2;
        double q;
        double a;
        double p1;
        double ch;
        double t2 = 0.0;
        if (Double.isNaN(p) || Double.isNaN(alpha) || Double.isNaN(scale)) {
            return p + alpha + scale;
        }
        if (p < 0.0 || p > 1.0 || alpha <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (p < pMIN) {
            return 0.0;
        }
        if (p > pMAX) {
            return Double.POSITIVE_INFINITY;
        }
        double v = 2.0 * alpha;
        double c = alpha - 1.0;
        double g = misc.lgammafn(alpha);
        if (v < -1.24 * Math.log(p)) {
            ch = Math.pow(p * alpha * Math.exp(g + alpha * 0.6931471805599453), 1.0 / alpha);
            if (ch < EPS0) {
                throw new ArithmeticException("Math Error: DOMAIN");
            }
        } else if (v > 0.32) {
            double x2 = normal.quantile(p, 0.0, 1.0);
            ch = v * Math.pow(x2 * Math.sqrt(p1 = 0.222222 / v) + 1.0 - p1, 3.0);
            if (ch > 2.2 * v + 6.0) {
                ch = -2.0 * (Math.log(1.0 - p) - c * Math.log(0.5 * ch) + g);
            }
        } else {
            ch = 0.4;
            a = Math.log(1.0 - p) + g + c * 0.6931471805599453;
            do {
                q = ch;
                p1 = 1.0 + ch * (C7 + ch);
                p2 = ch * (C9 + ch * (C8 + ch));
                t2 = -0.5 + (C7 + 2.0 * ch) / p1 - (C9 + ch * (C10 + 3.0 * ch)) / p2;
            } while (Math.abs(q / (ch -= (1.0 - Math.exp(a + 0.5 * ch) * p2 / p1) / t2) - 1.0) > EPS1);
        }
        int i = 1;
        while ((double)i <= MAXIT) {
            double s6;
            double s5;
            double s4;
            double s3;
            double s2;
            double b;
            double s1;
            q = ch;
            p1 = 0.5 * ch;
            p2 = p - gamma.cumulative(p1, alpha, 1.0);
            if (Double.isInfinite(p2)) {
                t2 = p2 * Math.exp(alpha * 0.6931471805599453 + g + p1 - c * Math.log(ch));
            }
            if (Math.abs(q / (ch += t2 * (1.0 + 0.5 * t2 * (s1 = (C19 + (a = 0.5 * t2 - (b = t2 / ch) * c) * (C17 + a * (C14 + a * (C13 + a * (C12 + C11 * a))))) / C24) - b * c * (s1 - b * ((s2 = (C24 + a * (C29 + a * (C32 + a * (C33 + C35 * a)))) / C37) - b * ((s3 = (C19 + a * (C25 + a * (C28 + C31 * a))) / C37) - b * ((s4 = (C20 + a * (C27 + C34 * a) + c * (C22 + a * (C30 + C36 * a))) / C38) - b * ((s5 = (C13 + C21 * a + c * (C18 + C26 * a)) / C37) - b * (s6 = (C15 + c * (C23 + C16 * c)) / C38)))))))) - 1.0) > EPS2) {
                return 0.5 * scale * ch;
            }
            ++i;
        }
        throw new ArithmeticException("Math Error: PRECISION");
    }

    public static double random(double a, double scale, uniform PRNG) {
        if (a < 1.0) {
            double ret_val;
            aa = 0.0;
            b = 1.0 + 0.36787944117144233 * a;
            while (true) {
                if ((p = b * uniform.random()) >= 1.0) {
                    ret_val = -Math.log((b - p) / a);
                    if (!(exponential.random(PRNG) >= (1.0 - a) * Math.log(ret_val))) continue;
                    break;
                }
                ret_val = Math.exp(Math.log(p) / a);
                if (exponential.random(PRNG) >= ret_val) break;
            }
            return scale * ret_val;
        }
        if (a != aa) {
            aa = a;
            s2 = a - 0.5;
            s = Math.sqrt(s2);
            d = sqrt32 - s * 12.0;
        }
        t = normal.random(PRNG);
        x = s + 0.5 * t;
        double ret_val = x * x;
        if (t >= 0.0) {
            return scale * ret_val;
        }
        u = uniform.random();
        if (d * u <= t * t * t) {
            return scale * ret_val;
        }
        if (a != aaa) {
            aaa = a;
            r = 1.0 / a;
            q0 = ((((((q7 * r + q6) * r + q5) * r + q4) * r + q3) * r + q2) * r + q1) * r;
            if (a <= 3.686) {
                b = 0.463 + s + 0.178 * s2;
                si = 1.235;
                c = 0.195 / s - 0.079 + 0.16 * s;
            } else if (a <= 13.022) {
                b = 1.654 + 0.0076 * s2;
                si = 1.68 / s + 0.275;
                c = 0.062 / s + 0.024;
            } else {
                b = 1.77;
                si = 0.75;
                c = 0.1515 / s;
            }
        }
        if (x > 0.0) {
            v = t / (s + s);
            q = Math.abs(v) <= 0.25 ? q0 + 0.5 * t * t * ((((((a7 * v + a6) * v + a5) * v + a4) * v + a3) * v + a2) * v + a1) * v : q0 - s * t + 0.25 * t * t + (s2 + s2) * Math.log(1.0 + v);
            if (Math.log(1.0 - u) <= q) {
                return scale * ret_val;
            }
        }
        while (true) {
            e = exponential.random(PRNG);
            u = uniform.random();
            t = (u = u + u - 1.0) < 0.0 ? b - si * e : b + si * e;
            if (!(t >= -0.71874483771719) || !((q = Math.abs(v = t / (s + s)) <= 0.25 ? q0 + 0.5 * t * t * ((((((a7 * v + a6) * v + a5) * v + a4) * v + a3) * v + a2) * v + a1) * v : q0 - s * t + 0.25 * t * t + (s2 + s2) * Math.log(1.0 + v)) > 0.0)) continue;
            w = q <= 0.5 ? ((((e5 * q + e4) * q + e3) * q + e2) * q + e1) * q : Math.exp(q) - 1.0;
            if (c * Math.abs(u) <= w * Math.exp(e - 0.5 * t * t)) break;
        }
        x = s + 0.5 * t;
        return scale * x * x;
    }
}

