/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.caseControl;

import java.util.List;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.stats.CountByType;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.caseControl.SnpSiftCmdCaseControlSummary;

public class Summary {
    CountByType countByType = new CountByType();

    public void count(String group, Boolean caseControl, VariantEffect.FunctionalClass functClass, String variantAf, int increment) {
        String key = group + "\t" + caseControl + "\t" + (Object)((Object)functClass) + "\t" + variantAf;
        this.countByType.inc(key, increment);
    }

    public String toString(List<String> groupNames) {
        StringBuilder sb = new StringBuilder();
        for (String group : groupNames) {
            for (Boolean caseControl : SnpSiftCmdCaseControlSummary.CaseControl) {
                for (VariantEffect.FunctionalClass functClass : VariantEffect.FunctionalClass.values()) {
                    if (functClass == VariantEffect.FunctionalClass.NONE) continue;
                    for (VcfEntry.AlleleFrequencyType variantAf : VcfEntry.AlleleFrequencyType.values()) {
                        String key = group + "\t" + caseControl + "\t" + (Object)((Object)functClass) + "\t" + (Object)((Object)variantAf);
                        long count2 = this.countByType.get(key);
                        sb.append((count2 > 0L ? Long.valueOf(count2) : "") + "\t");
                    }
                }
            }
        }
        return sb.toString();
    }

    public String toStringTitle(List<String> groupNames) {
        StringBuilder sb = new StringBuilder();
        for (String group : groupNames) {
            for (Boolean caseControl : SnpSiftCmdCaseControlSummary.CaseControl) {
                for (VariantEffect.FunctionalClass functClass : VariantEffect.FunctionalClass.values()) {
                    if (functClass == VariantEffect.FunctionalClass.NONE) continue;
                    for (VcfEntry.AlleleFrequencyType variantAf : VcfEntry.AlleleFrequencyType.values()) {
                        String key = group + "," + (caseControl != false ? "case" : "control") + "," + (Object)((Object)functClass) + "," + (Object)((Object)variantAf);
                        sb.append(key + "\t");
                    }
                }
            }
        }
        return sb.toString();
    }
}

