/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.util.List;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeaderEntry;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpeff.vcf.VcfInfoType;
import org.snpsift.SnpSift;

public class SnpSiftCmdGt
extends SnpSift {
    public static int SHOW_EVERY = 100;
    boolean uncompress;

    public SnpSiftCmdGt() {
    }

    public SnpSiftCmdGt(String[] args) {
        super(args);
    }

    @Override
    public String getOutput() {
        return this.output.toString();
    }

    @Override
    protected List<VcfHeaderEntry> headers() {
        List<VcfHeaderEntry> newHeaders = super.headers();
        newHeaders.add(new VcfHeaderInfo("HO", VcfInfoType.Integer, VcfHeaderInfo.VcfInfoNumber.UNLIMITED.toString(), "List of sample indexes having homozygous ALT genotypes"));
        newHeaders.add(new VcfHeaderInfo("HE", VcfInfoType.Integer, VcfHeaderInfo.VcfInfoNumber.UNLIMITED.toString(), "List of sample indexes having heterozygous ALT genotypes"));
        newHeaders.add(new VcfHeaderInfo("NA", VcfInfoType.Integer, VcfHeaderInfo.VcfInfoNumber.UNLIMITED.toString(), "List of sample indexes having missing genotypes"));
        return newHeaders;
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length == 0) {
            this.usage(null);
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                if (arg.equals("-u")) {
                    this.uncompress = true;
                    continue;
                }
                this.usage("Unknown option '" + arg + "'");
                continue;
            }
            if (this.vcfInputFile != null) continue;
            this.vcfInputFile = arg;
        }
    }

    @Override
    public boolean run() {
        int i = 1;
        VcfFileIterator vcf = this.openVcfInputFile();
        this.annotateInit(vcf);
        for (VcfEntry ve : vcf) {
            this.processVcfHeader(vcf);
            if (this.uncompress) {
                this.print(ve.uncompressGenotypes().toString());
            } else if (ve.compressGenotypes()) {
                this.print(ve.toStringNoGt());
            } else {
                this.print(ve.toString());
            }
            if (!this.verbose) continue;
            Gpr.showMark(i++, SHOW_EVERY);
        }
        this.annotateFinish(vcf);
        return true;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar gt [options] [file.vcf] > file.gt.vcf");
        System.err.println("Options: ");
        System.err.println("\t-u   : Uncompress (restore genotype fields).");
        System.err.println("\tDefault 'file.vcf' is STDIN.");
        System.exit(1);
    }
}

