/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Variant;
import org.snpeff.interval.tree.IntervalForest;

public class VariantBnd
extends Variant {
    private static final long serialVersionUID = 1L;
    Marker endPoint;
    boolean left;
    boolean before;

    public VariantBnd() {
    }

    public VariantBnd(Marker parent, int start, String ref, String alt, Chromosome chrTr, int startTr, boolean left, boolean before) {
        super(parent, start, ref, alt);
        this.endPoint = new Marker(chrTr, startTr, startTr);
        this.endPoint.setStrandMinus(left);
        this.left = left;
        this.before = before;
        this.variantType = Variant.VariantType.BND;
    }

    public Marker getEndPoint() {
        return this.endPoint;
    }

    public boolean isBefore() {
        return this.before;
    }

    @Override
    public boolean isBnd() {
        return true;
    }

    public boolean isLeft() {
        return this.left;
    }

    @Override
    public boolean isStructural() {
        return true;
    }

    @Override
    public Markers query(IntervalForest intervalForest) {
        Markers res1 = intervalForest.query(this);
        Markers res2 = intervalForest.query(this.endPoint);
        res1.add(res2);
        return res1;
    }

    @Override
    public Variant realignLeft() {
        return this;
    }

    @Override
    public String toString() {
        String sep = this.left ? "]" : "[";
        String trPos = sep + this.endPoint.getChromosomeName() + ":" + this.endPoint.getStart() + sep;
        return "chr" + this.getChromosomeName() + ":" + this.start + "_" + this.getReference() + "/" + (this.before ? trPos + this.getAlt() : this.getAlt() + trPos);
    }
}

