/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.serializer.MarkerSerializer;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;

public class NextProt
extends Marker {
    private static final long serialVersionUID = 8939301304881007289L;
    String transcriptId;
    boolean highlyConservedAaSequence;

    public NextProt() {
        this.type = EffectType.NEXT_PROT;
    }

    public NextProt(Transcript transcript, int start, int end, String id) {
        super(transcript.getChromosome(), start, end, false, id);
        this.type = EffectType.NEXT_PROT;
        this.transcriptId = transcript.getId();
    }

    @Override
    public NextProt cloneShallow() {
        NextProt clone2 = (NextProt)super.cloneShallow();
        clone2.transcriptId = this.transcriptId;
        clone2.highlyConservedAaSequence = this.highlyConservedAaSequence;
        return clone2;
    }

    public String getTranscriptId() {
        return this.transcriptId;
    }

    public boolean isHighlyConservedAaSequence() {
        return this.highlyConservedAaSequence;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.transcriptId = markerSerializer.getNextField();
        this.highlyConservedAaSequence = markerSerializer.getNextFieldBoolean();
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.transcriptId + "\t" + this.highlyConservedAaSequence;
    }

    public void setHighlyConservedAaSequence(boolean highlyConservedAaSequence) {
        this.highlyConservedAaSequence = highlyConservedAaSequence;
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        VariantEffect.EffectImpact effectImpact = VariantEffect.EffectImpact.MODIFIER;
        effectImpact = this.isHighlyConservedAaSequence() ? VariantEffect.EffectImpact.MODERATE : VariantEffect.EffectImpact.LOW;
        variantEffects.add(variant, this, this.type, effectImpact, "");
        return true;
    }
}

