/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.binseq.indexer;

import java.util.Iterator;
import org.snpeff.binseq.BinarySequence;
import org.snpeff.binseq.comparator.SequenceReference;
import org.snpeff.binseq.comparator.SubsequenceComparator;
import org.snpeff.binseq.indexer.OverlapFilter;
import org.snpeff.binseq.indexer.OverlapRessult;
import org.snpeff.binseq.indexer.SequenceIndexer;
import org.snpeff.collections.HashLongLongArray;
import org.snpeff.nmer.Nmer;
import org.snpeff.util.Gpr;

public class SuffixIndexerNmer<T extends BinarySequence>
extends SequenceIndexer<T> {
    int nmerSize;
    Nmer nmer;
    HashLongLongArray hash;
    OverlapFilter<T> overlapFilter = null;

    public SuffixIndexerNmer(SubsequenceComparator<T> subsequenceComparator, int nmerSize) {
        super(subsequenceComparator);
        this.nmerSize = nmerSize;
        this.nmer = new Nmer(nmerSize);
        this.hash = new HashLongLongArray();
        this.sequences.add(null);
    }

    @Override
    public int add(T sequence2) {
        this.sequences.add(sequence2);
        int idx = this.sequences.size() - 1;
        this.indexAllSuffix(sequence2, idx);
        return idx;
    }

    public OverlapRessult<T> findBestOverlap(T sequence2) {
        OverlapRessult result2 = new OverlapRessult();
        this.findOverlap(sequence2, result2);
        if (result2.bestScore < ((BinarySequence)sequence2).length()) {
            BinarySequence sequenceRwc = ((BinarySequence)sequence2).reverseWc();
            OverlapRessult resultRwc = new OverlapRessult();
            resultRwc.reverseWC = true;
            this.findOverlap(sequenceRwc, resultRwc);
            if (result2.bestSequence == null || result2.bestScore < resultRwc.bestScore) {
                result2 = resultRwc;
                sequence2 = sequenceRwc;
            }
        }
        return result2;
    }

    boolean findOverlap(T sequence2, OverlapRessult<T> result2) {
        int i;
        int max2 = ((BinarySequence)sequence2).length() - this.nmerSize;
        this.nmer.setNmer(0L);
        for (i = 0; i < this.nmerSize; ++i) {
            this.nmer.rol(((BinarySequence)sequence2).getBase(i));
        }
        i = 0;
        while (true) {
            long[] bucket = this.hash.getBucket(this.nmer.getNmer());
            if (result2.bestScore >= ((BinarySequence)sequence2).length() - i) break;
            if (bucket != null) {
                int len = this.hash.getBucketLength(this.nmer.getNmer());
                for (int r = 0; r < len; ++r) {
                    long ref = bucket[r];
                    int seqIdx = SequenceReference.getSeqIdx(ref);
                    int start = SequenceReference.getStart(ref);
                    Object seq2 = this.get(seqIdx);
                    if (this.overlapFilter != null && !this.overlapFilter.considerOverlap(sequence2, seq2) || i != 0 && start != 0 || i == 0 && result2.bestScore >= ((BinarySequence)seq2).length() - start || start == 0 && result2.bestScore >= ((BinarySequence)sequence2).length() - i) continue;
                    int score = this.subsequenceComparator.score(sequence2, i, seq2, start);
                    if (score > result2.bestScore) {
                        result2.bestScore = score;
                        result2.bestSequence = seq2;
                        result2.bestReference = ref;
                        result2.bestId = seqIdx;
                        result2.start = start - i;
                    }
                    if (score != ((BinarySequence)sequence2).length()) continue;
                    return true;
                }
            }
            if (i >= max2) break;
            this.nmer.rol(((BinarySequence)sequence2).getBase(i + this.nmerSize));
            ++i;
        }
        return result2.bestSequence != null;
    }

    public OverlapFilter<T> getOverlapFilter() {
        return this.overlapFilter;
    }

    void indexAllSuffix(T sequence2, int seqIds) {
        int max2 = ((BinarySequence)sequence2).length() - this.nmerSize;
        this.nmer.setNmer(0L);
        for (int i = 0; i < this.nmerSize; ++i) {
            this.nmer.rol(((BinarySequence)sequence2).getBase(i));
        }
        int start = 0;
        while (true) {
            long ref = SequenceReference.getReference(seqIds, start);
            this.hash.put(this.nmer.getNmer(), ref);
            if (start >= max2) break;
            this.nmer.rol(((BinarySequence)sequence2).getBase(start + this.nmerSize));
            ++start;
        }
    }

    @Override
    public Iterator<T> iterator() {
        Iterator it = this.sequences.iterator();
        it.next();
        return it;
    }

    public boolean overlap(T sequence2) {
        OverlapRessult<T> result2 = this.findBestOverlap(sequence2);
        if (result2.bestSequence == null) {
            return false;
        }
        if (result2.start >= 0 && result2.start + ((BinarySequence)sequence2).length() <= ((BinarySequence)result2.bestSequence).length()) {
            return true;
        }
        BinarySequence overlapSeq = ((BinarySequence)result2.bestSequence).overlap((BinarySequence)sequence2, result2.start);
        this.replaceSequenceOverlap(result2.bestSequence, overlapSeq, result2.bestId, result2.start);
        return true;
    }

    public void printSequences() {
        for (BinarySequence seq2 : this) {
            System.out.println(seq2.getSequence());
        }
    }

    void replaceSequenceOverlap(T sequenceOri, T sequenceNew, int seqIdx, int start) {
        int max2 = Math.max(((BinarySequence)sequenceNew).length(), ((BinarySequence)sequenceOri).length()) - this.nmerSize;
        if (start >= 0) {
            int startIdx = ((BinarySequence)sequenceOri).length() - this.nmerSize;
            int i = 0;
            int j = startIdx;
            while (i < this.nmerSize) {
                this.nmer.rol(((BinarySequence)sequenceNew).getBase(j));
                ++i;
                ++j;
            }
            for (int idx = startIdx; idx < max2; ++idx) {
                long ref = SequenceReference.getReference(seqIdx, idx);
                this.hash.put(this.nmer.getNmer(), ref);
                this.nmer.rol(((BinarySequence)sequenceNew).getBase(idx + this.nmerSize));
            }
        } else {
            for (int i = 0; i < this.nmerSize; ++i) {
                this.nmer.rol(((BinarySequence)sequenceNew).getBase(i));
            }
            int idxOri = 0;
            for (int idx = 0; idx < max2; ++idx) {
                long ref = SequenceReference.getReference(seqIdx, idx);
                if (0 <= idx && idx < -start) {
                    this.hash.put(this.nmer.getNmer(), ref);
                } else {
                    long refOld = SequenceReference.getReference(seqIdx, idxOri);
                    this.hash.replace(this.nmer.getNmer(), refOld, ref);
                    ++idxOri;
                }
                this.nmer.rol(((BinarySequence)sequenceNew).getBase(idx + this.nmerSize));
            }
        }
        this.sequences.set(seqIdx, sequenceNew);
    }

    public void sanityCheck() {
        int k = 1;
        for (int seqIdx = 1; seqIdx < this.sequences.size(); ++seqIdx) {
            BinarySequence sequence2 = (BinarySequence)this.sequences.get(seqIdx);
            int max2 = sequence2.length() - this.nmerSize;
            this.nmer.setNmer(0L);
            for (int i = 0; i < this.nmerSize; ++i) {
                this.nmer.rol(sequence2.getBase(i));
            }
            for (int start = 0; start < max2; ++start) {
                long ref = SequenceReference.getReference(seqIdx, start);
                if (!this.hash.contains(this.nmer.getNmer(), ref)) {
                    throw new RuntimeException("ERROR: Cannot find reference:\n\tReference: " + ref + "\tsequence.id: " + seqIdx + "\tindex: " + start + "\n\tNmer: " + this.nmer + "(" + this.nmer.getNmer() + ")\n\tSequence: " + sequence2.getSequence());
                }
                this.nmer.rol(sequence2.getBase(start + this.nmerSize));
                Gpr.showMarkStderr(k++, 10000);
            }
        }
        k = 1;
        for (long nmerLong : this.hash.keys()) {
            long[] bucket = this.hash.getBucket(nmerLong);
            if (bucket == null) {
                if (nmerLong == 0L) continue;
                throw new RuntimeException("ERROR: Nmer does not have any bucket!\n\tNmer: " + nmerLong);
            }
            int len = this.hash.getLatestBucketLength();
            for (int i = 0; i < len; ++i) {
                long ref = bucket[i];
                int seqIdx = SequenceReference.getSeqIdx(ref);
                int start = SequenceReference.getStart(ref);
                Object sequence3 = this.get(seqIdx);
                String nmerStr = ((BinarySequence)sequence3).getSequence().substring(start, start + this.nmer.length());
                this.nmer.setNmer(nmerLong);
                if (!this.nmer.toString().equalsIgnoreCase(nmerStr)) {
                    throw new RuntimeException("ERROR: Reference does not match Nmer:\n\tNnmer: " + nmerLong + "\tReference: " + ref + "\tsequence.id: " + seqIdx + "\tindex: " + start + "\n\tNmer: " + this.nmer + "\n\tSequence: " + ((BinarySequence)sequence3).getSequence());
                }
                Gpr.showMarkStderr(k++, 10000);
            }
        }
    }

    public void setOverlapFilter(OverlapFilter<T> overlapFilter) {
        this.overlapFilter = overlapFilter;
    }

    public String toString() {
        long tot = 0L;
        int max2 = 0;
        StringBuilder sb = new StringBuilder();
        for (BinarySequence seq2 : this) {
            tot += (long)seq2.length();
            max2 = Math.max(max2, seq2.length());
        }
        if (this.sequences.size() > 0) {
            sb.append("Max sequence length: " + max2 + "\tAvg sequence length: " + tot / (long)this.sequences.size());
        }
        sb.append("\tHash stats: " + this.hash.toString());
        return sb.toString();
    }

    public String toStringSequences() {
        StringBuilder sb = new StringBuilder();
        for (BinarySequence seq2 : this) {
            sb.append(seq2.getSequence() + "\n");
        }
        return sb.toString();
    }
}

